/*
 * Copyright 2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.social.facebook.api;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author vmotolyzhenko
 */
public class TestUserList extends FacebookObject {
    @JsonProperty("data")
    private List<TestUser> testUsers = new ArrayList<>();

    public List<TestUser> getTestUsers() {
        return testUsers;
    }

    public void setTestUsers(List<TestUser> testUsers) {
        this.testUsers = testUsers;
    }

    @Override
    @JsonAnySetter
    protected void add(String key, Object value) {
        super.add(key, value);
    }
}
