/*
 * Decompiled with CFR 0.152.
 */
package cronapi.utilitario.carne;

import br.com.gerencianet.gnsdk.Gerencianet;
import br.com.gerencianet.gnsdk.exceptions.GerencianetException;
import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.Var;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

@CronapiMetaData(categoryName="API Carn\u00ea")
public class UtilitarioCarne {
    @CronapiMetaData(type="function", name="Inserir Item", description="Insere item para ser adicionado ao boleto", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var createItem(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Nome*: Nome do item, produto ou servi\u00e7o") Var itemName, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Valor*: Valor, em centavos. Ex: R$ 10,00 = 1000") Var itemValue, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Quantidade: Quantidade de itens") Var amount) throws Exception {
        JSONObject item = new JSONObject();
        item.put("name", (Object)itemName.getObjectAsString());
        if (!amount.isNull().booleanValue()) {
            item.put("amount", (Object)amount.getObjectAsInt());
        }
        item.put("value", (Object)itemValue.getObjectAsInt());
        return Var.valueOf((Object)item);
    }

    @CronapiMetaData(type="function", name="Inserir Endere\u00e7o", description="Insere endere\u00e7o para ser adicionado ao cliente", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var createAddress(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Rua*: Nome da rua") Var street, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="N\u00famero*: N\u00famero") Var number, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Bairro*") Var neighborhood, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Complemento") Var complement, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Cidade*") Var city, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Estado*:Estado, 2 caracteres") Var state, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="CEP*: Sem pontos ou h\u00edfen") Var zipcode) throws Exception {
        JSONObject billingAddress = new JSONObject();
        billingAddress.put("street", (Object)street.getObjectAsString());
        billingAddress.put("number", (Object)number.getObjectAsInt());
        billingAddress.put("neighborhood", (Object)neighborhood.getObjectAsString());
        billingAddress.put("zipcode", (Object)zipcode.getObjectAsString());
        billingAddress.put("city", (Object)city.getObjectAsString());
        billingAddress.put("state", (Object)state.getObjectAsString());
        billingAddress.put("complement", (Object)complement.getObjectAsString());
        return Var.valueOf((Object)billingAddress);
    }

    @CronapiMetaData(type="function", name="Inserir PJ", description="Inserir pessoa Juridica", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var createPJ(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Nome*: Nome da raz\u00e3o social.") Var companyName, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="CNPJ*: CNPJ da empresa, com 14 caracteres.") Var cnpj) throws Exception {
        JSONObject juridicalData = new JSONObject();
        juridicalData.put("corporate_name", (Object)companyName.getObjectAsString());
        juridicalData.put("cnpj", (Object)cnpj.getObjectAsString());
        return Var.valueOf((Object)juridicalData);
    }

    @CronapiMetaData(type="function", name="Inserir Metadados", description="Define dados espec\u00edficos da transa\u00e7\u00e3o.", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var createMetadata(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Custom ID: associar uma transa\u00e7\u00e3o Gerencianet a uma ID espec\u00edfica") Var customID, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Url: endere\u00e7o de sua URL v\u00e1lida que receber\u00e1 as notifica\u00e7\u00f5es de mudan\u00e7as de status das transa\u00e7\u00f5es") Var notificationURL) throws Exception {
        JSONObject metadata = new JSONObject();
        metadata.put("custom_id", (Object)customID.getObjectAsString());
        metadata.put("notification_url", (Object)notificationURL.getObjectAsString());
        return Var.valueOf((Object)metadata);
    }

    @CronapiMetaData(type="function", name="Configura\u00e7\u00f5es", description="Permite incluir no carn\u00ea multa e juros caso seja pago ap\u00f3s o vencimento.", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var createConfigurations(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Multa: valor cobrado de multa ap\u00f3s o vencimento. Por exemplo: se voc\u00ea quiser 2%, voc\u00ea deve informar 200. M\u00ednimo de 0 e m\u00e1ximo de 1000.") Var fine, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Juros: valor cobrado de juros por dia ap\u00f3s a data de vencimento. Por exemplo: se voc\u00ea quiser 0,033%, voc\u00ea deve informar 33. M\u00ednimo de 0 e m\u00e1ximo de 330.") Var interest) throws Exception {
        JSONObject configurations = new JSONObject();
        configurations.put("fine", (Object)fine.getObjectAsInt());
        configurations.put("interest", (Object)interest.getObjectAsInt());
        return Var.valueOf((Object)configurations);
    }

    @CronapiMetaData(type="function", name="Desconto", description="Define dados de desconto sobre a cobran\u00e7a.", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var createDiscount(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Tipo: Tipo do desconto", blockType="util_dropdown", keys={"Moeda", "Porcentagem"}) Var type, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Valor: Valor do desconto (Integer). Se o tipo do desconto for currency, o valor desta tag dever\u00e1 ser informada pelo integrador em centavos (ou seja, 500 equivale a R$ 5,00). Caso o tipo do desconto seja percentage, o valor dever\u00e1 ser multiplicado por 100 (ou seja, 1500 equivale a 15%). Exemplos:1) currency // deve ser informado em centavos, ou seja, se o desconto ser\u00e1 de R$ 5,99, o integrador deve informar 599;2) percentage // deve ser informado em centavos, ou seja, se o desconto \u00e9 de 15%, o integrador deve informar 1500.") Var value) throws Exception {
        JSONObject discount = new JSONObject();
        if (type.getObjectAsString().equals("Moeda")) {
            discount.put("type", (Object)"currency");
        } else {
            discount.put("type", (Object)"percentage");
        }
        discount.put("value", (Object)value.getObjectAsInt());
        return Var.valueOf((Object)discount);
    }

    @CronapiMetaData(type="function", name="Desconto Condicional", description="Define dados de desconto sobre a cobran\u00e7a at\u00e9 uma data especifica.", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var createConditionalDiscount(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Tipo: Tipo do desconto", blockType="util_dropdown", keys={"Moeda", "Porcentagem"}) Var type, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Valor: Valor do desconto (Integer). Se o tipo do desconto for currency, o valor desta tag dever\u00e1 ser informada pelo integrador em centavos (ou seja, 500 equivale a R$ 5,00). Caso o tipo do desconto seja percentage, o valor dever\u00e1 ser multiplicado por 100 (ou seja, 1500 equivale a 15%). Exemplos:1) currency // deve ser informado em centavos, ou seja, se o desconto ser\u00e1 de R$ 5,99, o integrador deve informar 599;2) percentage // deve ser informado em centavos, ou seja, se o desconto \u00e9 de 15%, o integrador deve informar 1500.") Var value, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Data Limte: Data m\u00e1xima que o desconto ser\u00e1 concedido(Formato: YYYY-MM-DD)") Var untilDate) throws Exception {
        JSONObject condDiscount = new JSONObject();
        if (type.getObjectAsString().equals("Moeda")) {
            condDiscount.put("type", (Object)"currency");
        } else {
            condDiscount.put("type", (Object)"percentage");
        }
        condDiscount.put("value", (Object)value.getObjectAsInt());
        condDiscount.put("until_date", (Object)value.getObjectAsString());
        return Var.valueOf((Object)condDiscount);
    }

    @CronapiMetaData(type="function", name="Inserir Cliente", description="Inserir cliente para ser adicionado ao boleto", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var createClient(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Nome*: nome do cliente") Var clientName, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Cpf*: CPF do cliente (sem pontos, v\u00edrgulas ou h\u00edfen)") Var clientCpf, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Email: Endere\u00e7o de email v\u00e1lido do cliente") Var clientEmail, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Telefone*: Telefone v\u00e1lido do cliente, sem caracteres especiais") Var clientPhone, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Nascimento: Data de Nascimento (data v\u00e1lida em formato YYYY-MM-DD)") Var clientBirth, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="Endere\u00e7o*: Endere\u00e7o do Cliente") Var clientAddress, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="PJ: Dados de pessoa jur\u00eddica") Var clientPJ) throws Exception {
        JSONObject customer = new JSONObject();
        customer.put("name", (Object)clientName.getObjectAsString());
        customer.put("cpf", (Object)clientCpf.getObjectAsString());
        if (!clientEmail.isNull().booleanValue()) {
            customer.put("email", (Object)clientEmail.getObjectAsString());
        }
        if (!clientBirth.isNull().booleanValue()) {
            customer.put("birth", (Object)clientBirth.getObjectAsString());
        }
        if (!clientAddress.isNull().booleanValue()) {
            customer.put("address", clientAddress.getObject());
        }
        if (!clientPJ.isNull().booleanValue()) {
            customer.put("juridical_person", clientPJ.getObject());
        }
        customer.put("phone_number", (Object)clientPhone.getObjectAsString());
        return Var.valueOf((Object)customer);
    }

    @CronapiMetaData(type="function", name="Criar Carn\u00ea", description="Fun\u00e7\u00e3o para criar carn\u00ea", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var createCarnet(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ClientID*: id do cliente") Var clientID, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ClientSecret*: senha") Var clientSecret, @ParamMetaData(type=CronapiMetaData.ObjectType.BOOLEAN, description="Sandbox*: true para desenvolvimento") Var sandbox, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="Cliente*: Dados pessoais do pagador.") Var customer, @ParamMetaData(type=CronapiMetaData.ObjectType.LIST, description="Items*: Item que est\u00e1 sendo vendido. Uma mesma transa\u00e7\u00e3o pode possuir ilimitados itens.") Var items, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Validade*: Formato: YYYY-MM-DD. Data de vencimento do carn\u00ea. O intervalo das parcelas de um carn\u00ea \u00e9 sempre de 1 (um) m\u00eas entre elas.") Var expiration, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Parcelas*: N\u00famero de parcelas do carn\u00ea.") Var repeats, @ParamMetaData(type=CronapiMetaData.ObjectType.BOOLEAN, description="Dividir: Define se os itens do carn\u00ea ser\u00e3o divididos entre as parcelas (true), ou se o valor de cada parcela ser\u00e1 o valor total dos itens (false).", blockType="util_dropdown", keys={"true", "false"}) Var splitItems, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="Metadata: Define dados espec\u00edficos da transa\u00e7\u00e3o.") Var metadata, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="Configura\u00e7\u00f5es: Permite incluir no carn\u00ea multa e juros caso seja pago ap\u00f3s o vencimento.") Var configurations, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Mensagem: Permite incluir no boleto uma observa\u00e7\u00e3o, ou em outras palavras, uma mensagem para o cliente. Essa mensagem poder\u00e1 ser vista nos e-mails relacionados \u00e0 cobran\u00e7a, no boleto ou carn\u00ea.") Var message, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="Desconto: Define dados de desconto sobre a cobran\u00e7a") Var discount, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="Desconto Condicional: Define desconto condicional que \u00e9 v\u00e1lido at\u00e9 uma data espec\u00edfica. Se o pagamento n\u00e3o for efetuado at\u00e9 aquela data, o desconto \u00e9 invalidado.") Var conditionalDiscount) throws Exception {
        JSONObject body = new JSONObject();
        JSONArray itemsArray = new JSONArray();
        Var retorno = new Var();
        JSONObject options = new JSONObject();
        options.put("client_id", (Object)clientID.getObjectAsString());
        options.put("client_secret", (Object)clientSecret.getObjectAsString());
        options.put("sandbox", (Object)sandbox.getObjectAsString());
        for (int i = 0; i < items.getObjectAsList().size(); ++i) {
            itemsArray.put(Var.valueOf(items.getObjectAsList().get(i)).getObject());
        }
        body.put("items", (Object)itemsArray);
        body.put("customer", customer.getObject());
        body.put("expire_at", (Object)expiration.getObjectAsString());
        body.put("repeats", (Object)repeats.getObjectAsInt());
        body.put("split_items", (Object)splitItems.getObjectAsBoolean());
        if (!metadata.isNull().booleanValue()) {
            body.put("metadata", metadata.getObject());
        }
        if (!configurations.isNull().booleanValue()) {
            body.put("configurations", configurations.getObject());
        }
        if (!message.isNull().booleanValue()) {
            body.put("message", (Object)message.getObjectAsString());
        }
        if (!discount.isNull().booleanValue()) {
            body.put("discount", discount.getObject());
        }
        if (!conditionalDiscount.isNull().booleanValue()) {
            body.put("conditional_discount", conditionalDiscount.getObject());
        }
        try {
            Gerencianet gn = new Gerencianet(options);
            JSONObject response = gn.call("createCarnet", new HashMap(), body);
            retorno = Var.valueOf((Object)response);
        }
        catch (GerencianetException e) {
            System.out.println(e.getCode());
            System.out.println(e.getError());
            System.out.println(e.getErrorDescription());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
        return retorno;
    }

    @CronapiMetaData(type="function", name="Detalhar Carn\u00ea", description="Fun\u00e7\u00e3o para detalhar carn\u00ea", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var detailCarnet(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ClientID*: id do cliente") Var clientID, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ClientSecret*: senha") Var clientSecret, @ParamMetaData(type=CronapiMetaData.ObjectType.BOOLEAN, description="Sandbox*: true para desenvolvimento") Var sandbox, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="CarnetID*: id do carn\u00ea") Var carnetID) {
        JSONObject response = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", carnetID.getObjectAsString());
        JSONObject options = new JSONObject();
        options.put("client_id", (Object)clientID.getObjectAsString());
        options.put("client_secret", (Object)clientSecret.getObjectAsString());
        options.put("sandbox", (Object)sandbox.getObjectAsString());
        try {
            Gerencianet gn = new Gerencianet(options);
            response = gn.call("detailCarnet", params, new JSONObject());
        }
        catch (GerencianetException e) {
            System.out.println(e.getCode());
            System.out.println(e.getError());
            System.out.println(e.getErrorDescription());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
        return Var.valueOf((Object)response);
    }

    @CronapiMetaData(type="function", name="Atualizar Metadados", description="Fun\u00e7\u00e3o para atualizar o metadados", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var updateMetadata(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ClientID*: id do cliente") Var clientID, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ClientSecret*: senha") Var clientSecret, @ParamMetaData(type=CronapiMetaData.ObjectType.BOOLEAN, description="Sandbox*: true para desenvolvimento") Var sandbox, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ID*: id do carn\u00ea") Var carnetID, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="MetadadosID*: id do metadados") Var customID, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Url*: Endere\u00e7o de sua URL v\u00e1lida que receber\u00e1 as notifica\u00e7\u00f5es de mudan\u00e7as de status do carn\u00ea e de suas parcelas.") Var notificationURL) throws Exception {
        JSONObject response = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", carnetID.getObjectAsString());
        JSONObject body = new JSONObject();
        body.put("custom_id", (Object)customID.getObjectAsString());
        body.put("notification_url", (Object)notificationURL.getObjectAsString());
        JSONObject options = new JSONObject();
        options.put("client_id", (Object)clientID.getObjectAsString());
        options.put("client_secret", (Object)clientSecret.getObjectAsString());
        options.put("sandbox", (Object)sandbox.getObjectAsString());
        try {
            Gerencianet gn = new Gerencianet(options);
            response = gn.call("updateCarnetMetadata", params, body);
        }
        catch (GerencianetException e) {
            System.out.println(e.getCode());
            System.out.println(e.getError());
            System.out.println(e.getErrorDescription());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
        return Var.valueOf((Object)response);
    }

    @CronapiMetaData(type="function", name="Atualizar Parcela", description="Fun\u00e7\u00e3o para atualizar a parcela", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var updateParcel(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ClientID*: id do cliente") Var clientID, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ClientSecret*: senha") Var clientSecret, @ParamMetaData(type=CronapiMetaData.ObjectType.BOOLEAN, description="Sandbox*: true para desenvolvimento") Var sandbox, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ID*: id do carn\u00ea") Var carnetID, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Parcela*: numero da parcela") Var parcel, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Validade*: data de validade") Var expireAt) throws Exception {
        JSONObject response = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", carnetID.getObjectAsString());
        params.put("parcel", parcel.getObjectAsString());
        JSONObject body = new JSONObject();
        body.put("expire_at", (Object)expireAt.getObjectAsString());
        JSONObject options = new JSONObject();
        options.put("client_id", (Object)clientID.getObjectAsString());
        options.put("client_secret", (Object)clientSecret.getObjectAsString());
        options.put("sandbox", (Object)sandbox.getObjectAsString());
        try {
            Gerencianet gn = new Gerencianet(options);
            response = gn.call("updateParcel", params, body);
        }
        catch (GerencianetException e) {
            System.out.println(e.getCode());
            System.out.println(e.getError());
            System.out.println(e.getErrorDescription());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
        return Var.valueOf((Object)response);
    }

    @CronapiMetaData(type="function", name="Cancelar Carn\u00ea", description="Fun\u00e7\u00e3o para cancelar o carn\u00ea", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var cancelCarnet(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ClientID*: id do cliente") Var clientID, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ClientSecret*: senha") Var clientSecret, @ParamMetaData(type=CronapiMetaData.ObjectType.BOOLEAN, description="Sandbox*: true para desenvolvimento") Var sandbox, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ID*: id do carn\u00ea") Var carnetID) {
        JSONObject response = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", carnetID.getObjectAsString());
        JSONObject options = new JSONObject();
        options.put("client_id", (Object)clientID.getObjectAsString());
        options.put("client_secret", (Object)clientSecret.getObjectAsString());
        options.put("sandbox", (Object)sandbox.getObjectAsString());
        try {
            Gerencianet gn = new Gerencianet(options);
            response = gn.call("cancelCarnet", params, new JSONObject());
        }
        catch (GerencianetException e) {
            System.out.println(e.getCode());
            System.out.println(e.getError());
            System.out.println(e.getErrorDescription());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
        return Var.valueOf((Object)response);
    }

    @CronapiMetaData(type="function", name="Cancelar Parcela", description="Fun\u00e7\u00e3o para cancelar Parcela", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var cancelParcel(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ClientID*: id do cliente") Var clientID, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ClientSecret*: senha") Var clientSecret, @ParamMetaData(type=CronapiMetaData.ObjectType.BOOLEAN, description="Sandbox*: true para desenvolvimento") Var sandbox, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ID*: id do carn\u00ea") Var carnetID, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Parcela*: numero da parcela") Var parcel) {
        JSONObject response = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", carnetID.getObjectAsString());
        params.put("parcel", parcel.getObjectAsString());
        JSONObject options = new JSONObject();
        options.put("client_id", (Object)clientID.getObjectAsString());
        options.put("client_secret", (Object)clientSecret.getObjectAsString());
        options.put("sandbox", (Object)sandbox.getObjectAsString());
        try {
            Gerencianet gn = new Gerencianet(options);
            response = gn.call("cancelParcel", params, new JSONObject());
        }
        catch (GerencianetException e) {
            System.out.println(e.getCode());
            System.out.println(e.getError());
            System.out.println(e.getErrorDescription());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
        return Var.valueOf((Object)response);
    }

    @CronapiMetaData(type="function", name="Reenviar Carn\u00ea", description="Fun\u00e7\u00e3o para Reenviar Carn\u00ea", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var resendCarnet(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ClientID*: id do cliente") Var clientID, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ClientSecret*: senha") Var clientSecret, @ParamMetaData(type=CronapiMetaData.ObjectType.BOOLEAN, description="Sandbox*: true para desenvolvimento") Var sandbox, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="CarnetID*: id do carn\u00ea") Var carnetID, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Email*: email") Var email) throws Exception {
        JSONObject response = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", carnetID.getObjectAsString());
        JSONObject body = new JSONObject();
        body.put("email", (Object)email.getObjectAsString());
        JSONObject options = new JSONObject();
        options.put("client_id", (Object)clientID.getObjectAsString());
        options.put("client_secret", (Object)clientSecret.getObjectAsString());
        options.put("sandbox", (Object)sandbox.getObjectAsString());
        try {
            Gerencianet gn = new Gerencianet(options);
            response = gn.call("resendCarnet", params, body);
        }
        catch (GerencianetException e) {
            System.out.println(e.getCode());
            System.out.println(e.getError());
            System.out.println(e.getErrorDescription());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
        return Var.valueOf((Object)response);
    }

    @CronapiMetaData(type="function", name="Reenviar Parcela", description="Fun\u00e7\u00e3o para Reenviar Parcela", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var resendParcel(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ClientID*: id do cliente") Var clientID, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ClientSecret*: senha") Var clientSecret, @ParamMetaData(type=CronapiMetaData.ObjectType.BOOLEAN, description="Sandbox*: true para desenvolvimento") Var sandbox, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="CarnetID*: id do carn\u00ea") Var carnetID, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Parcela*: numero parcela") Var parcel, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Email*: numero do carne") Var email) throws Exception {
        JSONObject response = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", carnetID.getObjectAsString());
        params.put("parcel", parcel.getObjectAsString());
        JSONObject options = new JSONObject();
        options.put("client_id", (Object)clientID.getObjectAsString());
        options.put("client_secret", (Object)clientSecret.getObjectAsString());
        options.put("sandbox", (Object)sandbox.getObjectAsString());
        JSONObject body = new JSONObject();
        body.put("email", (Object)email.getObjectAsString());
        try {
            Gerencianet gn = new Gerencianet(options);
            response = gn.call("resendParcel", params, body);
        }
        catch (GerencianetException e) {
            System.out.println(e.getCode());
            System.out.println(e.getError());
            System.out.println(e.getErrorDescription());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
        return Var.valueOf((Object)response);
    }

    @CronapiMetaData(type="function", name="Criar descri\u00e7\u00e3o", description="Criar descri\u00e7\u00e3o do carn\u00ea", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var createCarnetHistory(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ClientID*: id do cliente") Var clientID, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="ClientSecret*: senha") Var clientSecret, @ParamMetaData(type=CronapiMetaData.ObjectType.BOOLEAN, description="Sandbox*: true para desenvolvimento") Var sandbox, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="CarnetID*: id do carn\u00ea") Var carnetID, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="Descri\u00e7\u00e3o*: descri\u00e7\u00e3o do carn\u00ea") Var description) throws Exception {
        JSONObject response = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", carnetID.getObjectAsString());
        JSONObject options = new JSONObject();
        options.put("client_id", (Object)clientID.getObjectAsString());
        options.put("client_secret", (Object)clientSecret.getObjectAsString());
        options.put("sandbox", (Object)sandbox.getObjectAsString());
        JSONObject body = new JSONObject();
        body.put("description", (Object)description);
        try {
            Gerencianet gn = new Gerencianet(options);
            response = gn.call("createCarnetHistory", params, body);
        }
        catch (GerencianetException e) {
            System.out.println(e.getCode());
            System.out.println(e.getError());
            System.out.println(e.getErrorDescription());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
        return Var.valueOf((Object)response);
    }
}

