/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.ref.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.olingo.odata2.ref.model.Building;
import org.apache.olingo.odata2.ref.model.Employee;
import org.apache.olingo.odata2.ref.model.Location;
import org.apache.olingo.odata2.ref.model.Manager;
import org.apache.olingo.odata2.ref.model.Photo;
import org.apache.olingo.odata2.ref.model.Room;
import org.apache.olingo.odata2.ref.model.Team;

public class DataContainer {
    private static final String IMAGE_JPEG = "image/jpeg";
    private List<Employee> employees = new ArrayList<Employee>();
    private List<Team> teams = new ArrayList<Team>();
    private List<Room> rooms = new ArrayList<Room>();
    private List<Manager> managers = new ArrayList<Manager>();
    private List<Building> buildings = new ArrayList<Building>();
    private List<Photo> photos = new ArrayList<Photo>();
    private int employeeId = 0;
    private int teamId = 0;
    private int roomId = 0;
    private int buildingId = 0;
    private int photoId = 0;

    public void init() {
        Team team1 = this.createTeam();
        team1.setScrumTeam(false);
        this.teams.add(team1);
        Team team2 = this.createTeam();
        team2.setScrumTeam(true);
        this.teams.add(team2);
        Team team3 = this.createTeam();
        team3.setScrumTeam(false);
        this.teams.add(team3);
        Building building1 = this.createBuilding();
        this.buildings.add(building1);
        Building building2 = this.createBuilding();
        this.buildings.add(building2);
        Building building3 = this.createBuilding();
        this.buildings.add(building3);
        Room room1 = this.createRoom();
        room1.setSeats(1);
        room1.setBuilding(building1);
        building1.getRooms().add(room1);
        room1.setVersion(1);
        this.rooms.add(room1);
        Room room2 = this.createRoom();
        room2.setSeats(5);
        room2.setBuilding(building2);
        building2.getRooms().add(room2);
        room2.setVersion(2);
        this.rooms.add(room2);
        Room room3 = this.createRoom();
        room3.setSeats(2);
        room3.setBuilding(building2);
        building2.getRooms().add(room3);
        room3.setVersion(3);
        this.rooms.add(room3);
        int i = 4;
        while (i <= 103) {
            Room roomN = this.createRoom();
            roomN.setSeats(4 + (i - 3) % 5);
            roomN.setBuilding(building3);
            building3.getRooms().add(roomN);
            roomN.setVersion(1);
            this.rooms.add(roomN);
            ++i;
        }
        Manager emp1 = this.createManager();
        emp1.setEmployeeName("Walter Winter");
        emp1.setAge(52);
        emp1.setTeam(team1);
        team1.getEmployees().add(emp1);
        emp1.setRoom(room1);
        room1.getEmployees().add(emp1);
        emp1.setManager(emp1);
        emp1.getEmployees().add(emp1);
        emp1.setLocation(new Location("Germany", "69124", "Heidelberg"));
        emp1.setEntryDate(this.generateDate(1999, 1, 1));
        emp1.setImageUri("Employees('1')/$value");
        emp1.setImage("/Employee_1.png");
        emp1.setImageType(IMAGE_JPEG);
        this.employees.add(emp1);
        this.managers.add(emp1);
        Employee emp2 = this.createEmployee();
        emp2.setEmployeeName("Frederic Fall");
        emp2.setAge(32);
        emp2.setTeam(team1);
        team1.getEmployees().add(emp2);
        emp2.setRoom(room2);
        room2.getEmployees().add(emp2);
        emp2.setManager(emp1);
        emp1.getEmployees().add(emp2);
        emp2.setLocation(new Location("Germany", "69190", "Walldorf"));
        emp2.setEntryDate(this.generateDate(2003, 7, 1));
        emp2.setImageUri("Employees('2')/$value");
        emp2.setImage("/Employee_2.png");
        emp2.setImageType(IMAGE_JPEG);
        this.employees.add(emp2);
        Manager emp3 = this.createManager();
        emp3.setEmployeeName("Jonathan Smith");
        emp3.setAge(56);
        emp3.setTeam(team1);
        team1.getEmployees().add(emp3);
        emp3.setRoom(room2);
        room2.getEmployees().add(emp3);
        emp3.setManager(emp1);
        emp1.getEmployees().add(emp3);
        emp3.setLocation(emp2.getLocation());
        emp3.setEntryDate(null);
        emp3.setImageUri("Employees('3')/$value");
        emp3.setImage("/Employee_3.png");
        emp3.setImageType(IMAGE_JPEG);
        this.employees.add(emp3);
        this.managers.add(emp3);
        Employee emp4 = this.createEmployee();
        emp4.setEmployeeName("Peter Burke");
        emp4.setAge(39);
        emp4.setTeam(team2);
        team2.getEmployees().add(emp4);
        emp4.setRoom(room2);
        room2.getEmployees().add(emp4);
        emp4.setManager(emp3);
        emp3.getEmployees().add(emp4);
        emp4.setLocation(emp2.getLocation());
        emp4.setEntryDate(this.generateDate(2004, 9, 12));
        emp4.setImageUri("Employees('4')/$value");
        emp4.setImage("/Employee_4.png");
        emp4.setImageType(IMAGE_JPEG);
        this.employees.add(emp4);
        Employee emp5 = this.createEmployee();
        emp5.setEmployeeName("John Field");
        emp5.setAge(42);
        emp5.setTeam(team2);
        team2.getEmployees().add(emp5);
        emp5.setRoom(room3);
        room3.getEmployees().add(emp5);
        emp5.setManager(emp3);
        emp3.getEmployees().add(emp5);
        emp5.setLocation(emp2.getLocation());
        emp5.setEntryDate(this.generateDate(2001, 2, 1));
        emp5.setImageUri("Employees('5')/$value");
        emp5.setImage("/Employee_5.png");
        emp5.setImageType(IMAGE_JPEG);
        this.employees.add(emp5);
        Employee emp6 = this.createEmployee();
        emp6.setEmployeeName("Susan Bay");
        emp6.setAge(29);
        emp6.setTeam(team3);
        team3.getEmployees().add(emp6);
        emp6.setRoom(room2);
        room2.getEmployees().add(emp6);
        emp6.setManager(emp1);
        emp1.getEmployees().add(emp6);
        emp6.setLocation(emp2.getLocation());
        emp6.setEntryDate(this.generateDate(2010, 12, 1));
        emp6.setImageUri("Employees('6')/$value");
        emp6.setImage("/Employee_6.png");
        emp6.setImageType(IMAGE_JPEG);
        this.employees.add(emp6);
        Photo photo1 = this.createPhoto("image/png");
        photo1.setContent("\u041e\u0431\u0440\u0430\u0437");
        this.photos.add(photo1);
        Photo photo2 = this.createPhoto("image/bmp");
        this.photos.add(photo2);
        Photo photo3 = this.createPhoto(IMAGE_JPEG);
        this.photos.add(photo3);
        Photo photo4 = this.createPhoto("foo");
        photo4.setContent("\u041f\u0440\u043e\u0434\u0443\u043a\u0442");
        this.photos.add(photo4);
    }

    private Calendar generateDate(int year, int month, int day) {
        Calendar date = Calendar.getInstance();
        date.clear();
        date.setTimeZone(TimeZone.getTimeZone("GMT"));
        date.set(year, month - 1, day);
        return date;
    }

    public Employee createEmployee() {
        return new Employee(++this.employeeId, "Employee " + this.employeeId);
    }

    public Team createTeam() {
        return new Team(++this.teamId, "Team " + this.teamId);
    }

    public Room createRoom() {
        return new Room(++this.roomId, "Room " + this.roomId);
    }

    public Manager createManager() {
        return new Manager(++this.employeeId, "Employee " + this.employeeId);
    }

    public Building createBuilding() {
        return new Building(++this.buildingId, "Building " + this.buildingId);
    }

    public Photo createPhoto(String type) {
        return new Photo(++this.photoId, "Photo " + this.photoId, type);
    }

    public List<Employee> getEmployees() {
        return this.employees;
    }

    public List<Team> getTeams() {
        return this.teams;
    }

    public List<Room> getRooms() {
        return this.rooms;
    }

    public List<Manager> getManagers() {
        return this.managers;
    }

    public List<Building> getBuildings() {
        return this.buildings;
    }

    public List<Photo> getPhotos() {
        return this.photos;
    }

    public void reset() {
        this.employees.clear();
        this.teams.clear();
        this.rooms.clear();
        this.managers.clear();
        this.buildings.clear();
        this.photos.clear();
        this.employeeId = 0;
        this.teamId = 0;
        this.roomId = 0;
        this.buildingId = 0;
        this.photoId = 0;
        this.init();
    }
}

