/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.ref.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.olingo.odata2.ref.model.ModelException;

public class Photo {
    private static final String RESOURCE = "/Employee_1.png";
    private static byte[] defaultImage;
    private final int id;
    private String name;
    private String type = "image/jpeg";
    private String imageUrl = "http://localhost/Employee_1.png";
    private byte[] image = defaultImage;
    private String imageType = this.type;
    private byte[] binaryData;
    private String content;

    static {
        try {
            InputStream instream = Photo.class.getResourceAsStream(RESOURCE);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            int b = 0;
            while ((b = instream.read()) != -1) {
                stream.write(b);
            }
            defaultImage = stream.toByteArray();
        }
        catch (IOException e) {
            throw new ModelException(e);
        }
    }

    public Photo(int id, String name, String type) {
        this.id = id;
        this.setName(name);
        this.setType(type);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getImageUri() {
        return this.imageUrl;
    }

    public void setImageUri(String uri) {
        this.imageUrl = uri;
    }

    public byte[] getImage() {
        return (byte[])this.image.clone();
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public String getImageType() {
        return this.imageType;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }

    public byte[] getBinaryData() {
        if (this.binaryData == null) {
            return null;
        }
        return (byte[])this.binaryData.clone();
    }

    public void setBinaryData(byte[] binaryData) {
        this.binaryData = binaryData;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.id == ((Photo)obj).id;
    }

    public String toString() {
        return "{\"Id\":" + this.id + "," + "\"Name\":\"" + this.name + "\"," + "\"Type\":\"" + this.type + "\"," + "\"ImageUrl\":\"" + this.imageUrl + "\"," + "\"Image\":\"" + Arrays.toString(this.image) + "\"," + "\"ImageType\":\"" + this.imageType + "\"," + "\"Content:\"" + this.content + "\"," + "\"BinaryData\":\"" + Arrays.toString(this.binaryData) + "\"}";
    }
}

