/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.ref.processor;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.olingo.odata2.api.ODataCallback;
import org.apache.olingo.odata2.api.batch.BatchHandler;
import org.apache.olingo.odata2.api.batch.BatchRequestPart;
import org.apache.olingo.odata2.api.batch.BatchResponsePart;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.commons.InlineCount;
import org.apache.olingo.odata2.api.edm.EdmConcurrencyMode;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmLiteral;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.EdmStructuralType;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderBatchProperties;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.api.ep.callback.OnWriteEntryContent;
import org.apache.olingo.odata2.api.ep.callback.OnWriteFeedContent;
import org.apache.olingo.odata2.api.ep.callback.WriteCallbackContext;
import org.apache.olingo.odata2.api.ep.callback.WriteEntryCallbackContext;
import org.apache.olingo.odata2.api.ep.callback.WriteEntryCallbackResult;
import org.apache.olingo.odata2.api.ep.callback.WriteFeedCallbackContext;
import org.apache.olingo.odata2.api.ep.callback.WriteFeedCallbackResult;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.exception.ODataBadRequestException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataHttpException;
import org.apache.olingo.odata2.api.exception.ODataNotFoundException;
import org.apache.olingo.odata2.api.exception.ODataNotImplementedException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.processor.ODataRequest;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.processor.ODataSingleProcessor;
import org.apache.olingo.odata2.api.uri.ExpandSelectTreeNode;
import org.apache.olingo.odata2.api.uri.KeyPredicate;
import org.apache.olingo.odata2.api.uri.NavigationSegment;
import org.apache.olingo.odata2.api.uri.PathInfo;
import org.apache.olingo.odata2.api.uri.UriParser;
import org.apache.olingo.odata2.api.uri.expression.BinaryExpression;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.ExpressionKind;
import org.apache.olingo.odata2.api.uri.expression.FilterExpression;
import org.apache.olingo.odata2.api.uri.expression.LiteralExpression;
import org.apache.olingo.odata2.api.uri.expression.MemberExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderByExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderExpression;
import org.apache.olingo.odata2.api.uri.expression.PropertyExpression;
import org.apache.olingo.odata2.api.uri.expression.SortOrder;
import org.apache.olingo.odata2.api.uri.expression.UnaryExpression;
import org.apache.olingo.odata2.api.uri.info.DeleteUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetComplexPropertyUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityLinkCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityLinkUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetLinksCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetLinksUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetFunctionImportUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetMediaResourceUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetSimplePropertyUriInfo;
import org.apache.olingo.odata2.api.uri.info.PostUriInfo;
import org.apache.olingo.odata2.api.uri.info.PutMergePatchUriInfo;
import org.apache.olingo.odata2.ref.processor.BeanPropertyAccess;
import org.apache.olingo.odata2.ref.processor.ScenarioDataSource;

public class ListsProcessor
extends ODataSingleProcessor {
    private static final int SERVER_PAGING_SIZE = 100;
    private final BeanPropertyAccess valueAccess;
    private final ScenarioDataSource dataSource;

    public ListsProcessor(ScenarioDataSource dataSource) {
        this(dataSource, new BeanPropertyAccess());
    }

    public ListsProcessor(ScenarioDataSource dataSource, BeanPropertyAccess valueAccess) {
        this.dataSource = dataSource;
        this.valueAccess = valueAccess;
    }

    public ODataResponse readEntitySet(GetEntitySetUriInfo uriInfo, String contentType) throws ODataException {
        ArrayList data = new ArrayList();
        try {
            data.addAll((List)this.retrieveData(uriInfo.getStartEntitySet(), uriInfo.getKeyPredicates(), uriInfo.getFunctionImport(), ListsProcessor.mapFunctionParameters(uriInfo.getFunctionImportParameters()), uriInfo.getNavigationSegments()));
        }
        catch (ODataNotFoundException e) {
            data.clear();
        }
        EdmEntitySet entitySet = uriInfo.getTargetEntitySet();
        InlineCount inlineCountType = uriInfo.getInlineCount();
        Integer count = this.applySystemQueryOptions(entitySet, data, uriInfo.getFilter(), inlineCountType, uriInfo.getOrderBy(), uriInfo.getSkipToken(), uriInfo.getSkip(), uriInfo.getTop());
        ODataContext context = this.getContext();
        String nextLink = null;
        if (data.size() > 100) {
            if (uriInfo.getOrderBy() == null && uriInfo.getSkipToken() == null && uriInfo.getSkip() == null && uriInfo.getTop() == null) {
                this.sortInDefaultOrder(entitySet, data);
            }
            nextLink = context.getPathInfo().getServiceRoot().relativize(context.getPathInfo().getRequestUri()).toString();
            nextLink = this.percentEncodeNextLink(nextLink);
            nextLink = String.valueOf(nextLink) + (nextLink.contains("?") ? "&" : "?") + "$skiptoken=" + this.getSkipToken(entitySet, data.get(100));
            while (data.size() > 100) {
                data.remove(100);
            }
        }
        EdmEntityType entityType = entitySet.getEntityType();
        ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
        for (Object entryData : data) {
            values.add(this.getStructuralTypeValueMap(entryData, (EdmStructuralType)entityType));
        }
        EntityProviderWriteProperties feedProperties = EntityProviderWriteProperties.serviceRoot((URI)context.getPathInfo().getServiceRoot()).inlineCountType(inlineCountType).inlineCount(count).callback(uriInfo.getCallback()).clientCallbacks(uriInfo.getClientCallbacks()).expandSelectTree(UriParser.createExpandSelectTree((List)uriInfo.getSelect(), (List)uriInfo.getExpand())).callbacks(this.getCallbacks(data, entityType)).nextLink(nextLink).build();
        int timingHandle = context.startRuntimeMeasurement("EntityProvider", "writeFeed");
        ODataResponse response = EntityProvider.writeFeed((String)contentType, (EdmEntitySet)entitySet, values, (EntityProviderWriteProperties)feedProperties);
        context.stopRuntimeMeasurement(timingHandle);
        return ODataResponse.fromResponse((ODataResponse)response).build();
    }

    String percentEncodeNextLink(String link) {
        if (link == null) {
            return null;
        }
        return link.replaceAll("\\$skiptoken=.+?(?:&|$)", "").replaceAll("\\$skip=.+?(?:&|$)", "").replaceFirst("(?:\\?|&)$", "");
    }

    public ODataResponse countEntitySet(GetEntitySetCountUriInfo uriInfo, String contentType) throws ODataException {
        ArrayList data = new ArrayList();
        try {
            data.addAll((List)this.retrieveData(uriInfo.getStartEntitySet(), uriInfo.getKeyPredicates(), uriInfo.getFunctionImport(), ListsProcessor.mapFunctionParameters(uriInfo.getFunctionImportParameters()), uriInfo.getNavigationSegments()));
        }
        catch (ODataNotFoundException e) {
            data.clear();
        }
        this.applySystemQueryOptions(uriInfo.getTargetEntitySet(), data, uriInfo.getFilter(), null, null, null, uriInfo.getSkip(), uriInfo.getTop());
        return ODataResponse.fromResponse((ODataResponse)EntityProvider.writeText((String)String.valueOf(data.size()))).build();
    }

    public ODataResponse readEntityLinks(GetEntitySetLinksUriInfo uriInfo, String contentType) throws ODataException {
        ArrayList data = new ArrayList();
        try {
            data.addAll((List)this.retrieveData(uriInfo.getStartEntitySet(), uriInfo.getKeyPredicates(), uriInfo.getFunctionImport(), ListsProcessor.mapFunctionParameters(uriInfo.getFunctionImportParameters()), uriInfo.getNavigationSegments()));
        }
        catch (ODataNotFoundException e) {
            data.clear();
        }
        Integer count = this.applySystemQueryOptions(uriInfo.getTargetEntitySet(), data, uriInfo.getFilter(), uriInfo.getInlineCount(), null, uriInfo.getSkipToken(), uriInfo.getSkip(), uriInfo.getTop());
        EdmEntitySet entitySet = uriInfo.getTargetEntitySet();
        ArrayList values = new ArrayList();
        for (Object entryData : data) {
            HashMap<String, Object> entryValues = new HashMap<String, Object>();
            for (EdmProperty property : entitySet.getEntityType().getKeyProperties()) {
                entryValues.put(property.getName(), this.valueAccess.getPropertyValue(entryData, property));
            }
            values.add(entryValues);
        }
        ODataContext context = this.getContext();
        EntityProviderWriteProperties entryProperties = EntityProviderWriteProperties.serviceRoot((URI)context.getPathInfo().getServiceRoot()).inlineCountType(uriInfo.getInlineCount()).inlineCount(count).callback(uriInfo.getCallback()).clientCallbacks(uriInfo.getClientCallbacks()).build();
        int timingHandle = context.startRuntimeMeasurement("EntityProvider", "writeLinks");
        ODataResponse response = EntityProvider.writeLinks((String)contentType, (EdmEntitySet)entitySet, values, (EntityProviderWriteProperties)entryProperties);
        context.stopRuntimeMeasurement(timingHandle);
        return ODataResponse.fromResponse((ODataResponse)response).build();
    }

    public ODataResponse countEntityLinks(GetEntitySetLinksCountUriInfo uriInfo, String contentType) throws ODataException {
        return this.countEntitySet((GetEntitySetCountUriInfo)uriInfo, contentType);
    }

    public ODataResponse readEntity(GetEntityUriInfo uriInfo, String contentType) throws ODataException {
        Object data = this.retrieveData(uriInfo.getStartEntitySet(), uriInfo.getKeyPredicates(), uriInfo.getFunctionImport(), ListsProcessor.mapFunctionParameters(uriInfo.getFunctionImportParameters()), uriInfo.getNavigationSegments());
        EdmEntitySet entitySet = uriInfo.getTargetEntitySet();
        if (!this.appliesFilter(entitySet, data, uriInfo.getFilter())) {
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        ExpandSelectTreeNode expandSelectTreeNode = UriParser.createExpandSelectTree((List)uriInfo.getSelect(), (List)uriInfo.getExpand());
        return ODataResponse.fromResponse((ODataResponse)this.writeEntry(entitySet, expandSelectTreeNode, data, contentType)).build();
    }

    public ODataResponse existsEntity(GetEntityCountUriInfo uriInfo, String contentType) throws ODataException {
        Object data = this.retrieveData(uriInfo.getStartEntitySet(), uriInfo.getKeyPredicates(), uriInfo.getFunctionImport(), ListsProcessor.mapFunctionParameters(uriInfo.getFunctionImportParameters()), uriInfo.getNavigationSegments());
        return ODataResponse.fromResponse((ODataResponse)EntityProvider.writeText((String)(this.appliesFilter(uriInfo.getTargetEntitySet(), data, uriInfo.getFilter()) ? "1" : "0"))).build();
    }

    public ODataResponse deleteEntity(DeleteUriInfo uriInfo, String contentType) throws ODataException {
        this.dataSource.deleteData(uriInfo.getStartEntitySet(), ListsProcessor.mapKey(uriInfo.getKeyPredicates()));
        return ODataResponse.newBuilder().build();
    }

    public ODataResponse createEntity(PostUriInfo uriInfo, InputStream content, String requestContentType, String contentType) throws ODataException {
        EdmEntitySet entitySet = uriInfo.getTargetEntitySet();
        EdmEntityType entityType = entitySet.getEntityType();
        Object data = this.dataSource.newDataObject(entitySet);
        ExpandSelectTreeNode expandSelectTree = null;
        if (entityType.hasStream()) {
            this.dataSource.createData(entitySet, data);
            this.dataSource.writeBinaryData(entitySet, data, new ScenarioDataSource.BinaryData(EntityProvider.readBinary((InputStream)content), requestContentType));
        } else {
            EntityProviderReadProperties properties = EntityProviderReadProperties.init().mergeSemantic(false).addTypeMappings(this.getStructuralTypeTypeMap(data, (EdmStructuralType)entityType)).build();
            ODataEntry entryValues = this.parseEntry(entitySet, content, requestContentType, properties);
            this.setStructuralTypeValuesFromMap(data, (EdmStructuralType)entityType, entryValues.getProperties(), false);
            this.dataSource.createData(entitySet, data);
            this.createInlinedEntities(entitySet, data, entryValues);
            expandSelectTree = entryValues.getExpandSelectTree();
        }
        List navigationSegments = uriInfo.getNavigationSegments();
        if (!navigationSegments.isEmpty()) {
            List<NavigationSegment> previousSegments = navigationSegments.subList(0, navigationSegments.size() - 1);
            Object sourceData = this.retrieveData(uriInfo.getStartEntitySet(), uriInfo.getKeyPredicates(), uriInfo.getFunctionImport(), ListsProcessor.mapFunctionParameters(uriInfo.getFunctionImportParameters()), previousSegments);
            EdmEntitySet previousEntitySet = previousSegments.isEmpty() ? uriInfo.getStartEntitySet() : previousSegments.get(previousSegments.size() - 1).getEntitySet();
            this.dataSource.writeRelation(previousEntitySet, sourceData, entitySet, this.getStructuralTypeValueMap(data, (EdmStructuralType)entityType));
        }
        return ODataResponse.fromResponse((ODataResponse)this.writeEntry(uriInfo.getTargetEntitySet(), expandSelectTree, data, contentType)).eTag(this.constructETag(entitySet, data)).build();
    }

    public ODataResponse updateEntity(PutMergePatchUriInfo uriInfo, InputStream content, String requestContentType, boolean merge, String contentType) throws ODataException {
        Object data = this.retrieveData(uriInfo.getStartEntitySet(), uriInfo.getKeyPredicates(), uriInfo.getFunctionImport(), ListsProcessor.mapFunctionParameters(uriInfo.getFunctionImportParameters()), uriInfo.getNavigationSegments());
        EdmEntitySet entitySet = uriInfo.getTargetEntitySet();
        if (!this.appliesFilter(entitySet, data, uriInfo.getFilter())) {
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        EdmEntityType entityType = entitySet.getEntityType();
        EntityProviderReadProperties properties = EntityProviderReadProperties.init().mergeSemantic(merge).addTypeMappings(this.getStructuralTypeTypeMap(data, (EdmStructuralType)entityType)).build();
        ODataEntry entryValues = this.parseEntry(entitySet, content, requestContentType, properties);
        this.setStructuralTypeValuesFromMap(data, (EdmStructuralType)entityType, entryValues.getProperties(), merge);
        return ODataResponse.newBuilder().eTag(this.constructETag(entitySet, data)).build();
    }

    public ODataResponse readEntityLink(GetEntityLinkUriInfo uriInfo, String contentType) throws ODataException {
        Object data = this.retrieveData(uriInfo.getStartEntitySet(), uriInfo.getKeyPredicates(), uriInfo.getFunctionImport(), ListsProcessor.mapFunctionParameters(uriInfo.getFunctionImportParameters()), uriInfo.getNavigationSegments());
        if (data == null) {
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        EdmEntitySet entitySet = uriInfo.getTargetEntitySet();
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (EdmProperty property : entitySet.getEntityType().getKeyProperties()) {
            values.put(property.getName(), this.valueAccess.getPropertyValue(data, property));
        }
        ODataContext context = this.getContext();
        EntityProviderWriteProperties entryProperties = EntityProviderWriteProperties.serviceRoot((URI)context.getPathInfo().getServiceRoot()).build();
        int timingHandle = context.startRuntimeMeasurement("EntityProvider", "writeLink");
        ODataResponse response = EntityProvider.writeLink((String)contentType, (EdmEntitySet)entitySet, values, (EntityProviderWriteProperties)entryProperties);
        context.stopRuntimeMeasurement(timingHandle);
        return ODataResponse.fromResponse((ODataResponse)response).build();
    }

    public ODataResponse existsEntityLink(GetEntityLinkCountUriInfo uriInfo, String contentType) throws ODataException {
        return this.existsEntity((GetEntityCountUriInfo)uriInfo, contentType);
    }

    public ODataResponse deleteEntityLink(DeleteUriInfo uriInfo, String contentType) throws ODataException {
        Map<String, Object> keys;
        EdmEntitySet targetEntitySet;
        List navigationSegments = uriInfo.getNavigationSegments();
        List<NavigationSegment> previousSegments = navigationSegments.subList(0, navigationSegments.size() - 1);
        Object sourceData = this.retrieveData(uriInfo.getStartEntitySet(), uriInfo.getKeyPredicates(), uriInfo.getFunctionImport(), ListsProcessor.mapFunctionParameters(uriInfo.getFunctionImportParameters()), previousSegments);
        EdmEntitySet entitySet = previousSegments.isEmpty() ? uriInfo.getStartEntitySet() : previousSegments.get(previousSegments.size() - 1).getEntitySet();
        Object targetData = this.dataSource.readRelatedData(entitySet, sourceData, targetEntitySet = uriInfo.getTargetEntitySet(), keys = ListsProcessor.mapKey(uriInfo.getTargetKeyPredicates()));
        if (targetData == null) {
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        this.dataSource.deleteRelation(entitySet, sourceData, targetEntitySet, keys);
        return ODataResponse.newBuilder().build();
    }

    public ODataResponse createEntityLink(PostUriInfo uriInfo, InputStream content, String requestContentType, String contentType) throws ODataException {
        List navigationSegments = uriInfo.getNavigationSegments();
        List<NavigationSegment> previousSegments = navigationSegments.subList(0, navigationSegments.size() - 1);
        Object sourceData = this.retrieveData(uriInfo.getStartEntitySet(), uriInfo.getKeyPredicates(), uriInfo.getFunctionImport(), ListsProcessor.mapFunctionParameters(uriInfo.getFunctionImportParameters()), previousSegments);
        EdmEntitySet entitySet = previousSegments.isEmpty() ? uriInfo.getStartEntitySet() : previousSegments.get(previousSegments.size() - 1).getEntitySet();
        EdmEntitySet targetEntitySet = uriInfo.getTargetEntitySet();
        Map<String, Object> targetKeys = this.parseLink(targetEntitySet, content, requestContentType);
        this.dataSource.writeRelation(entitySet, sourceData, targetEntitySet, targetKeys);
        return ODataResponse.newBuilder().build();
    }

    public ODataResponse updateEntityLink(PutMergePatchUriInfo uriInfo, InputStream content, String requestContentType, String contentType) throws ODataException {
        Map<String, Object> keys;
        Object targetData;
        List navigationSegments = uriInfo.getNavigationSegments();
        List<NavigationSegment> previousSegments = navigationSegments.subList(0, navigationSegments.size() - 1);
        Object sourceData = this.retrieveData(uriInfo.getStartEntitySet(), uriInfo.getKeyPredicates(), uriInfo.getFunctionImport(), ListsProcessor.mapFunctionParameters(uriInfo.getFunctionImportParameters()), previousSegments);
        EdmEntitySet entitySet = previousSegments.isEmpty() ? uriInfo.getStartEntitySet() : previousSegments.get(previousSegments.size() - 1).getEntitySet();
        EdmEntitySet targetEntitySet = uriInfo.getTargetEntitySet();
        if (!this.appliesFilter(targetEntitySet, targetData = this.dataSource.readRelatedData(entitySet, sourceData, targetEntitySet, keys = ListsProcessor.mapKey(uriInfo.getTargetKeyPredicates())), uriInfo.getFilter())) {
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        this.dataSource.deleteRelation(entitySet, sourceData, targetEntitySet, keys);
        Map<String, Object> newKeys = this.parseLink(targetEntitySet, content, requestContentType);
        this.dataSource.writeRelation(entitySet, sourceData, targetEntitySet, newKeys);
        return ODataResponse.newBuilder().build();
    }

    public ODataResponse readEntityComplexProperty(GetComplexPropertyUriInfo uriInfo, String contentType) throws ODataException {
        Object data = this.retrieveData(uriInfo.getStartEntitySet(), uriInfo.getKeyPredicates(), uriInfo.getFunctionImport(), ListsProcessor.mapFunctionParameters(uriInfo.getFunctionImportParameters()), uriInfo.getNavigationSegments());
        if (data == null) {
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        List propertyPath = uriInfo.getPropertyPath();
        EdmProperty property = (EdmProperty)propertyPath.get(propertyPath.size() - 1);
        Map<String, Object> value = property.isSimple() ? (property.getMapping() == null || property.getMapping().getMediaResourceMimeTypeKey() == null ? this.getPropertyValue(data, propertyPath) : this.getSimpleTypeValueMap(data, propertyPath)) : this.getStructuralTypeValueMap(this.getPropertyValue(data, propertyPath), (EdmStructuralType)property.getType());
        ODataContext context = this.getContext();
        int timingHandle = context.startRuntimeMeasurement("EntityProvider", "writeProperty");
        ODataResponse response = EntityProvider.writeProperty((String)contentType, (EdmProperty)property, value);
        context.stopRuntimeMeasurement(timingHandle);
        return ODataResponse.fromResponse((ODataResponse)response).eTag(this.constructETag(uriInfo.getTargetEntitySet(), data)).build();
    }

    public ODataResponse readEntitySimpleProperty(GetSimplePropertyUriInfo uriInfo, String contentType) throws ODataException {
        return this.readEntityComplexProperty((GetComplexPropertyUriInfo)uriInfo, contentType);
    }

    public ODataResponse readEntitySimplePropertyValue(GetSimplePropertyUriInfo uriInfo, String contentType) throws ODataException {
        Object data = this.retrieveData(uriInfo.getStartEntitySet(), uriInfo.getKeyPredicates(), uriInfo.getFunctionImport(), ListsProcessor.mapFunctionParameters(uriInfo.getFunctionImportParameters()), uriInfo.getNavigationSegments());
        if (data == null) {
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        List propertyPath = uriInfo.getPropertyPath();
        EdmProperty property = (EdmProperty)propertyPath.get(propertyPath.size() - 1);
        Map<String, Object> value = property.getMapping() == null || property.getMapping().getMediaResourceMimeTypeKey() == null ? this.getPropertyValue(data, propertyPath) : this.getSimpleTypeValueMap(data, propertyPath);
        return ODataResponse.fromResponse((ODataResponse)EntityProvider.writePropertyValue((EdmProperty)property, value)).eTag(this.constructETag(uriInfo.getTargetEntitySet(), data)).build();
    }

    public ODataResponse deleteEntitySimplePropertyValue(DeleteUriInfo uriInfo, String contentType) throws ODataException {
        Object data = this.retrieveData(uriInfo.getStartEntitySet(), uriInfo.getKeyPredicates(), uriInfo.getFunctionImport(), ListsProcessor.mapFunctionParameters(uriInfo.getFunctionImportParameters()), uriInfo.getNavigationSegments());
        if (data == null) {
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        List propertyPath = uriInfo.getPropertyPath();
        EdmProperty property = (EdmProperty)propertyPath.get(propertyPath.size() - 1);
        data = this.getPropertyValue(data, propertyPath.subList(0, propertyPath.size() - 1));
        this.valueAccess.setPropertyValue(data, property, null);
        this.valueAccess.setMappingValue(data, property.getMapping(), null);
        return ODataResponse.newBuilder().build();
    }

    public ODataResponse updateEntityComplexProperty(PutMergePatchUriInfo uriInfo, InputStream content, String requestContentType, boolean merge, String contentType) throws ODataException {
        Map values;
        Object data = this.retrieveData(uriInfo.getStartEntitySet(), uriInfo.getKeyPredicates(), uriInfo.getFunctionImport(), ListsProcessor.mapFunctionParameters(uriInfo.getFunctionImportParameters()), uriInfo.getNavigationSegments());
        if (!this.appliesFilter(uriInfo.getTargetEntitySet(), data, uriInfo.getFilter())) {
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        List propertyPath = uriInfo.getPropertyPath();
        EdmProperty property = (EdmProperty)propertyPath.get(propertyPath.size() - 1);
        data = this.getPropertyValue(data, propertyPath.subList(0, propertyPath.size() - 1));
        ODataContext context = this.getContext();
        int timingHandle = context.startRuntimeMeasurement("EntityConsumer", "readProperty");
        try {
            values = EntityProvider.readProperty((String)requestContentType, (EdmProperty)property, (InputStream)content, (EntityProviderReadProperties)EntityProviderReadProperties.init().mergeSemantic(merge).build());
        }
        catch (EntityProviderException e) {
            throw new ODataBadRequestException(ODataBadRequestException.BODY, (Throwable)e);
        }
        context.stopRuntimeMeasurement(timingHandle);
        Object value = values.get(property.getName());
        if (property.isSimple()) {
            this.valueAccess.setPropertyValue(data, property, value);
        } else {
            Map propertyValue = (Map)value;
            this.setStructuralTypeValuesFromMap(this.valueAccess.getPropertyValue(data, property), (EdmStructuralType)property.getType(), propertyValue, merge);
        }
        return ODataResponse.newBuilder().eTag(this.constructETag(uriInfo.getTargetEntitySet(), data)).build();
    }

    public ODataResponse updateEntitySimpleProperty(PutMergePatchUriInfo uriInfo, InputStream content, String requestContentType, String contentType) throws ODataException {
        return this.updateEntityComplexProperty(uriInfo, content, requestContentType, false, contentType);
    }

    public ODataResponse updateEntitySimplePropertyValue(PutMergePatchUriInfo uriInfo, InputStream content, String requestContentType, String contentType) throws ODataException {
        Object value;
        Object data = this.retrieveData(uriInfo.getStartEntitySet(), uriInfo.getKeyPredicates(), uriInfo.getFunctionImport(), ListsProcessor.mapFunctionParameters(uriInfo.getFunctionImportParameters()), uriInfo.getNavigationSegments());
        if (!this.appliesFilter(uriInfo.getTargetEntitySet(), data, uriInfo.getFilter())) {
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        List propertyPath = uriInfo.getPropertyPath();
        EdmProperty property = (EdmProperty)propertyPath.get(propertyPath.size() - 1);
        data = this.getPropertyValue(data, propertyPath.subList(0, propertyPath.size() - 1));
        ODataContext context = this.getContext();
        int timingHandle = context.startRuntimeMeasurement("EntityConsumer", "readPropertyValue");
        try {
            value = EntityProvider.readPropertyValue((EdmProperty)property, (InputStream)content);
        }
        catch (EntityProviderException e) {
            throw new ODataBadRequestException(ODataBadRequestException.BODY, (Throwable)e);
        }
        context.stopRuntimeMeasurement(timingHandle);
        this.valueAccess.setPropertyValue(data, property, value);
        this.valueAccess.setMappingValue(data, property.getMapping(), requestContentType);
        return ODataResponse.newBuilder().eTag(this.constructETag(uriInfo.getTargetEntitySet(), data)).build();
    }

    public ODataResponse readEntityMedia(GetMediaResourceUriInfo uriInfo, String contentType) throws ODataException {
        Object data = this.retrieveData(uriInfo.getStartEntitySet(), uriInfo.getKeyPredicates(), uriInfo.getFunctionImport(), ListsProcessor.mapFunctionParameters(uriInfo.getFunctionImportParameters()), uriInfo.getNavigationSegments());
        EdmEntitySet entitySet = uriInfo.getTargetEntitySet();
        if (!this.appliesFilter(entitySet, data, uriInfo.getFilter())) {
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        ScenarioDataSource.BinaryData binaryData = this.dataSource.readBinaryData(entitySet, data);
        if (binaryData == null) {
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        String mimeType = binaryData.getMimeType() == null ? "application/octet-stream" : binaryData.getMimeType();
        return ODataResponse.fromResponse((ODataResponse)EntityProvider.writeBinary((String)mimeType, (byte[])binaryData.getData())).eTag(this.constructETag(entitySet, data)).build();
    }

    public ODataResponse deleteEntityMedia(DeleteUriInfo uriInfo, String contentType) throws ODataException {
        Object data = this.retrieveData(uriInfo.getStartEntitySet(), uriInfo.getKeyPredicates(), uriInfo.getFunctionImport(), ListsProcessor.mapFunctionParameters(uriInfo.getFunctionImportParameters()), uriInfo.getNavigationSegments());
        if (data == null) {
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        this.dataSource.writeBinaryData(uriInfo.getTargetEntitySet(), data, new ScenarioDataSource.BinaryData(null, null));
        return ODataResponse.newBuilder().build();
    }

    public ODataResponse updateEntityMedia(PutMergePatchUriInfo uriInfo, InputStream content, String requestContentType, String contentType) throws ODataException {
        Object data = this.retrieveData(uriInfo.getStartEntitySet(), uriInfo.getKeyPredicates(), uriInfo.getFunctionImport(), ListsProcessor.mapFunctionParameters(uriInfo.getFunctionImportParameters()), uriInfo.getNavigationSegments());
        EdmEntitySet entitySet = uriInfo.getTargetEntitySet();
        if (!this.appliesFilter(entitySet, data, uriInfo.getFilter())) {
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        ODataContext context = this.getContext();
        int timingHandle = context.startRuntimeMeasurement("EntityProvider", "readBinary");
        byte[] value = EntityProvider.readBinary((InputStream)content);
        context.stopRuntimeMeasurement(timingHandle);
        this.dataSource.writeBinaryData(entitySet, data, new ScenarioDataSource.BinaryData(value, requestContentType));
        return ODataResponse.newBuilder().eTag(this.constructETag(entitySet, data)).build();
    }

    public ODataResponse executeFunctionImport(GetFunctionImportUriInfo uriInfo, String contentType) throws ODataException {
        Object value;
        EdmFunctionImport functionImport = uriInfo.getFunctionImport();
        EdmType type = functionImport.getReturnType().getType();
        Map<String, Object> data = this.dataSource.readData(functionImport, ListsProcessor.mapFunctionParameters(uriInfo.getFunctionImportParameters()), null);
        if (data == null) {
            throw new ODataNotFoundException(ODataHttpException.COMMON);
        }
        if (type.getKind() == EdmTypeKind.SIMPLE) {
            value = type == EdmSimpleTypeKind.Binary.getEdmSimpleTypeInstance() ? (Object)((ScenarioDataSource.BinaryData)((Object)data)).getData() : data;
        } else if (functionImport.getReturnType().getMultiplicity() == EdmMultiplicity.MANY) {
            ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
            for (Object typeData : (List)((Object)data)) {
                values.add(this.getStructuralTypeValueMap(typeData, (EdmStructuralType)type));
            }
            value = values;
        } else {
            value = this.getStructuralTypeValueMap(data, (EdmStructuralType)type);
        }
        ODataContext context = this.getContext();
        EntityProviderWriteProperties entryProperties = EntityProviderWriteProperties.serviceRoot((URI)context.getPathInfo().getServiceRoot()).build();
        int timingHandle = context.startRuntimeMeasurement("EntityProvider", "writeFunctionImport");
        ODataResponse response = EntityProvider.writeFunctionImport((String)contentType, (EdmFunctionImport)functionImport, (Object)value, (EntityProviderWriteProperties)entryProperties);
        context.stopRuntimeMeasurement(timingHandle);
        return ODataResponse.fromResponse((ODataResponse)response).build();
    }

    public ODataResponse executeFunctionImportValue(GetFunctionImportUriInfo uriInfo, String contentType) throws ODataException {
        String value;
        EdmFunctionImport functionImport = uriInfo.getFunctionImport();
        EdmSimpleType type = (EdmSimpleType)functionImport.getReturnType().getType();
        Object data = this.dataSource.readData(functionImport, ListsProcessor.mapFunctionParameters(uriInfo.getFunctionImportParameters()), null);
        if (data == null) {
            throw new ODataNotFoundException(ODataHttpException.COMMON);
        }
        ODataResponse response = type == EdmSimpleTypeKind.Binary.getEdmSimpleTypeInstance() ? EntityProvider.writeBinary((String)((ScenarioDataSource.BinaryData)data).getMimeType(), (byte[])((ScenarioDataSource.BinaryData)data).getData()) : EntityProvider.writeText((String)((value = type.valueToString(data, EdmLiteralKind.DEFAULT, null)) == null ? "" : value));
        return ODataResponse.fromResponse((ODataResponse)response).build();
    }

    private static Map<String, Object> mapKey(List<KeyPredicate> keys) throws EdmException {
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        for (KeyPredicate key : keys) {
            EdmProperty property = key.getProperty();
            EdmSimpleType type = (EdmSimpleType)property.getType();
            keyMap.put(property.getName(), type.valueOfString(key.getLiteral(), EdmLiteralKind.DEFAULT, property.getFacets(), type.getDefaultType()));
        }
        return keyMap;
    }

    private static Map<String, Object> mapFunctionParameters(Map<String, EdmLiteral> functionImportParameters) throws EdmSimpleTypeException {
        if (functionImportParameters == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        for (String parameterName : functionImportParameters.keySet()) {
            EdmLiteral literal = functionImportParameters.get(parameterName);
            EdmSimpleType type = literal.getType();
            parameterMap.put(parameterName, type.valueOfString(literal.getLiteral(), EdmLiteralKind.DEFAULT, null, type.getDefaultType()));
        }
        return parameterMap;
    }

    private Object retrieveData(EdmEntitySet startEntitySet, List<KeyPredicate> keyPredicates, EdmFunctionImport functionImport, Map<String, Object> functionImportParameters, List<NavigationSegment> navigationSegments) throws ODataException {
        Object data;
        Map<String, Object> keys = ListsProcessor.mapKey(keyPredicates);
        ODataContext context = this.getContext();
        int timingHandle = context.startRuntimeMeasurement(((Object)((Object)this)).getClass().getSimpleName(), "retrieveData");
        try {
            data = functionImport == null ? (keys.isEmpty() ? this.dataSource.readData(startEntitySet) : this.dataSource.readData(startEntitySet, keys)) : this.dataSource.readData(functionImport, functionImportParameters, keys);
            EdmEntitySet currentEntitySet = functionImport == null ? startEntitySet : functionImport.getEntitySet();
            for (NavigationSegment navigationSegment : navigationSegments) {
                data = this.dataSource.readRelatedData(currentEntitySet, data, navigationSegment.getEntitySet(), ListsProcessor.mapKey(navigationSegment.getKeyPredicates()));
                currentEntitySet = navigationSegment.getEntitySet();
            }
        }
        finally {
            context.stopRuntimeMeasurement(timingHandle);
        }
        return data;
    }

    private <T> String constructETag(EdmEntitySet entitySet, T data) throws ODataException {
        EdmEntityType entityType = entitySet.getEntityType();
        String eTag = null;
        for (String propertyName : entityType.getPropertyNames()) {
            EdmProperty property = (EdmProperty)entityType.getProperty(propertyName);
            if (property.getFacets() == null || property.getFacets().getConcurrencyMode() != EdmConcurrencyMode.Fixed) continue;
            EdmSimpleType type = (EdmSimpleType)property.getType();
            String component = type.valueToString(this.valueAccess.getPropertyValue(data, property), EdmLiteralKind.DEFAULT, property.getFacets());
            String string = eTag = eTag == null ? component : String.valueOf(eTag) + "." + component;
        }
        return eTag == null ? null : "W/\"" + eTag + "\"";
    }

    private <T> Map<String, ODataCallback> getCallbacks(T data, EdmEntityType entityType) throws EdmException {
        List navigationPropertyNames = entityType.getNavigationPropertyNames();
        if (navigationPropertyNames.isEmpty()) {
            return null;
        }
        WriteCallback callback = new WriteCallback(data);
        HashMap<String, ODataCallback> callbacks = new HashMap<String, ODataCallback>();
        for (String name : navigationPropertyNames) {
            callbacks.put(name, (ODataCallback)callback);
        }
        return callbacks;
    }

    private <T> ODataResponse writeEntry(EdmEntitySet entitySet, ExpandSelectTreeNode expandSelectTree, T data, String contentType) throws ODataException, EntityProviderException {
        EdmEntityType entityType = entitySet.getEntityType();
        Map<String, Object> values = this.getStructuralTypeValueMap(data, (EdmStructuralType)entityType);
        ODataContext context = this.getContext();
        EntityProviderWriteProperties writeProperties = EntityProviderWriteProperties.serviceRoot((URI)context.getPathInfo().getServiceRoot()).expandSelectTree(expandSelectTree).callbacks(this.getCallbacks(data, entityType)).build();
        int timingHandle = context.startRuntimeMeasurement("EntityProvider", "writeEntry");
        ODataResponse response = EntityProvider.writeEntry((String)contentType, (EdmEntitySet)entitySet, values, (EntityProviderWriteProperties)writeProperties);
        context.stopRuntimeMeasurement(timingHandle);
        return response;
    }

    private ODataEntry parseEntry(EdmEntitySet entitySet, InputStream content, String requestContentType, EntityProviderReadProperties properties) throws ODataBadRequestException {
        ODataEntry entryValues;
        ODataContext context = this.getContext();
        int timingHandle = context.startRuntimeMeasurement("EntityConsumer", "readEntry");
        try {
            entryValues = EntityProvider.readEntry((String)requestContentType, (EdmEntitySet)entitySet, (InputStream)content, (EntityProviderReadProperties)properties);
        }
        catch (EntityProviderException e) {
            throw new ODataBadRequestException(ODataBadRequestException.BODY, (Throwable)e);
        }
        context.stopRuntimeMeasurement(timingHandle);
        return entryValues;
    }

    private Map<String, Object> parseLink(EdmEntitySet entitySet, InputStream content, String contentType) throws ODataException {
        ODataContext context = this.getContext();
        int timingHandle = context.startRuntimeMeasurement("EntityProvider", "readLink");
        String uriString = EntityProvider.readLink((String)contentType, (EdmEntitySet)entitySet, (InputStream)content);
        context.stopRuntimeMeasurement(timingHandle);
        Map<String, Object> targetKeys = this.parseLinkUri(entitySet, uriString);
        if (targetKeys == null) {
            throw new ODataBadRequestException(ODataBadRequestException.BODY);
        }
        return targetKeys;
    }

    private Map<String, Object> parseLinkUri(EdmEntitySet targetEntitySet, String uriString) throws EdmException {
        ODataContext context = this.getContext();
        int timingHandle = context.startRuntimeMeasurement("UriParser", "getKeyPredicatesFromEntityLink");
        List key = null;
        try {
            key = UriParser.getKeyPredicatesFromEntityLink((EdmEntitySet)targetEntitySet, (String)uriString, (URI)context.getPathInfo().getServiceRoot());
        }
        catch (ODataException oDataException) {
            // empty catch block
        }
        context.stopRuntimeMeasurement(timingHandle);
        return key == null ? null : ListsProcessor.mapKey(key);
    }

    private <T> void createInlinedEntities(EdmEntitySet entitySet, T data, ODataEntry entryValues) throws ODataException {
        EdmEntityType entityType = entitySet.getEntityType();
        for (String navigationPropertyName : entityType.getNavigationPropertyNames()) {
            EdmNavigationProperty navigationProperty = (EdmNavigationProperty)entityType.getProperty(navigationPropertyName);
            EdmEntitySet relatedEntitySet = entitySet.getRelatedEntitySet(navigationProperty);
            EdmEntityType relatedEntityType = relatedEntitySet.getEntityType();
            Object relatedValue = entryValues.getProperties().get(navigationPropertyName);
            if (relatedValue == null) {
                for (String uriString : entryValues.getMetadata().getAssociationUris(navigationPropertyName)) {
                    Map<String, Object> key = this.parseLinkUri(relatedEntitySet, uriString);
                    if (key == null) continue;
                    this.dataSource.writeRelation(entitySet, data, relatedEntitySet, key);
                }
                continue;
            }
            if (relatedValue instanceof ODataFeed) {
                ODataFeed feed = (ODataFeed)relatedValue;
                List relatedValueList = feed.getEntries();
                for (ODataEntry relatedValues : relatedValueList) {
                    Object relatedData = this.dataSource.newDataObject(relatedEntitySet);
                    this.setStructuralTypeValuesFromMap(relatedData, (EdmStructuralType)relatedEntityType, relatedValues.getProperties(), false);
                    this.dataSource.createData(relatedEntitySet, relatedData);
                    this.dataSource.writeRelation(entitySet, data, relatedEntitySet, this.getStructuralTypeValueMap(relatedData, (EdmStructuralType)relatedEntityType));
                    this.createInlinedEntities(relatedEntitySet, relatedData, relatedValues);
                }
                continue;
            }
            if (relatedValue instanceof ODataEntry) {
                ODataEntry relatedValueEntry = (ODataEntry)relatedValue;
                Object relatedData = this.dataSource.newDataObject(relatedEntitySet);
                this.setStructuralTypeValuesFromMap(relatedData, (EdmStructuralType)relatedEntityType, relatedValueEntry.getProperties(), false);
                this.dataSource.createData(relatedEntitySet, relatedData);
                this.dataSource.writeRelation(entitySet, data, relatedEntitySet, this.getStructuralTypeValueMap(relatedData, (EdmStructuralType)relatedEntityType));
                this.createInlinedEntities(relatedEntitySet, relatedData, relatedValueEntry);
                continue;
            }
            throw new ODataException("Unexpected class for a related value: " + relatedValue.getClass().getSimpleName());
        }
    }

    private <T> Integer applySystemQueryOptions(EdmEntitySet entitySet, List<T> data, FilterExpression filter, InlineCount inlineCount, OrderByExpression orderBy, String skipToken, Integer skip, Integer top) throws ODataException {
        Integer count;
        ODataContext context = this.getContext();
        int timingHandle = context.startRuntimeMeasurement(((Object)((Object)this)).getClass().getSimpleName(), "applySystemQueryOptions");
        if (filter != null) {
            Iterator<T> iterator = data.iterator();
            while (iterator.hasNext()) {
                if (this.appliesFilter(entitySet, iterator.next(), filter)) continue;
                iterator.remove();
            }
        }
        Integer n = count = inlineCount == InlineCount.ALLPAGES ? Integer.valueOf(data.size()) : null;
        if (orderBy != null) {
            this.sort(entitySet, data, orderBy);
        } else if (skipToken != null || skip != null || top != null) {
            this.sortInDefaultOrder(entitySet, data);
        }
        if (skipToken != null) {
            while (!data.isEmpty() && !this.getSkipToken(entitySet, data.get(0)).equals(skipToken)) {
                data.remove(0);
            }
        }
        if (skip != null) {
            if (skip >= data.size()) {
                data.clear();
            } else {
                int i = 0;
                while (i < skip) {
                    data.remove(0);
                    ++i;
                }
            }
        }
        if (top != null) {
            while (data.size() > top) {
                data.remove(top);
            }
        }
        context.stopRuntimeMeasurement(timingHandle);
        return count;
    }

    private <T> void sort(final EdmEntitySet entitySet, List<T> data, final OrderByExpression orderBy) {
        Collections.sort(data, new Comparator<T>(){

            @Override
            public int compare(T entity1, T entity2) {
                try {
                    int result = 0;
                    for (OrderExpression expression : orderBy.getOrders()) {
                        String first = ListsProcessor.this.evaluateExpression(entitySet, entity1, expression.getExpression());
                        String second = ListsProcessor.this.evaluateExpression(entitySet, entity2, expression.getExpression());
                        if (first != null && second != null) {
                            result = first.compareTo(second);
                        } else if (first == null && second != null) {
                            result = 1;
                        } else if (first != null && second == null) {
                            result = -1;
                        }
                        if (expression.getSortOrder() == SortOrder.desc) {
                            result = -result;
                        }
                        if (result != 0) break;
                    }
                    return result;
                }
                catch (ODataException e) {
                    return 0;
                }
            }
        });
    }

    private <T> void sortInDefaultOrder(final EdmEntitySet entitySet, List<T> data) {
        Collections.sort(data, new Comparator<T>(){

            @Override
            public int compare(T entity1, T entity2) {
                try {
                    return ListsProcessor.this.getSkipToken(entitySet, entity1).compareTo(ListsProcessor.this.getSkipToken(entitySet, entity2));
                }
                catch (ODataException e) {
                    return 0;
                }
            }
        });
    }

    private <T> boolean appliesFilter(EdmEntitySet entitySet, T data, FilterExpression filter) throws ODataException {
        ODataContext context = this.getContext();
        int timingHandle = context.startRuntimeMeasurement(((Object)((Object)this)).getClass().getSimpleName(), "appliesFilter");
        try {
            boolean bl = data != null && (filter == null || this.evaluateExpression(entitySet, data, filter.getExpression()).equals("true"));
            return bl;
        }
        catch (RuntimeException e) {
            return false;
        }
        finally {
            context.stopRuntimeMeasurement(timingHandle);
        }
    }

    private <T> String evaluateExpression(EdmEntitySet entitySet, T data, CommonExpression expression) throws ODataException {
        switch (expression.getKind()) {
            case UNARY: {
                UnaryExpression unaryExpression = (UnaryExpression)expression;
                String operand = this.evaluateExpression(entitySet, data, unaryExpression.getOperand());
                switch (unaryExpression.getOperator()) {
                    case NOT: {
                        return Boolean.toString(!Boolean.parseBoolean(operand));
                    }
                    case MINUS: {
                        return operand.startsWith("-") ? operand.substring(1) : "-" + operand;
                    }
                }
                throw new ODataNotImplementedException();
            }
            case BINARY: {
                BinaryExpression binaryExpression = (BinaryExpression)expression;
                EdmType type = binaryExpression.getLeftOperand().getEdmType();
                String left = this.evaluateExpression(entitySet, data, binaryExpression.getLeftOperand());
                String right = this.evaluateExpression(entitySet, data, binaryExpression.getRightOperand());
                switch (binaryExpression.getOperator()) {
                    case ADD: {
                        if (binaryExpression.getEdmType() == EdmSimpleTypeKind.Decimal.getEdmSimpleTypeInstance() || binaryExpression.getEdmType() == EdmSimpleTypeKind.Double.getEdmSimpleTypeInstance() || binaryExpression.getEdmType() == EdmSimpleTypeKind.Single.getEdmSimpleTypeInstance()) {
                            return Double.toString(Double.valueOf(left) + Double.valueOf(right));
                        }
                        return Long.toString(Long.valueOf(left) + Long.valueOf(right));
                    }
                    case SUB: {
                        if (binaryExpression.getEdmType() == EdmSimpleTypeKind.Decimal.getEdmSimpleTypeInstance() || binaryExpression.getEdmType() == EdmSimpleTypeKind.Double.getEdmSimpleTypeInstance() || binaryExpression.getEdmType() == EdmSimpleTypeKind.Single.getEdmSimpleTypeInstance()) {
                            return Double.toString(Double.valueOf(left) - Double.valueOf(right));
                        }
                        return Long.toString(Long.valueOf(left) - Long.valueOf(right));
                    }
                    case MUL: {
                        if (binaryExpression.getEdmType() == EdmSimpleTypeKind.Decimal.getEdmSimpleTypeInstance() || binaryExpression.getEdmType() == EdmSimpleTypeKind.Double.getEdmSimpleTypeInstance() || binaryExpression.getEdmType() == EdmSimpleTypeKind.Single.getEdmSimpleTypeInstance()) {
                            return Double.toString(Double.valueOf(left) * Double.valueOf(right));
                        }
                        return Long.toString(Long.valueOf(left) * Long.valueOf(right));
                    }
                    case DIV: {
                        String number = Double.toString(Double.valueOf(left) / Double.valueOf(right));
                        return number.endsWith(".0") ? number.replace(".0", "") : number;
                    }
                    case MODULO: {
                        if (binaryExpression.getEdmType() == EdmSimpleTypeKind.Decimal.getEdmSimpleTypeInstance() || binaryExpression.getEdmType() == EdmSimpleTypeKind.Double.getEdmSimpleTypeInstance() || binaryExpression.getEdmType() == EdmSimpleTypeKind.Single.getEdmSimpleTypeInstance()) {
                            return Double.toString(Double.valueOf(left) % Double.valueOf(right));
                        }
                        return Long.toString(Long.valueOf(left) % Long.valueOf(right));
                    }
                    case AND: {
                        return Boolean.toString(left.equals("true") && right.equals("true"));
                    }
                    case OR: {
                        return Boolean.toString(left.equals("true") || right.equals("true"));
                    }
                    case EQ: {
                        return Boolean.toString(left == null && right == null || left.equals(right));
                    }
                    case NE: {
                        return Boolean.toString((left != null || right != null) && !left.equals(right));
                    }
                    case LT: {
                        if (type == EdmSimpleTypeKind.String.getEdmSimpleTypeInstance() || type == EdmSimpleTypeKind.DateTime.getEdmSimpleTypeInstance() || type == EdmSimpleTypeKind.DateTimeOffset.getEdmSimpleTypeInstance() || type == EdmSimpleTypeKind.Guid.getEdmSimpleTypeInstance() || type == EdmSimpleTypeKind.Time.getEdmSimpleTypeInstance()) {
                            return Boolean.toString(left.compareTo(right) < 0);
                        }
                        return Boolean.toString(Double.valueOf(left) < Double.valueOf(right));
                    }
                    case LE: {
                        if (type == EdmSimpleTypeKind.String.getEdmSimpleTypeInstance() || type == EdmSimpleTypeKind.DateTime.getEdmSimpleTypeInstance() || type == EdmSimpleTypeKind.DateTimeOffset.getEdmSimpleTypeInstance() || type == EdmSimpleTypeKind.Guid.getEdmSimpleTypeInstance() || type == EdmSimpleTypeKind.Time.getEdmSimpleTypeInstance()) {
                            return Boolean.toString(left.compareTo(right) <= 0);
                        }
                        return Boolean.toString(Double.valueOf(left) <= Double.valueOf(right));
                    }
                    case GT: {
                        if (type == EdmSimpleTypeKind.String.getEdmSimpleTypeInstance() || type == EdmSimpleTypeKind.DateTime.getEdmSimpleTypeInstance() || type == EdmSimpleTypeKind.DateTimeOffset.getEdmSimpleTypeInstance() || type == EdmSimpleTypeKind.Guid.getEdmSimpleTypeInstance() || type == EdmSimpleTypeKind.Time.getEdmSimpleTypeInstance()) {
                            return Boolean.toString(left.compareTo(right) > 0);
                        }
                        return Boolean.toString(Double.valueOf(left) > Double.valueOf(right));
                    }
                    case GE: {
                        if (type == EdmSimpleTypeKind.String.getEdmSimpleTypeInstance() || type == EdmSimpleTypeKind.DateTime.getEdmSimpleTypeInstance() || type == EdmSimpleTypeKind.DateTimeOffset.getEdmSimpleTypeInstance() || type == EdmSimpleTypeKind.Guid.getEdmSimpleTypeInstance() || type == EdmSimpleTypeKind.Time.getEdmSimpleTypeInstance()) {
                            return Boolean.toString(left.compareTo(right) >= 0);
                        }
                        return Boolean.toString(Double.valueOf(left) >= Double.valueOf(right));
                    }
                    case PROPERTY_ACCESS: {
                        throw new ODataNotImplementedException();
                    }
                }
                throw new ODataNotImplementedException();
            }
            case PROPERTY: {
                EdmTyped property = ((PropertyExpression)expression).getEdmProperty();
                EdmType propertyType = property.getType();
                if (propertyType.getKind() == EdmTypeKind.ENTITY) {
                    try {
                        this.dataSource.readRelatedData(entitySet, data, entitySet.getRelatedEntitySet((EdmNavigationProperty)property), null);
                    }
                    catch (ODataNotFoundException e) {
                        return null;
                    }
                    return property.getName();
                }
                return ((EdmSimpleType)propertyType).valueToString(this.valueAccess.getPropertyValue(data, (EdmProperty)property), EdmLiteralKind.DEFAULT, ((EdmProperty)property).getFacets());
            }
            case MEMBER: {
                MemberExpression memberExpression = (MemberExpression)expression;
                PropertyExpression propertyExpression = (PropertyExpression)memberExpression.getProperty();
                EdmProperty memberProperty = (EdmProperty)propertyExpression.getEdmProperty();
                EdmSimpleType memberType = (EdmSimpleType)memberExpression.getEdmType();
                ArrayList<EdmProperty> propertyPath = new ArrayList<EdmProperty>();
                MemberExpression currentExpression = memberExpression;
                while (currentExpression != null) {
                    PropertyExpression currentPropertyExpression = (PropertyExpression)(currentExpression.getKind() == ExpressionKind.MEMBER ? currentExpression.getProperty() : currentExpression);
                    EdmTyped currentProperty = currentPropertyExpression.getEdmProperty();
                    EdmTypeKind kind = currentProperty.getType().getKind();
                    if (kind != EdmTypeKind.SIMPLE && kind != EdmTypeKind.COMPLEX) {
                        throw new ODataNotImplementedException();
                    }
                    propertyPath.add(0, (EdmProperty)currentProperty);
                    CommonExpression commonExpression = currentExpression = currentExpression.getKind() == ExpressionKind.MEMBER ? currentExpression.getPath() : null;
                }
                return memberType.valueToString(this.getPropertyValue(data, propertyPath), EdmLiteralKind.DEFAULT, memberProperty.getFacets());
            }
            case LITERAL: {
                LiteralExpression literal = (LiteralExpression)expression;
                EdmSimpleType literalType = (EdmSimpleType)literal.getEdmType();
                return literalType.valueToString(literalType.valueOfString(literal.getUriLiteral(), EdmLiteralKind.URI, null, literalType.getDefaultType()), EdmLiteralKind.DEFAULT, null);
            }
            case METHOD: {
                MethodExpression methodExpression = (MethodExpression)expression;
                String first = this.evaluateExpression(entitySet, data, (CommonExpression)methodExpression.getParameters().get(0));
                String second = methodExpression.getParameterCount() > 1 ? this.evaluateExpression(entitySet, data, (CommonExpression)methodExpression.getParameters().get(1)) : "";
                String third = methodExpression.getParameterCount() > 2 ? this.evaluateExpression(entitySet, data, (CommonExpression)methodExpression.getParameters().get(2)) : "";
                switch (methodExpression.getMethod()) {
                    case ENDSWITH: {
                        return Boolean.toString(first.endsWith(second));
                    }
                    case INDEXOF: {
                        return Integer.toString(first.indexOf(second));
                    }
                    case STARTSWITH: {
                        return Boolean.toString(first.startsWith(second));
                    }
                    case TOLOWER: {
                        return first.toLowerCase(Locale.ROOT);
                    }
                    case TOUPPER: {
                        return first.toUpperCase(Locale.ROOT);
                    }
                    case TRIM: {
                        return first.trim();
                    }
                    case SUBSTRING: {
                        int offset = second.length() == 0 ? 0 : Integer.parseInt(second);
                        int length = third.length() == 0 ? 0 : Integer.parseInt(second);
                        return first.substring(offset, offset + length);
                    }
                    case SUBSTRINGOF: {
                        return Boolean.toString(second.contains(first));
                    }
                    case CONCAT: {
                        return String.valueOf(first) + second;
                    }
                    case LENGTH: {
                        return Integer.toString(first.length());
                    }
                    case YEAR: {
                        return String.valueOf(Integer.parseInt(first.substring(0, 4)));
                    }
                    case MONTH: {
                        return String.valueOf(Integer.parseInt(first.substring(5, 7)));
                    }
                    case DAY: {
                        return String.valueOf(Integer.parseInt(first.substring(8, 10)));
                    }
                    case HOUR: {
                        return String.valueOf(Integer.parseInt(first.substring(11, 13)));
                    }
                    case MINUTE: {
                        return String.valueOf(Integer.parseInt(first.substring(14, 16)));
                    }
                    case SECOND: {
                        return String.valueOf(Integer.parseInt(first.substring(17, 19)));
                    }
                    case ROUND: {
                        return Long.toString(Math.round(Double.valueOf(first)));
                    }
                    case FLOOR: {
                        return Long.toString(Math.round(Math.floor(Double.valueOf(first))));
                    }
                    case CEILING: {
                        return Long.toString(Math.round(Math.ceil(Double.valueOf(first))));
                    }
                }
                throw new ODataNotImplementedException();
            }
        }
        throw new ODataNotImplementedException();
    }

    private <T> String getSkipToken(EdmEntitySet entitySet, T data) throws ODataException {
        String skipToken = "";
        for (EdmProperty property : entitySet.getEntityType().getKeyProperties()) {
            EdmSimpleType type = (EdmSimpleType)property.getType();
            skipToken = skipToken.concat(type.valueToString(this.valueAccess.getPropertyValue(data, property), EdmLiteralKind.DEFAULT, property.getFacets()));
        }
        return skipToken;
    }

    private <T> Object getPropertyValue(T data, List<EdmProperty> propertyPath) throws ODataException {
        Object dataObject = data;
        for (EdmProperty property : propertyPath) {
            if (dataObject == null) continue;
            dataObject = this.valueAccess.getPropertyValue(dataObject, property);
        }
        return dataObject;
    }

    private void handleMimeType(Object data, EdmMapping mapping, Map<String, Object> valueMap) throws ODataException {
        String mimeTypeName = mapping.getMediaResourceMimeTypeKey();
        if (mimeTypeName != null) {
            Object value = this.valueAccess.getMappingValue(data, mapping);
            valueMap.put(mimeTypeName, value);
        }
    }

    private <T> Map<String, Object> getSimpleTypeValueMap(T data, List<EdmProperty> propertyPath) throws ODataException {
        EdmProperty property = propertyPath.get(propertyPath.size() - 1);
        HashMap<String, Object> valueWithMimeType = new HashMap<String, Object>();
        valueWithMimeType.put(property.getName(), this.getPropertyValue(data, propertyPath));
        this.handleMimeType(data, property.getMapping(), valueWithMimeType);
        return valueWithMimeType;
    }

    private <T> Map<String, Object> getStructuralTypeValueMap(T data, EdmStructuralType type) throws ODataException {
        ODataContext context = this.getContext();
        int timingHandle = context.startRuntimeMeasurement(((Object)((Object)this)).getClass().getSimpleName(), "getStructuralTypeValueMap");
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        EdmMapping mapping = type.getMapping();
        if (mapping != null) {
            this.handleMimeType(data, mapping, valueMap);
        }
        for (String propertyName : type.getPropertyNames()) {
            EdmProperty property = (EdmProperty)type.getProperty(propertyName);
            Object value = this.valueAccess.getPropertyValue(data, property);
            if (property.isSimple()) {
                if (property.getMapping() == null || property.getMapping().getMediaResourceMimeTypeKey() == null) {
                    valueMap.put(propertyName, value);
                    continue;
                }
                valueMap.put(propertyName, this.getSimpleTypeValueMap(data, Arrays.asList(property)));
                continue;
            }
            valueMap.put(propertyName, this.getStructuralTypeValueMap(value, (EdmStructuralType)property.getType()));
        }
        context.stopRuntimeMeasurement(timingHandle);
        return valueMap;
    }

    private <T> Map<String, Object> getStructuralTypeTypeMap(T data, EdmStructuralType type) throws ODataException {
        ODataContext context = this.getContext();
        int timingHandle = context.startRuntimeMeasurement(((Object)((Object)this)).getClass().getSimpleName(), "getStructuralTypeTypeMap");
        HashMap<String, Object> typeMap = new HashMap<String, Object>();
        for (String propertyName : type.getPropertyNames()) {
            EdmProperty property = (EdmProperty)type.getProperty(propertyName);
            if (property.isSimple()) {
                typeMap.put(propertyName, this.valueAccess.getPropertyType(data, property));
                continue;
            }
            typeMap.put(propertyName, this.getStructuralTypeTypeMap(this.valueAccess.getPropertyValue(data, property), (EdmStructuralType)property.getType()));
        }
        context.stopRuntimeMeasurement(timingHandle);
        return typeMap;
    }

    private <T> void setStructuralTypeValuesFromMap(T data, EdmStructuralType type, Map<String, Object> valueMap, boolean merge) throws ODataException {
        ODataContext context = this.getContext();
        int timingHandle = context.startRuntimeMeasurement(((Object)((Object)this)).getClass().getSimpleName(), "setStructuralTypeValuesFromMap");
        for (String propertyName : type.getPropertyNames()) {
            Object value;
            Object v;
            EdmProperty property = (EdmProperty)type.getProperty(propertyName);
            if (type instanceof EdmEntityType && ((EdmEntityType)type).getKeyProperties().contains(property) && (v = this.valueAccess.getPropertyValue(data, property)) != null || merge && (valueMap == null || !valueMap.containsKey(propertyName))) continue;
            Object object = value = valueMap == null ? null : valueMap.get(propertyName);
            if (property.isSimple()) {
                this.valueAccess.setPropertyValue(data, property, value);
                continue;
            }
            Map values = (Map)value;
            this.setStructuralTypeValuesFromMap(this.valueAccess.getPropertyValue(data, property), (EdmStructuralType)property.getType(), values, merge);
        }
        context.stopRuntimeMeasurement(timingHandle);
    }

    public ODataResponse executeBatch(BatchHandler handler, String contentType, InputStream content) throws ODataException {
        ArrayList<BatchResponsePart> batchResponseParts = new ArrayList<BatchResponsePart>();
        PathInfo pathInfo = this.getContext().getPathInfo();
        EntityProviderBatchProperties batchProperties = EntityProviderBatchProperties.init().pathInfo(pathInfo).build();
        List batchParts = EntityProvider.parseBatchRequest((String)contentType, (InputStream)content, (EntityProviderBatchProperties)batchProperties);
        for (BatchRequestPart batchPart : batchParts) {
            batchResponseParts.add(handler.handleBatchPart(batchPart));
        }
        ODataResponse batchResponse = EntityProvider.writeBatchResponse(batchResponseParts);
        return batchResponse;
    }

    public BatchResponsePart executeChangeSet(BatchHandler handler, List<ODataRequest> requests) throws ODataException {
        ArrayList<ODataResponse> responses = new ArrayList<ODataResponse>();
        for (ODataRequest request : requests) {
            ODataResponse response = handler.handleRequest(request);
            if (response.getStatus().getStatusCode() >= HttpStatusCodes.BAD_REQUEST.getStatusCode()) {
                ArrayList<ODataResponse> errorResponses = new ArrayList<ODataResponse>(1);
                errorResponses.add(response);
                return BatchResponsePart.responses(errorResponses).changeSet(false).build();
            }
            responses.add(response);
        }
        return BatchResponsePart.responses(responses).changeSet(true).build();
    }

    private class WriteCallback
    implements OnWriteEntryContent,
    OnWriteFeedContent {
        private final Object data;

        private <T> WriteCallback(T data) {
            this.data = data;
        }

        public WriteFeedCallbackResult retrieveFeedResult(WriteFeedCallbackContext context) throws ODataApplicationException {
            try {
                EdmEntityType entityType = context.getSourceEntitySet().getRelatedEntitySet(context.getNavigationProperty()).getEntityType();
                ArrayList<Map> values = new ArrayList<Map>();
                Object relatedData = null;
                try {
                    relatedData = this.readRelatedData((WriteCallbackContext)context);
                    for (Object entryData : (List)relatedData) {
                        values.add(ListsProcessor.this.getStructuralTypeValueMap(entryData, (EdmStructuralType)entityType));
                    }
                }
                catch (ODataNotFoundException e) {
                    values.clear();
                }
                WriteFeedCallbackResult result = new WriteFeedCallbackResult();
                result.setFeedData(values);
                EntityProviderWriteProperties inlineProperties = EntityProviderWriteProperties.serviceRoot((URI)ListsProcessor.this.getContext().getPathInfo().getServiceRoot()).callbacks(ListsProcessor.this.getCallbacks(relatedData, entityType)).expandSelectTree(context.getCurrentExpandSelectTreeNode()).selfLink(context.getSelfLink()).build();
                result.setInlineProperties(inlineProperties);
                return result;
            }
            catch (ODataException e) {
                throw new ODataApplicationException(e.getLocalizedMessage(), Locale.ROOT, (Throwable)e);
            }
        }

        public WriteEntryCallbackResult retrieveEntryResult(WriteEntryCallbackContext context) throws ODataApplicationException {
            try {
                Object relatedData;
                EdmEntityType entityType = context.getSourceEntitySet().getRelatedEntitySet(context.getNavigationProperty()).getEntityType();
                WriteEntryCallbackResult result = new WriteEntryCallbackResult();
                try {
                    relatedData = this.readRelatedData((WriteCallbackContext)context);
                }
                catch (ODataNotFoundException e) {
                    relatedData = null;
                }
                if (relatedData == null) {
                    result.setEntryData(Collections.emptyMap());
                } else {
                    result.setEntryData(ListsProcessor.this.getStructuralTypeValueMap(relatedData, (EdmStructuralType)entityType));
                    EntityProviderWriteProperties inlineProperties = EntityProviderWriteProperties.serviceRoot((URI)ListsProcessor.this.getContext().getPathInfo().getServiceRoot()).callbacks(ListsProcessor.this.getCallbacks(relatedData, entityType)).expandSelectTree(context.getCurrentExpandSelectTreeNode()).build();
                    result.setInlineProperties(inlineProperties);
                }
                return result;
            }
            catch (ODataException e) {
                throw new ODataApplicationException(e.getLocalizedMessage(), Locale.ROOT, (Throwable)e);
            }
        }

        private Object readRelatedData(WriteCallbackContext context) throws ODataException {
            EdmEntitySet entitySet = context.getSourceEntitySet();
            return ListsProcessor.this.dataSource.readRelatedData(entitySet, this.data instanceof List ? this.readEntryData((List)this.data, entitySet.getEntityType(), context.extractKeyFromEntryData()) : this.data, entitySet.getRelatedEntitySet(context.getNavigationProperty()), Collections.<String, Object>emptyMap());
        }

        private <T> T readEntryData(List<T> data, EdmEntityType entityType, Map<String, Object> key) throws ODataException {
            for (T entryData : data) {
                boolean found = true;
                for (EdmProperty keyProperty : entityType.getKeyProperties()) {
                    if (ListsProcessor.this.valueAccess.getPropertyValue(entryData, keyProperty).equals(key.get(keyProperty.getName()))) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                return entryData;
            }
            return null;
        }
    }
}

