/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.ODataCallback;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.commons.InlineCount;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmStructuralType;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataHttpException;
import org.apache.olingo.odata2.api.exception.ODataNotFoundException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.uri.ExpandSelectTreeNode;
import org.apache.olingo.odata2.api.uri.NavigationPropertySegment;
import org.apache.olingo.odata2.api.uri.PathInfo;
import org.apache.olingo.odata2.api.uri.SelectItem;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.UriParser;
import org.apache.olingo.odata2.api.uri.info.DeleteUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityLinkUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetLinksUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetFunctionImportUriInfo;
import org.apache.olingo.odata2.api.uri.info.PostUriInfo;
import org.apache.olingo.odata2.api.uri.info.PutMergePatchUriInfo;
import org.apache.olingo.odata2.core.uri.UriInfoImpl;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAResponseBuilder;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPATombstoneContext;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAPaging;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPAEntityParser;
import org.apache.olingo.odata2.jpa.processor.core.callback.JPAExpandCallBack;
import org.apache.olingo.odata2.jpa.processor.core.callback.JPATombstoneCallBack;

public final class ODataJPAResponseBuilderDefault
implements ODataJPAResponseBuilder {
    private final ODataJPAContext oDataJPAContext;
    private long count = -1L;

    public ODataJPAResponseBuilderDefault(ODataJPAContext context) {
        this.oDataJPAContext = context;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public ODataResponse build(GetEntitySetUriInfo resultsView, List<Object> jpaEntities, String contentType) throws ODataJPARuntimeException {
        EdmEntityType edmEntityType = null;
        ODataResponse odataResponse = null;
        List expandList = null;
        try {
            edmEntityType = resultsView.getTargetEntitySet().getEntityType();
            List<Map<String, Object>> edmEntityList = null;
            JPAEntityParser jpaResultParser = new JPAEntityParser(this.oDataJPAContext, (UriInfo)resultsView);
            List selectedItems = resultsView.getSelect();
            edmEntityList = selectedItems != null && !selectedItems.isEmpty() ? jpaResultParser.parse2EdmEntityList((UriInfo)resultsView, jpaEntities, ODataJPAResponseBuilderDefault.buildSelectItemList(selectedItems, edmEntityType), edmEntityType) : jpaResultParser.parse2EdmEntityList(jpaEntities, (EdmStructuralType)edmEntityType);
            expandList = resultsView.getExpand();
            if (expandList != null && !expandList.isEmpty()) {
                int count = 0;
                List<EdmNavigationProperty> edmNavPropertyList = ODataJPAResponseBuilderDefault.constructListofNavProperty(expandList);
                for (Object jpaEntity : jpaEntities) {
                    Map<String, Object> relationShipMap = edmEntityList.get(count);
                    HashMap<String, Object> navigationMap = jpaResultParser.parse2EdmNavigationValueMap(jpaEntity, edmNavPropertyList);
                    relationShipMap.putAll(navigationMap);
                    ++count;
                }
            }
            EntityProviderWriteProperties feedProperties = null;
            feedProperties = ODataJPAResponseBuilderDefault.getEntityProviderProperties(this.oDataJPAContext, resultsView, edmEntityList, this.count);
            odataResponse = EntityProvider.writeFeed((String)contentType, (EdmEntitySet)resultsView.getTargetEntitySet(), edmEntityList, (EntityProviderWriteProperties)feedProperties);
            odataResponse = ODataResponse.fromResponse((ODataResponse)odataResponse).status(HttpStatusCodes.OK).build();
        }
        catch (EntityProviderException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        return odataResponse;
    }

    public ODataResponse build(GetEntityUriInfo resultsView, Object jpaEntity, String contentType) throws ODataJPARuntimeException, ODataNotFoundException {
        List expandList = null;
        if (jpaEntity == null) {
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        EdmEntityType edmEntityType = null;
        ODataResponse odataResponse = null;
        try {
            edmEntityType = resultsView.getTargetEntitySet().getEntityType();
            HashMap<String, Object> edmPropertyValueMap = null;
            JPAEntityParser jpaResultParser = new JPAEntityParser(this.oDataJPAContext, (UriInfo)resultsView);
            List selectedItems = resultsView.getSelect();
            edmPropertyValueMap = selectedItems != null && !selectedItems.isEmpty() ? jpaResultParser.parse2EdmPropertyValueMap(jpaEntity, ODataJPAResponseBuilderDefault.buildSelectItemList(selectedItems, resultsView.getTargetEntitySet().getEntityType()), (EdmStructuralType)edmEntityType) : jpaResultParser.parse2EdmPropertyValueMap(jpaEntity, (EdmStructuralType)edmEntityType);
            expandList = resultsView.getExpand();
            if (expandList != null && !expandList.isEmpty()) {
                HashMap<String, Object> navigationMap = jpaResultParser.parse2EdmNavigationValueMap(jpaEntity, ODataJPAResponseBuilderDefault.constructListofNavProperty(expandList));
                edmPropertyValueMap.putAll(navigationMap);
            }
            EntityProviderWriteProperties feedProperties = null;
            feedProperties = ODataJPAResponseBuilderDefault.getEntityProviderProperties(this.oDataJPAContext, resultsView);
            if (resultsView.getTargetType() instanceof EdmEntityType) {
                odataResponse = EntityProvider.writeEntry((String)contentType, (EdmEntitySet)resultsView.getTargetEntitySet(), edmPropertyValueMap, (EntityProviderWriteProperties)feedProperties);
            } else {
                EdmProperty property = (EdmProperty)((UriInfoImpl)resultsView).getPropertyPath().get(0);
                odataResponse = ((UriInfoImpl)resultsView).isValue() ? EntityProvider.writePropertyValue((EdmProperty)property, edmPropertyValueMap.get(property.getName())) : EntityProvider.writeProperty((String)contentType, (EdmProperty)property, edmPropertyValueMap.get(property.getName()));
            }
            odataResponse = ODataResponse.fromResponse((ODataResponse)odataResponse).status(HttpStatusCodes.OK).build();
        }
        catch (EntityProviderException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        return odataResponse;
    }

    public ODataResponse build(long jpaEntityCount) throws ODataJPARuntimeException {
        ODataResponse odataResponse = null;
        try {
            odataResponse = EntityProvider.writeText((String)String.valueOf(jpaEntityCount));
            odataResponse = ODataResponse.fromResponse((ODataResponse)odataResponse).build();
        }
        catch (EntityProviderException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        return odataResponse;
    }

    public ODataResponse build(PostUriInfo uriInfo, Object createdObject, String contentType) throws ODataJPARuntimeException, ODataNotFoundException {
        if (createdObject == null) {
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        EdmEntityType edmEntityType = null;
        ODataResponse odataResponse = null;
        try {
            edmEntityType = uriInfo.getTargetEntitySet().getEntityType();
            HashMap<String, Object> edmPropertyValueMap = null;
            JPAEntityParser jpaResultParser = new JPAEntityParser(this.oDataJPAContext, (UriInfo)uriInfo);
            edmPropertyValueMap = jpaResultParser.parse2EdmPropertyValueMap(createdObject, (EdmStructuralType)edmEntityType);
            this.oDataJPAContext.getCreatedEntities().put(createdObject, edmPropertyValueMap);
            EntityProviderWriteProperties feedProperties = null;
            try {
                feedProperties = ODataJPAResponseBuilderDefault.getEntityProviderPropertiesforPost(this.oDataJPAContext);
                feedProperties.setClientCallbacks(((UriInfo)uriInfo).getClientCallbacks());
            }
            catch (ODataException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
            }
            if (uriInfo.getTargetType() instanceof EdmEntityType) {
                odataResponse = EntityProvider.writeEntry((String)contentType, (EdmEntitySet)uriInfo.getTargetEntitySet(), edmPropertyValueMap, (EntityProviderWriteProperties)feedProperties);
            } else {
                EdmProperty property = (EdmProperty)((UriInfoImpl)uriInfo).getPropertyPath().get(0);
                odataResponse = ((UriInfo)uriInfo).isValue() ? EntityProvider.writePropertyValue((EdmProperty)property, edmPropertyValueMap.get(property.getName())) : EntityProvider.writeProperty((String)contentType, (EdmProperty)property, edmPropertyValueMap.get(property.getName()));
            }
            odataResponse = ODataResponse.fromResponse((ODataResponse)odataResponse).status(HttpStatusCodes.CREATED).build();
        }
        catch (EntityProviderException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        return odataResponse;
    }

    public ODataResponse build(PutMergePatchUriInfo putUriInfo, Object updatedObject, String contentType) throws ODataJPARuntimeException, ODataNotFoundException {
        if (updatedObject == null) {
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        return this.build((PostUriInfo)putUriInfo, updatedObject, contentType);
    }

    public ODataResponse build(DeleteUriInfo deleteUriInfo, Object deletedObject) throws ODataJPARuntimeException, ODataNotFoundException {
        if (deletedObject == null) {
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        return ODataResponse.status((HttpStatusCodes)HttpStatusCodes.NO_CONTENT).build();
    }

    public ODataResponse build(GetFunctionImportUriInfo resultsView, Object result) throws ODataJPARuntimeException {
        try {
            EdmFunctionImport functionImport = resultsView.getFunctionImport();
            EdmSimpleType type = (EdmSimpleType)functionImport.getReturnType().getType();
            if (result != null) {
                ODataResponse response = null;
                if (type.getDefaultType().equals(byte[].class)) {
                    response = EntityProvider.writeBinary((String)"application/octet-stream", (byte[])((byte[])result));
                } else {
                    String value = type.valueToString(result, EdmLiteralKind.DEFAULT, null);
                    response = EntityProvider.writeText((String)value);
                }
                return ODataResponse.fromResponse((ODataResponse)response).build();
            }
            throw new ODataNotFoundException(ODataHttpException.COMMON);
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (EntityProviderException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (ODataException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
    }

    public ODataResponse build(GetFunctionImportUriInfo resultsView, List<Object> resultList, String contentType) throws ODataJPARuntimeException, ODataNotFoundException {
        ODataResponse odataResponse = null;
        if (resultList != null) {
            JPAEntityParser jpaResultParser = new JPAEntityParser(this.oDataJPAContext, (UriInfo)resultsView);
            EdmType edmType = null;
            EdmFunctionImport functionImport = null;
            HashMap<String, Object> edmPropertyValueMap = null;
            ArrayList<HashMap<String, Object>> edmEntityList = null;
            Cloneable result = null;
            try {
                EntityProviderWriteProperties feedProperties = EntityProviderWriteProperties.serviceRoot((URI)this.oDataJPAContext.getODataContext().getPathInfo().getServiceRoot()).build();
                functionImport = resultsView.getFunctionImport();
                edmType = functionImport.getReturnType().getType();
                if (edmType.getKind().equals((Object)EdmTypeKind.ENTITY) || edmType.getKind().equals((Object)EdmTypeKind.COMPLEX)) {
                    if (functionImport.getReturnType().getMultiplicity().equals((Object)EdmMultiplicity.MANY)) {
                        edmEntityList = new ArrayList<HashMap<String, Object>>();
                        for (Object jpaEntity : resultList) {
                            edmPropertyValueMap = jpaResultParser.parse2EdmPropertyValueMap(jpaEntity, (EdmStructuralType)edmType);
                            edmEntityList.add(edmPropertyValueMap);
                        }
                        result = edmEntityList;
                    } else {
                        Object resultObject = resultList.get(0);
                        edmPropertyValueMap = jpaResultParser.parse2EdmPropertyValueMap(resultObject, (EdmStructuralType)edmType);
                        result = edmPropertyValueMap;
                    }
                } else if (edmType.getKind().equals((Object)EdmTypeKind.SIMPLE)) {
                    result = resultList.get(0);
                }
                odataResponse = EntityProvider.writeFunctionImport((String)contentType, (EdmFunctionImport)resultsView.getFunctionImport(), (Object)result, (EntityProviderWriteProperties)feedProperties);
                odataResponse = ODataResponse.fromResponse((ODataResponse)odataResponse).status(HttpStatusCodes.OK).build();
            }
            catch (EdmException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
            catch (EntityProviderException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
            catch (ODataException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
            }
        } else {
            throw new ODataNotFoundException(ODataHttpException.COMMON);
        }
        return odataResponse;
    }

    public ODataResponse build(GetEntityLinkUriInfo resultsView, Object jpaEntity, String contentType) throws ODataNotFoundException, ODataJPARuntimeException {
        if (jpaEntity == null) {
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        EdmEntityType edmEntityType = null;
        ODataResponse odataResponse = null;
        try {
            EdmEntitySet entitySet = resultsView.getTargetEntitySet();
            edmEntityType = entitySet.getEntityType();
            HashMap<String, Object> edmPropertyValueMap = null;
            JPAEntityParser jpaResultParser = new JPAEntityParser(this.oDataJPAContext, (UriInfo)resultsView);
            edmPropertyValueMap = jpaResultParser.parse2EdmPropertyValueMap(jpaEntity, edmEntityType.getKeyProperties(), (EdmStructuralType)edmEntityType);
            EntityProviderWriteProperties entryProperties = EntityProviderWriteProperties.serviceRoot((URI)this.oDataJPAContext.getODataContext().getPathInfo().getServiceRoot()).build();
            ODataResponse response = EntityProvider.writeLink((String)contentType, (EdmEntitySet)entitySet, edmPropertyValueMap, (EntityProviderWriteProperties)entryProperties);
            odataResponse = ODataResponse.fromResponse((ODataResponse)response).build();
        }
        catch (ODataException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        return odataResponse;
    }

    public ODataResponse build(GetEntitySetLinksUriInfo resultsView, List<Object> jpaEntities, String contentType) throws ODataJPARuntimeException {
        EdmEntityType edmEntityType = null;
        ODataResponse odataResponse = null;
        try {
            EdmEntitySet entitySet = resultsView.getTargetEntitySet();
            edmEntityType = entitySet.getEntityType();
            List keyProperties = edmEntityType.getKeyProperties();
            ArrayList<Map<String, Object>> edmEntityList = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> edmPropertyValueMap = null;
            JPAEntityParser jpaResultParser = new JPAEntityParser(this.oDataJPAContext, (UriInfo)resultsView);
            for (Object jpaEntity : jpaEntities) {
                edmPropertyValueMap = jpaResultParser.parse2EdmPropertyValueMap(jpaEntity, keyProperties, (EdmStructuralType)edmEntityType);
                edmEntityList.add(edmPropertyValueMap);
            }
            Integer count = null;
            if (resultsView.getInlineCount() != null) {
                count = resultsView.getSkip() != null || resultsView.getTop() != null ? ODataJPAResponseBuilderDefault.getInlineCountForNonFilterQueryLinks(edmEntityList, resultsView) : (resultsView.getInlineCount() == InlineCount.ALLPAGES ? Integer.valueOf(edmEntityList.size()) : null);
            }
            ODataContext context = this.oDataJPAContext.getODataContext();
            EntityProviderWriteProperties entryProperties = EntityProviderWriteProperties.serviceRoot((URI)context.getPathInfo().getServiceRoot()).inlineCountType(resultsView.getInlineCount()).clientCallbacks(resultsView.getClientCallbacks()).callback(resultsView.getCallback()).inlineCount(count).build();
            odataResponse = EntityProvider.writeLinks((String)contentType, (EdmEntitySet)entitySet, edmEntityList, (EntityProviderWriteProperties)entryProperties);
            odataResponse = ODataResponse.fromResponse((ODataResponse)odataResponse).build();
        }
        catch (ODataException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        return odataResponse;
    }

    private static Integer getInlineCountForNonFilterQueryLinks(List<Map<String, Object>> edmEntityList, GetEntitySetLinksUriInfo resultsView) {
        Integer count = null;
        if (resultsView.getInlineCount() == InlineCount.ALLPAGES && (resultsView.getSkip() != null || resultsView.getTop() != null)) {
            count = edmEntityList.size();
            if (resultsView.getSkip() != null) {
                if (resultsView.getSkip() > edmEntityList.size()) {
                    edmEntityList.clear();
                    return count;
                }
                edmEntityList.subList(0, resultsView.getSkip()).clear();
            }
            if (resultsView.getTop() != null && resultsView.getTop() >= 0 && resultsView.getTop() < edmEntityList.size()) {
                edmEntityList.subList(0, resultsView.getTop());
            }
        }
        return count;
    }

    private static EntityProviderWriteProperties getEntityProviderProperties(ODataJPAContext odataJPAContext, GetEntitySetUriInfo resultsView, List<Map<String, Object>> edmEntityList, long queryCount) throws ODataJPARuntimeException {
        EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder entityFeedPropertiesBuilder = null;
        ODataContext context = odataJPAContext.getODataContext();
        Integer count = null;
        if (queryCount != -1L) {
            count = (int)queryCount;
        }
        try {
            PathInfo pathInfo = context.getPathInfo();
            URI serviceRoot = pathInfo.getServiceRoot();
            entityFeedPropertiesBuilder = EntityProviderWriteProperties.serviceRoot((URI)pathInfo.getServiceRoot());
            JPAPaging paging = odataJPAContext.getPaging();
            if (odataJPAContext.getPageSize() > 0 && paging != null && paging.getNextPage() > 0) {
                String nextLink = serviceRoot.relativize(pathInfo.getRequestUri()).toString();
                nextLink = ODataJPAResponseBuilderDefault.percentEncodeNextLink(nextLink);
                nextLink = nextLink + (nextLink != null ? (nextLink.contains("?") ? "&" : "?") : "?") + "$skiptoken=" + odataJPAContext.getPaging().getNextPage();
                entityFeedPropertiesBuilder.nextLink(nextLink);
            }
            entityFeedPropertiesBuilder.inlineCount(count);
            entityFeedPropertiesBuilder.clientCallbacks(resultsView.getClientCallbacks());
            entityFeedPropertiesBuilder.callback(resultsView.getCallback());
            entityFeedPropertiesBuilder.inlineCountType(resultsView.getInlineCount());
            ExpandSelectTreeNode expandSelectTree = UriParser.createExpandSelectTree((List)resultsView.getSelect(), (List)resultsView.getExpand());
            Map<String, ODataCallback> expandCallBack = JPAExpandCallBack.getCallbacks(odataJPAContext, serviceRoot, expandSelectTree, resultsView.getExpand());
            HashMap<String, Object> callBackMap = new HashMap<String, Object>();
            callBackMap.putAll(expandCallBack);
            String deltaToken = ODataJPATombstoneContext.getDeltaToken();
            if (deltaToken != null) {
                callBackMap.put("~tombstoneCallback", new JPATombstoneCallBack(serviceRoot.toString(), resultsView, deltaToken));
            }
            entityFeedPropertiesBuilder.callbacks(callBackMap);
            entityFeedPropertiesBuilder.expandSelectTree(expandSelectTree);
        }
        catch (ODataException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        return entityFeedPropertiesBuilder.build();
    }

    private static String percentEncodeNextLink(String link) {
        if (link == null) {
            return null;
        }
        return link.replaceAll("\\$skiptoken=.+?(?:&|$)", "").replaceAll("\\$skip=.+?(?:&|$)", "").replaceFirst("(?:\\?|&)$", "");
    }

    private static Integer getInlineCountForNonFilterQueryEntitySet(List<Map<String, Object>> edmEntityList, GetEntitySetUriInfo resultsView) {
        Integer count = null;
        if (resultsView.getInlineCount() == InlineCount.ALLPAGES && (resultsView.getSkip() != null || resultsView.getTop() != null)) {
            count = edmEntityList.size();
            if (resultsView.getSkip() != null) {
                if (resultsView.getSkip() > edmEntityList.size()) {
                    edmEntityList.clear();
                    return count;
                }
                edmEntityList.subList(0, resultsView.getSkip()).clear();
            }
            if (resultsView.getTop() != null && resultsView.getTop() >= 0 && resultsView.getTop() < edmEntityList.size()) {
                ArrayList<Map<String, Object>> edmEntitySubList = new ArrayList<Map<String, Object>>(edmEntityList.subList(0, resultsView.getTop()));
                edmEntityList.retainAll(edmEntitySubList);
            }
        }
        return count;
    }

    private static EntityProviderWriteProperties getEntityProviderProperties(ODataJPAContext odataJPAContext, GetEntityUriInfo resultsView) throws ODataJPARuntimeException {
        EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder entityFeedPropertiesBuilder = null;
        ExpandSelectTreeNode expandSelectTree = null;
        try {
            entityFeedPropertiesBuilder = EntityProviderWriteProperties.serviceRoot((URI)odataJPAContext.getODataContext().getPathInfo().getServiceRoot());
            expandSelectTree = UriParser.createExpandSelectTree((List)resultsView.getSelect(), (List)resultsView.getExpand());
            entityFeedPropertiesBuilder.expandSelectTree(expandSelectTree);
            entityFeedPropertiesBuilder.clientCallbacks(resultsView.getClientCallbacks());
            entityFeedPropertiesBuilder.callback(resultsView.getCallback());
            entityFeedPropertiesBuilder.callbacks(JPAExpandCallBack.getCallbacks(odataJPAContext, odataJPAContext.getODataContext().getPathInfo().getServiceRoot(), expandSelectTree, resultsView.getExpand()));
        }
        catch (ODataException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        return entityFeedPropertiesBuilder.build();
    }

    private static EntityProviderWriteProperties getEntityProviderPropertiesforPost(ODataJPAContext odataJPAContext) throws ODataJPARuntimeException {
        EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder entityFeedPropertiesBuilder = null;
        try {
            entityFeedPropertiesBuilder = EntityProviderWriteProperties.serviceRoot((URI)odataJPAContext.getODataContext().getPathInfo().getServiceRoot());
        }
        catch (ODataException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        return entityFeedPropertiesBuilder.build();
    }

    private static List<EdmProperty> buildSelectItemList(List<SelectItem> selectItems, EdmEntityType entity) throws ODataJPARuntimeException {
        boolean flag = false;
        ArrayList<EdmProperty> selectPropertyList = new ArrayList<EdmProperty>();
        try {
            for (SelectItem selectItem : selectItems) {
                if (selectItem.getNavigationPropertySegments().size() > 0) continue;
                if (selectItem.isStar()) {
                    selectPropertyList.addAll(ODataJPAResponseBuilderDefault.getEdmProperties((EdmStructuralType)entity));
                    return selectPropertyList;
                }
                selectPropertyList.add(selectItem.getProperty());
            }
            for (EdmProperty keyProperty : entity.getKeyProperties()) {
                flag = true;
                for (SelectItem selectedItem : selectItems) {
                    if (selectedItem.isStar() || !keyProperty.equals(selectedItem.getProperty())) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                selectPropertyList.add(keyProperty);
            }
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        return selectPropertyList;
    }

    private static List<EdmNavigationProperty> constructListofNavProperty(List<ArrayList<NavigationPropertySegment>> expandList) {
        ArrayList<EdmNavigationProperty> navigationPropertyList = new ArrayList<EdmNavigationProperty>();
        for (ArrayList<NavigationPropertySegment> navpropSegment : expandList) {
            navigationPropertyList.add(navpropSegment.get(0).getNavigationProperty());
        }
        return navigationPropertyList;
    }

    private static List<EdmProperty> getEdmProperties(EdmStructuralType structuralType) throws ODataJPARuntimeException {
        ArrayList<EdmProperty> edmProperties = new ArrayList<EdmProperty>();
        try {
            for (String propertyName : structuralType.getPropertyNames()) {
                edmProperties.add((EdmProperty)structuralType.getProperty(propertyName));
            }
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        return edmProperties;
    }
}

