/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.access.data;

import com.google.gson.JsonElement;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.olingo.odata2.api.commons.InlineCount;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmStructuralType;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.provider.NavigationProperty;
import org.apache.olingo.odata2.api.edm.provider.Property;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataBadRequestException;
import org.apache.olingo.odata2.api.uri.KeyPredicate;
import org.apache.olingo.odata2.api.uri.NavigationSegment;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.info.DeleteUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityLinkUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetLinksUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetFunctionImportUriInfo;
import org.apache.olingo.odata2.api.uri.info.PostUriInfo;
import org.apache.olingo.odata2.api.uri.info.PutMergePatchUriInfo;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;
import org.apache.olingo.odata2.core.edm.EdmUtil;
import org.apache.olingo.odata2.core.edm.provider.EdmEntityTypeImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmSimplePropertyImplProv;
import org.apache.olingo.odata2.core.uri.KeyPredicateImpl;
import org.apache.olingo.odata2.core.uri.UriInfoImpl;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAQueryExtensionEntityListener;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPATombstoneContext;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPATombstoneEntityListener;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPATransaction;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAFunction;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAMethodContext;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAPaging;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAProcessor;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextType;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmMapping;
import org.apache.olingo.odata2.jpa.processor.core.ODataEntityParser;
import org.apache.olingo.odata2.jpa.processor.core.ODataJPAConfig;
import org.apache.olingo.odata2.jpa.processor.core.ODataParameterizedWhereExpressionUtil;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPAEntity;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPAEntityParser;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPALink;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPAPage;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPAQueryBuilder;
import org.apache.olingo.odata2.jpa.processor.core.access.data.ReflectionUtil;
import org.apache.olingo.odata2.jpa.processor.core.access.data.VirtualClass;
import org.apache.olingo.odata2.jpa.processor.core.access.data.VirtualClassInterface;
import org.apache.olingo.odata2.jpa.processor.core.access.data.VirtualClassWrapper;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmMappingImpl;

public class JPAProcessorImpl
implements JPAProcessor {
    private static final String DELTATOKEN = "!deltatoken";
    ODataJPAContext oDataJPAContext;
    EntityManager em;
    Map<String, Object> created = new LinkedHashMap<String, Object>();

    public JPAProcessorImpl(ODataJPAContext oDataJPAContext) {
        this.oDataJPAContext = oDataJPAContext;
        this.em = oDataJPAContext.getEntityManager();
    }

    public List<Object> process(GetFunctionImportUriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        JPAMethodContext jpaMethodContext = JPAMethodContext.createBuilder((JPQLContextType)JPQLContextType.FUNCTION, (Object)uriParserResultView).build();
        ArrayList<Object> resultObj = null;
        try {
            JPAFunction jpaFunction = (JPAFunction)jpaMethodContext.getJPAFunctionList().get(0);
            Method method = jpaFunction.getFunction();
            Object[] args = jpaFunction.getArguments();
            if (uriParserResultView.getFunctionImport().getReturnType().getMultiplicity().equals((Object)EdmMultiplicity.MANY)) {
                resultObj = (List)method.invoke(jpaMethodContext.getEnclosingObject(), args);
            } else {
                resultObj = new ArrayList();
                Object result = method.invoke(jpaMethodContext.getEnclosingObject(), args);
                resultObj.add(result);
            }
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getTargetException().getMessage()}), (Throwable)e.getTargetException());
        }
        return resultObj;
    }

    public List<Object> process(GetEntitySetUriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        boolean hasNoAllPages;
        if (uriParserResultView.isNew()) {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(this.processNew((UriInfo)uriParserResultView));
            return result;
        }
        List<Object> result = null;
        if (uriParserResultView.getFunctionImport() != null) {
            return this.process((GetFunctionImportUriInfo)uriParserResultView);
        }
        InlineCount inlineCount = uriParserResultView.getInlineCount();
        Integer top = uriParserResultView.getTop() == null ? 1 : uriParserResultView.getTop();
        boolean bl = inlineCount == null ? true : (hasNoAllPages = !inlineCount.equals((Object)InlineCount.ALLPAGES));
        if (top == 0 && hasNoAllPages) {
            return new ArrayList<Object>();
        }
        try {
            JPAEdmMapping mapping = (JPAEdmMapping)uriParserResultView.getTargetEntitySet().getEntityType().getMapping();
            JPAQueryBuilder queryBuilder = new JPAQueryBuilder(this.oDataJPAContext);
            JPAQueryBuilder.JPAQueryInfo queryInfo = queryBuilder.build(uriParserResultView);
            Query query = queryInfo.getQuery();
            this.setPositionalParametersToQuery(query);
            ODataJPATombstoneEntityListener listener = queryBuilder.getODataJPATombstoneEntityListener((UriInfo)uriParserResultView);
            Map customQueryOptions = uriParserResultView.getCustomQueryOptions();
            String deltaToken = null;
            if (customQueryOptions != null) {
                deltaToken = (String)uriParserResultView.getCustomQueryOptions().get(DELTATOKEN);
            }
            if (deltaToken != null) {
                ODataJPATombstoneContext.setDeltaToken(deltaToken);
            }
            if (listener != null && !queryInfo.isTombstoneQuery() && listener.isTombstoneSupported()) {
                query.getResultList();
                List deltaResult = ODataJPATombstoneContext.getDeltaResult((String)((EdmMapping)mapping).getInternalName());
                result = this.handlePaging(deltaResult, uriParserResultView);
            } else {
                result = this.handlePaging(query, uriParserResultView, queryBuilder);
            }
            if (listener != null && listener.isTombstoneSupported()) {
                ODataJPATombstoneContext.setDeltaToken((String)listener.generateDeltaToken(result, query));
            }
            return result == null ? new ArrayList() : result;
        }
        catch (EdmException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void setPositionalParametersToQuery(Query query) {
        Map<String, Map<Integer, Object>> parameterizedMap = ODataParameterizedWhereExpressionUtil.getParameterizedQueryMap();
        if (parameterizedMap != null && parameterizedMap.size() > 0) {
            for (Map.Entry<String, Map<Integer, Object>> parameterEntry : parameterizedMap.entrySet()) {
                if (!ODataParameterizedWhereExpressionUtil.getJPQLStatement().contains(parameterEntry.getKey())) continue;
                Map<Integer, Object> positionalParameters = parameterEntry.getValue();
                for (Map.Entry<Integer, Object> param : positionalParameters.entrySet()) {
                    if (param.getValue() instanceof Calendar || param.getValue() instanceof Timestamp) {
                        query.setParameter(param.getKey().intValue(), (Calendar)param.getValue(), TemporalType.TIMESTAMP);
                        continue;
                    }
                    if (param.getValue() instanceof Time) {
                        query.setParameter(param.getKey().intValue(), (Date)((Time)param.getValue()), TemporalType.TIME);
                        continue;
                    }
                    query.setParameter(param.getKey().intValue(), param.getValue());
                }
                parameterizedMap.remove(parameterEntry.getKey());
                ODataParameterizedWhereExpressionUtil.setJPQLStatement(null);
                break;
            }
        }
    }

    public <T> Object process(GetEntityUriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        if (uriParserResultView.isNew()) {
            return this.processNew((UriInfo)uriParserResultView);
        }
        return this.readEntity(new JPAQueryBuilder(this.oDataJPAContext).build(uriParserResultView), (UriInfo)uriParserResultView);
    }

    public long process(GetEntitySetCountUriInfo resultsView) throws ODataJPAModelException, ODataJPARuntimeException {
        JPAQueryBuilder queryBuilder = new JPAQueryBuilder(this.oDataJPAContext);
        Query query = queryBuilder.build(resultsView);
        this.setPositionalParametersToQuery(query);
        List resultList = query.getResultList();
        if (resultList != null && !resultList.isEmpty()) {
            if (resultList.size() > 1 || query.toString().toLowerCase().contains("group by")) {
                return resultList.size();
            }
            try {
                return Long.valueOf(resultList.get(0).toString());
            }
            catch (Exception e) {
                return resultList.size();
            }
        }
        return 0L;
    }

    public long process(GetEntityCountUriInfo resultsView) throws ODataJPAModelException, ODataJPARuntimeException {
        JPAQueryBuilder queryBuilder = new JPAQueryBuilder(this.oDataJPAContext);
        Query query = queryBuilder.build(resultsView);
        this.setPositionalParametersToQuery(query);
        List resultList = query.getResultList();
        if (resultList != null && resultList.size() == 1) {
            return Long.valueOf(resultList.get(0).toString());
        }
        return 0L;
    }

    public Object process(PostUriInfo createView, InputStream content, String requestedContentType) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.processCreate(createView, content, null, requestedContentType);
    }

    public Object process(PostUriInfo createView, Map<String, Object> content) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.processCreate(createView, null, content, null);
    }

    public Object process(PutMergePatchUriInfo updateView, InputStream content, String requestContentType) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.processUpdate(updateView, content, null, requestContentType);
    }

    public Object process(PutMergePatchUriInfo updateView, Map<String, Object> content) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.processUpdate(updateView, null, content, null);
    }

    public Object process(DeleteUriInfo uriParserResultView, String contentType) throws ODataJPAModelException, ODataJPARuntimeException {
        if (uriParserResultView instanceof DeleteUriInfo && ((UriInfo)uriParserResultView).isLinks()) {
            return this.deleteLink(uriParserResultView);
        }
        JPAQueryBuilder queryBuilder = new JPAQueryBuilder(this.oDataJPAContext);
        ODataJPAQueryExtensionEntityListener listener = null;
        try {
            listener = queryBuilder.getODataJPAQueryEntityListener((UriInfo)uriParserResultView);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (listener != null) {
            listener.checkAuthorization(uriParserResultView);
        }
        ((UriInfoImpl)uriParserResultView).setRawEntity(true);
        LinkedHashMap<String, Object> selectedObject = null;
        if (!listener.canOverrideDelete((UriInfo)((UriInfoImpl)uriParserResultView))) {
            selectedObject = this.readEntity(new JPAQueryBuilder(this.oDataJPAContext).build(uriParserResultView), (UriInfo)uriParserResultView, true);
        } else {
            LinkedHashMap<String, Object> oDataEntryProperties = new LinkedHashMap<String, Object>();
            try {
                for (KeyPredicate keyPredicate : uriParserResultView.getKeyPredicates()) {
                    EdmSimplePropertyImplProv edmProperty = (EdmSimplePropertyImplProv)keyPredicate.getProperty();
                    if (edmProperty.getComposite() != null) {
                        String value = keyPredicate.getLiteral();
                        String[] values = null;
                        values = value == null ? new String[edmProperty.getComposite().size()] : value.split(ODataJPAConfig.COMPOSITE_SEPARATOR);
                        int i = 0;
                        for (EdmProperty p : edmProperty.getComposite()) {
                            if (i < values.length) {
                                Object valueObj = null;
                                if (!((EdmSimplePropertyImplProv)p).getProperty().isForeignKey() && oDataEntryProperties.containsKey(p.getName())) {
                                    valueObj = oDataEntryProperties.get(p.getName());
                                } else if (!"null".equals(values[i])) {
                                    valueObj = ((AbstractSimpleType)p.getType()).valueOfString(values[i], EdmLiteralKind.JSON, p.getFacets(), ((JPAEdmMappingImpl)p.getMapping()).getOriginaType());
                                }
                                oDataEntryProperties.put(p.getName(), valueObj);
                            }
                            ++i;
                        }
                        continue;
                    }
                    EdmSimpleType type = (EdmSimpleType)edmProperty.getType();
                    EdmFacets facets = edmProperty.getFacets();
                    String value = keyPredicate.getLiteral();
                    Object valueObj = type.valueOfString(value, EdmLiteralKind.JSON, facets, ((JPAEdmMappingImpl)edmProperty.getMapping()).getOriginaType());
                    oDataEntryProperties.put(keyPredicate.getProperty().getName(), valueObj);
                }
                selectedObject = oDataEntryProperties;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (selectedObject != null) {
            try {
                boolean override;
                EdmEntitySet oDataEntitySet = uriParserResultView.getTargetEntitySet();
                EdmEntityType oDataEntityType = oDataEntitySet.getEntityType();
                boolean isLocalTransaction = this.setTransaction();
                if (listener != null) {
                    listener.execEvent((UriInfo)((UriInfoImpl)uriParserResultView), oDataEntityType, "beforeDelete", selectedObject);
                }
                if (!(override = listener.overrideDelete((UriInfo)uriParserResultView, selectedObject))) {
                    this.em.remove(selectedObject);
                    this.em.flush();
                }
                if (listener != null) {
                    listener.execEvent((UriInfo)((UriInfoImpl)uriParserResultView), oDataEntityType, "afterDelete", selectedObject);
                }
                if (!override && isLocalTransaction) {
                    this.oDataJPAContext.getODataJPATransaction().commit();
                }
            }
            catch (Exception e) {
                this.em.getTransaction().rollback();
                throw new RuntimeException(e);
            }
        }
        return selectedObject;
    }

    public Object process(GetEntityLinkUriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.process((GetEntityUriInfo)uriParserResultView);
    }

    public List<Object> process(GetEntitySetLinksUriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.process((GetEntitySetUriInfo)uriParserResultView);
    }

    public void process(PostUriInfo uriInfo, InputStream content, String requestContentType, String contentType) throws ODataJPARuntimeException, ODataJPAModelException {
        JPALink link = new JPALink(this.oDataJPAContext);
        link.create(uriInfo, content, requestContentType, contentType);
        link.save();
    }

    public void process(PutMergePatchUriInfo putUriInfo, InputStream content, String requestContentType, String contentType) throws ODataJPARuntimeException, ODataJPAModelException {
        JPALink link = new JPALink(this.oDataJPAContext);
        link.update(putUriInfo, content, requestContentType, contentType);
        link.save();
    }

    private Object readEntity(Query query, UriInfo uriInfo) throws ODataJPARuntimeException {
        return this.readEntity(query, uriInfo, false);
    }

    private Object readEntity(Query query, UriInfo uriInfo, boolean rawEntity) throws ODataJPARuntimeException {
        Object selectedObject = null;
        List resultList = query.getResultList();
        if (!rawEntity) {
            resultList = this.normalizeList(resultList, uriInfo);
        }
        if (!resultList.isEmpty()) {
            selectedObject = resultList.get(0);
        }
        return selectedObject;
    }

    private Object processNew(UriInfo newView) throws ODataJPAModelException, ODataJPARuntimeException {
        Object jpaEntity;
        block5: {
            jpaEntity = null;
            try {
                Object newObj;
                EdmEntitySet oDataEntitySet = newView.getTargetEntitySet();
                EdmEntityType oDataEntityType = oDataEntitySet.getEntityType();
                jpaEntity = ((JPAEdmMappingImpl)oDataEntityType.getMapping()).getJPAType().newInstance();
                if (!((JPAEdmMappingImpl)oDataEntityType.getMapping()).isVirtualAccess()) break block5;
                JPAQueryBuilder queryBuilder = new JPAQueryBuilder(this.oDataJPAContext);
                ODataJPAQueryExtensionEntityListener listener = null;
                try {
                    listener = queryBuilder.getODataJPAQueryEntityListener(newView);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (listener != null && (newObj = listener.processNew(newView)) != null) {
                    jpaEntity = newObj;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return jpaEntity;
    }

    private void recreateJPAEntityIfTargetIsNotEntitySet(PostUriInfo createView, JPAEntity virtualJPAEntity) throws EdmException, ODataJPARuntimeException {
        EdmEntityType edmEntityType = createView.getTargetEntitySet().getEntityType();
        EdmEntityType edmEntityTypeBase = createView.getEntityContainer().getEntitySet(createView.getTargetEntitySet().getEntityType().getMapping().getInternalName()).getEntityType();
        if (edmEntityType != null && edmEntityTypeBase != null && !edmEntityType.equals(edmEntityTypeBase)) {
            JPAEntityParser jpaResultParser = new JPAEntityParser(this.oDataJPAContext, (UriInfo)createView);
            HashMap<String, Object> edmPropertyValueMap = jpaResultParser.parse2EdmPropertyValueMap(virtualJPAEntity.getJPAEntity(), (EdmStructuralType)edmEntityType);
            virtualJPAEntity.create(edmPropertyValueMap);
        }
    }

    private Object processCreate(PostUriInfo createView, InputStream content, Map<String, Object> properties, String requestedContentType) throws ODataJPAModelException, ODataJPARuntimeException {
        Object jpaEntity;
        JPAEntity virtualJPAEntity;
        ODataJPAQueryExtensionEntityListener listener;
        EdmEntityType oDataEntityType;
        block32: {
            EdmEntitySet oDataEntitySet = createView.getTargetEntitySet();
            oDataEntityType = oDataEntitySet.getEntityType();
            JPAQueryBuilder queryBuilder = new JPAQueryBuilder(this.oDataJPAContext);
            listener = null;
            try {
                listener = queryBuilder.getODataJPAQueryEntityListener((UriInfo)createView);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (listener != null) {
                listener.checkAuthorization(createView);
            }
            virtualJPAEntity = new JPAEntity(oDataEntityType, oDataEntitySet, this.oDataJPAContext);
            jpaEntity = null;
            if (content != null) {
                ODataEntityParser oDataEntityParser = new ODataEntityParser(this.oDataJPAContext);
                ODataEntry oDataEntry = oDataEntityParser.parseEntry((UriInfo)createView, oDataEntitySet, content, requestedContentType, false);
                Map<String, Object> extra = this.parseDetail((UriInfo)createView);
                oDataEntry.getProperties().putAll(extra);
                virtualJPAEntity.create(oDataEntry);
                try {
                    this.recreateJPAEntityIfTargetIsNotEntitySet(createView, virtualJPAEntity);
                }
                catch (Exception exception) {}
                break block32;
            }
            if (properties != null) {
                virtualJPAEntity.create(properties);
                break block32;
            }
            return null;
        }
        try {
            boolean isLocalTransaction = this.setTransaction();
            Object tempEntity = jpaEntity = virtualJPAEntity.getJPAEntity();
            boolean manymany = false;
            if (createView.getNavigationSegments().size() > 0) {
                UriInfoImpl clone = ((UriInfoImpl)createView).getClone();
                clone.setTargetEntitySet(createView.getStartEntitySet());
                clone.getNavigationSegments().clear();
                clone.setTargetType((EdmType)clone.getTargetEntitySet().getEntityType());
                Object relatedEntity = this.readEntity(new JPAQueryBuilder(this.oDataJPAContext).build((PutMergePatchUriInfo)clone), (UriInfo)clone);
                if (createView.getNavigationSegments().size() == 1) {
                    String property;
                    NavigationProperty navigationProperty = (NavigationProperty)((EdmEntityTypeImplProv)createView.getStartEntitySet().getEntityType()).getNavigationProperties().get(((NavigationSegment)createView.getNavigationSegments().get(0)).getNavigationProperty().getName());
                    if (navigationProperty.getRelationship().getName().toLowerCase().contains("many_many")) {
                        manymany = true;
                    }
                    if (manymany) {
                        JPAEdmMappingImpl mapping = (JPAEdmMappingImpl)navigationProperty.getMapping();
                        property = mapping.getInternalName();
                        try {
                            Field field = relatedEntity.getClass().getDeclaredField(property);
                            field.setAccessible(true);
                            List list = (List)field.get(relatedEntity);
                            list.add(jpaEntity);
                            jpaEntity = relatedEntity;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        property = (String)((NavigationSegment)createView.getNavigationSegments().get(0)).getNavigationProperty().getRelationship().getReferentialConstraint().getDependent().getPropertyRefNames().get(0);
                        try {
                            Field field = jpaEntity.getClass().getDeclaredField(property);
                            field.setAccessible(true);
                            field.set(jpaEntity, relatedEntity);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            if (manymany) {
                if (listener != null) {
                    listener.execEvent((UriInfo)((UriInfoImpl)createView), oDataEntityType, "beforeInsert", jpaEntity);
                }
                this.em.merge(jpaEntity);
            } else {
                Object resultEntity;
                if (listener != null) {
                    listener.execEvent((UriInfo)((UriInfoImpl)createView), oDataEntityType, "beforeInsert", tempEntity);
                }
                if ((resultEntity = listener.overridePost((UriInfo)createView, jpaEntity)) != null) {
                    return resultEntity;
                }
                this.em.persist(jpaEntity);
            }
            if (this.em.contains(jpaEntity)) {
                if (manymany) {
                    jpaEntity = tempEntity;
                }
                EdmEntityType edmEntityType = createView.getEntityContainer().getEntitySet(createView.getTargetEntitySet().getEntityType().getMapping().getInternalName()).getEntityType();
                JPAEntityParser jpaResultParser = new JPAEntityParser(this.oDataJPAContext, (UriInfo)createView);
                ArrayList<KeyPredicateImpl> predicates = new ArrayList<KeyPredicateImpl>();
                ((UriInfoImpl)createView).setKeyPredicates(predicates);
                ((UriInfoImpl)createView).setRawEntity(false);
                this.em.flush();
                this.em.clear();
                HashMap<String, Object> edmPropertyValueMap = jpaResultParser.parse2EdmPropertyValueMap(jpaEntity, (EdmStructuralType)edmEntityType);
                List originalKeys = EdmUtil.findOriginalKeys((EdmEntityType)createView.getTargetEntitySet().getEntityType());
                this.mapAllKeys(edmPropertyValueMap, originalKeys);
                for (EdmProperty key : originalKeys) {
                    EdmSimpleType type = (EdmSimpleType)key.getType();
                    EdmFacets facets = key.getFacets();
                    Object value = edmPropertyValueMap.get(key.getName());
                    String literal = type.valueToString(value, EdmLiteralKind.DEFAULT, facets);
                    KeyPredicateImpl predicate = new KeyPredicateImpl(literal, key);
                    predicates.add(predicate);
                    createView.getNavigationSegments().clear();
                }
                ((UriInfoImpl)createView).composeWhere(false);
                Object resultEntity = this.readEntity(new JPAQueryBuilder(this.oDataJPAContext).build((GetEntityUriInfo)createView), (UriInfo)createView);
                ((UriInfoImpl)createView).composeWhere(true);
                if (resultEntity == null) {
                    throw new RuntimeException("Entity not found after insert, check your query and default values");
                }
                if (listener != null) {
                    listener.execEvent((UriInfo)((UriInfoImpl)createView), oDataEntityType, "afterInsert", resultEntity);
                }
                if (isLocalTransaction) {
                    this.oDataJPAContext.getODataJPATransaction().commit();
                }
                if (this.getHeader((UriInfo)createView, "X-Master-Id") != null) {
                    this.created.put(this.getHeader((UriInfo)createView, "X-Master-Id"), resultEntity);
                }
                return resultEntity;
            }
        }
        catch (ODataBadRequestException e) {
            throw new RuntimeException(e);
        }
        catch (EdmException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Map<String, Object> parseDetail(UriInfo info) {
        data = new LinkedHashMap<String, Object>();
        if (this.getHeader(info, "X-Detail-Fill") != null) {
            fills = this.getHeader(info, "X-Detail-Fill");
            var8_5 = parts = fills.split(",");
            var7_6 = parts.length;
            var6_7 = 0;
            while (var6_7 < var7_6) {
                part = var8_5[var6_7];
                expression = part.split(":");
                if (expression.length == 2) {
                    key = expression[0];
                    path = expression[1].split("\\.");
                    if (path.length == 2 && (obj = this.created.get(id = path[0].replace("$", ""))) != null) {
                        if (path[1].equals(ODataJPAConfig.COMPOSITE_KEY_NAME)) {
                            try {
                                values = (Map)this.oDataJPAContext.getCreatedEntities().get(obj);
                                if (values == null || values.get(path[1]) == null) ** GOTO lbl36
                                oDataEntitySet = info.getTargetEntitySet();
                                oDataEntityType = oDataEntitySet.getEntityType();
                                property = (EdmProperty)oDataEntityType.getProperty(key);
                                facets = property.getFacets();
                                type = (EdmSimpleType)property.getType();
                                value = type.valueOfString(values.get(path[1]).toString(), EdmLiteralKind.DEFAULT, facets, type.getDefaultType());
                                data.put(key, value);
                            }
                            catch (Exception e1) {
                                throw new RuntimeException(e1);
                            }
                        } else {
                            try {
                                value = ReflectionUtil.getter(obj, path[1]);
                                data.put(key, value);
                            }
                            catch (NoSuchFieldException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                }
lbl36:
                // 7 sources

                ++var6_7;
            }
        }
        return data;
    }

    private String getHeader(UriInfo info, String key) {
        List values;
        if (info.getHeaders() != null && (values = (List)info.getHeaders().get(key)) != null && values.size() > 0) {
            return (String)values.get(0);
        }
        return null;
    }

    private void mapAllKeys(HashMap<String, Object> edmPropertyValueMap, List<EdmProperty> originalKeys) throws EdmException {
        String[] _objectKeys;
        if (edmPropertyValueMap.get(ODataJPAConfig.COMPOSITE_KEY_NAME) != null && (_objectKeys = edmPropertyValueMap.get(ODataJPAConfig.COMPOSITE_KEY_NAME).toString().split(ODataJPAConfig.COMPOSITE_SEPARATOR)).length == originalKeys.size()) {
            int i = 0;
            while (i < originalKeys.size()) {
                try {
                    Constructor<Object> cons;
                    String keyName = originalKeys.get(i).getName();
                    Object objForKey = edmPropertyValueMap.get(keyName);
                    if (objForKey != null) {
                        cons = objForKey.getClass().getConstructor(String.class);
                        edmPropertyValueMap.put(keyName, cons.newInstance(_objectKeys[i]));
                    } else {
                        cons = ((JPAEdmMappingImpl)originalKeys.get(i).getMapping()).getOriginaType().getConstructor(String.class);
                        edmPropertyValueMap.put(keyName, cons.newInstance(_objectKeys[i]));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error on cast value");
                }
                ++i;
            }
        }
    }

    private <T> Object processUpdate(PutMergePatchUriInfo updateView, InputStream content, Map<String, Object> properties, String requestContentType) throws ODataJPAModelException, ODataJPARuntimeException {
        EdmEntityType oDataEntityType;
        boolean isLocalTransaction;
        ODataJPAQueryExtensionEntityListener listener;
        JPAQueryBuilder queryBuilder;
        Object jpaEntity;
        block22: {
            jpaEntity = null;
            queryBuilder = new JPAQueryBuilder(this.oDataJPAContext);
            listener = null;
            try {
                listener = queryBuilder.getODataJPAQueryEntityListener((UriInfo)updateView);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (listener != null) {
                listener.checkAuthorization(updateView);
            }
            isLocalTransaction = this.setTransaction();
            ((UriInfoImpl)updateView).setRawEntity(true);
            boolean canOverride = listener.canOverridePut((UriInfo)updateView);
            if (!canOverride) {
                jpaEntity = this.readEntity(queryBuilder.build(updateView), (UriInfo)updateView, true);
                if (jpaEntity == null) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.RESOURCE_NOT_FOUND, null);
                }
            } else {
                jpaEntity = new VirtualClass();
            }
            EdmEntitySet oDataEntitySet = updateView.getTargetEntitySet();
            oDataEntityType = oDataEntitySet.getEntityType();
            JPAEntity virtualJPAEntity = new JPAEntity(oDataEntityType, oDataEntitySet, this.oDataJPAContext);
            virtualJPAEntity.setJPAEntity(jpaEntity);
            if (content != null) {
                ODataEntityParser oDataEntityParser = new ODataEntityParser(this.oDataJPAContext);
                ODataEntry oDataEntry = oDataEntityParser.parseEntry((UriInfo)updateView, oDataEntitySet, content, requestContentType, false);
                if (!canOverride) {
                    virtualJPAEntity.update(oDataEntry);
                } else {
                    virtualJPAEntity.create(oDataEntry);
                    jpaEntity = virtualJPAEntity.getJPAEntity();
                }
                break block22;
            }
            if (properties != null) {
                virtualJPAEntity.update(properties);
                break block22;
            }
            return null;
        }
        try {
            Object overridePut = null;
            if (listener != null) {
                listener.execEvent((UriInfo)((UriInfoImpl)updateView), oDataEntityType, "beforeUpdate", jpaEntity);
                overridePut = listener.overridePut((UriInfo)updateView, jpaEntity);
            }
            ((UriInfoImpl)updateView).setRawEntity(false);
            if (overridePut != null) {
                jpaEntity = overridePut;
            } else {
                this.em.flush();
                this.em.clear();
                ((UriInfoImpl)updateView).composeWhere(false);
                jpaEntity = this.readEntity(queryBuilder.build(updateView), (UriInfo)updateView);
                ((UriInfoImpl)updateView).composeWhere(true);
                if (listener != null) {
                    listener.execEvent((UriInfo)((UriInfoImpl)updateView), oDataEntityType, "afterUpdate", jpaEntity);
                }
                if (isLocalTransaction) {
                    this.oDataJPAContext.getODataJPATransaction().commit();
                }
            }
        }
        catch (ODataBadRequestException e) {
            throw new RuntimeException(e);
        }
        catch (EdmException e) {
            throw new RuntimeException(e);
        }
        catch (PersistenceException e) {
            this.em.getTransaction().rollback();
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            EntityTransaction et = this.em.getTransaction();
            if (et != null && et.isActive()) {
                et.rollback();
            }
            throw new RuntimeException(e);
        }
        return jpaEntity;
    }

    private Object deleteLink(DeleteUriInfo uriParserResultView) throws ODataJPARuntimeException {
        JPALink link = new JPALink(this.oDataJPAContext);
        link.delete(uriParserResultView);
        link.save();
        return link.getTargetJPAEntity();
    }

    private List<Object> handlePaging(List<Object> result, GetEntitySetUriInfo uriParserResultView) {
        if (result == null) {
            return null;
        }
        JPAPage.JPAPageBuilder pageBuilder = new JPAPage.JPAPageBuilder();
        pageBuilder.pageSize(this.oDataJPAContext.getPageSize()).entities(result).skipToken(uriParserResultView.getSkipToken());
        if (uriParserResultView.getSkip() != null) {
            pageBuilder.skip(uriParserResultView.getSkip());
        }
        if (uriParserResultView.getTop() != null) {
            pageBuilder.top(uriParserResultView.getTop());
        }
        JPAPage page = pageBuilder.build();
        this.oDataJPAContext.setPaging((JPAPaging)page);
        return page.getPagedEntities();
    }

    private List<Object> handlePaging(Query query, GetEntitySetUriInfo uriParserResultView, JPAQueryBuilder queryBuilder) {
        JPAPage.JPAPageBuilder pageBuilder = new JPAPage.JPAPageBuilder();
        pageBuilder.pageSize(this.oDataJPAContext.getPageSize()).query(query).skipToken(uriParserResultView.getSkipToken());
        if (uriParserResultView.getSkip() != null) {
            pageBuilder.skip(uriParserResultView.getSkip());
        }
        if (uriParserResultView.getTop() != null) {
            pageBuilder.top(uriParserResultView.getTop());
        }
        JPAPage page = pageBuilder.build();
        this.oDataJPAContext.setPaging((JPAPaging)page);
        List entities = this.normalizeList(page.getPagedEntities(), (UriInfo)uriParserResultView);
        return entities;
    }

    /*
     * WARNING - void declaration
     */
    private List normalizeList(List entities, UriInfo uriParserResultView) {
        if (entities != null && uriParserResultView != null && !entities.isEmpty()) {
            try {
                if (((JPAEdmMappingImpl)((EdmEntityTypeImplProv)uriParserResultView.getTargetType()).getMapping()).isVirtualAccess()) {
                    List properties = ((EdmEntityTypeImplProv)uriParserResultView.getTargetType()).getEntityType().getProperties();
                    ArrayList<VirtualClassInterface> newEntities = new ArrayList<VirtualClassInterface>(entities.size());
                    for (Object e : entities) {
                        VirtualClassInterface entity = null;
                        boolean extractItens = false;
                        if (e instanceof JsonElement || e instanceof Map) {
                            entity = new VirtualClassWrapper(e);
                        } else if (e instanceof VirtualClassInterface) {
                            entity = (VirtualClassInterface)e;
                            if (entity.getObject() != null && entity.getObject().getClass().isArray()) {
                                Object object = entity.getObject();
                                extractItens = true;
                            }
                        } else {
                            extractItens = true;
                        }
                        if (extractItens) {
                            void var5_7;
                            entity = new VirtualClass();
                            if (var5_7.getClass().isArray()) {
                                for (Property p : properties) {
                                    if (p.getMapping().getComplexIndex() == -1) continue;
                                    String key = p.getName();
                                    entity.set(key, ((Object[])var5_7)[p.getMapping().getComplexIndex()]);
                                    if (!p.getMapping().getInternalName().contains(".")) continue;
                                    String[] parts = p.getMapping().getInternalName().split("\\.");
                                    entity.set(parts[0], ((Object[])var5_7)[p.getMapping().getComplexIndex()]);
                                }
                            } else {
                                String key = ((Property)properties.get(0)).getName();
                                entity.set(key, var5_7);
                            }
                        }
                        newEntities.add(entity);
                    }
                    entities = newEntities;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return entities;
    }

    private boolean setTransaction() {
        ODataJPATransaction transaction = this.oDataJPAContext.getODataJPATransaction();
        if (!transaction.isActive()) {
            transaction.begin();
            return true;
        }
        return false;
    }
}

