/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.access.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmAssociationEnd;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.EdmStructuralType;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.core.edm.provider.EdmSimplePropertyImplProv;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmMapping;
import org.apache.olingo.odata2.jpa.processor.core.access.data.ReflectionUtil;

public final class JPAEntityParser {
    private static short MAX_SIZE = (short)10;
    public static final String ACCESS_MODIFIER_GET = "get";
    public static final String ACCESS_MODIFIER_SET = "set";
    private static final String ACCESS_MODIFIER_IS = "is";
    private final UriInfo infoView;
    private HashMap<String, HashMap<String, Method>> jpaEntityAccessMap = null;
    private HashMap<String, HashMap<String, String>> jpaEmbeddableKeyMap = null;
    private final ODataJPAContext oDataJPAContext;

    public JPAEntityParser(ODataJPAContext context, UriInfo infoView) {
        this.oDataJPAContext = context;
        this.infoView = infoView;
        this.jpaEntityAccessMap = new HashMap(MAX_SIZE);
        this.jpaEmbeddableKeyMap = new HashMap();
    }

    public HashMap<String, Method> getJPAEntityAccessMap(String jpaEntityName) {
        return this.jpaEntityAccessMap.get(jpaEntityName);
    }

    public HashMap<String, String> getJPAEmbeddableKeyMap(String jpaEntityName) {
        return this.jpaEmbeddableKeyMap.get(jpaEntityName);
    }

    public List<Map<String, Object>> parse2EdmEntityList(UriInfo infoView, Collection<Object> jpaEntityList, List<EdmProperty> properties, EdmEntityType entity) throws ODataJPARuntimeException {
        if (jpaEntityList == null) {
            return null;
        }
        ArrayList<Map<String, Object>> edmEntityList = new ArrayList<Map<String, Object>>();
        for (Object item : jpaEntityList) {
            edmEntityList.add(this.parse2EdmPropertyValueMap(item, properties, (EdmStructuralType)entity));
        }
        return edmEntityList;
    }

    public final HashMap<String, Object> parse2EdmPropertyValueMap(Object object, List<EdmProperty> list, EdmStructuralType edmStructuralType) throws ODataJPARuntimeException {
        throw new Error("Unresolved compilation problem: \n\tThe operator += is undefined for the argument type(s) Object, String\n");
    }

    public final List<Map<String, Object>> parse2EdmEntityList(Collection<Object> jpaEntityList, EdmStructuralType structuralType) throws ODataJPARuntimeException {
        if (jpaEntityList == null || structuralType == null) {
            return null;
        }
        List<EdmProperty> edmProperties = this.getEdmProperties(structuralType);
        ArrayList<Map<String, Object>> edmEntityList = new ArrayList<Map<String, Object>>();
        for (Object jpaEntity : jpaEntityList) {
            edmEntityList.add(this.parse2EdmPropertyValueMap(jpaEntity, edmProperties, structuralType));
        }
        return edmEntityList;
    }

    public final HashMap<String, Object> parse2EdmPropertyValueMap(Object jpaEntity, EdmStructuralType structuralType) throws ODataJPARuntimeException {
        if (jpaEntity == null || structuralType == null) {
            return null;
        }
        return this.parse2EdmPropertyValueMap(jpaEntity, this.getEdmProperties(structuralType), structuralType);
    }

    public final HashMap<String, Object> parse2EdmNavigationValueMap(Object jpaEntity, List<EdmNavigationProperty> navigationPropertyList) throws ODataJPARuntimeException {
        Object result = null;
        String methodName = null;
        HashMap<String, Object> navigationMap = new HashMap<String, Object>();
        if (jpaEntity == null) {
            return navigationMap;
        }
        if (navigationPropertyList != null && !navigationPropertyList.isEmpty()) {
            try {
                for (EdmNavigationProperty navigationProperty : navigationPropertyList) {
                    methodName = JPAEntityParser.getAccessModifierName(navigationProperty.getName(), navigationProperty.getMapping(), ACCESS_MODIFIER_GET);
                    Method getterMethod = null;
                    JPAEdmMapping jpaEdmMapping = (JPAEdmMapping)navigationProperty.getMapping();
                    getterMethod = jpaEdmMapping != null && jpaEdmMapping.isVirtualAccess() ? jpaEntity.getClass().getMethod(ACCESS_MODIFIER_GET, String.class) : jpaEntity.getClass().getMethod(methodName, null);
                    getterMethod.setAccessible(true);
                    result = JPAEntityParser.getPropertyValue(getterMethod, jpaEntity, navigationProperty.getMapping().getInternalName());
                    navigationMap.put(navigationProperty.getName(), result);
                }
            }
            catch (IllegalArgumentException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
            }
            catch (EdmException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
            }
            catch (SecurityException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
            }
        }
        return navigationMap;
    }

    public Method getAccessModifierSet(Object jpaEntity, String methodName) throws ODataJPARuntimeException {
        Class<?> jpaType = jpaEntity.getClass();
        String methodNameGet = ACCESS_MODIFIER_GET + methodName.substring(3);
        Method method = null;
        try {
            method = jpaType.getMethod(methodNameGet, null);
            Class<?> parameterType = method.getReturnType();
            method = jpaType.getMethod(methodName, parameterType);
        }
        catch (NoSuchMethodException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        catch (SecurityException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        return method;
    }

    public HashMap<String, Method> getAccessModifiers(Object jpaEntity, EdmStructuralType structuralType, String accessModifier) throws ODataJPARuntimeException {
        return this.getAccessModifiers(this.getEdmProperties(structuralType), jpaEntity.getClass(), accessModifier);
    }

    public static Object getPropertyValue(Method method, Object entity, String propertyName) throws ODataJPARuntimeException {
        Object propertyValue = null;
        if (method == null) {
            return null;
        }
        try {
            method.setAccessible(true);
            Class<?> returnType = method.getReturnType();
            if (returnType.equals(char[].class)) {
                char[] ch = (char[])method.invoke(entity, new Object[0]);
                if (ch != null) {
                    propertyValue = String.valueOf((char[])method.invoke(entity, new Object[0]));
                }
            } else if (returnType.equals(Character[].class)) {
                propertyValue = JPAEntityParser.toString((Character[])method.invoke(entity, new Object[0]));
            } else if (returnType.equals(Character.TYPE)) {
                char c = ((Character)method.invoke(entity, new Object[0])).charValue();
                if (c != '\u0000') {
                    propertyValue = String.valueOf(c);
                }
            } else if (returnType.equals(Character.class)) {
                Character c = (Character)method.invoke(entity, new Object[0]);
                if (c != null) {
                    propertyValue = JPAEntityParser.toString(new Character[]{c});
                }
            } else {
                propertyValue = returnType.equals(Blob.class) ? (Object)JPAEntityParser.getBytes((Blob)method.invoke(entity, new Object[0])) : (returnType.equals(Clob.class) ? JPAEntityParser.getString((Clob)method.invoke(entity, new Object[0])) : (method.getParameterTypes().length > 0 ? method.invoke(entity, propertyName) : method.invoke(entity, new Object[0])));
            }
        }
        catch (IllegalAccessException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        catch (SecurityException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        return propertyValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getString(Clob clob) throws ODataJPARuntimeException {
        Reader stringReader = null;
        try {
            long clobSize;
            if (clob == null) {
                return null;
            }
            stringReader = clob.getCharacterStream();
            StringWriter buffer = null;
            long remainingClobSize = clobSize = clob.length();
            int len = 0;
            int off = 0;
            boolean bufferNotEmpty = false;
            if (clobSize > Integer.MAX_VALUE) {
                buffer = new StringWriter(Integer.MAX_VALUE);
                len = Integer.MAX_VALUE;
                bufferNotEmpty = true;
            } else {
                buffer = new StringWriter((int)clobSize);
                len = (int)clobSize;
            }
            char[] c = new char[len];
            while (true) {
                if (remainingClobSize <= (long)len) {
                    if (remainingClobSize <= (long)len) {
                        stringReader.read(c, off, len);
                    }
                    if (!bufferNotEmpty) break;
                    String string = buffer.toString();
                    return string;
                }
                stringReader.read(c, off, len);
                buffer.write(c);
                off = len + 1;
                if ((remainingClobSize -= Integer.MAX_VALUE) > Integer.MAX_VALUE) {
                    len = Integer.MAX_VALUE;
                    continue;
                }
                len = (int)remainingClobSize;
            }
            String string = new String(c);
            return string;
        }
        catch (SQLException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        catch (IOException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        finally {
            if (stringReader != null) {
                try {
                    stringReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getBytes(Blob blob) throws ODataJPARuntimeException {
        InputStream is = null;
        ByteArrayOutputStream buffer = null;
        try {
            long blobSize;
            if (blob == null) {
                return null;
            }
            long remainingBlobSize = blobSize = blob.length();
            int len = 0;
            int off = 0;
            boolean bufferNotEmpty = false;
            if (blobSize > Integer.MAX_VALUE) {
                buffer = new ByteArrayOutputStream(Integer.MAX_VALUE);
                len = Integer.MAX_VALUE;
                bufferNotEmpty = true;
            } else {
                buffer = new ByteArrayOutputStream((int)blobSize);
                len = (int)blobSize;
            }
            is = blob.getBinaryStream();
            byte[] b = new byte[len];
            while (true) {
                if (remainingBlobSize <= (long)len) {
                    if (remainingBlobSize <= (long)len) {
                        is.read(b, off, len);
                    }
                    if (!bufferNotEmpty) break;
                    byte[] byArray = buffer.toByteArray();
                    return byArray;
                }
                is.read(b, off, len);
                buffer.write(b);
                off = len + 1;
                if ((remainingBlobSize -= Integer.MAX_VALUE) > Integer.MAX_VALUE) {
                    len = Integer.MAX_VALUE;
                    continue;
                }
                len = (int)remainingBlobSize;
            }
            byte[] byArray = b;
            return byArray;
        }
        catch (SQLException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        catch (IOException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Object getEmbeddablePropertyValue(String methodName, Object jpaEntity, boolean isVirtualAccess) throws ODataJPARuntimeException {
        String[] nameParts = methodName.split("\\.");
        Object propertyValue = jpaEntity;
        Method method = null;
        try {
            String[] stringArray = nameParts;
            int n = nameParts.length;
            int n2 = 0;
            while (n2 < n) {
                String namePart = stringArray[n2];
                if (propertyValue != null) {
                    if (isVirtualAccess) {
                        method = propertyValue.getClass().getMethod(ACCESS_MODIFIER_GET, String.class);
                        namePart = namePart.replaceFirst(ACCESS_MODIFIER_GET, "");
                    } else {
                        method = propertyValue.getClass().getMethod(namePart, null);
                    }
                    method.setAccessible(true);
                    propertyValue = JPAEntityParser.getPropertyValue(method, propertyValue, namePart);
                    isVirtualAccess = false;
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (NoSuchMethodException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        catch (SecurityException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        return propertyValue;
    }

    public Object getEmbeddablePropertyValue(String methodName, Object jpaEntity) throws ODataJPARuntimeException {
        return this.getEmbeddablePropertyValue(methodName, jpaEntity, false);
    }

    public static String toString(Character[] input) {
        if (input == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        Character[] characterArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            Character element = characterArray[n2];
            if (element != null) {
                builder.append(element.charValue());
            }
            ++n2;
        }
        return builder.toString();
    }

    public static Character[] toCharacterArray(String input) {
        if (input == null) {
            return null;
        }
        Character[] characters = new Character[input.length()];
        char[] chars = input.toCharArray();
        int i = 0;
        while (i < input.length()) {
            characters[i] = new Character(chars[i]);
            ++i;
        }
        return characters;
    }

    public static String getAccessModifierName(String propertyName, EdmMapping mapping, String accessModifier) throws ODataJPARuntimeException {
        String name = null;
        StringBuilder builder = new StringBuilder();
        String[] nameParts = new String[]{};
        name = mapping == null || mapping.getInternalName() == null ? propertyName : mapping.getInternalName();
        if (name != null) {
            nameParts = name.split("\\.");
        }
        if (nameParts.length == 1) {
            if (name != null) {
                char c = Character.toUpperCase(name.charAt(0));
                builder.append(accessModifier).append(c).append(name.substring(1)).toString();
            }
        } else if (nameParts.length > 1) {
            int i = 0;
            while (i < nameParts.length) {
                name = nameParts[i];
                char c = Character.toUpperCase(name.charAt(0));
                if (i == 0) {
                    builder.append(accessModifier).append(c).append(name.substring(1));
                } else {
                    builder.append(".").append(accessModifier).append(c).append(name.substring(1));
                }
                ++i;
            }
        } else {
            return null;
        }
        if (builder.length() > 0) {
            return builder.toString();
        }
        return null;
    }

    public Method getAccessModifier(Class<?> jpaEntityType, EdmNavigationProperty navigationProperty, String accessModifier) throws ODataJPARuntimeException {
        try {
            JPAEdmMapping navPropMapping = (JPAEdmMapping)navigationProperty.getMapping();
            Class[] params = null;
            if (navPropMapping != null && navPropMapping.isVirtualAccess()) {
                return jpaEntityType.getMethod(ACCESS_MODIFIER_SET, String.class, Object.class);
            }
            String name = JPAEntityParser.getAccessModifierName(navigationProperty.getName(), (EdmMapping)navPropMapping, accessModifier);
            if (accessModifier.equals(ACCESS_MODIFIER_SET)) {
                EdmAssociationEnd end = navigationProperty.getRelationship().getEnd(navigationProperty.getToRole());
                switch (end.getMultiplicity()) {
                    case MANY: {
                        params = new Class[]{navPropMapping != null ? navPropMapping.getJPAType() : null};
                        break;
                    }
                    case ZERO_TO_ONE: 
                    case ONE: {
                        params = new Class[]{((JPAEdmMapping)end.getEntityType().getMapping()).getJPAType()};
                        break;
                    }
                }
            }
            return jpaEntityType.getMethod(name, params);
        }
        catch (NoSuchMethodException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        catch (SecurityException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
    }

    private HashMap<String, Method> getAccessModifiers(List<EdmProperty> edmProperties, Class<?> jpaEntityType, String accessModifier) throws ODataJPARuntimeException {
        HashMap<String, String> embeddableKey;
        HashMap<String, Method> accessModifierMap = this.jpaEntityAccessMap.get(jpaEntityType.getName());
        if (accessModifierMap == null) {
            accessModifierMap = new HashMap();
            this.jpaEntityAccessMap.put(jpaEntityType.getName(), accessModifierMap);
        }
        if ((embeddableKey = this.jpaEmbeddableKeyMap.get(jpaEntityType.getName())) == null) {
            embeddableKey = new HashMap();
        }
        Method method = null;
        try {
            for (EdmProperty property : edmProperties) {
                String propertyName;
                block30: {
                    if (((EdmSimplePropertyImplProv)property).getComposite() != null) {
                        accessModifierMap.putAll(this.getAccessModifiers(((EdmSimplePropertyImplProv)property).getComposite(), jpaEntityType, accessModifier));
                    }
                    method = null;
                    propertyName = property.getName();
                    if (accessModifierMap.containsKey(propertyName)) continue;
                    String methodName = JPAEntityParser.getAccessModifierName(property.getName(), property.getMapping(), accessModifier);
                    String[] nameParts = methodName != null ? methodName.split("\\.") : new String[]{};
                    try {
                        JPAEdmMapping jpaEdmMapping;
                        if (nameParts.length > 1) {
                            if (!embeddableKey.containsKey(propertyName)) {
                                embeddableKey.put(propertyName, methodName);
                                continue;
                            }
                            break block30;
                        }
                        if (accessModifier.equals(ACCESS_MODIFIER_SET)) {
                            jpaEdmMapping = (JPAEdmMapping)property.getMapping();
                            if (jpaEdmMapping != null && jpaEdmMapping.isVirtualAccess()) {
                                try {
                                    accessModifierMap.put(propertyName, jpaEntityType.getMethod(ACCESS_MODIFIER_SET, String.class, Object.class));
                                }
                                catch (Exception e) {
                                    try {
                                        accessModifierMap.put(propertyName, ReflectionUtil.getMethod(jpaEntityType, methodName));
                                        break block30;
                                    }
                                    catch (Exception e2) {
                                        accessModifierMap.put(propertyName, null);
                                    }
                                }
                                break block30;
                            }
                            accessModifierMap.put(propertyName, ReflectionUtil.getMethod(jpaEntityType, methodName));
                            break block30;
                        }
                        jpaEdmMapping = (JPAEdmMapping)property.getMapping();
                        if (jpaEdmMapping != null && jpaEdmMapping.isVirtualAccess()) {
                            try {
                                method = jpaEntityType.getMethod(ACCESS_MODIFIER_GET, String.class);
                            }
                            catch (Exception e) {}
                        } else {
                            method = ReflectionUtil.getMethod(jpaEntityType, methodName);
                        }
                    }
                    catch (EdmException exp) {
                        throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)exp);
                    }
                    catch (NoSuchMethodException e1) {
                        try {
                            EdmSimpleType edmSimpleType = (EdmSimpleType)property.getType();
                            if (edmSimpleType == EdmSimpleTypeKind.Boolean.getEdmSimpleTypeInstance() && accessModifier.equals(ACCESS_MODIFIER_GET)) {
                                String nameWithIs = JPAEntityParser.getAccessModifierName(property.getName(), property.getMapping(), ACCESS_MODIFIER_IS);
                                method = jpaEntityType.getMethod(nameWithIs, null);
                            }
                            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e1);
                        }
                        catch (EdmException exp) {
                            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)exp);
                        }
                        catch (NoSuchMethodException exp) {
                            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)exp);
                        }
                        catch (SecurityException exp) {
                            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)exp);
                        }
                    }
                    catch (SecurityException e1) {
                        throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e1);
                    }
                }
                if (method == null) continue;
                accessModifierMap.put(propertyName, method);
            }
        }
        catch (EdmException exp) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)exp);
        }
        if (!embeddableKey.isEmpty()) {
            if (!this.jpaEmbeddableKeyMap.containsKey(jpaEntityType.getName())) {
                this.jpaEmbeddableKeyMap.put(jpaEntityType.getName(), embeddableKey);
            } else {
                this.jpaEmbeddableKeyMap.get(jpaEntityType.getName()).putAll(embeddableKey);
            }
        }
        return accessModifierMap;
    }

    private List<EdmProperty> getEdmProperties(EdmStructuralType structuralType) throws ODataJPARuntimeException {
        ArrayList<EdmProperty> edmProperties = new ArrayList<EdmProperty>();
        try {
            for (String propertyName : structuralType.getPropertyNames()) {
                edmProperties.add((EdmProperty)structuralType.getProperty(propertyName));
            }
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        return edmProperties;
    }
}

