/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.model;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.edm.provider.ComplexProperty;
import org.apache.olingo.odata2.api.edm.provider.ComplexType;
import org.apache.olingo.odata2.api.edm.provider.Facets;
import org.apache.olingo.odata2.api.edm.provider.Property;
import org.apache.olingo.odata2.api.edm.provider.SimpleProperty;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAEdmBuilder;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAEdmMappingModelAccess;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmAssociationEndView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmAssociationView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmBaseView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmComplexPropertyView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmComplexTypeView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmEntityTypeView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmKeyView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmMapping;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmNavigationPropertyView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmPropertyView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmReferentialConstraintView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmSchemaView;
import org.apache.olingo.odata2.jpa.processor.core.ODataJPAConfig;
import org.apache.olingo.odata2.jpa.processor.core.access.model.JPAEdmNameBuilder;
import org.apache.olingo.odata2.jpa.processor.core.access.model.JPATypeConverter;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmAssociation;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmAssociationEnd;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmBaseViewImpl;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmComplexType;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmFacets;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmKey;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmMappingImpl;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmNavigationProperty;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmReferentialConstraint;

public class JPAEdmProperty
extends JPAEdmBaseViewImpl
implements JPAEdmPropertyView,
JPAEdmComplexPropertyView {
    private JPAEdmSchemaView schemaView;
    private JPAEdmEntityTypeView entityTypeView;
    private JPAEdmComplexTypeView complexTypeView;
    private JPAEdmNavigationPropertyView navigationPropertyView = null;
    private JPAEdmKeyView keyView;
    private List<Property> properties;
    private SimpleProperty currentSimpleProperty = null;
    private ComplexProperty currentComplexProperty = null;
    private Attribute<?, ?> currentAttribute;
    private Attribute<?, ?> currentRefAttribute;
    private boolean isBuildModeComplexType;
    private Map<String, Integer> associationCount;
    private ArrayList<String[]> joinColumnNames = null;
    private List<SimpleProperty> joinProperties = null;
    private int totaJoinColumns = 0;
    private JPAEdmBuilder keyViewBuilder;

    public JPAEdmProperty(JPAEdmSchemaView view) {
        super((JPAEdmBaseView)view);
        this.schemaView = view;
        this.entityTypeView = this.schemaView.getJPAEdmEntityContainerView().getJPAEdmEntitySetView().getJPAEdmEntityTypeView();
        this.complexTypeView = this.schemaView.getJPAEdmComplexTypeView();
        this.navigationPropertyView = new JPAEdmNavigationProperty(this.schemaView);
        this.isBuildModeComplexType = false;
        this.associationCount = new HashMap<String, Integer>();
    }

    public JPAEdmProperty(JPAEdmSchemaView schemaView, JPAEdmComplexTypeView view) {
        super((JPAEdmBaseView)view);
        this.schemaView = schemaView;
        this.complexTypeView = view;
        this.isBuildModeComplexType = true;
    }

    public JPAEdmBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new JPAEdmPropertyBuilder();
        }
        return this.builder;
    }

    public List<Property> getEdmPropertyList() {
        return this.properties;
    }

    public JPAEdmKeyView getJPAEdmKeyView() {
        return this.keyView;
    }

    public SimpleProperty getEdmSimpleProperty() {
        return this.currentSimpleProperty;
    }

    public Attribute<?, ?> getJPAAttribute() {
        return this.currentAttribute;
    }

    public Attribute<?, ?> getJPAReferencedAttribute() {
        return this.currentRefAttribute;
    }

    public ComplexProperty getEdmComplexProperty() {
        return this.currentComplexProperty;
    }

    public JPAEdmNavigationPropertyView getJPAEdmNavigationPropertyView() {
        return this.navigationPropertyView;
    }

    public List<String[]> getJPAJoinColumns() {
        return this.joinColumnNames;
    }

    private String getReferenceColumnName(AnnotatedElement annotatedElement2, Attribute<?, ?> referencedAttribute) {
        String refColName = null;
        Column c = annotatedElement2.getAnnotation(Column.class);
        if (c != null) {
            refColName = c.name();
        }
        return refColName == null || "".equals(refColName) ? referencedAttribute.getName() : refColName;
    }

    public JPAEdmEntityTypeView getJPAEdmEntityTypeView() {
        return this.entityTypeView;
    }

    public JPAEdmComplexTypeView getJPAEdmComplexTypeView() {
        return this.complexTypeView;
    }

    private boolean isExcluded(JPAEdmPropertyView jpaEdmPropertyView, String jpaEntityTypeName, String jpaAttributeName) {
        JPAEdmMappingModelAccess mappingModelAccess = jpaEdmPropertyView.getJPAEdmMappingModelAccess();
        boolean isExcluded = false;
        if (mappingModelAccess != null && mappingModelAccess.isMappingModelExists() && (this.isBuildModeComplexType && mappingModelAccess.checkExclusionOfJPAEmbeddableAttributeType(jpaEntityTypeName, jpaAttributeName) || !this.isBuildModeComplexType && mappingModelAccess.checkExclusionOfJPAAttributeType(jpaEntityTypeName, jpaAttributeName))) {
            isExcluded = true;
        }
        return isExcluded;
    }

    private class JPAEdmPropertyBuilder
    implements JPAEdmBuilder {
        private JPAEdmPropertyBuilder() {
        }

        public void build() throws ODataJPAModelException, ODataJPARuntimeException {
            JPAEdmProperty.this.keyViewBuilder = null;
            JPAEdmProperty.this.properties = new ArrayList();
            List<Attribute<?, ?>> jpaAttributes = null;
            String currentEntityName = null;
            String targetEntityName = null;
            String entityTypeName = null;
            if (JPAEdmProperty.this.isBuildModeComplexType) {
                jpaAttributes = this.sortInAscendingOrder(JPAEdmProperty.this.complexTypeView.getJPAEmbeddableType().getAttributes(), JPAEdmProperty.this.complexTypeView.getJPAEmbeddableType().getJavaType());
                entityTypeName = JPAEdmProperty.this.complexTypeView.getJPAEmbeddableType().getJavaType().getSimpleName();
            } else {
                jpaAttributes = this.sortInAscendingOrder(JPAEdmProperty.this.entityTypeView.getJPAEntityType().getAttributes(), JPAEdmProperty.this.entityTypeView.getJPAEntityType().getJavaType());
                entityTypeName = JPAEdmProperty.this.entityTypeView.getJPAEntityType().getName();
            }
            LinkedList<SimpleProperty> objectKey = new LinkedList<SimpleProperty>();
            for (Attribute<?, ?> jpaAttribute : jpaAttributes) {
                JPAEdmProperty.this.currentAttribute = jpaAttribute;
                if (JPAEdmProperty.this.isExcluded(JPAEdmProperty.this, entityTypeName, JPAEdmProperty.this.currentAttribute.getName())) continue;
                Attribute.PersistentAttributeType attributeType = JPAEdmProperty.this.currentAttribute.getPersistentAttributeType();
                switch (attributeType) {
                    case BASIC: {
                        JPAEdmProperty.this.currentSimpleProperty = new SimpleProperty();
                        JPAEdmProperty.this.properties.add(this.buildSimpleProperty(JPAEdmProperty.this.currentAttribute, JPAEdmProperty.this.currentSimpleProperty));
                        break;
                    }
                    case EMBEDDED: {
                        ComplexType complexType = JPAEdmProperty.this.complexTypeView.searchEdmComplexType(JPAEdmProperty.this.currentAttribute.getJavaType().getName());
                        if (complexType == null) {
                            JPAEdmComplexType complexTypeViewLocal = new JPAEdmComplexType(JPAEdmProperty.this.schemaView, JPAEdmProperty.this.currentAttribute);
                            complexTypeViewLocal.getBuilder().build();
                            complexType = complexTypeViewLocal.getEdmComplexType();
                            JPAEdmProperty.this.complexTypeView.addJPAEdmCompleTypeView((JPAEdmComplexTypeView)complexTypeViewLocal);
                        }
                        if (!JPAEdmProperty.this.isBuildModeComplexType && JPAEdmProperty.this.entityTypeView.getJPAEntityType().getIdType().getJavaType().equals(JPAEdmProperty.this.currentAttribute.getJavaType())) {
                            if (JPAEdmProperty.this.keyView == null) {
                                JPAEdmProperty.this.keyView = new JPAEdmKey(JPAEdmProperty.this.complexTypeView, JPAEdmProperty.this);
                            }
                            JPAEdmProperty.this.keyView.getBuilder().build();
                            JPAEdmProperty.this.complexTypeView.expandEdmComplexType(complexType, JPAEdmProperty.this.properties, JPAEdmProperty.this.currentAttribute.getName());
                            break;
                        }
                        JPAEdmProperty.this.currentComplexProperty = new ComplexProperty();
                        if (JPAEdmProperty.this.isBuildModeComplexType) {
                            JPAEdmNameBuilder.build(JPAEdmProperty.this, JPAEdmProperty.this.complexTypeView.getJPAEmbeddableType().getJavaType().getSimpleName());
                        } else {
                            JPAEdmNameBuilder.build((JPAEdmComplexPropertyView)JPAEdmProperty.this, JPAEdmProperty.this, JPAEdmProperty.this.skipDefaultNaming);
                        }
                        JPAEdmProperty.this.currentComplexProperty.setType(new FullQualifiedName(JPAEdmProperty.this.schemaView.getEdmSchema().getNamespace(), complexType.getName()));
                        JPAEdmProperty.this.properties.add(JPAEdmProperty.this.currentComplexProperty);
                        if (JPAEdmProperty.this.complexTypeView.isReferencedInKey(JPAEdmProperty.this.currentComplexProperty.getType().getName())) break;
                        JPAEdmProperty.this.complexTypeView.setReferencedInKey(JPAEdmProperty.this.currentComplexProperty.getType().getName());
                        break;
                    }
                    case MANY_TO_ONE: 
                    case ONE_TO_ONE: 
                    case MANY_TO_MANY: 
                    case ONE_TO_MANY: {
                        if (attributeType.equals((Object)Attribute.PersistentAttributeType.MANY_TO_ONE) || attributeType.equals((Object)Attribute.PersistentAttributeType.ONE_TO_ONE)) {
                            this.addForeignKey(JPAEdmProperty.this.currentAttribute);
                        }
                        JPAEdmAssociationEnd associationEndView = new JPAEdmAssociationEnd(JPAEdmProperty.this.entityTypeView, JPAEdmProperty.this);
                        associationEndView.getBuilder().build();
                        JPAEdmAssociationView associationView = JPAEdmProperty.this.schemaView.getJPAEdmAssociationView();
                        if (associationView.searchAssociation((JPAEdmAssociationEndView)associationEndView) == null) {
                            int count = associationView.getNumberOfAssociationsWithSimilarEndPoints((JPAEdmAssociationEndView)associationEndView);
                            JPAEdmAssociation associationViewLocal = new JPAEdmAssociation(associationEndView, JPAEdmProperty.this.entityTypeView, JPAEdmProperty.this, count);
                            associationViewLocal.getBuilder().build();
                            associationView.addJPAEdmAssociationView((JPAEdmAssociationView)associationViewLocal, (JPAEdmAssociationEndView)associationEndView);
                        }
                        if (attributeType.equals((Object)Attribute.PersistentAttributeType.MANY_TO_ONE) || attributeType.equals((Object)Attribute.PersistentAttributeType.ONE_TO_ONE)) {
                            JPAEdmReferentialConstraint refConstraintView = new JPAEdmReferentialConstraint(associationView, JPAEdmProperty.this.entityTypeView, JPAEdmProperty.this);
                            refConstraintView.getBuilder().build();
                            if (refConstraintView.isExists()) {
                                associationView.addJPAEdmRefConstraintView((JPAEdmReferentialConstraintView)refConstraintView);
                            }
                        }
                        if (JPAEdmProperty.this.navigationPropertyView == null) {
                            JPAEdmProperty.this.navigationPropertyView = new JPAEdmNavigationProperty(JPAEdmProperty.this.schemaView);
                        }
                        currentEntityName = JPAEdmProperty.this.entityTypeView.getJPAEntityType().getName();
                        targetEntityName = JPAEdmProperty.this.currentAttribute.isCollection() ? ((PluralAttribute)JPAEdmProperty.this.currentAttribute).getElementType().getJavaType().getSimpleName() : JPAEdmProperty.this.currentAttribute.getJavaType().getSimpleName();
                        Integer sequenceNumber = (Integer)JPAEdmProperty.this.associationCount.get(String.valueOf(currentEntityName) + targetEntityName);
                        sequenceNumber = sequenceNumber == null ? new Integer(1) : new Integer(sequenceNumber + 1);
                        JPAEdmProperty.this.associationCount.put(String.valueOf(currentEntityName) + targetEntityName, sequenceNumber);
                        JPAEdmNavigationProperty localNavigationPropertyView = new JPAEdmNavigationProperty(associationView, JPAEdmProperty.this, sequenceNumber);
                        localNavigationPropertyView.getBuilder().build();
                        JPAEdmProperty.this.navigationPropertyView.addJPAEdmNavigationPropertyView((JPAEdmNavigationPropertyView)localNavigationPropertyView);
                        break;
                    }
                }
                if (attributeType != Attribute.PersistentAttributeType.BASIC && attributeType != Attribute.PersistentAttributeType.MANY_TO_MANY && attributeType != Attribute.PersistentAttributeType.ONE_TO_MANY && attributeType != Attribute.PersistentAttributeType.ONE_TO_ONE && attributeType != Attribute.PersistentAttributeType.MANY_TO_ONE || !(JPAEdmProperty.this.currentAttribute instanceof SingularAttribute) || !((SingularAttribute)JPAEdmProperty.this.currentAttribute).isId()) continue;
                objectKey.add(JPAEdmProperty.this.currentSimpleProperty);
            }
            SimpleProperty compositeProperty = new SimpleProperty();
            JPAEdmProperty.this.currentSimpleProperty = compositeProperty;
            JPAEdmNameBuilder.build(JPAEdmProperty.this, false, true, false);
            compositeProperty.setType(EdmSimpleTypeKind.String);
            Facets facets = new Facets();
            compositeProperty.setFacets((EdmFacets)facets);
            compositeProperty.setName(ODataJPAConfig.COMPOSITE_KEY_NAME);
            ((JPAEdmMappingImpl)compositeProperty.getMapping()).setJPAType(String.class);
            for (SimpleProperty p : objectKey) {
                p.setOriginalId(true);
                if (p.getComposite() != null) {
                    for (Property composite : p.getComposite()) {
                        compositeProperty.addComposite(composite);
                        composite.setForeignKey(true);
                        composite.setOriginalId(true);
                    }
                    continue;
                }
                compositeProperty.addComposite((Property)p);
                p.setOriginalId(true);
                p.setOriginalName(p.getName());
            }
            JPAEdmProperty.this.properties.add(compositeProperty);
            if (JPAEdmProperty.this.keyView == null) {
                JPAEdmProperty.this.keyView = new JPAEdmKey(JPAEdmProperty.this);
                JPAEdmProperty.this.keyViewBuilder = JPAEdmProperty.this.keyView.getBuilder();
            }
            if (JPAEdmProperty.this.keyViewBuilder != null) {
                JPAEdmProperty.this.keyViewBuilder.build();
            }
        }

        private SimpleProperty buildSimpleProperty(Attribute<?, ?> jpaAttribute, SimpleProperty simpleProperty) throws ODataJPAModelException, ODataJPARuntimeException {
            return this.buildSimpleProperty(jpaAttribute, simpleProperty, null);
        }

        private SimpleProperty buildSimpleProperty(Attribute<?, ?> jpaAttribute, SimpleProperty simpleProperty, JoinColumn joinColumn) throws ODataJPAModelException, ODataJPARuntimeException {
            boolean isForeignKey = joinColumn != null;
            JPAEdmNameBuilder.build(JPAEdmProperty.this, JPAEdmProperty.this.isBuildModeComplexType, JPAEdmProperty.this.skipDefaultNaming, isForeignKey);
            EdmSimpleTypeKind simpleTypeKind = JPATypeConverter.convertToEdmSimpleType(jpaAttribute.getJavaType(), jpaAttribute);
            simpleProperty.setType(simpleTypeKind);
            Facets facets = JPAEdmFacets.createAndSet(jpaAttribute, simpleProperty);
            if (isForeignKey) {
                facets.setNullable(Boolean.valueOf(joinColumn.nullable()));
                String path = ((String[])JPAEdmProperty.this.joinColumnNames.get(JPAEdmProperty.this.joinColumnNames.size() - 1))[1];
                if (JPAEdmProperty.this.totaJoinColumns > 1) {
                    simpleProperty.setName(String.valueOf(simpleProperty.getName()) + "_" + path.replace(".", "_"));
                }
            }
            int total = 0;
            String name = simpleProperty.getName();
            for (Property property : JPAEdmProperty.this.properties) {
                if (!property.getName().equals(name)) continue;
                name = String.valueOf(simpleProperty.getName()) + "_" + ++total;
            }
            if (total > 0) {
                simpleProperty.setName(name);
            }
            ((JPAEdmMapping)simpleProperty.getMapping()).setOriginalType(jpaAttribute.getJavaType());
            return simpleProperty;
        }

        private void addForeignKey(Attribute<?, ?> jpaAttribute) throws ODataJPAModelException, ODataJPARuntimeException {
            AnnotatedElement annotatedElement = (AnnotatedElement)((Object)jpaAttribute.getJavaMember());
            JPAEdmProperty.this.joinColumnNames = null;
            JPAEdmProperty.this.totaJoinColumns = 0;
            int joinColumnIndex = -1;
            if (JPAEdmProperty.this.joinProperties == null) {
                JPAEdmProperty.this.joinProperties = new LinkedList();
            }
            JPAEdmProperty.this.joinProperties.clear();
            if (annotatedElement == null) {
                return;
            }
            JoinColumn joinColumn = annotatedElement.getAnnotation(JoinColumn.class);
            if (joinColumn == null) {
                JoinColumns joinColumns = annotatedElement.getAnnotation(JoinColumns.class);
                if (joinColumns != null) {
                    JPAEdmProperty.this.totaJoinColumns = joinColumns.value().length;
                    SimpleProperty compositeProperty = null;
                    if (joinColumns.value().length > 1) {
                        compositeProperty = new SimpleProperty();
                        JPAEdmProperty.this.currentSimpleProperty = compositeProperty;
                        JPAEdmNameBuilder.build(JPAEdmProperty.this, false, true, false);
                        EdmSimpleTypeKind simpleTypeKind = JPATypeConverter.convertToEdmSimpleType(String.class, jpaAttribute);
                        compositeProperty.setType(simpleTypeKind);
                        JPAEdmFacets.createAndSet(jpaAttribute, compositeProperty);
                        compositeProperty.setName(jpaAttribute.getName());
                        ((JPAEdmMappingImpl)compositeProperty.getMapping()).setJPAType(String.class);
                        compositeProperty.setOriginalType(jpaAttribute.getJavaType());
                        JPAEdmProperty.this.properties.add(compositeProperty);
                    }
                    JoinColumn[] joinColumnArray = joinColumns.value();
                    int n = joinColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JoinColumn jc = joinColumnArray[n2];
                        SimpleProperty p = this.buildForeignKey(jc, jpaAttribute, ++joinColumnIndex);
                        if (ODataJPAConfig.EXPAND_COMPOSITE_KEYS) {
                            JPAEdmProperty.this.properties.add(p);
                        }
                        if (compositeProperty != null) {
                            compositeProperty.addComposite((Property)p);
                            JPAEdmProperty.this.currentSimpleProperty = compositeProperty;
                        }
                        ++n2;
                    }
                }
            } else {
                JPAEdmProperty.this.totaJoinColumns = 1;
                SimpleProperty p = this.buildForeignKey(joinColumn, jpaAttribute, ++joinColumnIndex);
                JPAEdmProperty.this.currentSimpleProperty.setOriginalType(jpaAttribute.getJavaType());
                JPAEdmProperty.this.properties.add(JPAEdmProperty.this.currentSimpleProperty);
            }
        }

        private SimpleProperty buildForeignKey(JoinColumn joinColumn, Attribute<?, ?> jpaAttribute, int joinColumnIndex) throws ODataJPAModelException, ODataJPARuntimeException {
            JPAEdmProperty.this.joinColumnNames = JPAEdmProperty.this.joinColumnNames == null ? new ArrayList() : JPAEdmProperty.this.joinColumnNames;
            String[] name = new String[2];
            name[0] = "".equals(joinColumn.name()) ? jpaAttribute.getName() : joinColumn.name();
            EntityType referencedEntityType = null;
            referencedEntityType = jpaAttribute.isCollection() ? JPAEdmProperty.this.metaModel.entity(((PluralAttribute)JPAEdmProperty.this.currentAttribute).getElementType().getJavaType()) : JPAEdmProperty.this.metaModel.entity(jpaAttribute.getJavaType());
            if ("".equals(joinColumn.referencedColumnName())) {
                for (Attribute referencedAttribute : referencedEntityType.getAttributes()) {
                    if (referencedAttribute.getPersistentAttributeType() != Attribute.PersistentAttributeType.BASIC || !((SingularAttribute)referencedAttribute).isId()) continue;
                    AnnotatedElement annotatedElement = (AnnotatedElement)((Object)referencedAttribute.getJavaMember());
                    Column referencedColumn = null;
                    if (annotatedElement != null) {
                        referencedColumn = annotatedElement.getAnnotation(Column.class);
                    }
                    name[1] = referencedColumn != null ? referencedColumn.name() : referencedAttribute.getName();
                    JPAEdmProperty.this.joinColumnNames.add(name);
                    JPAEdmProperty.this.currentRefAttribute = referencedAttribute;
                    break;
                }
            } else {
                List<Attribute<?, ?>> refPath = this.findRef(referencedEntityType, joinColumn);
                if (refPath.size() > 0) {
                    name[1] = this.toString(refPath);
                    JPAEdmProperty.this.joinColumnNames.add(name);
                    JPAEdmProperty.this.currentRefAttribute = refPath.get(refPath.size() - 1);
                }
            }
            if (JPAEdmProperty.this.currentRefAttribute == null) {
                throw ODataJPAModelException.throwException((MessageReference)ODataJPAModelException.REF_ATTRIBUTE_NOT_FOUND.addContent(new Object[]{String.valueOf(joinColumn.referencedColumnName()) + " -> " + referencedEntityType.getName()}), null);
            }
            JPAEdmProperty.this.currentSimpleProperty = new SimpleProperty();
            JPAEdmProperty.this.currentSimpleProperty.setOriginalName(jpaAttribute.getName());
            JPAEdmProperty.this.currentSimpleProperty.setIndex(joinColumnIndex);
            JPAEdmProperty.this.currentSimpleProperty.setForeignKey(true);
            this.buildSimpleProperty(JPAEdmProperty.this.currentRefAttribute, JPAEdmProperty.this.currentSimpleProperty, joinColumn);
            return JPAEdmProperty.this.currentSimpleProperty;
        }

        private String toString(List<Attribute<?, ?>> refPath) {
            String path = "";
            for (Attribute<?, ?> attr : refPath) {
                if (!path.isEmpty()) {
                    path = String.valueOf(path) + ".";
                }
                path = String.valueOf(path) + attr.getName();
            }
            return path;
        }

        private List<Attribute<?, ?>> findRef(EntityType<?> referencedEntityType, JoinColumn joinColumn) {
            LinkedList refPath = new LinkedList();
            this.findPath(refPath, referencedEntityType, joinColumn.referencedColumnName());
            return refPath;
        }

        private void findPath(List<Attribute<?, ?>> refPath, EntityType<?> referencedEntityType, String name) {
            for (Attribute referencedAttribute : referencedEntityType.getAttributes()) {
                String refColName;
                AnnotatedElement annotatedElement2 = (AnnotatedElement)((Object)referencedAttribute.getJavaMember());
                Column c = annotatedElement2.getAnnotation(Column.class);
                if (annotatedElement2 == null || c == null || !(refColName = JPAEdmProperty.this.getReferenceColumnName(annotatedElement2, referencedAttribute)).equals(name)) continue;
                refPath.add(referencedAttribute);
                return;
            }
            block1: for (Attribute referencedAttribute : referencedEntityType.getAttributes()) {
                AnnotatedElement annotatedElement = (AnnotatedElement)((Object)referencedAttribute.getJavaMember());
                if (annotatedElement == null) continue;
                JoinColumn joinColumn = annotatedElement.getAnnotation(JoinColumn.class);
                if (joinColumn == null) {
                    JoinColumns joinColumns = annotatedElement.getAnnotation(JoinColumns.class);
                    if (joinColumns == null) continue;
                    JoinColumn[] joinColumnArray = joinColumns.value();
                    int n = joinColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JoinColumn jc = joinColumnArray[n2];
                        if (jc.name().equals(name)) {
                            refPath.add(referencedAttribute);
                            this.findPath(refPath, JPAEdmProperty.this.metaModel.entity(referencedAttribute.getJavaType()), jc.referencedColumnName());
                            continue block1;
                        }
                        ++n2;
                    }
                    continue;
                }
                if (!joinColumn.name().equals(name)) continue;
                refPath.add(referencedAttribute);
                this.findPath(refPath, JPAEdmProperty.this.metaModel.entity(referencedAttribute.getJavaType()), joinColumn.referencedColumnName());
            }
        }

        private Attribute<?, ?> findField(Set<?> jpaAttributes, String name) {
            for (Object o : jpaAttributes) {
                if (!((Attribute)o).getName().equals(name)) continue;
                return (Attribute)o;
            }
            return null;
        }

        private List<Attribute<?, ?>> sortInAscendingOrder(Set<?> jpaAttributes, Class clazz) {
            Field[] fields;
            ArrayList jpaAttributeList = new ArrayList();
            Field[] fieldArray = fields = clazz.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                Attribute<?, ?> attr = this.findField(jpaAttributes, field.getName());
                if (attr != null) {
                    jpaAttributeList.add(attr);
                }
                ++n2;
            }
            return jpaAttributeList;
        }
    }
}

