/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.edm.provider.ComplexProperty;
import org.apache.olingo.odata2.api.edm.provider.ComplexType;
import org.apache.olingo.odata2.api.edm.provider.Mapping;
import org.apache.olingo.odata2.api.edm.provider.Property;
import org.apache.olingo.odata2.api.edm.provider.SimpleProperty;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAEdmBuilder;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAEdmMappingModelAccess;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmBaseView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmComplexTypeView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmMapping;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmSchemaView;
import org.apache.olingo.odata2.jpa.processor.core.access.model.JPAEdmNameBuilder;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmBaseViewImpl;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmMappingImpl;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmProperty;

public class JPAEdmComplexType
extends JPAEdmBaseViewImpl
implements JPAEdmComplexTypeView {
    private JPAEdmSchemaView schemaView;
    private ComplexType currentComplexType = null;
    private EmbeddableType<?> currentEmbeddableType = null;
    private HashMap<String, ComplexType> searchMap = null;
    private List<ComplexType> consistentComplextTypes = null;
    private boolean directBuild;
    private EmbeddableType<?> nestedComplexType = null;
    private List<String> nonKeyComplexList = null;

    public JPAEdmComplexType(JPAEdmSchemaView view) {
        super((JPAEdmBaseView)view);
        this.schemaView = view;
        this.directBuild = true;
        if (this.nonKeyComplexList == null) {
            this.nonKeyComplexList = new ArrayList<String>();
        }
    }

    public JPAEdmComplexType(JPAEdmSchemaView view, Attribute<?, ?> complexAttribute) {
        super((JPAEdmBaseView)view);
        this.schemaView = view;
        for (EmbeddableType jpaEmbeddable : this.schemaView.getJPAMetaModel().getEmbeddables()) {
            if (!jpaEmbeddable.getJavaType().getName().equals(complexAttribute.getJavaType().getName())) continue;
            this.nestedComplexType = jpaEmbeddable;
            break;
        }
        this.directBuild = false;
        if (this.nonKeyComplexList == null) {
            this.nonKeyComplexList = new ArrayList<String>();
        }
    }

    public boolean isReferencedInKey(String complexTypeName) {
        return this.nonKeyComplexList.contains(complexTypeName);
    }

    public void setReferencedInKey(String complexTypeName) {
        this.nonKeyComplexList.add(complexTypeName);
    }

    public JPAEdmBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new JPAEdmComplexTypeBuilder();
        }
        return this.builder;
    }

    public ComplexType getEdmComplexType() {
        return this.currentComplexType;
    }

    public ComplexType searchEdmComplexType(String embeddableTypeName) {
        return this.searchMap.get(embeddableTypeName);
    }

    public EmbeddableType<?> getJPAEmbeddableType() {
        return this.currentEmbeddableType;
    }

    public List<ComplexType> getConsistentEdmComplexTypes() {
        return this.consistentComplextTypes;
    }

    public ComplexType searchEdmComplexType(FullQualifiedName type) {
        String name = type.getName();
        return this.searchComplexTypeByName(name);
    }

    private ComplexType searchComplexTypeByName(String name) {
        for (ComplexType complexType : this.consistentComplextTypes) {
            if (complexType == null || complexType.getName() == null || !complexType.getName().equals(name)) continue;
            return complexType;
        }
        return null;
    }

    public void addJPAEdmCompleTypeView(JPAEdmComplexTypeView view) {
        String searchKey = view.getJPAEmbeddableType().getJavaType().getName();
        if (!this.searchMap.containsKey(searchKey)) {
            this.consistentComplextTypes.add(view.getEdmComplexType());
            this.searchMap.put(searchKey, view.getEdmComplexType());
        }
    }

    public void expandEdmComplexType(ComplexType complexType, List<Property> expandedList, String embeddablePropertyName) {
        if (expandedList == null) {
            expandedList = new ArrayList<Property>();
        }
        for (Property property : complexType.getProperties()) {
            try {
                SimpleProperty newSimpleProperty = new SimpleProperty();
                SimpleProperty oldSimpleProperty = (SimpleProperty)property;
                newSimpleProperty.setAnnotationAttributes(oldSimpleProperty.getAnnotationAttributes());
                newSimpleProperty.setAnnotationElements(oldSimpleProperty.getAnnotationElements());
                newSimpleProperty.setCustomizableFeedMappings(oldSimpleProperty.getCustomizableFeedMappings());
                newSimpleProperty.setDocumentation(oldSimpleProperty.getDocumentation());
                newSimpleProperty.setFacets(oldSimpleProperty.getFacets());
                newSimpleProperty.setMimeType(oldSimpleProperty.getMimeType());
                newSimpleProperty.setName(oldSimpleProperty.getName());
                newSimpleProperty.setType(oldSimpleProperty.getType());
                JPAEdmMappingImpl newMapping = new JPAEdmMappingImpl();
                Mapping mapping = oldSimpleProperty.getMapping();
                JPAEdmMapping oldMapping = (JPAEdmMapping)mapping;
                newMapping.setJPAColumnName(oldMapping.getJPAColumnName());
                newMapping.setInternalName(String.valueOf(embeddablePropertyName) + "." + mapping.getInternalName());
                newMapping.setObject(mapping.getObject());
                newMapping.setJPAType(oldMapping.getJPAType());
                newSimpleProperty.setMapping((Mapping)newMapping);
                expandedList.add((Property)newSimpleProperty);
            }
            catch (ClassCastException e) {
                ComplexProperty complexProperty = (ComplexProperty)property;
                String name = String.valueOf(embeddablePropertyName) + "." + complexProperty.getMapping().getInternalName();
                this.expandEdmComplexType(this.searchComplexTypeByName(complexProperty.getName()), expandedList, name);
            }
        }
    }

    private class JPAEdmComplexTypeBuilder
    implements JPAEdmBuilder {
        private JPAEdmComplexTypeBuilder() {
        }

        public void build() throws ODataJPAModelException, ODataJPARuntimeException {
            Set embeddables = new HashSet<EmbeddableType>();
            if (JPAEdmComplexType.this.consistentComplextTypes == null) {
                JPAEdmComplexType.this.consistentComplextTypes = new ArrayList();
            }
            if (JPAEdmComplexType.this.searchMap == null) {
                JPAEdmComplexType.this.searchMap = new HashMap();
            }
            if (JPAEdmComplexType.this.directBuild) {
                embeddables = JPAEdmComplexType.this.schemaView.getJPAMetaModel().getEmbeddables();
            } else {
                embeddables.add(JPAEdmComplexType.this.nestedComplexType);
            }
            for (EmbeddableType embeddableType : embeddables) {
                JPAEdmComplexType.this.currentEmbeddableType = embeddableType;
                String searchKey = embeddableType.getJavaType().getName();
                if (JPAEdmComplexType.this.searchMap.containsKey(searchKey) || this.isExcluded(JPAEdmComplexType.this)) continue;
                JPAEdmProperty propertyView = new JPAEdmProperty(JPAEdmComplexType.this.schemaView, JPAEdmComplexType.this);
                propertyView.getBuilder().build();
                JPAEdmComplexType.this.currentComplexType = new ComplexType();
                JPAEdmComplexType.this.currentComplexType.setProperties(propertyView.getEdmPropertyList());
                JPAEdmNameBuilder.build(JPAEdmComplexType.this);
                JPAEdmComplexType.this.searchMap.put(searchKey, JPAEdmComplexType.this.currentComplexType);
                JPAEdmComplexType.this.consistentComplextTypes.add(JPAEdmComplexType.this.currentComplexType);
            }
        }

        private boolean isExcluded(JPAEdmComplexType jpaEdmComplexType) {
            JPAEdmMappingModelAccess mappingModelAccess = jpaEdmComplexType.getJPAEdmMappingModelAccess();
            return mappingModelAccess != null && mappingModelAccess.isMappingModelExists() && mappingModelAccess.checkExclusionOfJPAEmbeddableType(jpaEdmComplexType.getJPAEmbeddableType().getJavaType().getSimpleName());
        }
    }
}

