/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.access.data;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.info.DeleteUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityUriInfo;
import org.apache.olingo.odata2.api.uri.info.PutMergePatchUriInfo;
import org.apache.olingo.odata2.core.uri.UriInfoImpl;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAQueryExtensionEntityListener;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPATombstoneEntityListener;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContext;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextType;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextView;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLStatement;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmMapping;
import org.apache.olingo.odata2.jpa.processor.core.ODataParameterizedWhereExpressionUtil;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmMappingImpl;

public class JPAQueryBuilder {
    private EntityManager em = null;
    private int pageSize = 0;
    private ODataJPAContext odataJPAContext;
    private boolean ignoreListener = false;
    private static final Pattern NORMALIZATION_NEEDED_PATTERN = Pattern.compile(".*[\\s(](\\S+\\.\\S+\\.\\S+).*");
    private static final Pattern VALUE_NORM_PATTERN = Pattern.compile("(?:^|\\s|\\()'(([^']*)')");
    private static final Pattern JOIN_ALIAS_PATTERN = Pattern.compile(".*\\sJOIN\\s(\\S*\\s\\S*).*");

    public JPAQueryBuilder(ODataJPAContext odataJPAContext) {
        this.em = odataJPAContext.getEntityManager();
        this.pageSize = odataJPAContext.getPageSize();
        this.odataJPAContext = odataJPAContext;
    }

    public JPAQueryBuilder ignoreListenner(boolean ignoreListenner) {
        this.ignoreListener = ignoreListenner;
        return this;
    }

    public JPAQueryInfo build(GetEntitySetUriInfo uriInfo) throws ODataJPARuntimeException {
        JPAQueryInfo queryInfo = new JPAQueryInfo();
        Query query = null;
        try {
            ODataJPAQueryExtensionEntityListener listener = this.getODataJPAQueryEntityListener((UriInfo)uriInfo);
            if (listener != null && !this.ignoreListener) {
                EdmEntitySet oDataEntitySet = uriInfo.getTargetEntitySet();
                EdmEntityType oDataEntityType = oDataEntitySet.getEntityType();
                listener.execEvent((UriInfo)((UriInfoImpl)uriInfo), oDataEntityType, "onAuthorize", null);
                query = listener.getQuery(uriInfo, this.em);
            }
            if (query == null) {
                query = this.buildQuery((UriInfo)uriInfo, UriInfoType.GetEntitySet);
            } else {
                queryInfo.setTombstoneQuery(true);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        queryInfo.setQuery(query);
        return queryInfo;
    }

    public Query build(GetEntityUriInfo uriInfo) throws ODataJPARuntimeException {
        return this.build(uriInfo, true);
    }

    public Query build(GetEntityUriInfo uriInfo, boolean authorize) throws ODataJPARuntimeException {
        Query query = null;
        try {
            ODataJPAQueryExtensionEntityListener listener = this.getODataJPAQueryEntityListener((UriInfo)uriInfo);
            if (listener != null && !this.ignoreListener) {
                if (authorize) {
                    EdmEntitySet oDataEntitySet = uriInfo.getTargetEntitySet();
                    EdmEntityType oDataEntityType = oDataEntitySet.getEntityType();
                    listener.execEvent((UriInfo)((UriInfoImpl)uriInfo), oDataEntityType, "onAuthorize", null);
                }
                query = listener.getQuery(uriInfo, this.em);
            }
            if (query == null) {
                query = this.buildQuery((UriInfo)uriInfo, UriInfoType.GetEntity);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return query;
    }

    public Query build(GetEntitySetCountUriInfo uriInfo, boolean authorize) throws ODataJPARuntimeException {
        Query query = null;
        try {
            ODataJPAQueryExtensionEntityListener listener = this.getODataJPAQueryEntityListener((UriInfo)uriInfo);
            if (listener != null && !this.ignoreListener) {
                if (authorize) {
                    EdmEntitySet oDataEntitySet = uriInfo.getTargetEntitySet();
                    EdmEntityType oDataEntityType = oDataEntitySet.getEntityType();
                    listener.execEvent((UriInfo)((UriInfoImpl)uriInfo), oDataEntityType, "onAuthorize", null);
                }
                query = listener.getQuery(uriInfo, this.em);
            }
            if (query == null) {
                query = this.buildQuery((UriInfo)uriInfo, UriInfoType.GetEntitySetCount);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return query;
    }

    public Query build(GetEntityCountUriInfo uriInfo) throws ODataJPARuntimeException {
        Query query = null;
        try {
            ODataJPAQueryExtensionEntityListener listener = this.getODataJPAQueryEntityListener((UriInfo)uriInfo);
            if (listener != null && !this.ignoreListener) {
                EdmEntitySet oDataEntitySet = uriInfo.getTargetEntitySet();
                EdmEntityType oDataEntityType = oDataEntitySet.getEntityType();
                listener.execEvent((UriInfo)((UriInfoImpl)uriInfo), oDataEntityType, "onAuthorize", null);
                query = listener.getQuery(uriInfo, this.em);
            }
            if (query == null) {
                query = this.buildQuery((UriInfo)uriInfo, UriInfoType.GetEntityCount);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return query;
    }

    public Query build(DeleteUriInfo uriInfo) throws ODataJPARuntimeException {
        Query query = null;
        try {
            if (uriInfo.getTargetEntitySet().getEntityType().getMapping() != null && !((JPAEdmMappingImpl)uriInfo.getTargetEntitySet().getEntityType().getMapping()).canEdit()) {
                throw new RuntimeException("Entity is Read Only");
            }
            ODataJPAQueryExtensionEntityListener listener = this.getODataJPAQueryEntityListener((UriInfo)uriInfo);
            if (listener != null && !this.ignoreListener) {
                query = listener.getQuery(uriInfo, this.em);
            }
            if (query == null) {
                query = this.buildQuery((UriInfo)uriInfo, UriInfoType.Delete);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return query;
    }

    public Query build(PutMergePatchUriInfo uriInfo) throws ODataJPARuntimeException {
        Query query = null;
        try {
            if (uriInfo.getTargetEntitySet().getEntityType().getMapping() != null && !((JPAEdmMappingImpl)uriInfo.getTargetEntitySet().getEntityType().getMapping()).canEdit()) {
                throw new RuntimeException("Entity is Read Only");
            }
            ODataJPAQueryExtensionEntityListener listener = this.getODataJPAQueryEntityListener((UriInfo)uriInfo);
            if (listener != null && !this.ignoreListener) {
                query = listener.getQuery(uriInfo, this.em);
            }
            if (query == null) {
                query = this.buildQuery((UriInfo)uriInfo, UriInfoType.PutMergePatch);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return query;
    }

    private Query buildQuery(UriInfo uriParserResultView, UriInfoType type) throws EdmException, ODataJPAModelException, ODataJPARuntimeException {
        Map<String, Map<Integer, Object>> parameterizedMap;
        ODataJPAQueryExtensionEntityListener listener = null;
        try {
            listener = this.getODataJPAQueryEntityListener(uriParserResultView);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uriParserResultView.getFilter() != null && listener != null && !this.ignoreListener) {
            listener.checkFilter(uriParserResultView.getTargetEntitySet().getEntityType(), uriParserResultView.getFilter());
        }
        JPQLContextType contextType = this.determineJPQLContextType(uriParserResultView, type);
        JPQLContext jpqlContext = this.buildJPQLContext(contextType, uriParserResultView);
        JPQLStatement jpqlStatement = JPQLStatement.createBuilder((JPQLContextView)jpqlContext).build();
        Query query = this.em.createQuery(jpqlStatement.toString());
        if (listener != null) {
            listener.prepareQuery(query);
        }
        if ((parameterizedMap = ODataParameterizedWhereExpressionUtil.getParameterizedQueryMap()) != null && parameterizedMap.size() > 0) {
            for (Map.Entry<String, Map<Integer, Object>> parameterEntry : parameterizedMap.entrySet()) {
                if (!jpqlStatement.toString().contains(parameterEntry.getKey())) continue;
                Map<Integer, Object> positionalParameters = parameterEntry.getValue();
                for (Map.Entry<Integer, Object> param : positionalParameters.entrySet()) {
                    if (param.getValue() instanceof Calendar || param.getValue() instanceof Timestamp) {
                        query.setParameter(param.getKey().intValue(), (Calendar)param.getValue(), TemporalType.TIMESTAMP);
                        continue;
                    }
                    if (param.getValue() instanceof Time) {
                        query.setParameter(param.getKey().intValue(), (Date)((Time)param.getValue()), TemporalType.TIME);
                        continue;
                    }
                    try {
                        query.setParameter(param.getKey().intValue(), param.getValue());
                    }
                    catch (Exception e) {
                        Class clazz = query.getParameter(param.getKey().intValue()).getParameterType();
                        if (clazz != null) {
                            query.setParameter(param.getKey().intValue(), listener.convert(param.getValue(), clazz));
                            continue;
                        }
                        throw new RuntimeException(e);
                    }
                }
                parameterizedMap.remove(parameterEntry.getKey());
                ODataParameterizedWhereExpressionUtil.setJPQLStatement(null);
                break;
            }
        }
        return query;
    }

    public ODataJPAQueryExtensionEntityListener getODataJPAQueryEntityListener(UriInfo uriInfo) throws EdmException, InstantiationException, IllegalAccessException {
        ODataJPATombstoneEntityListener listener = this.getODataJPATombstoneEntityListener(uriInfo);
        if (listener instanceof ODataJPAQueryExtensionEntityListener) {
            ODataJPAQueryExtensionEntityListener queryListener = null;
            queryListener = (ODataJPAQueryExtensionEntityListener)listener;
            return queryListener;
        }
        return this.odataJPAContext.getODataJPAQueryExtensionEntityListener();
    }

    public ODataJPATombstoneEntityListener getODataJPATombstoneEntityListener(UriInfo uriParserResultView) throws InstantiationException, IllegalAccessException, EdmException {
        JPAEdmMapping mapping = (JPAEdmMapping)uriParserResultView.getTargetEntitySet().getEntityType().getMapping();
        if (mapping.getODataJPATombstoneEntityListener() != null) {
            return (ODataJPATombstoneEntityListener)mapping.getODataJPATombstoneEntityListener().newInstance();
        }
        return this.odataJPAContext.getODataJPAQueryExtensionEntityListener();
    }

    public JPQLContext buildJPQLContext(JPQLContextType contextType, UriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        if (this.pageSize > 0 && (contextType == JPQLContextType.SELECT || contextType == JPQLContextType.JOIN)) {
            return JPQLContext.createBuilder((JPQLContextType)contextType, (Object)uriParserResultView, (boolean)true).build();
        }
        return JPQLContext.createBuilder((JPQLContextType)contextType, (Object)uriParserResultView).build();
    }

    public JPQLContextType determineJPQLContextType(UriInfo uriParserResultView, UriInfoType type) {
        JPQLContextType contextType = null;
        if (!uriParserResultView.getNavigationSegments().isEmpty()) {
            if (type == UriInfoType.GetEntitySet) {
                contextType = JPQLContextType.JOIN;
            } else if (type == UriInfoType.Delete || type == UriInfoType.GetEntity || type == UriInfoType.PutMergePatch) {
                contextType = JPQLContextType.JOIN_SINGLE;
            } else if (type == UriInfoType.GetEntitySetCount || type == UriInfoType.GetEntityCount) {
                contextType = JPQLContextType.JOIN_COUNT;
            }
        } else if (type == UriInfoType.GetEntitySet) {
            contextType = JPQLContextType.SELECT;
        } else if (type == UriInfoType.Delete || type == UriInfoType.GetEntity || type == UriInfoType.PutMergePatch) {
            contextType = JPQLContextType.SELECT_SINGLE;
        } else if (type == UriInfoType.GetEntitySetCount || type == UriInfoType.GetEntityCount) {
            contextType = JPQLContextType.SELECT_COUNT;
        }
        return contextType;
    }

    private static String normalizeMembers(EntityManager em, String jpqlQuery) {
        String query = JPAQueryBuilder.checkConditionValues(jpqlQuery);
        query = JPAQueryBuilder.removeExtraClause(jpqlQuery);
        Matcher normalizationNeededMatcher = NORMALIZATION_NEEDED_PATTERN.matcher(query);
        if (!normalizationNeededMatcher.find()) {
            return jpqlQuery;
        }
        if (JPAQueryBuilder.containsEmbeddedAttributes(em, jpqlQuery)) {
            return jpqlQuery;
        }
        String normalizedJpqlQuery = jpqlQuery;
        HashMap<String, String> joinAliases = new HashMap<String, String>();
        Matcher joinAliasMatcher = JOIN_ALIAS_PATTERN.matcher(normalizedJpqlQuery);
        if (joinAliasMatcher.find()) {
            int i = 1;
            while (i <= joinAliasMatcher.groupCount()) {
                String[] joinAlias = joinAliasMatcher.group(i).split(String.valueOf(' '));
                joinAliases.put(joinAlias[0], joinAlias[1]);
                ++i;
            }
        }
        boolean normalizationNeeded = true;
        while (normalizationNeeded) {
            String alias;
            String membershipToNormalize = normalizationNeededMatcher.group(1);
            String memberInfo = membershipToNormalize.substring(0, JPAQueryBuilder.ordinalIndexOf(membershipToNormalize, '.', 1));
            if (joinAliases.containsKey(memberInfo)) {
                alias = (String)joinAliases.get(memberInfo);
            } else {
                alias = "R" + (joinAliases.size() + 1);
                int joinInsertPosition = normalizedJpqlQuery.indexOf("WHERE");
                if (joinInsertPosition == -1) {
                    joinInsertPosition = normalizedJpqlQuery.indexOf("ORDER BY");
                }
                normalizedJpqlQuery = String.valueOf(normalizedJpqlQuery.substring(0, joinInsertPosition)) + "JOIN" + ' ' + memberInfo + ' ' + alias + ' ' + normalizedJpqlQuery.substring(joinInsertPosition);
                joinAliases.put(memberInfo, alias);
            }
            normalizedJpqlQuery = normalizedJpqlQuery.replaceAll(String.valueOf(memberInfo) + "\\" + '.', String.valueOf(alias) + '.');
            query = JPAQueryBuilder.checkConditionValues(normalizedJpqlQuery);
            query = JPAQueryBuilder.removeExtraClause(normalizedJpqlQuery);
            normalizationNeededMatcher = NORMALIZATION_NEEDED_PATTERN.matcher(query);
            normalizationNeeded = normalizationNeededMatcher.find();
        }
        return normalizedJpqlQuery.replaceFirst("SELECT ", "SELECT DISTINCT ");
    }

    private static String removeExtraClause(String jpqlQuery) {
        String query = jpqlQuery;
        if (query.contains("ORDER BY")) {
            int index = query.indexOf("ORDER BY");
            query = query.substring(0, index);
        }
        return query;
    }

    private static String checkConditionValues(String jpqlQuery) {
        int i = 0;
        StringBuffer query = new StringBuffer();
        query.append(jpqlQuery);
        Matcher valueMatcher = VALUE_NORM_PATTERN.matcher(query);
        while (valueMatcher.find()) {
            String val = valueMatcher.group();
            int index = query.indexOf(val);
            String var = "[" + ++i + "] ";
            query.replace(index, index + val.length(), var);
            valueMatcher = VALUE_NORM_PATTERN.matcher(query);
        }
        return query.toString();
    }

    private static boolean containsEmbeddedAttributes(EntityManager entityManager, String string) {
        throw new Error("Unresolved compilation problem: \n\tCannot cast from Set<Attribute<? super capture#5-of ?,?>> to Set<Attribute<?,?>>\n");
    }

    private static int ordinalIndexOf(String str, char s, int n) {
        int pos = str.indexOf(s, 0);
        while (n-- > 0 && pos != -1) {
            pos = str.indexOf(s, pos + 1);
        }
        return pos;
    }

    final class JPAQueryInfo {
        private Query query = null;
        private boolean isTombstoneQuery = false;

        JPAQueryInfo() {
        }

        public Query getQuery() {
            return this.query;
        }

        public void setQuery(Query query) {
            this.query = query;
        }

        public boolean isTombstoneQuery() {
            return this.isTombstoneQuery;
        }

        public void setTombstoneQuery(boolean isTombstoneQuery) {
            this.isTombstoneQuery = isTombstoneQuery;
        }
    }

    static enum UriInfoType {
        GetEntitySet,
        GetEntity,
        GetEntitySetCount,
        GetEntityCount,
        PutMergePatch,
        Delete;

    }
}

