/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmLiteral;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.api.edm.provider.SimpleProperty;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataNotImplementedException;
import org.apache.olingo.odata2.api.uri.KeyPredicate;
import org.apache.olingo.odata2.api.uri.expression.BinaryExpression;
import org.apache.olingo.odata2.api.uri.expression.BinaryOperator;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.ExpressionKind;
import org.apache.olingo.odata2.api.uri.expression.FilterExpression;
import org.apache.olingo.odata2.api.uri.expression.LiteralExpression;
import org.apache.olingo.odata2.api.uri.expression.MemberExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodOperator;
import org.apache.olingo.odata2.api.uri.expression.OrderByExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderExpression;
import org.apache.olingo.odata2.api.uri.expression.PropertyExpression;
import org.apache.olingo.odata2.api.uri.expression.SortOrder;
import org.apache.olingo.odata2.api.uri.expression.UnaryExpression;
import org.apache.olingo.odata2.core.edm.EdmNull;
import org.apache.olingo.odata2.core.edm.EdmString;
import org.apache.olingo.odata2.core.edm.provider.EdmSimplePropertyImplProv;
import org.apache.olingo.odata2.core.uri.KeyPredicateImpl;
import org.apache.olingo.odata2.core.uri.expression.FilterParserImpl;
import org.apache.olingo.odata2.core.uri.expression.LiteralExpressionImpl;
import org.apache.olingo.odata2.core.uri.expression.PropertyExpressionImpl;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.core.ODataJPAConfig;
import org.apache.olingo.odata2.jpa.processor.core.ODataParameterizedWhereExpressionUtil;
import org.apache.olingo.odata2.jpa.processor.core.access.model.JPATypeConverter;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmMappingImpl;

public class ODataExpressionParser {
    public static final String EMPTY = "";
    public static final ThreadLocal<Integer> methodFlag = new ThreadLocal();
    public static final Character[] EMPTY_CHARACTER_ARRAY = new Character[0];
    private static ThreadLocal<Integer> index = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 1;
        }
    };
    private static ThreadLocal<Map<Integer, Object>> positionalParameters = new ThreadLocal<Map<Integer, Object>>(){

        @Override
        protected Map<Integer, Object> initialValue() {
            return new HashMap<Integer, Object>();
        }
    };

    public static String parseToJPAWhereExpression(CommonExpression whereExpression, String tableAlias) throws ODataException {
        return ODataExpressionParser.parseToJPAWhereExpression(whereExpression, tableAlias, "?");
    }

    public static String unquote(String str) {
        if (str.length() >= 2 && (str.startsWith("\"") || str.startsWith("'")) && (str.endsWith("\"") || str.endsWith("'"))) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    private static boolean isEdmComplexTypeKind(Class fieldClass) {
        try {
            JPATypeConverter.convertToEdmSimpleType(fieldClass, null);
            return false;
        }
        catch (ODataJPAModelException e) {
            return true;
        }
    }

    private static String parseBinary(BinaryOperator binaryOperator, CommonExpression leftOperand, CommonExpression rightOperand, String tableAlias, String prefix) throws ODataException {
        MethodOperator operator = null;
        if (leftOperand.getKind() == ExpressionKind.METHOD) {
            operator = ((MethodExpression)leftOperand).getMethod();
        }
        if (operator != null && (binaryOperator == BinaryOperator.EQ || binaryOperator == BinaryOperator.NE) && operator == MethodOperator.SUBSTRINGOF) {
            methodFlag.set(1);
        }
        String left = ODataExpressionParser.parseToJPAWhereExpression(leftOperand, tableAlias, prefix);
        index.set(index.get() + 1);
        String right = ODataExpressionParser.parseToJPAWhereExpression(rightOperand, tableAlias, prefix);
        if (rightOperand.getEdmType() instanceof EdmNull) {
            try {
                Class<?> clazz = ((JPAEdmMappingImpl)((EdmSimplePropertyImplProv)((PropertyExpressionImpl)leftOperand).getEdmProperty()).getMapping()).getJPAType();
                boolean isComplex = ODataExpressionParser.isEdmComplexTypeKind(clazz);
                if (isComplex) {
                    left = left.substring(0, left.lastIndexOf("."));
                }
            }
            catch (Exception clazz) {
                // empty catch block
            }
        }
        if (operator != null && (operator == MethodOperator.STARTSWITH || operator == MethodOperator.ENDSWITH)) {
            if (!binaryOperator.equals((Object)BinaryOperator.EQ) && !(rightOperand instanceof LiteralExpression) && ("true".equals(right) || "false".equals(right))) {
                ODataExpressionParser.reInitializePositionalParameters();
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.OPERATOR_EQ_NE_MISSING.addContent(new Object[]{binaryOperator.toString()}), null);
            }
            if (binaryOperator.equals((Object)BinaryOperator.EQ)) {
                if ("false".equals(right)) {
                    return String.valueOf('(') + left.replaceFirst("LIKE", "NOT LIKE") + ' ' + ')';
                }
                if ("true".equals(right)) {
                    return String.valueOf('(') + left + ' ' + ')';
                }
            }
        }
        switch (binaryOperator) {
            case AND: {
                return String.valueOf('(') + left + ' ' + "AND" + ' ' + right + ')';
            }
            case OR: {
                return String.valueOf('(') + left + ' ' + "OR" + ' ' + right + ')';
            }
            case EQ: {
                EdmSimpleType type = (EdmSimpleType)leftOperand.getEdmType();
                return String.valueOf('(') + left + ' ' + (!"null".equals(right) ? "=" : "IS") + ' ' + right + ')';
            }
            case NE: {
                return String.valueOf('(') + left + ' ' + (!"null".equals(right) ? "<>" : "IS NOT") + ' ' + right + ')';
            }
            case LT: {
                return String.valueOf('(') + left + ' ' + "<" + ' ' + right + ')';
            }
            case LE: {
                return String.valueOf('(') + left + ' ' + "<=" + ' ' + right + ')';
            }
            case GT: {
                return String.valueOf('(') + left + ' ' + ">" + ' ' + right + ')';
            }
            case GE: {
                return String.valueOf('(') + left + ' ' + ">=" + ' ' + right + ')';
            }
            case PROPERTY_ACCESS: {
                ODataExpressionParser.reInitializePositionalParameters();
                throw new ODataNotImplementedException();
            }
        }
        ODataExpressionParser.reInitializePositionalParameters();
        throw new ODataNotImplementedException();
    }

    public static String parseToJPAWhereExpression(CommonExpression whereExpression, String tableAlias, String prefix) throws ODataException {
        switch (whereExpression.getKind()) {
            case UNARY: {
                UnaryExpression unaryExpression = (UnaryExpression)whereExpression;
                String operand = ODataExpressionParser.parseToJPAWhereExpression(unaryExpression.getOperand(), tableAlias, prefix);
                switch (unaryExpression.getOperator()) {
                    case NOT: {
                        return "NOT(" + operand + ')';
                    }
                    case MINUS: {
                        if (operand.startsWith("-")) {
                            return operand.substring(1);
                        }
                        return "-" + operand;
                    }
                }
                ODataExpressionParser.reInitializePositionalParameters();
                throw new ODataNotImplementedException();
            }
            case FILTER: {
                return ODataExpressionParser.parseToJPAWhereExpression(((FilterExpression)whereExpression).getExpression(), tableAlias, prefix);
            }
            case BINARY: {
                EdmSimplePropertyImplProv edmProp;
                BinaryExpression binaryExpression = (BinaryExpression)whereExpression;
                if (binaryExpression.getLeftOperand() instanceof PropertyExpressionImpl && (edmProp = (EdmSimplePropertyImplProv)((PropertyExpressionImpl)binaryExpression.getLeftOperand()).getEdmProperty()).getComposite() != null) {
                    FilterParserImpl filterParser = new FilterParserImpl(null);
                    String expression = "(";
                    String[] values = ODataExpressionParser.unquote(binaryExpression.getRightOperand().getUriLiteral()).split(ODataJPAConfig.COMPOSITE_SEPARATOR);
                    int i = 0;
                    for (EdmProperty p : edmProp.getComposite()) {
                        PropertyExpressionImpl left;
                        if (expression.length() > 1) {
                            expression = String.valueOf(expression) + " AND ";
                        }
                        if (i < values.length) {
                            values[i] = p.getType() instanceof EdmString && values[i] != null && values[i].length() > 1 && !values[i].startsWith("'") && !values[i].endsWith("'") ? "'" + values[i] + "'" : values[i].replace("''", "'");
                            left = new PropertyExpressionImpl(values[i], null);
                            left.setEdmProperty((EdmTyped)p);
                            left.setEdmType(p.getType());
                            String literalStr = values[i];
                            CommonExpression literal = null;
                            if (!"null".equals(values[i])) {
                                literal = filterParser.parseFilterString(literalStr).getExpression();
                            }
                            if (literal == null) {
                                literal = filterParser.parseFilterString("null").getExpression();
                            }
                            expression = String.valueOf(expression) + ODataExpressionParser.parseBinary(binaryExpression.getOperator(), (CommonExpression)left, literal, tableAlias, prefix);
                        } else {
                            left = new PropertyExpressionImpl(p.getName(), null);
                            left.setEdmProperty((EdmTyped)p);
                            left.setEdmType(p.getType());
                            expression = String.valueOf(expression) + ODataExpressionParser.parseBinary(binaryExpression.getOperator(), (CommonExpression)left, (CommonExpression)((LiteralExpressionImpl)filterParser.parseFilterString("null").getExpression()), tableAlias, prefix);
                        }
                        ++i;
                    }
                    expression = String.valueOf(expression) + ")";
                    return expression;
                }
                return ODataExpressionParser.parseBinary(binaryExpression.getOperator(), binaryExpression.getLeftOperand(), binaryExpression.getRightOperand(), tableAlias, prefix);
            }
            case PROPERTY: {
                String returnStr = ODataExpressionParser.getPropertyName(whereExpression);
                if (tableAlias != null) {
                    returnStr = String.valueOf(tableAlias) + '.' + returnStr;
                }
                return returnStr;
            }
            case MEMBER: {
                String memberExpStr = EMPTY;
                int i = 0;
                MemberExpression member = null;
                CommonExpression tempExp = whereExpression;
                while (tempExp != null && tempExp.getKind() == ExpressionKind.MEMBER) {
                    member = (MemberExpression)tempExp;
                    if (i > 0) {
                        memberExpStr = String.valueOf('.') + memberExpStr;
                    }
                    ++i;
                    memberExpStr = String.valueOf(ODataExpressionParser.getPropertyName(member.getProperty())) + memberExpStr;
                    tempExp = member.getPath();
                }
                memberExpStr = String.valueOf(ODataExpressionParser.getPropertyName(tempExp)) + '.' + memberExpStr;
                return String.valueOf(tableAlias) + '.' + memberExpStr;
            }
            case LITERAL: {
                LiteralExpression literal = (LiteralExpression)whereExpression;
                EdmSimpleType literalType = (EdmSimpleType)literal.getEdmType();
                EdmLiteral uriLiteral = EdmSimpleTypeKind.parseUriLiteral((String)literal.getUriLiteral());
                return ODataExpressionParser.evaluateComparingExpression(uriLiteral.getLiteral(), literalType, null, prefix);
            }
            case METHOD: {
                MethodExpression methodExpression = (MethodExpression)whereExpression;
                String first = ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)methodExpression.getParameters().get(0), tableAlias, prefix);
                index.set(index.get() + 1);
                String second = methodExpression.getParameterCount() > 1 ? ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)methodExpression.getParameters().get(1), tableAlias, prefix) : null;
                index.set(index.get() + 1);
                String third = methodExpression.getParameterCount() > 2 ? ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)methodExpression.getParameters().get(2), tableAlias, prefix) : null;
                switch (methodExpression.getMethod()) {
                    case SUBSTRING: {
                        third = third != null ? ", " + third : EMPTY;
                        return String.format("SUBSTRING(%s, %s + 1 %s)", first, second, third);
                    }
                    case SUBSTRINGOF: {
                        return String.format("(%s LIKE CONCAT('%%',CONCAT(%s,'%%')) ESCAPE '\\')", second, first);
                    }
                    case TOLOWER: {
                        SimpleProperty property = ((EdmSimplePropertyImplProv)((PropertyExpressionImpl)methodExpression.getParameters().get(0)).getEdmProperty()).getProperty();
                        if ("TEXT".equals(property.getColumnDefinition())) {
                            return String.format("%s", first);
                        }
                        return String.format("LOWER(%s)", first);
                    }
                    case STARTSWITH: {
                        return String.format("%s LIKE CONCAT(%s,'%%') ESCAPE '\\'", first, second);
                    }
                    case ENDSWITH: {
                        return String.format("%s LIKE CONCAT('%%',%s) ESCAPE '\\'", first, second);
                    }
                    case YEAR: {
                        return String.format("EXTRACT(YEAR %s)", first);
                    }
                    case DAY: {
                        return String.format("EXTRACT(DAY %s)", first);
                    }
                    case MONTH: {
                        return String.format("EXTRACT(MONTH %s)", first);
                    }
                    case HOUR: {
                        return String.format("EXTRACT(HOUR %s)", first);
                    }
                    case MINUTE: {
                        return String.format("EXTRACT(MINUTE %s)", first);
                    }
                    case SECOND: {
                        return String.format("EXTRACT(SECOND %s)", first);
                    }
                }
                ODataExpressionParser.reInitializePositionalParameters();
                throw new ODataNotImplementedException();
            }
        }
        throw new ODataNotImplementedException();
    }

    public static Map<Integer, Object> getPositionalParameters() {
        return positionalParameters.get();
    }

    public static void reInitializePositionalParameters() {
        index.set(1);
        positionalParameters.set(new HashMap());
    }

    public static Byte[] toByteArray(String uriLiteral) {
        int length = uriLiteral.length();
        if (length == 0) {
            return new Byte[0];
        }
        byte[] byteValues = uriLiteral.getBytes();
        Byte[] result = new Byte[length];
        int i = 0;
        while (i < length) {
            result[i] = new Byte(byteValues[i]);
            ++i;
        }
        return result;
    }

    private static String updateValueIfWildcards(String value) {
        if (value != null) {
            value = value.replace("\\", "\\\\");
            value = value.replace("%", "\\%");
            value = value.replace("_", "\\_");
        }
        return value;
    }

    public static String parseToJPASelectExpression(String tableAlias, ArrayList<String> selectedFields) {
        if (selectedFields == null || selectedFields.isEmpty()) {
            return tableAlias;
        }
        String selectClause = EMPTY;
        Iterator<String> itr = selectedFields.iterator();
        int count = 0;
        while (itr.hasNext()) {
            selectClause = String.valueOf(selectClause) + tableAlias + '.' + itr.next();
            if (++count >= selectedFields.size()) continue;
            selectClause = String.valueOf(selectClause) + ',' + ' ';
        }
        return selectClause;
    }

    public static String parseToJPAOrderByExpression(OrderByExpression orderByExpression, String tableAlias) throws ODataJPARuntimeException {
        return ODataExpressionParser.parseToJPAOrderByExpression(orderByExpression, tableAlias, "?");
    }

    public static String parseToJPAOrderByExpression(OrderByExpression orderByExpression, String tableAlias, String prefix) throws ODataJPARuntimeException {
        String jpqlOrderByExpression = EMPTY;
        if (orderByExpression != null && orderByExpression.getOrders() != null) {
            List orderBys = orderByExpression.getOrders();
            String orderByField = null;
            String orderByDirection = null;
            for (OrderExpression orderBy : orderBys) {
                try {
                    orderByField = orderBy.getExpression().getKind() == ExpressionKind.MEMBER ? ODataExpressionParser.parseToJPAWhereExpression(orderBy.getExpression(), tableAlias, prefix) : (tableAlias != null ? String.valueOf(tableAlias) + '.' + ODataExpressionParser.getPropertyName(orderBy.getExpression()) : ODataExpressionParser.getPropertyName(orderBy.getExpression()));
                    orderByDirection = orderBy.getSortOrder() == SortOrder.asc ? EMPTY : " DESC";
                    jpqlOrderByExpression = String.valueOf(jpqlOrderByExpression) + orderByField + orderByDirection + " , ";
                }
                catch (EdmException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
                catch (ODataException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
            }
        }
        return ODataExpressionParser.normalizeOrderByExpression(jpqlOrderByExpression);
    }

    private static String normalizeOrderByExpression(String jpqlOrderByExpression) {
        if (jpqlOrderByExpression != EMPTY) {
            return jpqlOrderByExpression.substring(0, jpqlOrderByExpression.length() - 3);
        }
        return jpqlOrderByExpression;
    }

    public static String parseKeyPredicates(List<KeyPredicate> keyPredicates, String tableAlias) throws ODataJPARuntimeException {
        return ODataExpressionParser.parseKeyPredicates(keyPredicates, tableAlias, "?");
    }

    public static String parseKeyPredicates(List<KeyPredicate> keyPredicates, String tableAlias, String prefix) throws ODataJPARuntimeException {
        String literal = null;
        String propertyName = null;
        EdmSimpleType edmSimpleType = null;
        Class<?> edmMappedType = null;
        StringBuilder keyFilters = new StringBuilder();
        int i = 0;
        for (KeyPredicate keyPredicate : keyPredicates) {
            if (i > 0) {
                keyFilters.append(" AND ");
            }
            ++i;
            EdmSimplePropertyImplProv edmProp = (EdmSimplePropertyImplProv)keyPredicate.getProperty();
            if (edmProp.getComposite() != null) {
                String[] values = ODataExpressionParser.unquote(keyPredicate.getLiteral()).split(ODataJPAConfig.COMPOSITE_SEPARATOR);
                LinkedList<KeyPredicate> compositeKeyPredicates = new LinkedList<KeyPredicate>();
                int j = 0;
                for (EdmProperty p : edmProp.getComposite()) {
                    KeyPredicateImpl key;
                    if (j < values.length) {
                        try {
                            if (p.getType() instanceof EdmString && values[j] != null && values[j].length() > 1 && !values[j].startsWith("'") && !values[j].endsWith("'")) {
                                values[j] = "'" + values[j].replace("'", "''") + "'";
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        key = new KeyPredicateImpl(values[j], p);
                        compositeKeyPredicates.add((KeyPredicate)key);
                    } else {
                        key = new KeyPredicateImpl("null", p);
                        compositeKeyPredicates.add((KeyPredicate)key);
                    }
                    ++j;
                }
                String expression = "(" + ODataExpressionParser.parseKeyPredicates(compositeKeyPredicates, tableAlias, prefix) + ")";
                keyFilters.append(expression);
                continue;
            }
            literal = keyPredicate.getLiteral();
            try {
                propertyName = keyPredicate.getProperty().getMapping().getInternalExpression() != null && tableAlias == null ? keyPredicate.getProperty().getMapping().getInternalExpression() : keyPredicate.getProperty().getMapping().getInternalName();
                edmSimpleType = (EdmSimpleType)keyPredicate.getProperty().getType();
                edmMappedType = ((JPAEdmMappingImpl)keyPredicate.getProperty().getMapping()).getJPAType();
            }
            catch (EdmException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
            literal = ODataExpressionParser.evaluateComparingExpression(literal, edmSimpleType, edmMappedType, prefix);
            if (edmSimpleType == EdmSimpleTypeKind.String.getEdmSimpleTypeInstance()) {
                if (tableAlias != null) {
                    keyFilters.append(String.valueOf(tableAlias) + '.');
                }
                keyFilters.append(String.valueOf(propertyName) + ' ' + "=" + ' ' + literal);
                continue;
            }
            if (tableAlias != null) {
                keyFilters.append(String.valueOf(tableAlias) + '.');
            }
            keyFilters.append(String.valueOf(propertyName) + ' ' + "=" + ' ' + literal);
        }
        if (keyFilters.length() > 0) {
            HashMap<String, Map<Integer, Object>> parameterizedExpressionMap = new HashMap<String, Map<Integer, Object>>();
            parameterizedExpressionMap.put(keyFilters.toString(), ODataExpressionParser.getPositionalParameters());
            ODataParameterizedWhereExpressionUtil.setParameterizedQueryMap(parameterizedExpressionMap);
            return keyFilters.toString();
        }
        return null;
    }

    public static Character[] toCharacterArray(char[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHARACTER_ARRAY;
        }
        Character[] result = new Character[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = new Character(array[i]);
            ++i;
        }
        return result;
    }

    public static String parseKeyPropertiesToJPAOrderByExpression(List<EdmProperty> edmPropertylist, String tableAlias) throws ODataJPARuntimeException {
        String propertyName = null;
        String orderExpression = EMPTY;
        if (edmPropertylist == null) {
            return orderExpression;
        }
        for (EdmProperty edmProperty : edmPropertylist) {
            try {
                EdmMapping mapping = edmProperty.getMapping();
                propertyName = mapping != null && mapping.getInternalName() != null ? mapping.getInternalName() : edmProperty.getName();
            }
            catch (EdmException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
            orderExpression = String.valueOf(orderExpression) + tableAlias + '.' + propertyName + " , ";
        }
        return ODataExpressionParser.normalizeOrderByExpression(orderExpression);
    }

    private static String evaluateComparingExpression(String uriLiteral, EdmSimpleType edmSimpleType, Class<?> edmMappedType, String prefix) throws ODataJPARuntimeException {
        Map<Integer, Object> positionalParameters = ODataExpressionParser.getPositionalParameters();
        int index = ODataExpressionParser.index.get();
        if (EdmSimpleTypeKind.String.getEdmSimpleTypeInstance().isCompatible(edmSimpleType) || EdmSimpleTypeKind.Guid.getEdmSimpleTypeInstance().isCompatible(edmSimpleType)) {
            if (!positionalParameters.containsKey(index)) {
                if (edmMappedType != null) {
                    try {
                        String value = (String)edmSimpleType.valueOfString(uriLiteral, EdmLiteralKind.URI, null, edmSimpleType.getDefaultType());
                        positionalParameters.put(index, value);
                    }
                    catch (EdmSimpleTypeException e) {
                        throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                    }
                } else {
                    positionalParameters.put(index, String.valueOf(uriLiteral));
                }
            }
            uriLiteral = String.valueOf(prefix) + index;
            ODataExpressionParser.index.set(++index);
        } else {
            if (EdmSimpleTypeKind.DateTime.getEdmSimpleTypeInstance().isCompatible(edmSimpleType) || EdmSimpleTypeKind.DateTimeOffset.getEdmSimpleTypeInstance().isCompatible(edmSimpleType)) {
                try {
                    Calendar datetime = (Calendar)edmSimpleType.valueOfString(uriLiteral, EdmLiteralKind.DEFAULT, null, edmSimpleType.getDefaultType());
                    if (!positionalParameters.containsKey(index)) {
                        positionalParameters.put(index, datetime);
                    }
                    uriLiteral = String.valueOf(prefix) + index;
                    ODataExpressionParser.index.set(++index);
                }
                catch (EdmSimpleTypeException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
            }
            if (EdmSimpleTypeKind.Time.getEdmSimpleTypeInstance().isCompatible(edmSimpleType)) {
                try {
                    Calendar time = (Calendar)edmSimpleType.valueOfString(uriLiteral, EdmLiteralKind.DEFAULT, null, edmSimpleType.getDefaultType());
                    String hourValue = String.format("%02d", time.get(11));
                    String minValue = String.format("%02d", time.get(12));
                    String secValue = String.format("%02d", time.get(13));
                    uriLiteral = String.valueOf(hourValue) + ':' + minValue + ':' + secValue;
                    if (!positionalParameters.containsKey(index)) {
                        positionalParameters.put(index, Time.valueOf(uriLiteral));
                    }
                    uriLiteral = String.valueOf(prefix) + index;
                    ODataExpressionParser.index.set(++index);
                }
                catch (EdmSimpleTypeException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
            }
            try {
                uriLiteral = ODataExpressionParser.evaluateExpressionForNumbers(uriLiteral, edmSimpleType, edmMappedType, prefix);
            }
            catch (Exception e) {
                try {
                    Object result = edmSimpleType.valueOfString(uriLiteral, EdmLiteralKind.URI, null, edmSimpleType.getDefaultType());
                    if (!positionalParameters.containsKey(index)) {
                        positionalParameters.put(index, result);
                    }
                    uriLiteral = String.valueOf(prefix) + index;
                    ODataExpressionParser.index.set(++index);
                }
                catch (EdmSimpleTypeException ex) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{ex.getMessage()}), (Throwable)ex);
                }
            }
        }
        return uriLiteral;
    }

    private static String evaluateExpressionForNumbers(String uriLiteral, EdmSimpleType edmSimpleType, Class<?> edmMappedType, String prefix) {
        Map<Integer, Object> positionalParameters = ODataExpressionParser.getPositionalParameters();
        int index = ODataExpressionParser.index.get();
        Class type = edmMappedType == null ? edmSimpleType.getDefaultType() : edmMappedType;
        int size = positionalParameters.size();
        if (Long.class.equals((Object)type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, Long.valueOf(uriLiteral));
            }
        } else if (Double.class.equals((Object)type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, Double.valueOf(uriLiteral));
            }
        } else if (Integer.class.equals((Object)type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, Integer.valueOf(uriLiteral));
            }
        } else if (Byte.class.equals((Object)type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, Byte.valueOf(uriLiteral));
            }
        } else if (Byte[].class.equals((Object)type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, ODataExpressionParser.toByteArray(uriLiteral));
            }
        } else if (Short.class.equals((Object)type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, Short.valueOf(uriLiteral));
            }
        } else if (BigDecimal.class.equals((Object)type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, new BigDecimal(uriLiteral));
            }
        } else if (BigInteger.class.equals((Object)type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, new BigInteger(uriLiteral));
            }
        } else if (Float.class.equals((Object)type) && !positionalParameters.containsKey(index)) {
            positionalParameters.put(index, Float.valueOf(uriLiteral));
        }
        if (size + 1 == positionalParameters.size()) {
            uriLiteral = String.valueOf(prefix) + index;
            ++index;
        }
        ODataExpressionParser.index.set(index);
        return uriLiteral;
    }

    private static void evaluateExpressionForString(String uriLiteral, Class<?> edmMappedType) {
        Map<Integer, Object> positionalParameters = ODataExpressionParser.getPositionalParameters();
        int index = ODataExpressionParser.index.get();
        if (edmMappedType.equals(char[].class)) {
            positionalParameters.put(index, uriLiteral.toCharArray());
        } else if (edmMappedType.equals(Character.TYPE)) {
            positionalParameters.put(index, Character.valueOf(uriLiteral.charAt(0)));
        } else if (edmMappedType.equals(Character[].class)) {
            char[] charArray = uriLiteral.toCharArray();
            Character[] charObjectArray = ODataExpressionParser.toCharacterArray(charArray);
            positionalParameters.put(index, charObjectArray);
        } else if (edmMappedType.equals(Character.class)) {
            positionalParameters.put(index, Character.valueOf(uriLiteral.charAt(0)));
        } else {
            positionalParameters.put(index, String.valueOf(uriLiteral));
        }
    }

    private static String getPropertyName(CommonExpression whereExpression) throws EdmException, ODataJPARuntimeException {
        EdmMapping mapping;
        EdmTyped edmProperty = ((PropertyExpression)whereExpression).getEdmProperty();
        if (edmProperty instanceof EdmNavigationProperty) {
            EdmNavigationProperty edmNavigationProperty = (EdmNavigationProperty)edmProperty;
            mapping = edmNavigationProperty.getMapping();
        } else if (edmProperty instanceof EdmProperty) {
            EdmProperty property = (EdmProperty)edmProperty;
            mapping = property.getMapping();
        } else {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL, null);
        }
        return mapping != null ? (mapping.getInternalExpression() != null ? mapping.getInternalExpression() : mapping.getInternalName()) : edmProperty.getName();
    }

    public static void clear() {
        positionalParameters.remove();
        index.remove();
        methodFlag.remove();
    }
}

