/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.access.data;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.olingo.odata2.jpa.processor.core.access.data.VirtualClassInterface;

public class ReflectionUtil {
    public static Method getMethod(Object o, String name) throws NoSuchMethodException {
        if (o != null) {
            Method m;
            Class<?> clazz = o instanceof Class ? (Class<?>)o : o.getClass();
            Method[] methodArray = clazz.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                m = methodArray[n2];
                if (m.getName().equalsIgnoreCase(name)) {
                    return m;
                }
                ++n2;
            }
            methodArray = clazz.getDeclaredMethods();
            n = methodArray.length;
            n2 = 0;
            while (n2 < n) {
                m = methodArray[n2];
                if (m.getName().equalsIgnoreCase(name)) {
                    return m;
                }
                ++n2;
            }
        }
        throw new NoSuchMethodException("No such Method");
    }

    public static Field getField(Object o, String name) throws NoSuchFieldException {
        if (o != null) {
            Field f;
            Class<?> clazz = o instanceof Class ? (Class<?>)o : o.getClass();
            Field[] fieldArray = clazz.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                f = fieldArray[n2];
                if (f.getName().equalsIgnoreCase(name)) {
                    return f;
                }
                ++n2;
            }
            fieldArray = clazz.getDeclaredFields();
            n = fieldArray.length;
            n2 = 0;
            while (n2 < n) {
                f = fieldArray[n2];
                if (f.getName().equalsIgnoreCase(name)) {
                    return f;
                }
                ++n2;
            }
        }
        throw new NoSuchFieldException("No such Field");
    }

    public static Object getter(Object o, String name) throws NoSuchFieldException {
        if (o instanceof Map) {
            return ((Map)o).get(name);
        }
        if (o instanceof VirtualClassInterface) {
            return ((VirtualClassInterface)o).get(name);
        }
        try {
            Method method = ReflectionUtil.getMethod(o, "get" + name);
            if (method != null) {
                return method.invoke(o, new Object[0]);
            }
        }
        catch (Exception method) {
            // empty catch block
        }
        try {
            Field field = ReflectionUtil.getField(o, name);
            if (field != null) {
                field.setAccessible(true);
                return field.get(o);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new NoSuchFieldException("No such Field");
    }
}

