/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.jpql;

import java.util.HashMap;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.core.edm.EdmUtil;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContext;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextType;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLSelectContextView;
import org.apache.olingo.odata2.jpa.processor.core.ODataExpressionParser;
import org.apache.olingo.odata2.jpa.processor.core.ODataParameterizedWhereExpressionUtil;

public class JPQLSelectContext
extends JPQLContext
implements JPQLSelectContextView {
    protected String selectExpression;
    protected String orderByCollection;
    protected String whereCondition;
    protected boolean isCountOnly = false;

    public JPQLSelectContext(boolean isCountOnly) {
        this.isCountOnly = isCountOnly;
    }

    protected final void setOrderByCollection(String orderByCollection) {
        this.orderByCollection = orderByCollection;
    }

    protected final void setWhereExpression(String filterExpression) {
        this.whereCondition = filterExpression;
    }

    protected final void setSelectExpression(String selectExpression) {
        this.selectExpression = selectExpression;
    }

    public String getSelectExpression() {
        return this.selectExpression;
    }

    public String getOrderByCollection() {
        return this.orderByCollection;
    }

    public String getWhereExpression() {
        return this.whereCondition;
    }

    public class JPQLSelectContextBuilder
    extends JPQLContext.JPQLContextBuilder {
        protected GetEntitySetUriInfo entitySetView;

        public JPQLContext build() throws ODataJPAModelException, ODataJPARuntimeException {
            if (this.entitySetView != null) {
                try {
                    EdmEntityType entityType;
                    EdmMapping mapping;
                    if (JPQLSelectContext.this.isCountOnly) {
                        JPQLSelectContext.this.setType(JPQLContextType.SELECT_COUNT);
                    } else {
                        JPQLSelectContext.this.setType(JPQLContextType.SELECT);
                    }
                    if (this.withPaging) {
                        JPQLSelectContext.this.isPagingRequested(this.withPaging);
                    }
                    if ((mapping = (entityType = this.entitySetView.getTargetEntitySet().getEntityType()).getMapping()) != null) {
                        JPQLSelectContext.this.setJPAEntityName(mapping.getInternalName());
                    } else {
                        JPQLSelectContext.this.setJPAEntityName(entityType.getName());
                    }
                    JPQLSelectContext.this.setJPAEntityAlias(this.generateJPAEntityAlias());
                    JPQLSelectContext.this.setOrderByCollection(this.generateOrderByFileds());
                    JPQLSelectContext.this.setSelectExpression(this.generateSelectExpression());
                    JPQLSelectContext.this.setWhereExpression(this.generateWhereExpression());
                }
                catch (ODataException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
                }
            }
            return JPQLSelectContext.this;
        }

        protected void setResultsView(Object resultsView) {
            if (resultsView instanceof GetEntitySetUriInfo) {
                this.entitySetView = (GetEntitySetUriInfo)resultsView;
            }
        }

        protected String generateSelectExpression() throws EdmException {
            return JPQLSelectContext.this.getJPAEntityAlias();
        }

        protected String generateOrderByFileds() throws ODataJPARuntimeException, EdmException {
            if (this.entitySetView.getOrderBy() != null) {
                return ODataExpressionParser.parseToJPAOrderByExpression(this.entitySetView.getOrderBy(), JPQLSelectContext.this.getJPAEntityAlias());
            }
            if ((this.entitySetView.getTop() != null || this.entitySetView.getSkip() != null || JPQLSelectContext.this.pagingRequested) && !JPQLSelectContext.this.getType().equals((Object)JPQLContextType.SELECT_COUNT)) {
                return ODataExpressionParser.parseKeyPropertiesToJPAOrderByExpression(EdmUtil.findOriginalKeys((EdmEntityType)this.entitySetView.getTargetEntitySet().getEntityType()), JPQLSelectContext.this.getJPAEntityAlias());
            }
            return null;
        }

        protected String generateWhereExpression() throws ODataException {
            if (this.entitySetView.getFilter() != null) {
                String whereExpression = ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)this.entitySetView.getFilter(), JPQLSelectContext.this.getJPAEntityAlias());
                HashMap<String, Map<Integer, Object>> parameterizedExpressionMap = new HashMap<String, Map<Integer, Object>>();
                parameterizedExpressionMap.put(whereExpression, ODataExpressionParser.getPositionalParameters());
                ODataParameterizedWhereExpressionUtil.setParameterizedQueryMap(parameterizedExpressionMap);
                ODataExpressionParser.reInitializePositionalParameters();
                return whereExpression;
            }
            ODataExpressionParser.reInitializePositionalParameters();
            return null;
        }
    }
}

