/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.jpql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.provider.Mapping;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.uri.NavigationSegment;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAJoinClause;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContext;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextType;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLJoinSelectSingleContextView;
import org.apache.olingo.odata2.jpa.processor.core.ODataExpressionParser;
import org.apache.olingo.odata2.jpa.processor.core.ODataParameterizedWhereExpressionUtil;
import org.apache.olingo.odata2.jpa.processor.core.jpql.JPQLSelectSingleContext;

public class JPQLJoinSelectSingleContext
extends JPQLSelectSingleContext
implements JPQLJoinSelectSingleContextView {
    private List<JPAJoinClause> jpaJoinClauses = null;
    protected String whereCondition;

    protected final void setWhereExpression(String filterExpression) {
        this.whereCondition = filterExpression;
    }

    public String getWhereExpression() {
        return this.whereCondition;
    }

    protected void setJPAJoinClause(List<JPAJoinClause> jpaJoinClauses) {
        this.jpaJoinClauses = jpaJoinClauses;
    }

    public List<JPAJoinClause> getJPAJoinClauses() {
        return this.jpaJoinClauses;
    }

    public class JPQLJoinSelectSingleContextBuilder
    extends JPQLSelectSingleContext.JPQLSelectSingleContextBuilder {
        protected int relationShipAliasCounter = 0;

        protected String generateWhereExpression() throws ODataException {
            if (this.entityView.getFilter() != null) {
                String whereExpression = ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)this.entityView.getFilter(), JPQLJoinSelectSingleContext.this.getJPAEntityAlias());
                HashMap<String, Map<Integer, Object>> parameterizedExpressionMap = new HashMap<String, Map<Integer, Object>>();
                parameterizedExpressionMap.put(whereExpression, ODataExpressionParser.getPositionalParameters());
                ODataParameterizedWhereExpressionUtil.setParameterizedQueryMap(parameterizedExpressionMap);
                ODataExpressionParser.reInitializePositionalParameters();
                return whereExpression;
            }
            ODataExpressionParser.reInitializePositionalParameters();
            return null;
        }

        @Override
        public JPQLContext build() throws ODataJPAModelException, ODataJPARuntimeException {
            try {
                JPQLJoinSelectSingleContext.this.setType(JPQLContextType.JOIN_SINGLE);
                JPQLJoinSelectSingleContext.this.setJPAJoinClause(this.generateJoinClauses());
                if (!JPQLJoinSelectSingleContext.this.jpaJoinClauses.isEmpty()) {
                    JPAJoinClause joinClause = (JPAJoinClause)JPQLJoinSelectSingleContext.this.jpaJoinClauses.get(JPQLJoinSelectSingleContext.this.jpaJoinClauses.size() - 1);
                    JPQLJoinSelectSingleContext.this.setJPAEntityName(joinClause.getEntityName());
                    JPQLJoinSelectSingleContext.this.setJPAEntityAlias(joinClause.getEntityRelationShipAlias());
                }
                JPQLJoinSelectSingleContext.this.setKeyPredicates(this.entityView.getKeyPredicates());
                JPQLJoinSelectSingleContext.this.setSelectExpression(this.generateSelectExpression());
                JPQLJoinSelectSingleContext.this.setWhereExpression(this.generateWhereExpression());
                ODataExpressionParser.reInitializePositionalParameters();
            }
            catch (Exception e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL, (Throwable)e);
            }
            return JPQLJoinSelectSingleContext.this;
        }

        protected List<JPAJoinClause> generateJoinClauses() throws ODataJPARuntimeException, EdmException {
            ArrayList<JPAJoinClause> jpaOuterJoinClauses = new ArrayList<JPAJoinClause>();
            JPAJoinClause jpaOuterJoinClause = null;
            String joinCondition = null;
            String entityAlias = this.generateJPAEntityAlias();
            joinCondition = ODataExpressionParser.parseKeyPredicates(this.entityView.getKeyPredicates(), entityAlias);
            EdmEntityType entityType = this.entityView.getStartEntitySet().getEntityType();
            Mapping mapping = (Mapping)entityType.getMapping();
            String entityTypeName = null;
            entityTypeName = mapping != null ? mapping.getInternalName() : entityType.getName();
            jpaOuterJoinClause = new JPAJoinClause(entityTypeName, entityAlias, null, null, joinCondition, JPAJoinClause.JOIN.INNER);
            jpaOuterJoinClauses.add(jpaOuterJoinClause);
            for (NavigationSegment navigationSegment : this.entityView.getNavigationSegments()) {
                EdmNavigationProperty navigationProperty = navigationSegment.getNavigationProperty();
                String relationShipAlias = this.generateRelationShipAlias();
                joinCondition = ODataExpressionParser.parseKeyPredicates(navigationSegment.getKeyPredicates(), relationShipAlias);
                jpaOuterJoinClause = new JPAJoinClause(this.getFromEntityName(navigationProperty), entityAlias, this.getRelationShipName(navigationProperty), relationShipAlias, joinCondition, JPAJoinClause.JOIN.INNER);
                jpaOuterJoinClauses.add(jpaOuterJoinClause);
            }
            return jpaOuterJoinClauses;
        }

        private String getFromEntityName(EdmNavigationProperty navigationProperty) throws EdmException {
            String fromRole = navigationProperty.getFromRole();
            EdmEntityType fromEntityType = navigationProperty.getRelationship().getEnd(fromRole).getEntityType();
            EdmMapping mapping = fromEntityType.getMapping();
            String entityName = null;
            entityName = mapping != null ? mapping.getInternalName() : fromEntityType.getName();
            return entityName;
        }

        private String getRelationShipName(EdmNavigationProperty navigationProperty) throws EdmException {
            EdmMapping mapping = navigationProperty.getMapping();
            String relationShipName = null;
            relationShipName = mapping != null ? mapping.getInternalName() : navigationProperty.getName();
            return relationShipName;
        }

        private String generateRelationShipAlias() {
            return new String("R" + ++this.relationShipAliasCounter);
        }
    }
}

