/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.model;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.edm.provider.ComplexProperty;
import org.apache.olingo.odata2.api.edm.provider.ComplexType;
import org.apache.olingo.odata2.api.edm.provider.Facets;
import org.apache.olingo.odata2.api.edm.provider.Property;
import org.apache.olingo.odata2.api.edm.provider.SimpleProperty;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAEdmBuilder;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAEdmMappingModelAccess;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmAssociationEndView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmAssociationView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmBaseView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmComplexPropertyView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmComplexTypeView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmEntityTypeView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmKeyView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmMapping;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmNavigationPropertyView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmPropertyView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmReferentialConstraintView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmSchemaView;
import org.apache.olingo.odata2.jpa.processor.core.access.model.JPAEdmNameBuilder;
import org.apache.olingo.odata2.jpa.processor.core.access.model.JPATypeConverter;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmAssociation;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmAssociationEnd;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmBaseViewImpl;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmComplexType;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmFacets;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmKey;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmNavigationProperty;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmReferentialConstraint;

public class JPAEdmProperty
extends JPAEdmBaseViewImpl
implements JPAEdmPropertyView,
JPAEdmComplexPropertyView {
    private JPAEdmSchemaView schemaView;
    private JPAEdmEntityTypeView entityTypeView;
    private JPAEdmComplexTypeView complexTypeView;
    private JPAEdmNavigationPropertyView navigationPropertyView = null;
    private JPAEdmKeyView keyView;
    private List<Property> properties;
    private SimpleProperty currentSimpleProperty = null;
    private ComplexProperty currentComplexProperty = null;
    private Attribute<?, ?> currentAttribute;
    private Attribute<?, ?> currentRefAttribute;
    private boolean isBuildModeComplexType;
    private Map<String, Integer> associationCount;
    private ArrayList<String[]> joinColumnNames = null;

    public JPAEdmProperty(JPAEdmSchemaView view) {
        super((JPAEdmBaseView)view);
        this.schemaView = view;
        this.entityTypeView = this.schemaView.getJPAEdmEntityContainerView().getJPAEdmEntitySetView().getJPAEdmEntityTypeView();
        this.complexTypeView = this.schemaView.getJPAEdmComplexTypeView();
        this.navigationPropertyView = new JPAEdmNavigationProperty(this.schemaView);
        this.isBuildModeComplexType = false;
        this.associationCount = new HashMap<String, Integer>();
    }

    public JPAEdmProperty(JPAEdmSchemaView schemaView, JPAEdmComplexTypeView view) {
        super((JPAEdmBaseView)view);
        this.schemaView = schemaView;
        this.complexTypeView = view;
        this.isBuildModeComplexType = true;
    }

    public JPAEdmBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new JPAEdmPropertyBuilder();
        }
        return this.builder;
    }

    public List<Property> getEdmPropertyList() {
        return this.properties;
    }

    public JPAEdmKeyView getJPAEdmKeyView() {
        return this.keyView;
    }

    public SimpleProperty getEdmSimpleProperty() {
        return this.currentSimpleProperty;
    }

    public Attribute<?, ?> getJPAAttribute() {
        return this.currentAttribute;
    }

    public Attribute<?, ?> getJPAReferencedAttribute() {
        return this.currentRefAttribute;
    }

    public ComplexProperty getEdmComplexProperty() {
        return this.currentComplexProperty;
    }

    public JPAEdmNavigationPropertyView getJPAEdmNavigationPropertyView() {
        return this.navigationPropertyView;
    }

    public List<String[]> getJPAJoinColumns() {
        return this.joinColumnNames;
    }

    private String getReferenceColumnName(AnnotatedElement annotatedElement2, Attribute<?, ?> referencedAttribute) {
        String refColName = null;
        Column c = annotatedElement2.getAnnotation(Column.class);
        if (c != null) {
            refColName = c.name();
        }
        return refColName == null || "".equals(refColName) ? referencedAttribute.getName() : refColName;
    }

    public JPAEdmEntityTypeView getJPAEdmEntityTypeView() {
        return this.entityTypeView;
    }

    public JPAEdmComplexTypeView getJPAEdmComplexTypeView() {
        return this.complexTypeView;
    }

    private boolean isExcluded(JPAEdmPropertyView jpaEdmPropertyView, String jpaEntityTypeName, String jpaAttributeName) {
        JPAEdmMappingModelAccess mappingModelAccess = jpaEdmPropertyView.getJPAEdmMappingModelAccess();
        boolean isExcluded = false;
        if (mappingModelAccess != null && mappingModelAccess.isMappingModelExists() && (this.isBuildModeComplexType && mappingModelAccess.checkExclusionOfJPAEmbeddableAttributeType(jpaEntityTypeName, jpaAttributeName) || !this.isBuildModeComplexType && mappingModelAccess.checkExclusionOfJPAAttributeType(jpaEntityTypeName, jpaAttributeName))) {
            isExcluded = true;
        }
        return isExcluded;
    }

    private class JPAEdmPropertyBuilder
    implements JPAEdmBuilder {
        private JPAEdmPropertyBuilder() {
        }

        public void build() throws ODataJPAModelException, ODataJPARuntimeException {
            JPAEdmBuilder keyViewBuilder = null;
            JPAEdmProperty.this.properties = new ArrayList();
            List<Attribute<?, ?>> jpaAttributes = null;
            String currentEntityName = null;
            String targetEntityName = null;
            String entityTypeName = null;
            if (JPAEdmProperty.this.isBuildModeComplexType) {
                jpaAttributes = this.sortInAscendingOrder(JPAEdmProperty.this.complexTypeView.getJPAEmbeddableType().getAttributes(), JPAEdmProperty.this.complexTypeView.getJPAEmbeddableType().getJavaType());
                entityTypeName = JPAEdmProperty.this.complexTypeView.getJPAEmbeddableType().getJavaType().getSimpleName();
            } else {
                jpaAttributes = this.sortInAscendingOrder(JPAEdmProperty.this.entityTypeView.getJPAEntityType().getAttributes(), JPAEdmProperty.this.entityTypeView.getJPAEntityType().getJavaType());
                entityTypeName = JPAEdmProperty.this.entityTypeView.getJPAEntityType().getName();
            }
            for (Attribute<?, ?> jpaAttribute : jpaAttributes) {
                JPAEdmProperty.this.currentAttribute = jpaAttribute;
                if (JPAEdmProperty.this.isExcluded(JPAEdmProperty.this, entityTypeName, JPAEdmProperty.this.currentAttribute.getName())) continue;
                Attribute.PersistentAttributeType attributeType = JPAEdmProperty.this.currentAttribute.getPersistentAttributeType();
                switch (attributeType) {
                    case BASIC: {
                        JPAEdmProperty.this.currentSimpleProperty = new SimpleProperty();
                        JPAEdmProperty.this.properties.add(this.buildSimpleProperty(JPAEdmProperty.this.currentAttribute, JPAEdmProperty.this.currentSimpleProperty));
                        break;
                    }
                    case EMBEDDED: {
                        ComplexType complexType = JPAEdmProperty.this.complexTypeView.searchEdmComplexType(JPAEdmProperty.this.currentAttribute.getJavaType().getName());
                        if (complexType == null) {
                            JPAEdmComplexType complexTypeViewLocal = new JPAEdmComplexType(JPAEdmProperty.this.schemaView, JPAEdmProperty.this.currentAttribute);
                            complexTypeViewLocal.getBuilder().build();
                            complexType = complexTypeViewLocal.getEdmComplexType();
                            JPAEdmProperty.this.complexTypeView.addJPAEdmCompleTypeView((JPAEdmComplexTypeView)complexTypeViewLocal);
                        }
                        if (!JPAEdmProperty.this.isBuildModeComplexType && JPAEdmProperty.this.entityTypeView.getJPAEntityType().getIdType().getJavaType().equals(JPAEdmProperty.this.currentAttribute.getJavaType())) {
                            if (JPAEdmProperty.this.keyView == null) {
                                JPAEdmProperty.this.keyView = new JPAEdmKey(JPAEdmProperty.this.complexTypeView, JPAEdmProperty.this);
                            }
                            JPAEdmProperty.this.keyView.getBuilder().build();
                            JPAEdmProperty.this.complexTypeView.expandEdmComplexType(complexType, JPAEdmProperty.this.properties, JPAEdmProperty.this.currentAttribute.getName());
                            break;
                        }
                        JPAEdmProperty.this.currentComplexProperty = new ComplexProperty();
                        if (JPAEdmProperty.this.isBuildModeComplexType) {
                            JPAEdmNameBuilder.build(JPAEdmProperty.this, JPAEdmProperty.this.complexTypeView.getJPAEmbeddableType().getJavaType().getSimpleName());
                        } else {
                            JPAEdmNameBuilder.build((JPAEdmComplexPropertyView)JPAEdmProperty.this, JPAEdmProperty.this, JPAEdmProperty.this.skipDefaultNaming);
                        }
                        JPAEdmProperty.this.currentComplexProperty.setType(new FullQualifiedName(JPAEdmProperty.this.schemaView.getEdmSchema().getNamespace(), complexType.getName()));
                        JPAEdmProperty.this.properties.add(JPAEdmProperty.this.currentComplexProperty);
                        if (JPAEdmProperty.this.complexTypeView.isReferencedInKey(JPAEdmProperty.this.currentComplexProperty.getType().getName())) break;
                        JPAEdmProperty.this.complexTypeView.setReferencedInKey(JPAEdmProperty.this.currentComplexProperty.getType().getName());
                        break;
                    }
                    case MANY_TO_MANY: 
                    case ONE_TO_MANY: 
                    case ONE_TO_ONE: 
                    case MANY_TO_ONE: {
                        if (attributeType.equals((Object)Attribute.PersistentAttributeType.MANY_TO_ONE) || attributeType.equals((Object)Attribute.PersistentAttributeType.ONE_TO_ONE)) {
                            this.addForeignKey(JPAEdmProperty.this.currentAttribute);
                        }
                        JPAEdmAssociationEnd associationEndView = new JPAEdmAssociationEnd(JPAEdmProperty.this.entityTypeView, JPAEdmProperty.this);
                        associationEndView.getBuilder().build();
                        JPAEdmAssociationView associationView = JPAEdmProperty.this.schemaView.getJPAEdmAssociationView();
                        if (associationView.searchAssociation((JPAEdmAssociationEndView)associationEndView) == null) {
                            int count = associationView.getNumberOfAssociationsWithSimilarEndPoints((JPAEdmAssociationEndView)associationEndView);
                            JPAEdmAssociation associationViewLocal = new JPAEdmAssociation(associationEndView, JPAEdmProperty.this.entityTypeView, JPAEdmProperty.this, count);
                            associationViewLocal.getBuilder().build();
                            associationView.addJPAEdmAssociationView((JPAEdmAssociationView)associationViewLocal, (JPAEdmAssociationEndView)associationEndView);
                        }
                        if (attributeType.equals((Object)Attribute.PersistentAttributeType.MANY_TO_ONE) || attributeType.equals((Object)Attribute.PersistentAttributeType.ONE_TO_ONE)) {
                            JPAEdmReferentialConstraint refConstraintView = new JPAEdmReferentialConstraint(associationView, JPAEdmProperty.this.entityTypeView, JPAEdmProperty.this);
                            refConstraintView.getBuilder().build();
                            if (refConstraintView.isExists()) {
                                associationView.addJPAEdmRefConstraintView((JPAEdmReferentialConstraintView)refConstraintView);
                            }
                        }
                        if (JPAEdmProperty.this.navigationPropertyView == null) {
                            JPAEdmProperty.this.navigationPropertyView = new JPAEdmNavigationProperty(JPAEdmProperty.this.schemaView);
                        }
                        currentEntityName = JPAEdmProperty.this.entityTypeView.getJPAEntityType().getName();
                        targetEntityName = JPAEdmProperty.this.currentAttribute.isCollection() ? ((PluralAttribute)JPAEdmProperty.this.currentAttribute).getElementType().getJavaType().getSimpleName() : JPAEdmProperty.this.currentAttribute.getJavaType().getSimpleName();
                        Integer sequenceNumber = (Integer)JPAEdmProperty.this.associationCount.get(currentEntityName + targetEntityName);
                        sequenceNumber = sequenceNumber == null ? new Integer(1) : new Integer(sequenceNumber + 1);
                        JPAEdmProperty.this.associationCount.put(currentEntityName + targetEntityName, sequenceNumber);
                        JPAEdmNavigationProperty localNavigationPropertyView = new JPAEdmNavigationProperty(associationView, JPAEdmProperty.this, sequenceNumber);
                        localNavigationPropertyView.getBuilder().build();
                        JPAEdmProperty.this.navigationPropertyView.addJPAEdmNavigationPropertyView((JPAEdmNavigationPropertyView)localNavigationPropertyView);
                        break;
                    }
                }
                if (attributeType != Attribute.PersistentAttributeType.BASIC && attributeType != Attribute.PersistentAttributeType.MANY_TO_MANY && attributeType != Attribute.PersistentAttributeType.ONE_TO_MANY && attributeType != Attribute.PersistentAttributeType.ONE_TO_ONE && attributeType != Attribute.PersistentAttributeType.MANY_TO_ONE || !(JPAEdmProperty.this.currentAttribute instanceof SingularAttribute) || !((SingularAttribute)JPAEdmProperty.this.currentAttribute).isId()) continue;
                if (JPAEdmProperty.this.keyView == null) {
                    JPAEdmProperty.this.keyView = new JPAEdmKey(JPAEdmProperty.this);
                    keyViewBuilder = JPAEdmProperty.this.keyView.getBuilder();
                }
                if (keyViewBuilder == null) continue;
                keyViewBuilder.build();
            }
        }

        private SimpleProperty buildSimpleProperty(Attribute<?, ?> jpaAttribute, SimpleProperty simpleProperty) throws ODataJPAModelException, ODataJPARuntimeException {
            return this.buildSimpleProperty(jpaAttribute, simpleProperty, null);
        }

        private SimpleProperty buildSimpleProperty(Attribute<?, ?> jpaAttribute, SimpleProperty simpleProperty, JoinColumn joinColumn) throws ODataJPAModelException, ODataJPARuntimeException {
            boolean isForeignKey = joinColumn != null;
            JPAEdmNameBuilder.build(JPAEdmProperty.this, JPAEdmProperty.this.isBuildModeComplexType, JPAEdmProperty.this.skipDefaultNaming, isForeignKey);
            EdmSimpleTypeKind simpleTypeKind = JPATypeConverter.convertToEdmSimpleType(jpaAttribute.getJavaType(), jpaAttribute);
            simpleProperty.setType(simpleTypeKind);
            Facets facets = JPAEdmFacets.createAndSet(jpaAttribute, simpleProperty);
            if (isForeignKey) {
                facets.setNullable(Boolean.valueOf(joinColumn.nullable()));
            }
            int total = 0;
            String name = simpleProperty.getName();
            for (Property property : JPAEdmProperty.this.properties) {
                if (!property.getName().equals(name)) continue;
                name = simpleProperty.getName() + "_" + ++total;
            }
            if (total > 0) {
                simpleProperty.setName(name);
            }
            ((JPAEdmMapping)simpleProperty.getMapping()).setOriginalType(jpaAttribute.getJavaType());
            return simpleProperty;
        }

        private void addForeignKey(Attribute<?, ?> jpaAttribute) throws ODataJPAModelException, ODataJPARuntimeException {
            AnnotatedElement annotatedElement = (AnnotatedElement)((Object)jpaAttribute.getJavaMember());
            JPAEdmProperty.this.joinColumnNames = null;
            if (annotatedElement == null) {
                return;
            }
            JoinColumn joinColumn = annotatedElement.getAnnotation(JoinColumn.class);
            if (joinColumn == null) {
                JoinColumns joinColumns = annotatedElement.getAnnotation(JoinColumns.class);
                if (joinColumns != null) {
                    for (JoinColumn jc : joinColumns.value()) {
                        this.buildForeignKey(jc, jpaAttribute);
                    }
                }
            } else {
                this.buildForeignKey(joinColumn, jpaAttribute);
            }
        }

        private void buildForeignKey(JoinColumn joinColumn, Attribute<?, ?> jpaAttribute) throws ODataJPAModelException, ODataJPARuntimeException {
            JPAEdmProperty.this.joinColumnNames = JPAEdmProperty.this.joinColumnNames == null ? new ArrayList() : JPAEdmProperty.this.joinColumnNames;
            String[] name = new String[]{null, null};
            name[0] = "".equals(joinColumn.name()) ? jpaAttribute.getName() : joinColumn.name();
            EntityType referencedEntityType = null;
            referencedEntityType = jpaAttribute.isCollection() ? JPAEdmProperty.this.metaModel.entity(((PluralAttribute)JPAEdmProperty.this.currentAttribute).getElementType().getJavaType()) : JPAEdmProperty.this.metaModel.entity(jpaAttribute.getJavaType());
            if ("".equals(joinColumn.referencedColumnName())) {
                for (Attribute referencedAttribute : referencedEntityType.getAttributes()) {
                    if (referencedAttribute.getPersistentAttributeType() != Attribute.PersistentAttributeType.BASIC || !((SingularAttribute)referencedAttribute).isId()) continue;
                    AnnotatedElement annotatedElement = (AnnotatedElement)((Object)referencedAttribute.getJavaMember());
                    Column referencedColumn = null;
                    if (annotatedElement != null) {
                        referencedColumn = annotatedElement.getAnnotation(Column.class);
                    }
                    name[1] = referencedColumn != null ? referencedColumn.name() : referencedAttribute.getName();
                    JPAEdmProperty.this.joinColumnNames.add(name);
                    JPAEdmProperty.this.currentRefAttribute = referencedAttribute;
                    break;
                }
            } else {
                for (Attribute referencedAttribute : referencedEntityType.getAttributes()) {
                    String refColName;
                    AnnotatedElement annotatedElement2 = (AnnotatedElement)((Object)referencedAttribute.getJavaMember());
                    if (annotatedElement2 == null || !(refColName = JPAEdmProperty.this.getReferenceColumnName(annotatedElement2, referencedAttribute)).equals(joinColumn.referencedColumnName())) continue;
                    name[1] = refColName;
                    JPAEdmProperty.this.joinColumnNames.add(name);
                    JPAEdmProperty.this.currentRefAttribute = referencedAttribute;
                    break;
                }
            }
            if (JPAEdmProperty.this.currentRefAttribute == null) {
                throw ODataJPAModelException.throwException((MessageReference)ODataJPAModelException.REF_ATTRIBUTE_NOT_FOUND.addContent(new Object[]{joinColumn.referencedColumnName() + " -> " + referencedEntityType.getName()}), null);
            }
            JPAEdmProperty.this.currentSimpleProperty = new SimpleProperty();
            JPAEdmProperty.this.properties.add(this.buildSimpleProperty(JPAEdmProperty.this.currentRefAttribute, JPAEdmProperty.this.currentSimpleProperty, joinColumn));
            if (joinColumn.nullable()) {
                JPAEdmProperty.this.currentSimpleProperty.getFacets();
            }
        }

        private Attribute<?, ?> findField(Set<?> jpaAttributes, String name) {
            for (Object o : jpaAttributes) {
                if (!((Attribute)o).getName().equals(name)) continue;
                return (Attribute)o;
            }
            return null;
        }

        private List<Attribute<?, ?>> sortInAscendingOrder(Set<?> jpaAttributes, Class clazz) {
            Field[] fields;
            ArrayList jpaAttributeList = new ArrayList();
            for (Field field : fields = clazz.getDeclaredFields()) {
                Attribute<?, ?> attr = this.findField(jpaAttributes, field.getName());
                if (attr == null) continue;
                jpaAttributeList.add(attr);
            }
            return jpaAttributeList;
        }
    }
}

