/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.access.data;

import com.google.gson.JsonElement;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.olingo.odata2.api.commons.InlineCount;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmStructuralType;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.provider.NavigationProperty;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataBadRequestException;
import org.apache.olingo.odata2.api.uri.NavigationSegment;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.info.DeleteUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityLinkUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetLinksUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetFunctionImportUriInfo;
import org.apache.olingo.odata2.api.uri.info.PostUriInfo;
import org.apache.olingo.odata2.api.uri.info.PutMergePatchUriInfo;
import org.apache.olingo.odata2.core.edm.provider.EdmEntityTypeImplProv;
import org.apache.olingo.odata2.core.uri.KeyPredicateImpl;
import org.apache.olingo.odata2.core.uri.UriInfoImpl;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAQueryExtensionEntityListener;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPATombstoneContext;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPATombstoneEntityListener;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPATransaction;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAFunction;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAMethodContext;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAPaging;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAProcessor;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextType;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmMapping;
import org.apache.olingo.odata2.jpa.processor.core.ODataEntityParser;
import org.apache.olingo.odata2.jpa.processor.core.ODataParameterizedWhereExpressionUtil;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPAEntity;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPAEntityParser;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPALink;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPAPage;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPAQueryBuilder;
import org.apache.olingo.odata2.jpa.processor.core.access.data.VirtualClass;
import org.apache.olingo.odata2.jpa.processor.core.access.data.VirtualClassInterface;
import org.apache.olingo.odata2.jpa.processor.core.access.data.VirtualClassWrapper;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmMappingImpl;

public class JPAProcessorImpl
implements JPAProcessor {
    private static final String DELTATOKEN = "!deltatoken";
    ODataJPAContext oDataJPAContext;
    EntityManager em;

    public JPAProcessorImpl(ODataJPAContext oDataJPAContext) {
        this.oDataJPAContext = oDataJPAContext;
        this.em = oDataJPAContext.getEntityManager();
    }

    public List<Object> process(GetFunctionImportUriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        JPAMethodContext jpaMethodContext = JPAMethodContext.createBuilder((JPQLContextType)JPQLContextType.FUNCTION, (Object)uriParserResultView).build();
        ArrayList<Object> resultObj = null;
        try {
            JPAFunction jpaFunction = (JPAFunction)jpaMethodContext.getJPAFunctionList().get(0);
            Method method = jpaFunction.getFunction();
            Object[] args = jpaFunction.getArguments();
            if (uriParserResultView.getFunctionImport().getReturnType().getMultiplicity().equals((Object)EdmMultiplicity.MANY)) {
                resultObj = (List)method.invoke(jpaMethodContext.getEnclosingObject(), args);
            } else {
                resultObj = new ArrayList();
                Object result = method.invoke(jpaMethodContext.getEnclosingObject(), args);
                resultObj.add(result);
            }
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getTargetException().getMessage()}), (Throwable)e.getTargetException());
        }
        return resultObj;
    }

    public List<Object> process(GetEntitySetUriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        boolean hasNoAllPages;
        if (uriParserResultView.isNew()) {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(this.processNew((UriInfo)uriParserResultView));
            return result;
        }
        List<Object> result = null;
        if (uriParserResultView.getFunctionImport() != null) {
            return this.process((GetFunctionImportUriInfo)uriParserResultView);
        }
        InlineCount inlineCount = uriParserResultView.getInlineCount();
        Integer top = uriParserResultView.getTop() == null ? 1 : uriParserResultView.getTop();
        boolean bl = inlineCount == null ? true : (hasNoAllPages = !inlineCount.equals((Object)InlineCount.ALLPAGES));
        if (top == 0 && hasNoAllPages) {
            return new ArrayList<Object>();
        }
        try {
            JPAEdmMapping mapping = (JPAEdmMapping)uriParserResultView.getTargetEntitySet().getEntityType().getMapping();
            JPAQueryBuilder queryBuilder = new JPAQueryBuilder(this.oDataJPAContext);
            JPAQueryBuilder.JPAQueryInfo queryInfo = queryBuilder.build(uriParserResultView);
            Query query = queryInfo.getQuery();
            this.setPositionalParametersToQuery(query);
            ODataJPATombstoneEntityListener listener = queryBuilder.getODataJPATombstoneEntityListener((UriInfo)uriParserResultView);
            Map customQueryOptions = uriParserResultView.getCustomQueryOptions();
            String deltaToken = null;
            if (customQueryOptions != null) {
                deltaToken = (String)uriParserResultView.getCustomQueryOptions().get(DELTATOKEN);
            }
            if (deltaToken != null) {
                ODataJPATombstoneContext.setDeltaToken(deltaToken);
            }
            if (listener != null && !queryInfo.isTombstoneQuery() && listener.isTombstoneSupported()) {
                query.getResultList();
                List deltaResult = ODataJPATombstoneContext.getDeltaResult((String)((EdmMapping)mapping).getInternalName());
                result = this.handlePaging(deltaResult, uriParserResultView);
            } else {
                result = this.handlePaging(query, uriParserResultView, queryBuilder);
            }
            if (listener != null && listener.isTombstoneSupported()) {
                ODataJPATombstoneContext.setDeltaToken((String)listener.generateDeltaToken(result, query));
            }
            return result == null ? new ArrayList() : result;
        }
        catch (EdmException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void setPositionalParametersToQuery(Query query) {
        Map<String, Map<Integer, Object>> parameterizedMap = ODataParameterizedWhereExpressionUtil.getParameterizedQueryMap();
        if (parameterizedMap != null && parameterizedMap.size() > 0) {
            for (Map.Entry<String, Map<Integer, Object>> parameterEntry : parameterizedMap.entrySet()) {
                if (!ODataParameterizedWhereExpressionUtil.getJPQLStatement().contains(parameterEntry.getKey())) continue;
                Map<Integer, Object> positionalParameters = parameterEntry.getValue();
                for (Map.Entry<Integer, Object> param : positionalParameters.entrySet()) {
                    if (param.getValue() instanceof Calendar || param.getValue() instanceof Timestamp) {
                        query.setParameter(param.getKey().intValue(), (Calendar)param.getValue(), TemporalType.TIMESTAMP);
                        continue;
                    }
                    if (param.getValue() instanceof Time) {
                        query.setParameter(param.getKey().intValue(), (Date)((Time)param.getValue()), TemporalType.TIME);
                        continue;
                    }
                    query.setParameter(param.getKey().intValue(), param.getValue());
                }
                parameterizedMap.remove(parameterEntry.getKey());
                ODataParameterizedWhereExpressionUtil.setJPQLStatement(null);
                break;
            }
        }
    }

    public <T> Object process(GetEntityUriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        if (uriParserResultView.isNew()) {
            return this.processNew((UriInfo)uriParserResultView);
        }
        return this.readEntity(new JPAQueryBuilder(this.oDataJPAContext).build(uriParserResultView), (UriInfo)uriParserResultView);
    }

    public long process(GetEntitySetCountUriInfo resultsView) throws ODataJPAModelException, ODataJPARuntimeException {
        JPAQueryBuilder queryBuilder = new JPAQueryBuilder(this.oDataJPAContext);
        Query query = queryBuilder.build(resultsView);
        this.setPositionalParametersToQuery(query);
        List resultList = query.getResultList();
        if (resultList != null && resultList.size() > 0) {
            try {
                return Long.valueOf(resultList.get(0).toString());
            }
            catch (Exception e) {
                return resultList.size();
            }
        }
        return 0L;
    }

    public long process(GetEntityCountUriInfo resultsView) throws ODataJPAModelException, ODataJPARuntimeException {
        JPAQueryBuilder queryBuilder = new JPAQueryBuilder(this.oDataJPAContext);
        Query query = queryBuilder.build(resultsView);
        this.setPositionalParametersToQuery(query);
        List resultList = query.getResultList();
        if (resultList != null && resultList.size() == 1) {
            return Long.valueOf(resultList.get(0).toString());
        }
        return 0L;
    }

    public Object process(PostUriInfo createView, InputStream content, String requestedContentType) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.processCreate(createView, content, null, requestedContentType);
    }

    public Object process(PostUriInfo createView, Map<String, Object> content) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.processCreate(createView, null, content, null);
    }

    public Object process(PutMergePatchUriInfo updateView, InputStream content, String requestContentType) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.processUpdate(updateView, content, null, requestContentType);
    }

    public Object process(PutMergePatchUriInfo updateView, Map<String, Object> content) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.processUpdate(updateView, null, content, null);
    }

    public Object process(DeleteUriInfo uriParserResultView, String contentType) throws ODataJPAModelException, ODataJPARuntimeException {
        if (uriParserResultView instanceof DeleteUriInfo && ((UriInfo)uriParserResultView).isLinks()) {
            return this.deleteLink(uriParserResultView);
        }
        JPAQueryBuilder queryBuilder = new JPAQueryBuilder(this.oDataJPAContext);
        ODataJPAQueryExtensionEntityListener listener = null;
        try {
            listener = queryBuilder.getODataJPAQueryEntityListener((UriInfo)uriParserResultView);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (listener != null) {
            listener.checkAuthorization(uriParserResultView);
        }
        ((UriInfoImpl)uriParserResultView).setRawEntity(true);
        Object selectedObject = this.readEntity(new JPAQueryBuilder(this.oDataJPAContext).build(uriParserResultView), (UriInfo)uriParserResultView, true);
        if (selectedObject != null) {
            try {
                boolean override;
                EdmEntitySet oDataEntitySet = uriParserResultView.getTargetEntitySet();
                EdmEntityType oDataEntityType = oDataEntitySet.getEntityType();
                boolean isLocalTransaction = this.setTransaction();
                if (listener != null) {
                    listener.execEvent((UriInfo)((UriInfoImpl)uriParserResultView), oDataEntityType, "beforeDelete", selectedObject);
                }
                if (!(override = listener.overrideDelete((UriInfo)uriParserResultView, selectedObject))) {
                    this.em.remove(selectedObject);
                    this.em.flush();
                }
                if (listener != null) {
                    listener.execEvent((UriInfo)((UriInfoImpl)uriParserResultView), oDataEntityType, "afterDelete", selectedObject);
                }
                if (!override && isLocalTransaction) {
                    this.oDataJPAContext.getODataJPATransaction().commit();
                }
            }
            catch (Exception e) {
                this.em.getTransaction().rollback();
                throw new RuntimeException(e);
            }
        }
        return selectedObject;
    }

    public Object process(GetEntityLinkUriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.process((GetEntityUriInfo)uriParserResultView);
    }

    public List<Object> process(GetEntitySetLinksUriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.process((GetEntitySetUriInfo)uriParserResultView);
    }

    public void process(PostUriInfo uriInfo, InputStream content, String requestContentType, String contentType) throws ODataJPARuntimeException, ODataJPAModelException {
        JPALink link = new JPALink(this.oDataJPAContext);
        link.create(uriInfo, content, requestContentType, contentType);
        link.save();
    }

    public void process(PutMergePatchUriInfo putUriInfo, InputStream content, String requestContentType, String contentType) throws ODataJPARuntimeException, ODataJPAModelException {
        JPALink link = new JPALink(this.oDataJPAContext);
        link.update(putUriInfo, content, requestContentType, contentType);
        link.save();
    }

    private Object readEntity(Query query, UriInfo uriInfo) throws ODataJPARuntimeException {
        return this.readEntity(query, uriInfo, false);
    }

    private Object readEntity(Query query, UriInfo uriInfo, boolean rawEntity) throws ODataJPARuntimeException {
        Object selectedObject = null;
        List resultList = query.getResultList();
        if (!rawEntity) {
            resultList = this.normalizeList(resultList, uriInfo);
        }
        if (!resultList.isEmpty()) {
            selectedObject = resultList.get(0);
        }
        return selectedObject;
    }

    private Object processNew(UriInfo newView) throws ODataJPAModelException, ODataJPARuntimeException {
        Object jpaEntity;
        block5: {
            jpaEntity = null;
            try {
                Object newObj;
                EdmEntitySet oDataEntitySet = newView.getTargetEntitySet();
                EdmEntityType oDataEntityType = oDataEntitySet.getEntityType();
                jpaEntity = ((JPAEdmMappingImpl)oDataEntityType.getMapping()).getJPAType().newInstance();
                if (!((JPAEdmMappingImpl)oDataEntityType.getMapping()).isVirtualAccess()) break block5;
                JPAQueryBuilder queryBuilder = new JPAQueryBuilder(this.oDataJPAContext);
                ODataJPAQueryExtensionEntityListener listener = null;
                try {
                    listener = queryBuilder.getODataJPAQueryEntityListener(newView);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (listener != null && (newObj = listener.processNew(newView)) != null) {
                    jpaEntity = newObj;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return jpaEntity;
    }

    private Object processCreate(PostUriInfo createView, InputStream content, Map<String, Object> properties, String requestedContentType) throws ODataJPAModelException, ODataJPARuntimeException {
        try {
            EdmEntitySet oDataEntitySet = createView.getTargetEntitySet();
            EdmEntityType oDataEntityType = oDataEntitySet.getEntityType();
            JPAQueryBuilder queryBuilder = new JPAQueryBuilder(this.oDataJPAContext);
            ODataJPAQueryExtensionEntityListener listener = null;
            try {
                listener = queryBuilder.getODataJPAQueryEntityListener((UriInfo)createView);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (listener != null) {
                listener.checkAuthorization(createView);
            }
            JPAEntity virtualJPAEntity = new JPAEntity(oDataEntityType, oDataEntitySet, this.oDataJPAContext);
            Object jpaEntity = null;
            if (content != null) {
                ODataEntityParser oDataEntityParser = new ODataEntityParser(this.oDataJPAContext);
                ODataEntry oDataEntry = oDataEntityParser.parseEntry((UriInfo)createView, oDataEntitySet, content, requestedContentType, false);
                virtualJPAEntity.create(oDataEntry);
            } else if (properties != null) {
                virtualJPAEntity.create(properties);
            } else {
                return null;
            }
            boolean isLocalTransaction = this.setTransaction();
            Object tempEntity = jpaEntity = virtualJPAEntity.getJPAEntity();
            boolean manymany = false;
            if (createView.getNavigationSegments().size() > 0) {
                UriInfoImpl clone = ((UriInfoImpl)createView).getClone();
                clone.setTargetEntitySet(createView.getStartEntitySet());
                clone.getNavigationSegments().clear();
                clone.setTargetType((EdmType)clone.getTargetEntitySet().getEntityType());
                Object relatedEntity = this.readEntity(new JPAQueryBuilder(this.oDataJPAContext).build((PutMergePatchUriInfo)clone), (UriInfo)clone);
                if (createView.getNavigationSegments().size() == 1) {
                    String property;
                    NavigationProperty navigationProperty = (NavigationProperty)((EdmEntityTypeImplProv)createView.getStartEntitySet().getEntityType()).getNavigationProperties().get(((NavigationSegment)createView.getNavigationSegments().get(0)).getNavigationProperty().getName());
                    if (navigationProperty.getRelationship().getName().toLowerCase().contains("many_many")) {
                        manymany = true;
                    }
                    if (manymany) {
                        JPAEdmMappingImpl mapping = (JPAEdmMappingImpl)navigationProperty.getMapping();
                        property = mapping.getInternalName();
                        try {
                            Field field = relatedEntity.getClass().getDeclaredField(property);
                            field.setAccessible(true);
                            List list = (List)field.get(relatedEntity);
                            list.add(jpaEntity);
                            jpaEntity = relatedEntity;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        property = (String)((NavigationSegment)createView.getNavigationSegments().get(0)).getNavigationProperty().getRelationship().getReferentialConstraint().getDependent().getPropertyRefNames().get(0);
                        try {
                            Field field = jpaEntity.getClass().getDeclaredField(property);
                            field.setAccessible(true);
                            field.set(jpaEntity, relatedEntity);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            if (manymany) {
                if (listener != null) {
                    listener.execEvent((UriInfo)((UriInfoImpl)createView), oDataEntityType, "beforeInsert", jpaEntity);
                }
                this.em.merge(jpaEntity);
            } else {
                Object resultEntity;
                if (listener != null) {
                    listener.execEvent((UriInfo)((UriInfoImpl)createView), oDataEntityType, "beforeInsert", tempEntity);
                }
                if ((resultEntity = listener.overridePost((UriInfo)createView, jpaEntity)) != null) {
                    return resultEntity;
                }
                this.em.persist(jpaEntity);
            }
            if (this.em.contains(jpaEntity)) {
                if (manymany) {
                    jpaEntity = tempEntity;
                }
                EdmEntityType edmEntityType = createView.getEntityContainer().getEntitySet(createView.getTargetEntitySet().getEntityType().getMapping().getInternalName()).getEntityType();
                JPAEntityParser jpaResultParser = new JPAEntityParser(this.oDataJPAContext, (UriInfo)createView);
                ArrayList<KeyPredicateImpl> predicates = new ArrayList<KeyPredicateImpl>();
                ((UriInfoImpl)createView).setKeyPredicates(predicates);
                ((UriInfoImpl)createView).setRawEntity(false);
                this.em.flush();
                this.em.clear();
                HashMap<String, Object> edmPropertyValueMap = jpaResultParser.parse2EdmPropertyValueMap(jpaEntity, (EdmStructuralType)edmEntityType);
                for (EdmProperty key : createView.getTargetEntitySet().getEntityType().getKeyProperties()) {
                    EdmSimpleType type = (EdmSimpleType)key.getType();
                    EdmFacets facets = key.getFacets();
                    Object value = edmPropertyValueMap.get(key.getName());
                    String literal = type.valueToString(value, EdmLiteralKind.DEFAULT, facets);
                    KeyPredicateImpl predicate = new KeyPredicateImpl(literal, key);
                    predicates.add(predicate);
                    createView.getNavigationSegments().clear();
                }
                ((UriInfoImpl)createView).composeWhere(false);
                Object resultEntity = this.readEntity(new JPAQueryBuilder(this.oDataJPAContext).build((GetEntityUriInfo)createView), (UriInfo)createView);
                ((UriInfoImpl)createView).composeWhere(true);
                if (resultEntity == null) {
                    throw new RuntimeException("Entity not found after insert, check your query and default values");
                }
                if (listener != null) {
                    listener.execEvent((UriInfo)((UriInfoImpl)createView), oDataEntityType, "afterInsert", resultEntity);
                }
                if (isLocalTransaction) {
                    this.oDataJPAContext.getODataJPATransaction().commit();
                }
                return resultEntity;
            }
        }
        catch (ODataBadRequestException e) {
            throw new RuntimeException(e);
        }
        catch (EdmException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private <T> Object processUpdate(PutMergePatchUriInfo updateView, InputStream content, Map<String, Object> properties, String requestContentType) throws ODataJPAModelException, ODataJPARuntimeException {
        Object jpaEntity = null;
        try {
            JPAQueryBuilder queryBuilder = new JPAQueryBuilder(this.oDataJPAContext);
            ODataJPAQueryExtensionEntityListener listener = null;
            try {
                listener = queryBuilder.getODataJPAQueryEntityListener((UriInfo)updateView);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (listener != null) {
                listener.checkAuthorization(updateView);
            }
            boolean isLocalTransaction = this.setTransaction();
            ((UriInfoImpl)updateView).setRawEntity(true);
            boolean canOverride = listener.canOverridePut((UriInfo)updateView);
            if (!canOverride) {
                jpaEntity = this.readEntity(queryBuilder.build(updateView), (UriInfo)updateView, true);
                if (jpaEntity == null) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.RESOURCE_NOT_FOUND, null);
                }
            } else {
                jpaEntity = new VirtualClass();
            }
            EdmEntitySet oDataEntitySet = updateView.getTargetEntitySet();
            EdmEntityType oDataEntityType = oDataEntitySet.getEntityType();
            JPAEntity virtualJPAEntity = new JPAEntity(oDataEntityType, oDataEntitySet, this.oDataJPAContext);
            virtualJPAEntity.setJPAEntity(jpaEntity);
            if (content != null) {
                ODataEntityParser oDataEntityParser = new ODataEntityParser(this.oDataJPAContext);
                ODataEntry oDataEntry = oDataEntityParser.parseEntry((UriInfo)updateView, oDataEntitySet, content, requestContentType, false);
                if (!canOverride) {
                    virtualJPAEntity.update(oDataEntry);
                } else {
                    virtualJPAEntity.create(oDataEntry);
                    jpaEntity = virtualJPAEntity.getJPAEntity();
                }
            } else if (properties != null) {
                virtualJPAEntity.update(properties);
            } else {
                return null;
            }
            Object overridePut = null;
            if (listener != null) {
                listener.execEvent((UriInfo)((UriInfoImpl)updateView), oDataEntityType, "beforeUpdate", jpaEntity);
                overridePut = listener.overridePut((UriInfo)updateView, jpaEntity);
            }
            ((UriInfoImpl)updateView).setRawEntity(false);
            if (overridePut != null) {
                jpaEntity = overridePut;
            } else {
                this.em.flush();
                this.em.clear();
                ((UriInfoImpl)updateView).composeWhere(false);
                jpaEntity = this.readEntity(queryBuilder.build(updateView), (UriInfo)updateView);
                ((UriInfoImpl)updateView).composeWhere(true);
                if (listener != null) {
                    listener.execEvent((UriInfo)((UriInfoImpl)updateView), oDataEntityType, "afterUpdate", jpaEntity);
                }
                if (isLocalTransaction) {
                    this.oDataJPAContext.getODataJPATransaction().commit();
                }
            }
        }
        catch (ODataBadRequestException e) {
            throw new RuntimeException(e);
        }
        catch (EdmException e) {
            throw new RuntimeException(e);
        }
        catch (PersistenceException e) {
            this.em.getTransaction().rollback();
            throw new RuntimeException(e);
        }
        return jpaEntity;
    }

    private Object deleteLink(DeleteUriInfo uriParserResultView) throws ODataJPARuntimeException {
        JPALink link = new JPALink(this.oDataJPAContext);
        link.delete(uriParserResultView);
        link.save();
        return link.getTargetJPAEntity();
    }

    private List<Object> handlePaging(List<Object> result, GetEntitySetUriInfo uriParserResultView) {
        if (result == null) {
            return null;
        }
        JPAPage.JPAPageBuilder pageBuilder = new JPAPage.JPAPageBuilder();
        pageBuilder.pageSize(this.oDataJPAContext.getPageSize()).entities(result).skipToken(uriParserResultView.getSkipToken());
        if (uriParserResultView.getSkip() != null) {
            pageBuilder.skip(uriParserResultView.getSkip());
        }
        if (uriParserResultView.getTop() != null) {
            pageBuilder.top(uriParserResultView.getTop());
        }
        JPAPage page = pageBuilder.build();
        this.oDataJPAContext.setPaging((JPAPaging)page);
        return page.getPagedEntities();
    }

    private List<Object> handlePaging(Query query, GetEntitySetUriInfo uriParserResultView, JPAQueryBuilder queryBuilder) {
        JPAPage.JPAPageBuilder pageBuilder = new JPAPage.JPAPageBuilder();
        pageBuilder.pageSize(this.oDataJPAContext.getPageSize()).query(query).skipToken(uriParserResultView.getSkipToken());
        if (uriParserResultView.getSkip() != null) {
            pageBuilder.skip(uriParserResultView.getSkip());
        }
        if (uriParserResultView.getTop() != null) {
            pageBuilder.top(uriParserResultView.getTop());
        }
        JPAPage page = pageBuilder.build();
        this.oDataJPAContext.setPaging((JPAPaging)page);
        List entities = this.normalizeList(page.getPagedEntities(), (UriInfo)uriParserResultView);
        return entities;
    }

    private List normalizeList(List entities, UriInfo uriParserResultView) {
        if (entities != null && uriParserResultView != null && !entities.isEmpty()) {
            try {
                if (((JPAEdmMappingImpl)((EdmEntityTypeImplProv)uriParserResultView.getTargetType()).getMapping()).isVirtualAccess()) {
                    List names = uriParserResultView.getTargetEntitySet().getEntityType().getPropertyNames();
                    ArrayList<VirtualClassInterface> newEntities = new ArrayList<VirtualClassInterface>(entities.size());
                    for (Object e : entities) {
                        VirtualClassInterface entity;
                        if (e instanceof JsonElement) {
                            entity = new VirtualClassWrapper(e);
                        } else if (e instanceof VirtualClassInterface) {
                            entity = (VirtualClassInterface)e;
                        } else {
                            entity = new VirtualClass();
                            if (e.getClass().isArray()) {
                                int i = 0;
                                for (Object o : (Object[])e) {
                                    String key = (String)names.get(i);
                                    entity.set(key, o);
                                    ++i;
                                }
                            } else {
                                String key = (String)names.get(0);
                                entity.set(key, e);
                            }
                        }
                        newEntities.add(entity);
                    }
                    entities = newEntities;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return entities;
    }

    private boolean setTransaction() {
        ODataJPATransaction transaction = this.oDataJPAContext.getODataJPATransaction();
        if (!transaction.isActive()) {
            transaction.begin();
            return true;
        }
        return false;
    }
}

