/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.access.data;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Id;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmStructuralType;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.api.ep.entry.EntryMetadata;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.core.edm.provider.EdmSimplePropertyImplProv;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.OnJPAWriteContent;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmMapping;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPAEntityParser;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPALink;
import org.apache.olingo.odata2.jpa.processor.core.access.data.ReflectionUtil;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmMappingImpl;

public class JPAEntity {
    private Object jpaEntity = null;
    private JPAEntity parentJPAEntity = null;
    private EdmEntityType oDataEntityType = null;
    private EdmEntitySet oDataEntitySet = null;
    private Class<?> jpaType = null;
    private HashMap<String, Method> accessModifiersWrite = null;
    private JPAEntityParser jpaEntityParser = null;
    private ODataJPAContext oDataJPAContext;
    private OnJPAWriteContent onJPAWriteContent = null;
    private List<String> relatedJPAEntityLink = new ArrayList<String>();
    public HashMap<String, List<Object>> relatedJPAEntityMap = null;
    private EdmNavigationProperty viaNavigationProperty;

    public JPAEntity(EdmEntityType oDataEntityType, EdmEntitySet oDataEntitySet, ODataJPAContext context) {
        this.oDataEntityType = oDataEntityType;
        this.oDataEntitySet = oDataEntitySet;
        this.oDataJPAContext = context;
        try {
            JPAEdmMapping mapping = (JPAEdmMapping)oDataEntityType.getMapping();
            this.jpaType = mapping.getJPAType();
        }
        catch (EdmException e) {
            return;
        }
        this.jpaEntityParser = new JPAEntityParser(this.oDataJPAContext, null);
        this.onJPAWriteContent = (OnJPAWriteContent)this.oDataJPAContext.getODataContext().getServiceFactory().getCallback(OnJPAWriteContent.class);
    }

    public void setAccessModifersWrite(HashMap<String, Method> accessModifiersWrite) {
        this.accessModifiersWrite = accessModifiersWrite;
    }

    public void setParentJPAEntity(JPAEntity jpaEntity) {
        this.parentJPAEntity = jpaEntity;
    }

    public JPAEntity getParentJPAEntity() {
        return this.parentJPAEntity;
    }

    public Object getJPAEntity() {
        return this.jpaEntity;
    }

    public void setViaNavigationProperty(EdmNavigationProperty viaNavigationProperty) {
        this.viaNavigationProperty = viaNavigationProperty;
    }

    public EdmNavigationProperty getViaNavigationProperty() {
        return this.viaNavigationProperty;
    }

    public void create(ODataEntry oDataEntry) throws ODataJPARuntimeException {
        if (oDataEntry == null) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL, null);
        }
        try {
            EntryMetadata entryMetadata = oDataEntry.getMetadata();
            Map oDataEntryProperties = oDataEntry.getProperties();
            if (oDataEntry.containsInlineEntry()) {
                this.normalizeInlineEntries(oDataEntryProperties);
            }
            if (oDataEntry.getProperties().size() > 0) {
                this.write(oDataEntryProperties, true);
                for (String navigationPropertyName : this.oDataEntityType.getNavigationPropertyNames()) {
                    EdmNavigationProperty navProperty = (EdmNavigationProperty)this.oDataEntityType.getProperty(navigationPropertyName);
                    if (this.relatedJPAEntityMap != null && this.relatedJPAEntityMap.containsKey(navigationPropertyName)) {
                        oDataEntry.getProperties().get(navigationPropertyName);
                        JPALink.linkJPAEntities(this.oDataJPAContext, (Collection<Object>)this.relatedJPAEntityMap.get(navigationPropertyName), this.jpaEntity, navProperty);
                        continue;
                    }
                    if (this.parentJPAEntity != null && navProperty.getRelationship().equals(this.getViaNavigationProperty().getRelationship())) {
                        ArrayList<Object> targetJPAEntities = new ArrayList<Object>();
                        targetJPAEntities.add(this.parentJPAEntity.getJPAEntity());
                        JPALink.linkJPAEntities(this.oDataJPAContext, targetJPAEntities, this.jpaEntity, navProperty);
                        continue;
                    }
                    if (entryMetadata.getAssociationUris(navigationPropertyName).isEmpty() || this.relatedJPAEntityLink.contains(navigationPropertyName)) continue;
                    this.relatedJPAEntityLink.add(navigationPropertyName);
                }
            }
            if (!this.relatedJPAEntityLink.isEmpty()) {
                JPALink link = new JPALink(this.oDataJPAContext);
                link.setSourceJPAEntity(this.jpaEntity);
                link.create(this.oDataEntitySet, oDataEntry, this.relatedJPAEntityLink);
            }
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (ODataJPAModelException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    public EdmEntitySet getEdmEntitySet() {
        return this.oDataEntitySet;
    }

    public void create(Map<String, Object> oDataEntryProperties) throws ODataJPARuntimeException {
        this.normalizeInlineEntries(oDataEntryProperties);
        this.write(oDataEntryProperties, true);
    }

    public void update(ODataEntry oDataEntry) throws ODataJPARuntimeException {
        if (oDataEntry == null) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL, null);
        }
        Map oDataEntryProperties = oDataEntry.getProperties();
        if (oDataEntry.containsInlineEntry()) {
            this.normalizeInlineEntries(oDataEntryProperties);
        }
        this.write(oDataEntryProperties, false);
        JPALink link = new JPALink(this.oDataJPAContext);
        link.setSourceJPAEntity(this.jpaEntity);
        try {
            link.create(this.oDataEntitySet, oDataEntry, this.oDataEntityType.getNavigationPropertyNames());
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (ODataJPAModelException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    public void update(Map<String, Object> oDataEntryProperties) throws ODataJPARuntimeException {
        this.normalizeInlineEntries(oDataEntryProperties);
        this.write(oDataEntryProperties, false);
    }

    public void setJPAEntity(Object jpaEntity) {
        this.jpaEntity = jpaEntity;
    }

    protected void setComplexProperty(Method accessModifier, Object jpaEntity, EdmStructuralType edmComplexType, HashMap<String, Object> propertyValue) throws EdmException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException, ODataJPARuntimeException, NoSuchMethodException, SecurityException, SQLException {
        this.setComplexProperty(accessModifier, jpaEntity, edmComplexType, propertyValue, null);
    }

    protected void setProperty(Method method, Object entity, Object entityPropertyValue, EdmSimpleType type, boolean isNullable) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ODataJPARuntimeException, EdmException {
        this.setProperty(method, entity, entityPropertyValue, type, null, isNullable);
    }

    protected void setEmbeddableKeyProperty(HashMap<String, String> embeddableKeys, List<EdmProperty> oDataEntryKeyProperties, Map<String, Object> oDataEntryProperties, Object entity) throws ODataJPARuntimeException, EdmException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        HashMap embeddableObjMap = new HashMap();
        ArrayList<EdmProperty> leftODataEntryKeyProperties = new ArrayList<EdmProperty>();
        HashMap<String, String> leftEmbeddableKeys = new HashMap<String, String>();
        for (EdmProperty edmProperty : oDataEntryKeyProperties) {
            String edmPropertyName;
            String embeddableKeyNameComposite;
            if (!oDataEntryProperties.containsKey(edmProperty.getName()) || (embeddableKeyNameComposite = embeddableKeys.get(edmPropertyName = edmProperty.getName())) == null) continue;
            String[] embeddableKeyNameSplit = embeddableKeyNameComposite.split("\\.");
            String methodPartName = null;
            Method method = null;
            Object embeddableObj = null;
            if (!embeddableObjMap.containsKey(embeddableKeyNameSplit[0])) {
                methodPartName = embeddableKeyNameSplit[0];
                method = this.jpaEntityParser.getAccessModifierSet(entity, methodPartName);
                embeddableObj = method.getParameterTypes()[0].newInstance();
                method.invoke(entity, embeddableObj);
                embeddableObjMap.put(embeddableKeyNameSplit[0], embeddableObj);
            } else {
                embeddableObj = embeddableObjMap.get(embeddableKeyNameSplit[0]);
            }
            if (embeddableKeyNameSplit.length == 2) {
                methodPartName = embeddableKeyNameSplit[1];
                method = this.jpaEntityParser.getAccessModifierSet(embeddableObj, methodPartName);
                Object simpleObj = oDataEntryProperties.get(edmProperty.getName());
                method.invoke(embeddableObj, simpleObj);
                continue;
            }
            if (embeddableKeyNameSplit.length <= 2) continue;
            leftODataEntryKeyProperties.add(edmProperty);
            leftEmbeddableKeys.put(edmPropertyName, embeddableKeyNameComposite.split(embeddableKeyNameSplit[0] + ".", 2)[1]);
        }
    }

    protected Object instantiateJPAEntity() throws InstantiationException, IllegalAccessException {
        if (this.jpaType == null) {
            throw new InstantiationException();
        }
        return this.jpaType.newInstance();
    }

    private void normalizeInlineEntries(Map<String, Object> oDataEntryProperties) throws ODataJPARuntimeException {
        ArrayList<ODataEntry> entries = null;
        try {
            for (String navigationPropertyName : this.oDataEntityType.getNavigationPropertyNames()) {
                Object inline = oDataEntryProperties.get(navigationPropertyName);
                if (inline instanceof ODataFeed) {
                    entries = ((ODataFeed)inline).getEntries();
                } else if (inline instanceof ODataEntry) {
                    entries = new ArrayList<ODataEntry>();
                    entries.add((ODataEntry)inline);
                }
                if (entries == null) continue;
                oDataEntryProperties.put(navigationPropertyName, entries);
                entries = null;
            }
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    private void write(Map<String, Object> oDataEntryProperties, boolean isCreate) throws ODataJPARuntimeException {
        try {
            EdmStructuralType structuralType = null;
            List keyNames = this.oDataEntityType.getKeyPropertyNames();
            if (isCreate) {
                this.jpaEntity = this.instantiateJPAEntity();
            } else if (this.jpaEntity == null) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.RESOURCE_NOT_FOUND, null);
            }
            if (this.accessModifiersWrite == null) {
                this.accessModifiersWrite = this.jpaEntityParser.getAccessModifiers(this.jpaEntity, (EdmStructuralType)this.oDataEntityType, "set");
            }
            if (this.oDataEntityType == null || oDataEntryProperties == null) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL, null);
            }
            HashMap<String, String> embeddableKeys = this.jpaEntityParser.getJPAEmbeddableKeyMap(this.jpaEntity.getClass().getName());
            Set<String> propertyNames = null;
            if (embeddableKeys != null) {
                this.setEmbeddableKeyProperty(embeddableKeys, this.oDataEntityType.getKeyProperties(), oDataEntryProperties, this.jpaEntity);
                propertyNames = new HashSet<String>();
                propertyNames.addAll(oDataEntryProperties.keySet());
            } else {
                propertyNames = oDataEntryProperties.keySet();
            }
            boolean isVirtual = false;
            HashMap<String, Object> created = new HashMap<String, Object>();
            block13: for (String propertyName : propertyNames) {
                EdmTyped edmTyped = this.oDataEntityType.getProperty(propertyName);
                isVirtual = edmTyped instanceof EdmProperty ? ((JPAEdmMappingImpl)((EdmProperty)edmTyped).getMapping()).isVirtualAccess() : false;
                Method accessModifier = null;
                switch (edmTyped.getType().getKind()) {
                    case SIMPLE: {
                        boolean isNullable;
                        if (!isCreate && keyNames.contains(edmTyped.getName())) continue block13;
                        accessModifier = this.accessModifiersWrite.get(propertyName);
                        EdmProperty edmProperty = (EdmProperty)this.oDataEntityType.getProperty(propertyName);
                        boolean bl = edmProperty.getFacets() == null ? !keyNames.contains(propertyName) : (isNullable = edmProperty.getFacets().isNullable() == null ? true : edmProperty.getFacets().isNullable());
                        if (isVirtual || accessModifier == null) {
                            try {
                                this.setProperty(accessModifier, this.jpaEntity, oDataEntryProperties.get(propertyName), (EdmSimpleType)edmTyped.getType(), propertyName, isNullable);
                            }
                            catch (Exception e) {
                                try {
                                    this.setProperty(accessModifier, this.jpaEntity, oDataEntryProperties.get(propertyName), (EdmSimpleType)edmTyped.getType(), isNullable);
                                }
                                catch (Exception e3) {
                                    JPAEdmMappingImpl mapping = (JPAEdmMappingImpl)((EdmSimplePropertyImplProv)edmTyped).getMapping();
                                    String expression = mapping.getInternalExpression();
                                    int start = 1;
                                    if (expression == null && accessModifier == null) {
                                        expression = mapping.getInternalName();
                                        start = 0;
                                    }
                                    if (expression == null) continue block13;
                                    try {
                                        Object o;
                                        Object current = o = this.jpaEntity;
                                        Object lastObject = o;
                                        Method lastSet = null;
                                        Method mget = null;
                                        Method mset = null;
                                        String[] parts = expression.split("\\.");
                                        boolean canContinue = true;
                                        if (parts.length > 1) {
                                            Class<?> clazz = this.jpaEntity.getClass();
                                            for (int i = start; i < parts.length; ++i) {
                                                String p = parts[i];
                                                if (i == parts.length - 1) {
                                                    Field f = ReflectionUtil.getField(clazz, p);
                                                    if (f == null) continue;
                                                    canContinue = f.getAnnotation(Id.class) != null;
                                                    continue;
                                                }
                                                mget = ReflectionUtil.getMethod(o, "get" + p);
                                                clazz = mget.getReturnType();
                                                current = mget.invoke(current, new Object[0]);
                                            }
                                        }
                                        if (!canContinue) continue block13;
                                        String path = "";
                                        mset = null;
                                        boolean hasObject = false;
                                        for (int i = start; i < parts.length; ++i) {
                                            String p = parts[i];
                                            if (!path.isEmpty()) {
                                                path = path + ".";
                                            }
                                            path = path + p;
                                            lastSet = mset;
                                            mget = ReflectionUtil.getMethod(o, "get" + p);
                                            mset = ReflectionUtil.getMethod(o, "set" + p);
                                            if (i < parts.length - 1) {
                                                lastObject = o;
                                                Object value = mget.invoke(o, new Object[0]);
                                                if (value == null || value != null && !created.containsKey(path)) {
                                                    value = mget.getReturnType().newInstance();
                                                    mset.invoke(o, value);
                                                    created.put(path, value);
                                                }
                                                o = value;
                                                hasObject = true;
                                            }
                                            if (i != parts.length - 1) continue;
                                            Field f = ReflectionUtil.getField(o, p);
                                            if (oDataEntryProperties.get(propertyName) == null && f.getAnnotation(Id.class) != null && lastSet != null) {
                                                this.setProperty(lastSet, lastObject, null, (EdmSimpleType)edmTyped.getType(), isNullable);
                                                continue;
                                            }
                                            if (hasObject && f.getAnnotation(Id.class) == null) continue;
                                            this.setProperty(mset, o, oDataEntryProperties.get(propertyName), (EdmSimpleType)edmTyped.getType(), isNullable);
                                        }
                                        continue block13;
                                    }
                                    catch (Exception o) {}
                                }
                            }
                            break;
                        }
                        this.setProperty(accessModifier, this.jpaEntity, oDataEntryProperties.get(propertyName), (EdmSimpleType)edmTyped.getType(), isNullable);
                        break;
                    }
                    case COMPLEX: {
                        structuralType = (EdmStructuralType)edmTyped.getType();
                        accessModifier = this.accessModifiersWrite.get(propertyName);
                        if (isVirtual) {
                            this.setComplexProperty(accessModifier, this.jpaEntity, structuralType, (HashMap)oDataEntryProperties.get(propertyName), propertyName);
                            break;
                        }
                        this.setComplexProperty(accessModifier, this.jpaEntity, structuralType, (HashMap)oDataEntryProperties.get(propertyName));
                        break;
                    }
                    case NAVIGATION: 
                    case ENTITY: {
                        if (isCreate) {
                            structuralType = (EdmStructuralType)edmTyped.getType();
                            EdmNavigationProperty navProperty = (EdmNavigationProperty)edmTyped;
                            EdmEntitySet edmRelatedEntitySet = this.oDataEntitySet.getRelatedEntitySet(navProperty);
                            List relatedEntries = (List)oDataEntryProperties.get(propertyName);
                            if (this.relatedJPAEntityMap == null) {
                                this.relatedJPAEntityMap = new HashMap();
                            }
                            ArrayList<Object> relatedJPAEntities = new ArrayList<Object>();
                            for (ODataEntry oDataEntry : relatedEntries) {
                                JPAEntity relatedEntity = new JPAEntity((EdmEntityType)structuralType, edmRelatedEntitySet, this.oDataJPAContext);
                                relatedEntity.setParentJPAEntity(this);
                                relatedEntity.setViaNavigationProperty(navProperty);
                                relatedEntity.create(oDataEntry);
                                if (oDataEntry.getProperties().size() == 0) {
                                    if (oDataEntry.getMetadata().getUri().isEmpty() || this.relatedJPAEntityLink.contains(navProperty.getName())) continue;
                                    this.relatedJPAEntityLink.add(navProperty.getName());
                                    continue;
                                }
                                relatedJPAEntities.add(relatedEntity.getJPAEntity());
                            }
                            if (!relatedJPAEntities.isEmpty()) {
                                this.relatedJPAEntityMap.put(navProperty.getName(), relatedJPAEntities);
                            }
                        }
                    }
                    default: {
                        continue block13;
                    }
                }
            }
        }
        catch (Exception e) {
            if (e instanceof ODataJPARuntimeException) {
                throw (ODataJPARuntimeException)((Object)e);
            }
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    protected void setComplexProperty(Method accessModifier, Object jpaEntity, EdmStructuralType edmComplexType, HashMap<String, Object> propertyValue, String propertyName) throws EdmException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException, ODataJPARuntimeException, NoSuchMethodException, SecurityException, SQLException {
        JPAEdmMapping mapping = (JPAEdmMapping)edmComplexType.getMapping();
        Object embeddableObject = mapping.getJPAType().newInstance();
        if (propertyName != null) {
            accessModifier.invoke(jpaEntity, propertyName, embeddableObject);
        } else {
            accessModifier.invoke(jpaEntity, embeddableObject);
        }
        HashMap<String, Method> accessModifiers = this.jpaEntityParser.getAccessModifiers(embeddableObject, edmComplexType, "set");
        for (String edmPropertyName : edmComplexType.getPropertyNames()) {
            boolean isNullable;
            if (propertyValue == null) continue;
            EdmTyped edmTyped = edmComplexType.getProperty(edmPropertyName);
            accessModifier = accessModifiers.get(edmPropertyName);
            EdmType type = edmTyped.getType();
            if (type.getKind().toString().equals(EdmTypeKind.COMPLEX.toString())) {
                this.setComplexProperty(accessModifier, embeddableObject, (EdmStructuralType)type, (HashMap)propertyValue.get(edmPropertyName), propertyName);
                continue;
            }
            EdmSimpleType simpleType = (EdmSimpleType)type;
            EdmProperty edmProperty = (EdmProperty)edmComplexType.getProperty(edmPropertyName);
            boolean bl = edmProperty.getFacets() == null ? true : (isNullable = edmProperty.getFacets().isNullable() == null ? true : edmProperty.getFacets().isNullable());
            if (propertyName != null) {
                this.setProperty(accessModifier, embeddableObject, propertyValue.get(edmPropertyName), simpleType, isNullable);
                continue;
            }
            this.setProperty(accessModifier, embeddableObject, propertyValue.get(edmPropertyName), simpleType, isNullable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setProperty(Method method, Object entity, Object entityPropertyValue, EdmSimpleType type, String propertyName, boolean isNullable) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ODataJPARuntimeException, EdmException {
        if (method == null) {
            throw new RuntimeException("Null");
        }
        if (entityPropertyValue == null && !isNullable) return;
        if (propertyName != null) {
            if (entityPropertyValue == null) {
                try {
                    method.invoke(entity, propertyName, new Object[]{null});
                    return;
                }
                catch (Exception exception) {}
                return;
            } else {
                method.invoke(entity, propertyName, entityPropertyValue);
            }
            return;
        }
        Class<?> parameterType = method.getParameterTypes()[0];
        if (entityPropertyValue == null) {
            try {
                method.invoke(entity, new Object[]{null});
                return;
            }
            catch (Exception exception) {}
            return;
        } else if (type != null && type.getDefaultType().equals(Short.class) && parameterType.equals(Byte.class)) {
            method.invoke(entity, ((Short)entityPropertyValue).byteValue());
            return;
        } else if (type != null && type.getDefaultType().equals(String.class)) {
            if (parameterType.equals(String.class)) {
                method.invoke(entity, entityPropertyValue);
                return;
            } else if (parameterType.equals(char[].class)) {
                char[] characters = entityPropertyValue != null ? ((String)entityPropertyValue).toCharArray() : null;
                method.invoke(entity, new Object[]{characters});
                return;
            } else if (parameterType.equals(Character.TYPE)) {
                char c = entityPropertyValue != null ? ((String)entityPropertyValue).charAt(0) : (char)'\u0000';
                method.invoke(entity, Character.valueOf(c));
                return;
            } else if (parameterType.equals(Character[].class)) {
                Character[] characters = entityPropertyValue != null ? JPAEntityParser.toCharacterArray((String)entityPropertyValue) : null;
                method.invoke(entity, new Object[]{characters});
                return;
            } else if (parameterType.equals(Character.class)) {
                Character c = entityPropertyValue != null ? Character.valueOf(((String)entityPropertyValue).charAt(0)) : null;
                method.invoke(entity, c);
                return;
            } else if (parameterType.isEnum()) {
                Object e = entityPropertyValue != null ? Enum.valueOf(parameterType, (String)entityPropertyValue) : null;
                method.invoke(entity, e);
                return;
            } else {
                String setterName = method.getName();
                String getterName = setterName.replace("set", "get");
                try {
                    Method getMethod = entity.getClass().getDeclaredMethod(getterName, new Class[0]);
                    if (!getMethod.isAnnotationPresent(XmlJavaTypeAdapter.class)) return;
                    XmlAdapter xmlAdapter = (XmlAdapter)getMethod.getAnnotation(XmlJavaTypeAdapter.class).value().newInstance();
                    method.invoke(entity, xmlAdapter.unmarshal(entityPropertyValue));
                    return;
                }
                catch (Exception e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL, (Throwable)e);
                }
            }
        } else if (parameterType.equals(Blob.class)) {
            if (this.onJPAWriteContent == null) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPA_BLOB_NULL, null);
            }
            method.invoke(entity, entityPropertyValue != null ? this.onJPAWriteContent.getJPABlob((byte[])entityPropertyValue) : null);
            return;
        } else if (parameterType.equals(Clob.class)) {
            if (this.onJPAWriteContent == null) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPA_CLOB_NULL, null);
            }
            method.invoke(entity, entityPropertyValue != null ? this.onJPAWriteContent.getJPAClob(((String)entityPropertyValue).toCharArray()) : null);
            return;
        } else if (parameterType.equals(Timestamp.class)) {
            Timestamp ts = entityPropertyValue != null ? new Timestamp(((Calendar)entityPropertyValue).getTimeInMillis()) : null;
            method.invoke(entity, ts);
            return;
        } else if (parameterType.equals(java.util.Date.class)) {
            java.util.Date d = entityPropertyValue != null ? ((Calendar)entityPropertyValue).getTime() : null;
            method.invoke(entity, d);
            return;
        } else if (parameterType.equals(Date.class)) {
            Date d = entityPropertyValue != null ? new Date(((Calendar)entityPropertyValue).getTimeInMillis()) : null;
            method.invoke(entity, d);
            return;
        } else if (parameterType.equals(Time.class)) {
            Time t = entityPropertyValue != null ? new Time(((Calendar)entityPropertyValue).getTimeInMillis()) : null;
            method.invoke(entity, t);
            return;
        } else {
            method.invoke(entity, entityPropertyValue);
        }
    }
}

