/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.access.data;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.uri.KeyPredicate;
import org.apache.olingo.odata2.api.uri.NavigationSegment;
import org.apache.olingo.odata2.api.uri.PathSegment;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.info.DeleteUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityUriInfo;
import org.apache.olingo.odata2.api.uri.info.PostUriInfo;
import org.apache.olingo.odata2.api.uri.info.PutMergePatchUriInfo;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPATransaction;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAProcessor;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.factory.ODataJPAFactory;
import org.apache.olingo.odata2.jpa.processor.core.ODataEntityParser;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPAEntityParser;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmMappingImpl;

public class JPALink {
    private static final String SPACE = " ";
    private static final String ODATA_COMMAND_FILTER = "$filter";
    private static final String ODATA_OPERATOR_OR = "or";
    private static final String ODATA_OPERATOR_NE = "ne";
    private ODataJPAContext context;
    private JPAProcessor jpaProcessor;
    private ODataEntityParser parser;
    private Object targetJPAEntity;
    private Object sourceJPAEntity;

    public JPALink(ODataJPAContext context) {
        this.context = context;
        this.jpaProcessor = ODataJPAFactory.createFactory().getJPAAccessFactory().getJPAProcessor(this.context);
        this.parser = new ODataEntityParser(this.context);
    }

    public void setSourceJPAEntity(Object jpaEntity) {
        this.sourceJPAEntity = jpaEntity;
    }

    public void setTargetJPAEntity(Object jpaEntity) {
        this.targetJPAEntity = jpaEntity;
    }

    public Object getTargetJPAEntity() {
        return this.targetJPAEntity;
    }

    public Object getSourceJPAEntity() {
        return this.sourceJPAEntity;
    }

    public void create(PostUriInfo uriInfo, InputStream content, String requestContentType, String contentType) throws ODataJPARuntimeException, ODataJPAModelException {
        this.modifyLink((UriInfo)uriInfo, content, requestContentType);
    }

    public void update(PutMergePatchUriInfo putUriInfo, InputStream content, String requestContentType, String contentType) throws ODataJPARuntimeException, ODataJPAModelException {
        this.modifyLink((UriInfo)putUriInfo, content, requestContentType);
    }

    public void delete(DeleteUriInfo uriInfo) throws ODataJPARuntimeException {
        try {
            int index = this.context.getODataContext().getPathInfo().getODataSegments().size() - 2;
            ArrayList<String> linkSegments = new ArrayList<String>();
            String customLinkSegment = ((PathSegment)this.context.getODataContext().getPathInfo().getODataSegments().get(0)).getPath();
            linkSegments.add(customLinkSegment);
            customLinkSegment = ((NavigationSegment)uriInfo.getNavigationSegments().get(0)).getNavigationProperty().getName();
            linkSegments.add(customLinkSegment);
            HashMap<String, String> options = new HashMap<String, String>();
            List keyPredicates = ((NavigationSegment)uriInfo.getNavigationSegments().get(0)).getKeyPredicates();
            StringBuffer condition = new StringBuffer();
            String literal = null;
            KeyPredicate keyPredicate = null;
            int size = keyPredicates.size();
            for (int i = 0; i < size; ++i) {
                keyPredicate = (KeyPredicate)keyPredicates.get(i);
                literal = ((EdmSimpleType)keyPredicate.getProperty().getType()).toUriLiteral(keyPredicate.getLiteral());
                condition.append(keyPredicate.getProperty().getName()).append(SPACE);
                condition.append(ODATA_OPERATOR_NE).append(SPACE);
                condition.append(literal).append(SPACE);
                if (i == size - 1) continue;
                condition.append(ODATA_OPERATOR_OR).append(SPACE);
            }
            if (condition.length() > 0) {
                options.put(ODATA_COMMAND_FILTER, condition.toString());
            }
            UriInfo parsedUriInfo = this.parser.parseLinkSegments(linkSegments, options);
            List relatedEntities = this.jpaProcessor.process((GetEntitySetUriInfo)parsedUriInfo);
            parsedUriInfo = this.parser.parseURISegment(0, index);
            if (parsedUriInfo != null) {
                this.targetJPAEntity = this.jpaProcessor.process((GetEntityUriInfo)parsedUriInfo);
                if (this.targetJPAEntity == null) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.RESOURCE_X_NOT_FOUND.addContent(new Object[]{parsedUriInfo.getTargetEntitySet().getName()}), null);
                }
                NavigationSegment navigationSegment = (NavigationSegment)uriInfo.getNavigationSegments().get(0);
                EdmNavigationProperty navigationProperty = navigationSegment.getNavigationProperty();
                this.delinkJPAEntities(this.targetJPAEntity, relatedEntities, navigationProperty);
            }
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (ODataException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    public void save() {
        EntityManager em = this.context.getEntityManager();
        ODataJPATransaction tx = this.context.getODataJPATransaction();
        boolean isLocalTransaction = false;
        if (!tx.isActive()) {
            tx.begin();
            isLocalTransaction = true;
        }
        if (this.sourceJPAEntity != null) {
            em.persist(this.sourceJPAEntity);
        }
        if (this.targetJPAEntity != null) {
            em.persist(this.targetJPAEntity);
        }
        if (isLocalTransaction && (this.sourceJPAEntity != null && em.contains(this.sourceJPAEntity) || this.targetJPAEntity != null && em.contains(this.targetJPAEntity))) {
            tx.commit();
        }
    }

    public void create(EdmEntitySet entitySet, ODataEntry oDataEntry, List<String> navigationPropertyNames) throws ODataJPARuntimeException, ODataJPAModelException {
        ArrayList<Object> targetJPAEntities = new ArrayList<Object>();
        try {
            for (String navPropertyName : navigationPropertyNames) {
                List<String> links = oDataEntry.getMetadata().getAssociationUris(navPropertyName);
                if (links == null || links.isEmpty()) {
                    links = this.extractLinkURI(oDataEntry, navPropertyName);
                }
                if (links == null || links.isEmpty()) continue;
                EdmNavigationProperty navProperty = (EdmNavigationProperty)entitySet.getEntityType().getProperty(navPropertyName);
                for (String link : links) {
                    UriInfo bindingUriInfo = this.parser.parseBindingLink(link, new HashMap<String, String>());
                    this.targetJPAEntity = this.jpaProcessor.process((GetEntityUriInfo)bindingUriInfo);
                    if (this.targetJPAEntity == null) continue;
                    targetJPAEntities.add(this.targetJPAEntity);
                }
                if (!targetJPAEntities.isEmpty()) {
                    JPALink.linkJPAEntities(this.context, targetJPAEntities, this.sourceJPAEntity, navProperty);
                }
                targetJPAEntities.clear();
            }
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    public static void linkJPAEntities(ODataJPAContext oDataJPAContext, Collection<Object> targetJPAEntities, Object sourceJPAEntity, EdmNavigationProperty navigationProperty) throws ODataJPARuntimeException {
        if (targetJPAEntities == null || sourceJPAEntity == null || navigationProperty == null) {
            return;
        }
        try {
            JPAEntityParser entityParser = new JPAEntityParser(oDataJPAContext, null);
            Method setMethod = entityParser.getAccessModifier(sourceJPAEntity.getClass(), navigationProperty, "set");
            JPAEdmMappingImpl jpaEdmMappingImpl = null;
            if (navigationProperty.getMapping() instanceof JPAEdmMappingImpl) {
                jpaEdmMappingImpl = (JPAEdmMappingImpl)navigationProperty.getMapping();
            }
            if (jpaEdmMappingImpl != null && jpaEdmMappingImpl.isVirtualAccess()) {
                setMethod.invoke(sourceJPAEntity, jpaEdmMappingImpl.getInternalName(), targetJPAEntities.iterator().next());
            } else {
                switch (navigationProperty.getMultiplicity()) {
                    case MANY: {
                        Method getMethod = entityParser.getAccessModifier(sourceJPAEntity.getClass(), navigationProperty, "get");
                        Collection relatedEntities = (Collection)getMethod.invoke(sourceJPAEntity, new Object[0]);
                        if (relatedEntities == null) {
                            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_CREATE_REQUEST, null);
                        }
                        relatedEntities.addAll(targetJPAEntities);
                        setMethod.invoke(sourceJPAEntity, relatedEntities);
                        break;
                    }
                    case ONE: 
                    case ZERO_TO_ONE: {
                        setMethod.invoke(sourceJPAEntity, targetJPAEntities.iterator().next());
                    }
                }
            }
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
    }

    private List<String> extractLinkURI(ODataEntry oDataEntry, String navigationPropertyName) {
        ArrayList<String> links = new ArrayList<String>();
        String link = null;
        Object object = oDataEntry.getProperties().get(navigationPropertyName);
        if (object == null) {
            return links;
        }
        if (object instanceof ODataEntry) {
            link = ((ODataEntry)object).getMetadata().getUri();
            if (!link.isEmpty()) {
                links.add(link);
            }
        } else {
            for (ODataEntry entry : (List)object) {
                link = entry.getMetadata().getUri();
                if (link == null || link.isEmpty()) continue;
                links.add(link);
            }
        }
        return links;
    }

    private void modifyLink(UriInfo uriInfo, InputStream content, String requestContentType) throws ODataJPARuntimeException, ODataJPAModelException {
        try {
            EdmEntitySet targetEntitySet = uriInfo.getTargetEntitySet();
            String targerEntitySetName = targetEntitySet.getName();
            EdmNavigationProperty navigationProperty = null;
            UriInfo getUriInfo = null;
            if (!uriInfo.isLinks()) {
                return;
            }
            getUriInfo = this.parser.parseLink(targetEntitySet, content, requestContentType);
            navigationProperty = ((NavigationSegment)uriInfo.getNavigationSegments().get(0)).getNavigationProperty();
            if (!getUriInfo.getTargetEntitySet().getName().equals(targerEntitySetName)) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.RELATIONSHIP_INVALID, null);
            }
            this.targetJPAEntity = this.jpaProcessor.process((GetEntityUriInfo)getUriInfo);
            if (this.targetJPAEntity != null && this.sourceJPAEntity == null) {
                int index = this.context.getODataContext().getPathInfo().getODataSegments().size() - 2;
                getUriInfo = this.parser.parseURISegment(0, index);
                this.sourceJPAEntity = this.jpaProcessor.process((GetEntityUriInfo)getUriInfo);
                if (this.sourceJPAEntity == null) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.RESOURCE_X_NOT_FOUND.addContent(new Object[]{getUriInfo.getTargetEntitySet().getName()}), null);
                }
            }
            if (this.targetJPAEntity != null && this.sourceJPAEntity != null) {
                ArrayList<Object> targetJPAEntities = new ArrayList<Object>();
                targetJPAEntities.add(this.targetJPAEntity);
                JPALink.linkJPAEntities(this.context, targetJPAEntities, this.sourceJPAEntity, navigationProperty);
            }
        }
        catch (IllegalArgumentException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        catch (ODataException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    private void delinkJPAEntities(Object jpaEntity, List<Object> relatedJPAEntities, EdmNavigationProperty targetNavigationProperty) throws ODataJPARuntimeException {
        try {
            JPAEntityParser entityParser = new JPAEntityParser(this.context, null);
            Method setMethod = entityParser.getAccessModifier(jpaEntity.getClass(), targetNavigationProperty, "set");
            Method getMethod = entityParser.getAccessModifier(jpaEntity.getClass(), targetNavigationProperty, "get");
            if (getMethod.getReturnType().getTypeParameters() != null && getMethod.getReturnType().getTypeParameters().length != 0) {
                setMethod.invoke(jpaEntity, relatedJPAEntities);
            } else {
                setMethod.invoke(jpaEntity, new Object[]{null});
            }
        }
        catch (IllegalAccessException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
    }
}

