/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmLiteral;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataNotImplementedException;
import org.apache.olingo.odata2.api.uri.KeyPredicate;
import org.apache.olingo.odata2.api.uri.expression.BinaryExpression;
import org.apache.olingo.odata2.api.uri.expression.BinaryOperator;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.ExpressionKind;
import org.apache.olingo.odata2.api.uri.expression.FilterExpression;
import org.apache.olingo.odata2.api.uri.expression.LiteralExpression;
import org.apache.olingo.odata2.api.uri.expression.MemberExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodOperator;
import org.apache.olingo.odata2.api.uri.expression.OrderByExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderExpression;
import org.apache.olingo.odata2.api.uri.expression.PropertyExpression;
import org.apache.olingo.odata2.api.uri.expression.SortOrder;
import org.apache.olingo.odata2.api.uri.expression.UnaryExpression;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.core.ODataParameterizedWhereExpressionUtil;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmMappingImpl;

public class ODataExpressionParser {
    public static final String EMPTY = "";
    public static final ThreadLocal<Integer> methodFlag = new ThreadLocal();
    public static final Character[] EMPTY_CHARACTER_ARRAY = new Character[0];
    private static ThreadLocal<Integer> index = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 1;
        }
    };
    private static ThreadLocal<Map<Integer, Object>> positionalParameters = new ThreadLocal<Map<Integer, Object>>(){

        @Override
        protected Map<Integer, Object> initialValue() {
            return new HashMap<Integer, Object>();
        }
    };

    public static String parseToJPAWhereExpression(CommonExpression whereExpression, String tableAlias) throws ODataException {
        switch (whereExpression.getKind()) {
            case UNARY: {
                UnaryExpression unaryExpression = (UnaryExpression)whereExpression;
                String operand = ODataExpressionParser.parseToJPAWhereExpression(unaryExpression.getOperand(), tableAlias);
                switch (unaryExpression.getOperator()) {
                    case NOT: {
                        return "NOT(" + operand + ')';
                    }
                    case MINUS: {
                        if (operand.startsWith("-")) {
                            return operand.substring(1);
                        }
                        return "-" + operand;
                    }
                }
                ODataExpressionParser.reInitializePositionalParameters();
                throw new ODataNotImplementedException();
            }
            case FILTER: {
                return ODataExpressionParser.parseToJPAWhereExpression(((FilterExpression)whereExpression).getExpression(), tableAlias);
            }
            case BINARY: {
                BinaryExpression binaryExpression = (BinaryExpression)whereExpression;
                MethodOperator operator = null;
                if (binaryExpression.getLeftOperand().getKind() == ExpressionKind.METHOD) {
                    operator = ((MethodExpression)binaryExpression.getLeftOperand()).getMethod();
                }
                if (operator != null && (binaryExpression.getOperator() == BinaryOperator.EQ || binaryExpression.getOperator() == BinaryOperator.NE) && operator == MethodOperator.SUBSTRINGOF) {
                    methodFlag.set(1);
                }
                String left = ODataExpressionParser.parseToJPAWhereExpression(binaryExpression.getLeftOperand(), tableAlias);
                index.set(index.get() + 1);
                String right = ODataExpressionParser.parseToJPAWhereExpression(binaryExpression.getRightOperand(), tableAlias);
                if (operator != null && (operator == MethodOperator.STARTSWITH || operator == MethodOperator.ENDSWITH)) {
                    if (!binaryExpression.getOperator().equals((Object)BinaryOperator.EQ) && !(binaryExpression.getRightOperand() instanceof LiteralExpression) && ("true".equals(right) || "false".equals(right))) {
                        ODataExpressionParser.reInitializePositionalParameters();
                        throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.OPERATOR_EQ_NE_MISSING.addContent(new Object[]{binaryExpression.getOperator().toString()}), null);
                    }
                    if (binaryExpression.getOperator().equals((Object)BinaryOperator.EQ)) {
                        if ("false".equals(right)) {
                            return '(' + left.replaceFirst("LIKE", "NOT LIKE") + ' ' + ')';
                        }
                        if ("true".equals(right)) {
                            return '(' + left + ' ' + ')';
                        }
                    }
                }
                switch (binaryExpression.getOperator()) {
                    case AND: {
                        return '(' + left + ' ' + "AND" + ' ' + right + ')';
                    }
                    case OR: {
                        return '(' + left + ' ' + "OR" + ' ' + right + ')';
                    }
                    case EQ: {
                        EdmSimpleType type = (EdmSimpleType)((BinaryExpression)whereExpression).getLeftOperand().getEdmType();
                        if (EdmSimpleTypeKind.String.getEdmSimpleTypeInstance().isCompatible(type)) {
                            return '(' + left + ' ' + (!"null".equals(right) ? "LIKE" : "IS") + ' ' + right + ("null".equals(right) ? EMPTY : " ESCAPE '\\'") + ')';
                        }
                        return '(' + left + ' ' + (!"null".equals(right) ? "=" : "IS") + ' ' + right + ')';
                    }
                    case NE: {
                        return '(' + left + ' ' + (!"null".equals(right) ? "<>" : "IS NOT") + ' ' + right + ')';
                    }
                    case LT: {
                        return '(' + left + ' ' + "<" + ' ' + right + ')';
                    }
                    case LE: {
                        return '(' + left + ' ' + "<=" + ' ' + right + ')';
                    }
                    case GT: {
                        return '(' + left + ' ' + ">" + ' ' + right + ')';
                    }
                    case GE: {
                        return '(' + left + ' ' + ">=" + ' ' + right + ')';
                    }
                    case PROPERTY_ACCESS: {
                        ODataExpressionParser.reInitializePositionalParameters();
                        throw new ODataNotImplementedException();
                    }
                }
                ODataExpressionParser.reInitializePositionalParameters();
                throw new ODataNotImplementedException();
            }
            case PROPERTY: {
                String returnStr = ODataExpressionParser.getPropertyName(whereExpression);
                if (tableAlias != null) {
                    returnStr = tableAlias + '.' + returnStr;
                }
                return returnStr;
            }
            case MEMBER: {
                String memberExpStr = EMPTY;
                int i = 0;
                MemberExpression member = null;
                CommonExpression tempExp = whereExpression;
                while (tempExp != null && tempExp.getKind() == ExpressionKind.MEMBER) {
                    member = (MemberExpression)tempExp;
                    if (i > 0) {
                        memberExpStr = '.' + memberExpStr;
                    }
                    ++i;
                    memberExpStr = ODataExpressionParser.getPropertyName(member.getProperty()) + memberExpStr;
                    tempExp = member.getPath();
                }
                memberExpStr = ODataExpressionParser.getPropertyName(tempExp) + '.' + memberExpStr;
                return tableAlias + '.' + memberExpStr;
            }
            case LITERAL: {
                LiteralExpression literal = (LiteralExpression)whereExpression;
                EdmSimpleType literalType = (EdmSimpleType)literal.getEdmType();
                EdmLiteral uriLiteral = EdmSimpleTypeKind.parseUriLiteral((String)literal.getUriLiteral());
                return ODataExpressionParser.evaluateComparingExpression(uriLiteral.getLiteral(), literalType, null);
            }
            case METHOD: {
                MethodExpression methodExpression = (MethodExpression)whereExpression;
                String first = ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)methodExpression.getParameters().get(0), tableAlias);
                index.set(index.get() + 1);
                String second = methodExpression.getParameterCount() > 1 ? ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)methodExpression.getParameters().get(1), tableAlias) : null;
                index.set(index.get() + 1);
                String third = methodExpression.getParameterCount() > 2 ? ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)methodExpression.getParameters().get(2), tableAlias) : null;
                switch (methodExpression.getMethod()) {
                    case SUBSTRING: {
                        third = third != null ? ", " + third : EMPTY;
                        return String.format("SUBSTRING(%s, %s + 1 %s)", first, second, third);
                    }
                    case SUBSTRINGOF: {
                        if (methodFlag.get() != null && methodFlag.get() == 1) {
                            methodFlag.set(null);
                            return String.format("(CASE WHEN (%s LIKE CONCAT('%%',CONCAT(%s,'%%')) ESCAPE '\\') THEN TRUE ELSE FALSE END)", second, first);
                        }
                        return String.format("(CASE WHEN (%s LIKE CONCAT('%%',CONCAT(%s,'%%')) ESCAPE '\\') THEN TRUE ELSE FALSE END) = true", second, first);
                    }
                    case TOLOWER: {
                        return String.format("LOWER(%s)", first);
                    }
                    case STARTSWITH: {
                        return String.format("%s LIKE CONCAT(%s,'%%') ESCAPE '\\'", first, second);
                    }
                    case ENDSWITH: {
                        return String.format("%s LIKE CONCAT('%%',%s) ESCAPE '\\'", first, second);
                    }
                    case YEAR: {
                        return String.format("EXTRACT(YEAR %s)", first);
                    }
                    case DAY: {
                        return String.format("EXTRACT(DAY %s)", first);
                    }
                    case MONTH: {
                        return String.format("EXTRACT(MONTH %s)", first);
                    }
                    case HOUR: {
                        return String.format("EXTRACT(HOUR %s)", first);
                    }
                    case MINUTE: {
                        return String.format("EXTRACT(MINUTE %s)", first);
                    }
                    case SECOND: {
                        return String.format("EXTRACT(SECOND %s)", first);
                    }
                }
                ODataExpressionParser.reInitializePositionalParameters();
                throw new ODataNotImplementedException();
            }
        }
        throw new ODataNotImplementedException();
    }

    public static Map<Integer, Object> getPositionalParameters() {
        return positionalParameters.get();
    }

    public static void reInitializePositionalParameters() {
        index.set(1);
        positionalParameters.set(new HashMap());
    }

    public static Byte[] toByteArray(String uriLiteral) {
        int length = uriLiteral.length();
        if (length == 0) {
            return new Byte[0];
        }
        byte[] byteValues = uriLiteral.getBytes();
        Byte[] result = new Byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = new Byte(byteValues[i]);
        }
        return result;
    }

    private static String updateValueIfWildcards(String value) {
        if (value != null) {
            value = value.replace("\\", "\\\\");
            value = value.replace("%", "\\%");
            value = value.replace("_", "\\_");
        }
        return value;
    }

    public static String parseToJPASelectExpression(String tableAlias, ArrayList<String> selectedFields) {
        if (selectedFields == null || selectedFields.isEmpty()) {
            return tableAlias;
        }
        String selectClause = EMPTY;
        Iterator<String> itr = selectedFields.iterator();
        int count = 0;
        while (itr.hasNext()) {
            selectClause = selectClause + tableAlias + '.' + itr.next();
            if (++count >= selectedFields.size()) continue;
            selectClause = selectClause + ',' + ' ';
        }
        return selectClause;
    }

    public static String parseToJPAOrderByExpression(OrderByExpression orderByExpression, String tableAlias) throws ODataJPARuntimeException {
        String jpqlOrderByExpression = EMPTY;
        if (orderByExpression != null && orderByExpression.getOrders() != null) {
            List orderBys = orderByExpression.getOrders();
            String orderByField = null;
            String orderByDirection = null;
            for (OrderExpression orderBy : orderBys) {
                try {
                    orderByField = orderBy.getExpression().getKind() == ExpressionKind.MEMBER ? ODataExpressionParser.parseToJPAWhereExpression(orderBy.getExpression(), tableAlias) : (tableAlias != null ? tableAlias + '.' + ODataExpressionParser.getPropertyName(orderBy.getExpression()) : ODataExpressionParser.getPropertyName(orderBy.getExpression()));
                    orderByDirection = orderBy.getSortOrder() == SortOrder.asc ? EMPTY : " DESC";
                    jpqlOrderByExpression = jpqlOrderByExpression + orderByField + orderByDirection + " , ";
                }
                catch (EdmException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
                catch (ODataException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
            }
        }
        return ODataExpressionParser.normalizeOrderByExpression(jpqlOrderByExpression);
    }

    private static String normalizeOrderByExpression(String jpqlOrderByExpression) {
        if (jpqlOrderByExpression != EMPTY) {
            return jpqlOrderByExpression.substring(0, jpqlOrderByExpression.length() - 3);
        }
        return jpqlOrderByExpression;
    }

    public static String parseKeyPredicates(List<KeyPredicate> keyPredicates, String tableAlias) throws ODataJPARuntimeException {
        String literal = null;
        String propertyName = null;
        EdmSimpleType edmSimpleType = null;
        Class<?> edmMappedType = null;
        StringBuilder keyFilters = new StringBuilder();
        int i = 0;
        for (KeyPredicate keyPredicate : keyPredicates) {
            if (i > 0) {
                keyFilters.append(" AND ");
            }
            ++i;
            literal = keyPredicate.getLiteral();
            try {
                propertyName = keyPredicate.getProperty().getMapping().getInternalExpression() != null && tableAlias == null ? keyPredicate.getProperty().getMapping().getInternalExpression() : keyPredicate.getProperty().getMapping().getInternalName();
                edmSimpleType = (EdmSimpleType)keyPredicate.getProperty().getType();
                edmMappedType = ((JPAEdmMappingImpl)keyPredicate.getProperty().getMapping()).getJPAType();
            }
            catch (EdmException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
            literal = ODataExpressionParser.evaluateComparingExpression(literal, edmSimpleType, edmMappedType);
            if (edmSimpleType == EdmSimpleTypeKind.String.getEdmSimpleTypeInstance()) {
                if (tableAlias != null) {
                    keyFilters.append(tableAlias + '.');
                }
                keyFilters.append(propertyName + ' ' + "LIKE" + ' ' + literal + " ESCAPE '\\'");
                continue;
            }
            if (tableAlias != null) {
                keyFilters.append(tableAlias + '.');
            }
            keyFilters.append(propertyName + ' ' + "=" + ' ' + literal);
        }
        if (keyFilters.length() > 0) {
            HashMap<String, Map<Integer, Object>> parameterizedExpressionMap = new HashMap<String, Map<Integer, Object>>();
            parameterizedExpressionMap.put(keyFilters.toString(), ODataExpressionParser.getPositionalParameters());
            ODataParameterizedWhereExpressionUtil.setParameterizedQueryMap(parameterizedExpressionMap);
            return keyFilters.toString();
        }
        return null;
    }

    public static Character[] toCharacterArray(char[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHARACTER_ARRAY;
        }
        Character[] result = new Character[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Character(array[i]);
        }
        return result;
    }

    public static String parseKeyPropertiesToJPAOrderByExpression(List<EdmProperty> edmPropertylist, String tableAlias) throws ODataJPARuntimeException {
        String propertyName = null;
        String orderExpression = EMPTY;
        if (edmPropertylist == null) {
            return orderExpression;
        }
        for (EdmProperty edmProperty : edmPropertylist) {
            try {
                EdmMapping mapping = edmProperty.getMapping();
                propertyName = mapping != null && mapping.getInternalName() != null ? mapping.getInternalName() : edmProperty.getName();
            }
            catch (EdmException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
            orderExpression = orderExpression + tableAlias + '.' + propertyName + " , ";
        }
        return ODataExpressionParser.normalizeOrderByExpression(orderExpression);
    }

    private static String evaluateComparingExpression(String uriLiteral, EdmSimpleType edmSimpleType, Class<?> edmMappedType) throws ODataJPARuntimeException {
        Map<Integer, Object> positionalParameters = ODataExpressionParser.getPositionalParameters();
        int index = ODataExpressionParser.index.get();
        if (EdmSimpleTypeKind.String.getEdmSimpleTypeInstance().isCompatible(edmSimpleType) || EdmSimpleTypeKind.Guid.getEdmSimpleTypeInstance().isCompatible(edmSimpleType)) {
            uriLiteral = uriLiteral.replaceAll("'", "''");
            uriLiteral = ODataExpressionParser.updateValueIfWildcards(uriLiteral);
            if (!positionalParameters.containsKey(index)) {
                if (edmMappedType != null) {
                    ODataExpressionParser.evaluateExpressionForString(uriLiteral, edmMappedType);
                } else {
                    positionalParameters.put(index, String.valueOf(uriLiteral));
                }
            }
            uriLiteral = "?" + index;
            ++index;
        } else if (EdmSimpleTypeKind.DateTime.getEdmSimpleTypeInstance().isCompatible(edmSimpleType) || EdmSimpleTypeKind.DateTimeOffset.getEdmSimpleTypeInstance().isCompatible(edmSimpleType)) {
            try {
                Calendar datetime = (Calendar)edmSimpleType.valueOfString(uriLiteral, EdmLiteralKind.DEFAULT, null, edmSimpleType.getDefaultType());
                if (!positionalParameters.containsKey(index)) {
                    positionalParameters.put(index, datetime);
                }
                uriLiteral = "?" + index;
                ++index;
            }
            catch (EdmSimpleTypeException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
        } else if (EdmSimpleTypeKind.Time.getEdmSimpleTypeInstance().isCompatible(edmSimpleType)) {
            try {
                Calendar time = (Calendar)edmSimpleType.valueOfString(uriLiteral, EdmLiteralKind.DEFAULT, null, edmSimpleType.getDefaultType());
                String hourValue = String.format("%02d", time.get(11));
                String minValue = String.format("%02d", time.get(12));
                String secValue = String.format("%02d", time.get(13));
                uriLiteral = hourValue + ':' + minValue + ':' + secValue;
                if (!positionalParameters.containsKey(index)) {
                    positionalParameters.put(index, Time.valueOf(uriLiteral));
                }
                uriLiteral = "?" + index;
                ++index;
            }
            catch (EdmSimpleTypeException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
        } else {
            uriLiteral = ODataExpressionParser.evaluateExpressionForNumbers(uriLiteral, edmSimpleType, edmMappedType);
        }
        ODataExpressionParser.index.set(index);
        return uriLiteral;
    }

    private static String evaluateExpressionForNumbers(String uriLiteral, EdmSimpleType edmSimpleType, Class<?> edmMappedType) {
        Map<Integer, Object> positionalParameters = ODataExpressionParser.getPositionalParameters();
        int index = ODataExpressionParser.index.get();
        Class type = edmMappedType == null ? edmSimpleType.getDefaultType() : edmMappedType;
        int size = positionalParameters.size();
        if (Long.class.equals((Object)type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, Long.valueOf(uriLiteral));
            }
        } else if (Double.class.equals((Object)type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, Double.valueOf(uriLiteral));
            }
        } else if (Integer.class.equals((Object)type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, Integer.valueOf(uriLiteral));
            }
        } else if (Byte.class.equals((Object)type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, Byte.valueOf(uriLiteral));
            }
        } else if (Byte[].class.equals((Object)type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, ODataExpressionParser.toByteArray(uriLiteral));
            }
        } else if (Short.class.equals((Object)type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, Short.valueOf(uriLiteral));
            }
        } else if (BigDecimal.class.equals((Object)type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, new BigDecimal(uriLiteral));
            }
        } else if (BigInteger.class.equals((Object)type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, new BigInteger(uriLiteral));
            }
        } else if (Float.class.equals((Object)type) && !positionalParameters.containsKey(index)) {
            positionalParameters.put(index, Float.valueOf(uriLiteral));
        }
        if (size + 1 == positionalParameters.size()) {
            uriLiteral = "?" + index;
            ++index;
        }
        ODataExpressionParser.index.set(index);
        return uriLiteral;
    }

    private static void evaluateExpressionForString(String uriLiteral, Class<?> edmMappedType) {
        Map<Integer, Object> positionalParameters = ODataExpressionParser.getPositionalParameters();
        int index = ODataExpressionParser.index.get();
        if (edmMappedType.equals(char[].class)) {
            positionalParameters.put(index, uriLiteral.toCharArray());
        } else if (edmMappedType.equals(Character.TYPE)) {
            positionalParameters.put(index, Character.valueOf(uriLiteral.charAt(0)));
        } else if (edmMappedType.equals(Character[].class)) {
            char[] charArray = uriLiteral.toCharArray();
            Character[] charObjectArray = ODataExpressionParser.toCharacterArray(charArray);
            positionalParameters.put(index, charObjectArray);
        } else if (edmMappedType.equals(Character.class)) {
            positionalParameters.put(index, Character.valueOf(uriLiteral.charAt(0)));
        } else {
            positionalParameters.put(index, String.valueOf(uriLiteral));
        }
    }

    private static String getPropertyName(CommonExpression whereExpression) throws EdmException, ODataJPARuntimeException {
        EdmMapping mapping;
        EdmTyped edmProperty = ((PropertyExpression)whereExpression).getEdmProperty();
        if (edmProperty instanceof EdmNavigationProperty) {
            EdmNavigationProperty edmNavigationProperty = (EdmNavigationProperty)edmProperty;
            mapping = edmNavigationProperty.getMapping();
        } else if (edmProperty instanceof EdmProperty) {
            EdmProperty property = (EdmProperty)edmProperty;
            mapping = property.getMapping();
        } else {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL, null);
        }
        return mapping != null ? (mapping.getInternalExpression() != null ? mapping.getInternalExpression() : mapping.getInternalName()) : edmProperty.getName();
    }

    public static void clear() {
        positionalParameters.remove();
        index.remove();
        methodFlag.remove();
    }
}

