/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.api;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.odata2.api.batch.BatchHandler;
import org.apache.olingo.odata2.api.batch.BatchRequestPart;
import org.apache.olingo.odata2.api.batch.BatchResponsePart;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.commons.InlineCount;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderBatchProperties;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.processor.ODataRequest;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.uri.PathInfo;
import org.apache.olingo.odata2.api.uri.info.DeleteUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityLinkUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetLinksUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetFunctionImportUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetSimplePropertyUriInfo;
import org.apache.olingo.odata2.api.uri.info.PostUriInfo;
import org.apache.olingo.odata2.api.uri.info.PutMergePatchUriInfo;
import org.apache.olingo.odata2.core.uri.UriInfoImpl;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAProcessor;

public abstract class ODataJPADefaultProcessor
extends ODataJPAProcessor {
    public ODataJPADefaultProcessor(ODataJPAContext oDataJPAContext) {
        super(oDataJPAContext);
    }

    public ODataResponse readEntitySet(GetEntitySetUriInfo uriParserResultView, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            List<Object> jpaEntities = this.jpaProcessor.process(uriParserResultView);
            InlineCount inlineCount = uriParserResultView.getInlineCount();
            if (inlineCount != null && inlineCount.equals((Object)InlineCount.ALLPAGES)) {
                ((UriInfoImpl)uriParserResultView).setCount(true);
                this.responseBuilder.setCount(this.jpaProcessor.process((GetEntitySetCountUriInfo)uriParserResultView));
            }
            oDataResponse = uriParserResultView.isNew() ? this.responseBuilder.build((GetEntityUriInfo)uriParserResultView, jpaEntities.get(0), contentType) : this.responseBuilder.build(uriParserResultView, jpaEntities, contentType);
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    public ODataResponse readEntity(GetEntityUriInfo uriParserResultView, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            Object jpaEntity = this.jpaProcessor.process(uriParserResultView);
            oDataResponse = this.responseBuilder.build(uriParserResultView, jpaEntity, contentType);
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    public ODataResponse countEntitySet(GetEntitySetCountUriInfo uriParserResultView, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            long jpaEntityCount = this.jpaProcessor.process(uriParserResultView);
            oDataResponse = this.responseBuilder.build(jpaEntityCount);
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    public ODataResponse existsEntity(GetEntityCountUriInfo uriInfo, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            long jpaEntityCount = this.jpaProcessor.process(uriInfo);
            oDataResponse = this.responseBuilder.build(jpaEntityCount);
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    public ODataResponse createEntity(PostUriInfo uriParserResultView, InputStream content, String requestContentType, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            Object createdJpaEntity = this.jpaProcessor.process(uriParserResultView, content, requestContentType);
            oDataResponse = this.responseBuilder.build(uriParserResultView, createdJpaEntity, contentType);
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    public ODataResponse updateEntity(PutMergePatchUriInfo uriParserResultView, InputStream content, String requestContentType, boolean merge, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            EdmType type = null;
            if (!(uriParserResultView.getTargetType() instanceof EdmEntityType)) {
                type = uriParserResultView.getTargetType();
                ((UriInfoImpl)uriParserResultView).setTargetType((EdmType)uriParserResultView.getTargetEntitySet().getEntityType());
            }
            Object jpaEntity = this.jpaProcessor.process(uriParserResultView, content, requestContentType);
            if (type != null) {
                ((UriInfoImpl)uriParserResultView).setTargetType(type);
            }
            oDataResponse = this.responseBuilder.build(uriParserResultView, jpaEntity, contentType);
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    public ODataResponse deleteEntity(DeleteUriInfo uriParserResultView, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            Object deletedObj = this.jpaProcessor.process(uriParserResultView, contentType);
            oDataResponse = this.responseBuilder.build(uriParserResultView, deletedObj);
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    public ODataResponse executeFunctionImport(GetFunctionImportUriInfo uriParserResultView, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            List<Object> resultEntity = this.jpaProcessor.process(uriParserResultView);
            oDataResponse = this.responseBuilder.build(uriParserResultView, resultEntity, contentType);
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    public ODataResponse executeFunctionImportValue(GetFunctionImportUriInfo uriParserResultView, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            List<Object> result = this.jpaProcessor.process(uriParserResultView);
            oDataResponse = this.responseBuilder.build(uriParserResultView, result.get(0));
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    public ODataResponse readEntityLink(GetEntityLinkUriInfo uriParserResultView, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            Object jpaEntity = this.jpaProcessor.process(uriParserResultView);
            oDataResponse = this.responseBuilder.build(uriParserResultView, jpaEntity, contentType);
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    public ODataResponse readEntityLinks(GetEntitySetLinksUriInfo uriParserResultView, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            List<Object> jpaEntity = this.jpaProcessor.process(uriParserResultView);
            oDataResponse = this.responseBuilder.build(uriParserResultView, jpaEntity, contentType);
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    public ODataResponse createEntityLink(PostUriInfo uriParserResultView, InputStream content, String requestContentType, String contentType) throws ODataException {
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            this.jpaProcessor.process(uriParserResultView, content, requestContentType, contentType);
            ODataResponse oDataResponse = ODataResponse.newBuilder().build();
            return oDataResponse;
        }
        finally {
            this.close();
        }
    }

    public ODataResponse updateEntityLink(PutMergePatchUriInfo uriParserResultView, InputStream content, String requestContentType, String contentType) throws ODataException {
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            this.jpaProcessor.process(uriParserResultView, content, requestContentType, contentType);
            ODataResponse oDataResponse = ODataResponse.newBuilder().build();
            return oDataResponse;
        }
        finally {
            this.close();
        }
    }

    public ODataResponse deleteEntityLink(DeleteUriInfo uriParserResultView, String contentType) throws ODataException {
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            this.jpaProcessor.process(uriParserResultView, contentType);
            ODataResponse oDataResponse = ODataResponse.newBuilder().build();
            return oDataResponse;
        }
        finally {
            this.close();
        }
    }

    public ODataResponse executeBatch(BatchHandler handler, String contentType, InputStream content) throws ODataException {
        try {
            ODataResponse batchResponse;
            this.oDataJPAContext.setODataContext(this.getContext());
            ArrayList<BatchResponsePart> batchResponseParts = new ArrayList<BatchResponsePart>();
            PathInfo pathInfo = this.getContext().getPathInfo();
            EntityProviderBatchProperties batchProperties = EntityProviderBatchProperties.init().pathInfo(pathInfo).build();
            List batchParts = EntityProvider.parseBatchRequest((String)contentType, (InputStream)content, (EntityProviderBatchProperties)batchProperties);
            for (BatchRequestPart batchPart : batchParts) {
                batchResponseParts.add(handler.handleBatchPart(batchPart));
            }
            ODataResponse oDataResponse = batchResponse = EntityProvider.writeBatchResponse(batchResponseParts);
            return oDataResponse;
        }
        finally {
            this.close(true);
        }
    }

    public BatchResponsePart executeChangeSet(BatchHandler handler, List<ODataRequest> requests) throws ODataException {
        ArrayList<ODataResponse> responses = new ArrayList<ODataResponse>();
        try {
            this.oDataJPAContext.getODataJPATransaction().begin();
            for (ODataRequest request : requests) {
                this.oDataJPAContext.setODataContext(this.getContext());
                ODataResponse response = handler.handleRequest(request);
                if (response.getStatus().getStatusCode() >= HttpStatusCodes.BAD_REQUEST.getStatusCode()) {
                    this.oDataJPAContext.getODataJPATransaction().rollback();
                    ArrayList<ODataResponse> errorResponses = new ArrayList<ODataResponse>(1);
                    errorResponses.add(response);
                    BatchResponsePart batchResponsePart = BatchResponsePart.responses(errorResponses).changeSet(false).build();
                    return batchResponsePart;
                }
                responses.add(response);
            }
            this.oDataJPAContext.getODataJPATransaction().commit();
            BatchResponsePart batchResponsePart = BatchResponsePart.responses(responses).changeSet(true).build();
            return batchResponsePart;
        }
        catch (Exception e) {
            throw new ODataException("Error on processing request content:" + e.getMessage(), (Throwable)e);
        }
        finally {
            this.close(true);
        }
    }

    public ODataResponse readEntitySimpleProperty(GetSimplePropertyUriInfo uriInfo, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            EdmType type = uriInfo.getTargetType();
            ((UriInfoImpl)uriInfo).setTargetType((EdmType)uriInfo.getTargetEntitySet().getEntityType());
            this.oDataJPAContext.setODataContext(this.getContext());
            Object jpaEntity = this.jpaProcessor.process((GetEntityUriInfo)uriInfo);
            ((UriInfoImpl)uriInfo).setTargetType(type);
            oDataResponse = this.responseBuilder.build((GetEntityUriInfo)uriInfo, jpaEntity, contentType);
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    public ODataResponse readEntitySimplePropertyValue(GetSimplePropertyUriInfo uriInfo, String contentType) throws ODataException {
        return this.readEntitySimpleProperty(uriInfo, contentType);
    }

    public ODataResponse updateEntitySimpleProperty(PutMergePatchUriInfo uriInfo, InputStream content, String requestContentType, String contentType) throws ODataException {
        return this.updateEntity(uriInfo, content, requestContentType, true, contentType);
    }

    public ODataResponse updateEntitySimplePropertyValue(PutMergePatchUriInfo uriInfo, InputStream content, String requestContentType, String contentType) throws ODataException {
        return this.updateEntity(uriInfo, content, requestContentType, true, contentType);
    }
}

