package org.apache.olingo.odata2.core.edm;

import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.core.edm.provider.EdmSimplePropertyImplProv;

import java.util.LinkedList;
import java.util.List;

public class EdmUtil {
  private static EdmTyped findProperty(EdmEntityType entityType, String name) throws EdmException {
    for (String item : entityType.getKeyPropertyNames()) {
      if (item.equals(name)) {
        return entityType.getProperty(item);
      }
    }

    return null;
  }

  public static List<EdmProperty> findOriginalKeys(EdmEntityType entityType) throws EdmException {
    List<EdmProperty> keys = new LinkedList<EdmProperty>();
    for (EdmProperty item : entityType.getKeyProperties()) {
      EdmSimplePropertyImplProv property = (EdmSimplePropertyImplProv) findProperty(entityType, item.getName());
      if (property != null) {
        if (property.getComposite() != null) {
          keys.addAll(property.getComposite());
        } else {
          keys.add(property);
        }
      }
    }
    return keys;
  }
}
