/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.producer;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.ClientCallback;
import org.apache.olingo.odata2.api.commons.InlineCount;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.api.ep.callback.TombstoneCallback;
import org.apache.olingo.odata2.api.ep.callback.TombstoneCallbackResult;
import org.apache.olingo.odata2.core.ep.EntityProviderProducerException;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.producer.JsonDeletedEntryEntityProducer;
import org.apache.olingo.odata2.core.ep.producer.JsonEntryEntityProducer;
import org.apache.olingo.odata2.core.ep.producer.OlingoJsonSerializer;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;

public class JsonFeedEntityProducer {
    private final EntityProviderWriteProperties properties;

    public JsonFeedEntityProducer(EntityProviderWriteProperties properties) throws EntityProviderException {
        this.properties = properties == null ? EntityProviderWriteProperties.serviceRoot(null).build() : properties;
    }

    public void appendAsObject(Writer writer, EntityInfoAggregator entityInfo, List<Map<String, Object>> data, boolean isRootElement) throws EntityProviderException {
        JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
        TombstoneCallback callback = this.getTombstoneCallback();
        try {
            if (this.properties.getCallback() != null && isRootElement) {
                jsonStreamWriter.unquotedValue(this.properties.getCallback());
                jsonStreamWriter.unquotedValue("(");
            }
            jsonStreamWriter.beginObject();
            if (isRootElement) {
                if (this.properties.getClientCallbacks() != null && !this.properties.getClientCallbacks().isEmpty()) {
                    JsonFeedEntityProducer.appendClientCallbacks(jsonStreamWriter, this.properties.getClientCallbacks());
                }
                jsonStreamWriter.name("d").beginObject();
            }
            if (this.properties.getInlineCountType() == InlineCount.ALLPAGES) {
                int inlineCount = this.properties.getInlineCount() == null ? 0 : this.properties.getInlineCount();
                jsonStreamWriter.namedStringValueRaw("__count", String.valueOf(inlineCount)).separator();
            }
            jsonStreamWriter.name("results").beginArray();
            this.appendEntries(writer, entityInfo, data, jsonStreamWriter);
            if (callback != null) {
                this.appendDeletedEntries(writer, entityInfo, data, callback);
            }
            jsonStreamWriter.endArray();
            this.appendNextLink(jsonStreamWriter);
            this.appendDeltaLink(callback, jsonStreamWriter);
            if (isRootElement) {
                jsonStreamWriter.endObject();
            }
            jsonStreamWriter.endObject();
            if (this.properties.getCallback() != null && isRootElement) {
                jsonStreamWriter.unquotedValue(")");
            }
        }
        catch (IOException e) {
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), e);
        }
    }

    public static void appendClientCallbacks(JsonStreamWriter writer, List<ClientCallback> callbacks) throws EntityProviderException, IOException {
        writer.name("__callback").beginArray();
        boolean first1 = true;
        for (ClientCallback callback : callbacks) {
            if (!first1) {
                writer.separator();
            }
            first1 = false;
            writer.beginObject();
            writer.namedStringValue("function", callback.getFunction());
            writer.separator();
            writer.name("params");
            writer.beginArray();
            boolean first2 = true;
            for (Object o : callback.getParams()) {
                if (!first2) {
                    writer.separator();
                }
                first2 = false;
                if (o instanceof OlingoJsonSerializer) {
                    writer.unquotedValue(((OlingoJsonSerializer)o).serializeAsJson());
                    continue;
                }
                writer.stringValue(o.toString());
            }
            writer.endArray();
            writer.endObject();
        }
        writer.endArray();
        writer.separator();
    }

    public void appendAsArray(Writer writer, EntityInfoAggregator entityInfo, List<Map<String, Object>> data) throws EntityProviderException {
        JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
        try {
            jsonStreamWriter.beginArray();
            this.appendEntries(writer, entityInfo, data, jsonStreamWriter);
            jsonStreamWriter.endArray();
        }
        catch (IOException e) {
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), e);
        }
    }

    private void appendDeletedEntries(Writer writer, EntityInfoAggregator entityInfo, List<Map<String, Object>> data, TombstoneCallback callback) throws EntityProviderException {
        JsonDeletedEntryEntityProducer deletedEntryProducer = new JsonDeletedEntryEntityProducer(this.properties);
        TombstoneCallbackResult callbackResult = callback.getTombstoneCallbackResult();
        List deletedEntries = callbackResult.getDeletedEntriesData();
        if (deletedEntries != null) {
            deletedEntryProducer.append(writer, entityInfo, deletedEntries, data.isEmpty());
        }
    }

    private void appendEntries(Writer writer, EntityInfoAggregator entityInfo, List<Map<String, Object>> data, JsonStreamWriter jsonStreamWriter) throws EntityProviderException, IOException {
        JsonEntryEntityProducer entryProducer = new JsonEntryEntityProducer(this.properties);
        boolean first = true;
        for (Map<String, Object> entryData : data) {
            if (first) {
                first = false;
            } else {
                jsonStreamWriter.separator();
            }
            entryProducer.append(writer, entityInfo, entryData, false);
        }
    }

    private TombstoneCallback getTombstoneCallback() {
        if (this.properties.getCallbacks() != null && this.properties.getCallbacks().containsKey("~tombstoneCallback")) {
            TombstoneCallback callback = (TombstoneCallback)this.properties.getCallbacks().get("~tombstoneCallback");
            return callback;
        }
        return null;
    }

    private void appendNextLink(JsonStreamWriter jsonStreamWriter) throws IOException {
        if (this.properties.getNextLink() != null) {
            jsonStreamWriter.separator().namedStringValue("__next", this.properties.getNextLink());
        }
    }

    private void appendDeltaLink(TombstoneCallback callback, JsonStreamWriter jsonStreamWriter) throws IOException {
        TombstoneCallbackResult callbackResult;
        String deltaLink;
        if (callback != null && (deltaLink = (callbackResult = callback.getTombstoneCallbackResult()).getDeltaLink()) != null) {
            jsonStreamWriter.separator().namedStringValue("__delta", deltaLink);
        }
    }
}

