/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri.expression;

import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmStructuralType;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.uri.expression.BinaryOperator;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.ExpressionParserException;
import org.apache.olingo.odata2.api.uri.expression.PropertyExpression;
import org.apache.olingo.odata2.core.uri.expression.ExpressionParserInternalError;
import org.apache.olingo.odata2.core.uri.expression.MethodExpressionImpl;
import org.apache.olingo.odata2.core.uri.expression.PropertyExpressionImpl;
import org.apache.olingo.odata2.core.uri.expression.Token;
import org.apache.olingo.odata2.core.uri.expression.TokenizerException;
import org.apache.olingo.odata2.core.uri.expression.TokenizerExpectError;

public class FilterParserExceptionImpl
extends ExpressionParserException {
    private static final long serialVersionUID = 77L;

    public static ExpressionParserException createERROR_IN_TOKENIZER(TokenizerException exceptionTokenizer, String expression) {
        Token token = exceptionTokenizer.getToken();
        MessageReference msgRef = ExpressionParserException.ERROR_IN_TOKENIZER.create();
        msgRef.addContent(new Object[]{token.getUriLiteral()});
        msgRef.addContent(new Object[]{Integer.toString(token.getPosition() + 1)});
        msgRef.addContent(new Object[]{expression});
        return new ExpressionParserException(msgRef, (Throwable)((Object)exceptionTokenizer));
    }

    public static ExpressionParserException createINVALID_TRAILING_TOKEN_DETECTED_AFTER_PARSING(Token token, String expression) {
        MessageReference msgRef = ExpressionParserException.INVALID_TRAILING_TOKEN_DETECTED_AFTER_PARSING.create();
        msgRef.addContent(new Object[]{token.getUriLiteral()});
        msgRef.addContent(new Object[]{Integer.toString(token.getPosition() + 1)});
        msgRef.addContent(new Object[]{expression});
        return new ExpressionParserException(msgRef);
    }

    public static ExpressionParserException createEXPRESSION_EXPECTED_AFTER_POS(Token token, String expression) {
        MessageReference msgRef = ExpressionParserException.EXPRESSION_EXPECTED_AFTER_POS.create();
        msgRef.addContent(new Object[]{Integer.toString(token.getPosition() + 1)});
        msgRef.addContent(new Object[]{expression});
        return new ExpressionParserException(msgRef);
    }

    public static ExpressionParserException createEXPRESSION_EXPECTED_AFTER_POS(int position, String expression) {
        MessageReference msgRef = ExpressionParserException.EXPRESSION_EXPECTED_AFTER_POS.create();
        msgRef.addContent(new Object[]{position});
        msgRef.addContent(new Object[]{expression});
        return new ExpressionParserException(msgRef);
    }

    public static ExpressionParserException createCOMMA_OR_END_EXPECTED_AT_POS(Token token, String expression) {
        MessageReference msgRef = ExpressionParserException.COMMA_OR_END_EXPECTED_AT_POS.create();
        msgRef.addContent(new Object[]{Integer.toString(token.getPosition() + 1)});
        msgRef.addContent(new Object[]{expression});
        return new ExpressionParserException(msgRef);
    }

    public static ExpressionParserException createEXPRESSION_EXPECTED_AT_POS(Token token, String expression) {
        MessageReference msgRef = ExpressionParserException.EXPRESSION_EXPECTED_AT_POS.create();
        msgRef.addContent(new Object[]{Integer.toString(token.getPosition() + 1)});
        msgRef.addContent(new Object[]{expression});
        return new ExpressionParserException(msgRef);
    }

    public static ExpressionParserException createCOMMA_OR_CLOSING_PARENTHESIS_EXPECTED_AFTER_POS(Token token, String expression) {
        MessageReference msgRef = ExpressionParserException.COMMA_OR_CLOSING_PARENTHESIS_EXPECTED_AFTER_POS.create();
        msgRef.addContent(new Object[]{Integer.toString(token.getPosition() + token.getUriLiteral().length())});
        msgRef.addContent(new Object[]{expression});
        return new ExpressionParserException(msgRef);
    }

    public static ExpressionParserException createMETHOD_WRONG_ARG_COUNT(MethodExpressionImpl methodExpression, Token token, String expression) {
        MessageReference msgRef = null;
        int minParam = methodExpression.getMethodInfo().getMinParameter();
        int maxParam = methodExpression.getMethodInfo().getMaxParameter();
        if (minParam != -1 || maxParam != -1) {
            if (minParam != -1 && maxParam == -1) {
                msgRef = ExpressionParserException.METHOD_WRONG_ARG_X_OR_MORE.create();
                msgRef.addContent(new Object[]{methodExpression.getMethod().toUriLiteral()});
                msgRef.addContent(new Object[]{token.getPosition() + 1});
                msgRef.addContent(new Object[]{expression});
                msgRef.addContent(new Object[]{minParam});
            } else if (minParam == -1 && maxParam != -1) {
                msgRef = ExpressionParserException.METHOD_WRONG_ARG_X_OR_LESS.create();
                msgRef.addContent(new Object[]{methodExpression.getMethod().toUriLiteral()});
                msgRef.addContent(new Object[]{token.getPosition() + 1});
                msgRef.addContent(new Object[]{expression});
                msgRef.addContent(new Object[]{maxParam});
            } else if (minParam != -1 && maxParam != -1) {
                if (minParam == maxParam) {
                    msgRef = ExpressionParserException.METHOD_WRONG_ARG_EXACT.create();
                    msgRef.addContent(new Object[]{methodExpression.getMethod().toUriLiteral()});
                    msgRef.addContent(new Object[]{token.getPosition() + 1});
                    msgRef.addContent(new Object[]{expression});
                    msgRef.addContent(new Object[]{minParam});
                } else {
                    msgRef = ExpressionParserException.METHOD_WRONG_ARG_BETWEEN.create();
                    msgRef.addContent(new Object[]{methodExpression.getMethod().toUriLiteral()});
                    msgRef.addContent(new Object[]{token.getPosition() + 1});
                    msgRef.addContent(new Object[]{expression});
                    msgRef.addContent(new Object[]{minParam});
                    msgRef.addContent(new Object[]{maxParam});
                }
            }
        }
        return new ExpressionParserException(msgRef);
    }

    public static ExpressionParserException createMETHOD_WRONG_INPUT_TYPE(MethodExpressionImpl methodExpression, Token token, String expression) {
        MessageReference msgRef = null;
        msgRef = ExpressionParserException.METHOD_WRONG_INPUT_TYPE.create();
        msgRef.addContent(new Object[]{methodExpression.getMethod().toUriLiteral()});
        msgRef.addContent(new Object[]{token.getPosition() + 1});
        msgRef.addContent(new Object[]{expression});
        return new ExpressionParserException(msgRef);
    }

    public static ExpressionParserException createLEFT_SIDE_NOT_A_PROPERTY(Token token, String expression) throws ExpressionParserInternalError {
        MessageReference msgRef = ExpressionParserException.LEFT_SIDE_NOT_A_PROPERTY.create();
        msgRef.addContent(new Object[]{token.getPosition() + 1});
        msgRef.addContent(new Object[]{expression});
        return new ExpressionParserException(msgRef);
    }

    public static ExpressionParserException createLEFT_SIDE_NOT_STRUCTURAL_TYPE(EdmType parentType, PropertyExpressionImpl property, Token token, String expression) throws ExpressionParserInternalError {
        MessageReference msgRef = ExpressionParserException.LEFT_SIDE_NOT_STRUCTURAL_TYPE.create();
        try {
            msgRef.addContent(new Object[]{property.getUriLiteral()});
            msgRef.addContent(new Object[]{String.valueOf(parentType.getNamespace()) + "." + parentType.getName()});
            msgRef.addContent(new Object[]{token.getPosition() + 1});
            msgRef.addContent(new Object[]{expression});
        }
        catch (EdmException e) {
            throw ExpressionParserInternalError.createERROR_ACCESSING_EDM(e);
        }
        return new ExpressionParserException(msgRef);
    }

    public static ExpressionParserException createPROPERTY_NAME_NOT_FOUND_IN_TYPE(EdmStructuralType parentType, PropertyExpression property, Token token, String expression) throws ExpressionParserInternalError {
        MessageReference msgRef = ExpressionParserException.PROPERTY_NAME_NOT_FOUND_IN_TYPE.create();
        try {
            msgRef.addContent(new Object[]{property.getUriLiteral()});
            msgRef.addContent(new Object[]{String.valueOf(parentType.getNamespace()) + "." + parentType.getName()});
            msgRef.addContent(new Object[]{token.getPosition() + 1});
            msgRef.addContent(new Object[]{expression});
        }
        catch (EdmException e) {
            throw ExpressionParserInternalError.createERROR_ACCESSING_EDM(e);
        }
        return new ExpressionParserException(msgRef);
    }

    public static ExpressionParserException createTOKEN_UNDETERMINATED_STRING(int position, String expression) {
        MessageReference msgRef = ExpressionParserException.TOKEN_UNDETERMINATED_STRING.create();
        msgRef.addContent(new Object[]{position + 1});
        msgRef.addContent(new Object[]{expression});
        return new ExpressionParserException(msgRef);
    }

    public static ExpressionParserException createINVALID_TYPES_FOR_BINARY_OPERATOR(BinaryOperator op, EdmType left, EdmType right, Token token, String expression) {
        MessageReference msgRef = ExpressionParserException.INVALID_TYPES_FOR_BINARY_OPERATOR.create();
        msgRef.addContent(new Object[]{op.toUriLiteral()});
        try {
            msgRef.addContent(new Object[]{String.valueOf(left.getNamespace()) + "." + left.getName()});
        }
        catch (EdmException e) {
            msgRef.addContent(new Object[]{""});
        }
        try {
            msgRef.addContent(new Object[]{String.valueOf(right.getNamespace()) + "." + right.getName()});
        }
        catch (EdmException e) {
            msgRef.addContent(new Object[]{""});
        }
        msgRef.addContent(new Object[]{token.getPosition() + 1});
        msgRef.addContent(new Object[]{expression});
        return new ExpressionParserException(msgRef);
    }

    public static ExpressionParserException createMISSING_CLOSING_PARENTHESIS(int position, String expression, TokenizerExpectError e) {
        MessageReference msgRef = ExpressionParserException.MISSING_CLOSING_PARENTHESIS.create();
        msgRef.addContent(new Object[]{position + 1});
        msgRef.addContent(new Object[]{expression});
        return new ExpressionParserException(msgRef, (Throwable)((Object)e));
    }

    public static ExpressionParserException createINVALID_SORT_ORDER(Token token, String expression) {
        MessageReference msgRef = ExpressionParserException.INVALID_SORT_ORDER.create();
        msgRef.addContent(new Object[]{token.getPosition() + 1});
        msgRef.addContent(new Object[]{expression});
        return new ExpressionParserException(msgRef);
    }

    public static ExpressionParserException createINVALID_METHOD_CALL(CommonExpression leftNode, Token prevToken, String expression) {
        MessageReference msgRef = ExpressionParserException.INVALID_METHOD_CALL.create();
        msgRef.addContent(new Object[]{leftNode.getUriLiteral()});
        msgRef.addContent(new Object[]{prevToken.getPosition() + 1});
        msgRef.addContent(new Object[]{expression});
        return new ExpressionParserException(msgRef);
    }

    public static ExpressionParserException createTYPE_EXPECTED_AT(EdmType expectedType, EdmType actualType, int position, String expression) {
        MessageReference msgRef = ExpressionParserException.TYPE_EXPECTED_AT.create();
        try {
            msgRef.addContent(new Object[]{String.valueOf(expectedType.getNamespace()) + '.' + expectedType.getName()});
        }
        catch (EdmException e) {
            msgRef.addContent(new Object[]{""});
        }
        msgRef.addContent(new Object[]{position});
        msgRef.addContent(new Object[]{expression});
        if (actualType != null) {
            try {
                msgRef.addContent(new Object[]{String.valueOf(actualType.getNamespace()) + '.' + actualType.getName()});
            }
            catch (EdmException e) {
                msgRef.addContent(new Object[]{""});
            }
        } else {
            msgRef.addContent(new Object[]{"null"});
        }
        return new ExpressionParserException(msgRef);
    }
}

