/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.servlet;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.olingo.odata2.api.exception.ODataBadRequestException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataNotFoundException;
import org.apache.olingo.odata2.api.exception.ODataUnsupportedMediaTypeException;
import org.apache.olingo.odata2.api.uri.PathInfo;
import org.apache.olingo.odata2.api.uri.PathSegment;
import org.apache.olingo.odata2.core.ODataPathSegmentImpl;
import org.apache.olingo.odata2.core.PathInfoImpl;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.commons.Decoder;

public class RestUtil {
    private static final String REG_EX_OPTIONAL_WHITESPACE = "\\s*";
    private static final String REG_EX_FIELD_VALUE_SEPARATOR = ",\\s*";
    private static final String REG_EX_QVALUE = "q=((?:1(?:\\.0{0,3})?)|(?:0(?:\\.[0-9]{0,3})?))";
    private static final String REG_EX_PARAMETER = "(?:;\\s*(?:(?:[^qQ].*)|(?:[qQ]\\s*=\\s*(?:[^01].*))))*";
    private static final Pattern REG_EX_ACCEPT = Pattern.compile("([a-z\\*\\s]+/[a-zA-Z\\+\\*\\-=\\s]+(?:;\\s*(?:(?:[^qQ].*)|(?:[qQ]\\s*=\\s*(?:[^01].*))))*)");
    private static final Pattern REG_EX_ACCEPT_WITH_Q_FACTOR = Pattern.compile(REG_EX_ACCEPT + "(?:" + "\\s*" + "q=((?:1(?:\\.0{0,3})?)|(?:0(?:\\.[0-9]{0,3})?))" + ")?");
    private static final Pattern REG_EX_ACCEPT_LANGUAGES = Pattern.compile("((?:\\*)|(?:[a-z]{1,8}(?:\\-[a-zA-Z]{1,8})?))");
    private static final Pattern REG_EX_ACCEPT_LANGUAGES_WITH_Q_FACTOR = Pattern.compile(REG_EX_ACCEPT_LANGUAGES + "(?:;" + "\\s*" + "q=((?:1(?:\\.0{0,3})?)|(?:0(?:\\.[0-9]{0,3})?))" + ")?");
    private static final Pattern REG_EX_MATRIX_PARAMETER = Pattern.compile("([^=]*)(?:=(.*))?");
    private static final String ACCEPT_FORM_ENCODING = "odata-accept-forms-encoding";

    public static ContentType extractRequestContentType(String contentType) throws ODataUnsupportedMediaTypeException {
        if (contentType == null || contentType.isEmpty()) {
            return ContentType.APPLICATION_OCTET_STREAM;
        }
        if (ContentType.isParseable(contentType)) {
            return ContentType.create(contentType);
        }
        throw new ODataUnsupportedMediaTypeException(ODataUnsupportedMediaTypeException.NOT_SUPPORTED_CONTENT_TYPE.addContent(new Object[]{contentType}));
    }

    public static Map<String, String> extractQueryParameters(String queryString) {
        HashMap<String, String> queryParametersMap = new HashMap<String, String>();
        if (queryString != null && queryString.length() > 0) {
            List<String> queryParameters = Arrays.asList(queryString.split("\\&"));
            for (String param : queryParameters) {
                String decodedParam = Decoder.decode(param);
                int indexOfEqualSign = decodedParam.indexOf("=");
                if (indexOfEqualSign < 0) {
                    queryParametersMap.put(decodedParam, "");
                    continue;
                }
                queryParametersMap.put(decodedParam.substring(0, indexOfEqualSign), decodedParam.substring(indexOfEqualSign + 1));
            }
        }
        return queryParametersMap;
    }

    public static Map<String, List<String>> extractAllQueryParameters(String queryString, String formEncoding) {
        HashMap<String, List<String>> allQueryParameterMap = new HashMap<String, List<String>>();
        if (Boolean.parseBoolean(formEncoding)) {
            ArrayList<String> encoding = new ArrayList<String>();
            encoding.add(formEncoding);
            allQueryParameterMap.put(ACCEPT_FORM_ENCODING, encoding);
        }
        if (queryString != null && queryString.length() > 0) {
            List<String> queryParameters = Arrays.asList(queryString.split("\\&"));
            for (String param : queryParameters) {
                String decodedParam = Decoder.decode(param);
                int indexOfEqualSign = decodedParam.indexOf("=");
                if (indexOfEqualSign < 0) {
                    List<String> parameterList = allQueryParameterMap.containsKey(decodedParam) ? (List)allQueryParameterMap.get(decodedParam) : new LinkedList();
                    allQueryParameterMap.put(decodedParam, parameterList);
                    parameterList.add("");
                    continue;
                }
                String key = decodedParam.substring(0, indexOfEqualSign);
                List<String> parameterList = allQueryParameterMap.containsKey(key) ? (List)allQueryParameterMap.get(key) : new LinkedList();
                allQueryParameterMap.put(key, parameterList);
                parameterList.add(decodedParam.substring(indexOfEqualSign + 1));
            }
        }
        return allQueryParameterMap;
    }

    public static List<Locale> extractAcceptableLanguage(String acceptableLanguageHeader) {
        ArrayList<Locale> acceptLanguages = new ArrayList<Locale>();
        TreeSet<Accept> acceptTree = RestUtil.getAcceptTree();
        if (acceptableLanguageHeader != null && !acceptableLanguageHeader.isEmpty()) {
            List<String> list = Arrays.asList(acceptableLanguageHeader.split(REG_EX_FIELD_VALUE_SEPARATOR));
            for (String acceptLanguage : list) {
                Matcher matcher = REG_EX_ACCEPT_LANGUAGES_WITH_Q_FACTOR.matcher(acceptLanguage);
                if (!matcher.find()) continue;
                String language = matcher.group(1);
                double qualityFactor = matcher.group(2) != null ? Double.parseDouble(matcher.group(2)) : 1.0;
                acceptTree.add(new Accept(language, qualityFactor));
            }
        }
        for (Accept accept : acceptTree) {
            Locale locale;
            String languageRange = accept.getValue();
            int indexOfMinus = languageRange.indexOf("-");
            if (indexOfMinus < 0) {
                locale = new Locale(languageRange);
            } else {
                String language = languageRange.substring(0, indexOfMinus);
                String country = languageRange.substring(indexOfMinus + 1);
                locale = new Locale(language, country);
            }
            acceptLanguages.add(locale);
        }
        return acceptLanguages;
    }

    public static List<String> extractAcceptHeaders(String acceptHeader) {
        TreeSet<Accept> acceptTree = RestUtil.getAcceptTree();
        ArrayList<String> acceptHeaders = new ArrayList<String>();
        if (acceptHeader != null && !acceptHeader.isEmpty()) {
            List<String> list = Arrays.asList(acceptHeader.split(REG_EX_FIELD_VALUE_SEPARATOR));
            for (String accept : list) {
                Matcher matcher = REG_EX_ACCEPT_WITH_Q_FACTOR.matcher(accept);
                if (!matcher.find()) continue;
                String headerValue = matcher.group(1);
                double qualityFactor = matcher.group(2) != null ? Double.parseDouble(matcher.group(2)) : 1.0;
                acceptTree.add(new Accept(headerValue, qualityFactor));
            }
        }
        for (Accept accept : acceptTree) {
            acceptHeaders.add(accept.getValue());
        }
        return acceptHeaders;
    }

    public static Map<String, List<String>> extractHeaders(HttpServletRequest req) {
        HashMap<String, List<String>> requestHeaders = new HashMap<String, List<String>>();
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            ArrayList<String> headerValues = new ArrayList<String>();
            Enumeration headers = req.getHeaders(headerName);
            while (headers.hasMoreElements()) {
                String value = (String)headers.nextElement();
                headerValues.add(value);
            }
            if (requestHeaders.containsKey(headerName)) {
                ((List)requestHeaders.get(headerName)).addAll(headerValues);
                continue;
            }
            requestHeaders.put(headerName, headerValues);
        }
        return requestHeaders;
    }

    public static PathInfo buildODataPathInfo(HttpServletRequest req, int pathSplit) throws ODataException {
        PathInfoImpl pathInfo = RestUtil.splitPath(req, pathSplit);
        pathInfo.setServiceRoot(RestUtil.buildBaseUri(req, pathInfo.getPrecedingSegments()));
        pathInfo.setRequestUri(RestUtil.buildRequestUri(req));
        return pathInfo;
    }

    private static URI buildBaseUri(HttpServletRequest req, List<PathSegment> precedingPathSegments) throws ODataException {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(req.getContextPath()).append(req.getServletPath());
            for (PathSegment ps : precedingPathSegments) {
                if (!"".equals(ps.getPath()) && ps.getPath().length() > 0) {
                    stringBuilder.append("/").append(ps.getPath());
                }
                for (String key : ps.getMatrixParameters().keySet()) {
                    List matrixParameters = (List)ps.getMatrixParameters().get(key);
                    String matrixParameterString = ";" + key + "=";
                    for (String matrixParam : matrixParameters) {
                        matrixParameterString = String.valueOf(matrixParameterString) + Decoder.decode(matrixParam) + ",";
                    }
                    stringBuilder.append(matrixParameterString.substring(0, matrixParameterString.length() - 1));
                }
            }
            String path = stringBuilder.toString();
            if (!path.endsWith("/")) {
                path = String.valueOf(path) + "/";
            }
            URI baseUri = new URI(req.getScheme(), null, req.getServerName(), req.getServerPort(), path, null, null);
            return baseUri;
        }
        catch (URISyntaxException e) {
            throw new ODataException((Throwable)e);
        }
    }

    private static URI buildRequestUri(HttpServletRequest servletRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(servletRequest.getRequestURL());
        String queryString = servletRequest.getQueryString();
        if (queryString != null) {
            stringBuilder.append("?").append(queryString);
        }
        String requestUriString = stringBuilder.toString();
        URI requestUri = URI.create(requestUriString);
        return requestUri;
    }

    private static PathInfoImpl splitPath(HttpServletRequest servletRequest, int pathSplit) throws ODataException {
        List<Object> pathSegments;
        List<Object> precedingPathSegments;
        PathInfoImpl pathInfo = new PathInfoImpl();
        String pathInfoString = RestUtil.extractPathInfo(servletRequest);
        while (pathInfoString.startsWith("/")) {
            pathInfoString = pathInfoString.substring(1);
        }
        List<Object> segments = null;
        segments = pathInfoString.isEmpty() ? new ArrayList() : Arrays.asList(pathInfoString.split("/", -1));
        if (pathSplit == 0) {
            precedingPathSegments = Collections.emptyList();
            pathSegments = segments;
        } else {
            if (segments.size() < pathSplit) {
                throw new ODataBadRequestException(ODataBadRequestException.URLTOOSHORT);
            }
            precedingPathSegments = segments.subList(0, pathSplit);
            int pathSegmentCount = segments.size();
            pathSegments = segments.subList(pathSplit, pathSegmentCount);
        }
        pathInfo.setPrecedingPathSegment(RestUtil.convertPathSegmentList(precedingPathSegments));
        ArrayList<PathSegment> odataSegments = new ArrayList<PathSegment>();
        for (String string : pathSegments) {
            int index = string.indexOf(";");
            if (index < 0) {
                odataSegments.add(new ODataPathSegmentImpl(string, null));
                continue;
            }
            String path = string.substring(0, index);
            Map<String, List<String>> parameterMap = RestUtil.extractMatrixParameter(string, index);
            throw new ODataNotFoundException(ODataNotFoundException.MATRIX.addContent(new Object[]{parameterMap.keySet(), path}));
        }
        pathInfo.setODataPathSegment(odataSegments);
        return pathInfo;
    }

    private static List<PathSegment> convertPathSegmentList(List<String> pathSegments) {
        ArrayList<PathSegment> converted = new ArrayList<PathSegment>();
        for (String segment : pathSegments) {
            int index = segment.indexOf(";");
            if (index == -1) {
                converted.add(new ODataPathSegmentImpl(Decoder.decode(segment), null));
                continue;
            }
            String path = segment.substring(0, index);
            Map<String, List<String>> parameterMap = RestUtil.extractMatrixParameter(segment, index);
            converted.add(new ODataPathSegmentImpl(Decoder.decode(path), parameterMap));
        }
        return converted;
    }

    private static Map<String, List<String>> extractMatrixParameter(String segment, int index) {
        List<String> matrixParameters = Arrays.asList(segment.substring(index + 1).split(";"));
        String matrixParameterName = "";
        String matrixParamaterValues = "";
        HashMap<String, List<String>> parameterMap = new HashMap<String, List<String>>();
        for (String matrixParameter : matrixParameters) {
            List<String> values = Arrays.asList("");
            Matcher matcher = REG_EX_MATRIX_PARAMETER.matcher(matrixParameter);
            if (matcher.find()) {
                matrixParameterName = matcher.group(1);
                matrixParamaterValues = matcher.group(2);
            }
            if (matrixParamaterValues != null) {
                values = Arrays.asList(matrixParamaterValues.split(","));
            }
            parameterMap.put(matrixParameterName, values);
        }
        return parameterMap;
    }

    private static String extractPathInfo(HttpServletRequest servletRequest) {
        int indexServletPath;
        String requestUri;
        String pathInfoString = requestUri = servletRequest.getRequestURI();
        int index = requestUri.indexOf(servletRequest.getContextPath());
        if (index >= 0) {
            pathInfoString = pathInfoString.substring(servletRequest.getContextPath().length());
        }
        if ((indexServletPath = pathInfoString.indexOf(servletRequest.getServletPath())) >= 0) {
            int substringFromPos = indexServletPath + servletRequest.getServletPath().length();
            pathInfoString = pathInfoString.substring(substringFromPos);
        }
        return pathInfoString;
    }

    private static TreeSet<Accept> getAcceptTree() {
        TreeSet<Accept> treeSet = new TreeSet<Accept>(new Comparator<Accept>(){

            @Override
            public int compare(Accept header1, Accept header2) {
                if (header1.getQuality() <= header2.getQuality()) {
                    return 1;
                }
                return -1;
            }
        });
        return treeSet;
    }

    private static class Accept {
        private double quality;
        private String value;

        public Accept(String headerValue, double qualityFactor) {
            this.value = headerValue;
            this.quality = qualityFactor;
        }

        public String getValue() {
            return this.value;
        }

        public double getQuality() {
            return this.quality;
        }
    }
}

