/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.olingo.odata2.api.processor.ODataRequest;

public class ODataRequestWrapper
implements HttpServletRequest {
    private ODataRequest oDataRequest;
    private HttpServletRequest request;

    public ODataRequestWrapper(ODataRequest oDataRequest, HttpServletRequest request) {
        this.oDataRequest = oDataRequest;
        this.request = request;
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public Cookie[] getCookies() {
        return this.request.getCookies();
    }

    public long getDateHeader(String name) {
        return -1L;
    }

    public String getHeader(String name) {
        List values = (List)this.oDataRequest.getRequestHeaders().get(name);
        if (values != null && !values.isEmpty()) {
            String result = "";
            for (String v : values) {
                if (!result.isEmpty()) {
                    result = String.valueOf(result) + ", ";
                }
                result = String.valueOf(result) + v;
            }
            return result;
        }
        if (this.request != null) {
            return this.request.getHeader(name);
        }
        return null;
    }

    public Enumeration<String> getHeaders(String name) {
        return Collections.enumeration((Collection)this.oDataRequest.getRequestHeaders().get(name));
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.oDataRequest.getRequestHeaders().keySet());
    }

    public int getIntHeader(String name) {
        return Integer.valueOf(this.getHeader(name));
    }

    public String getMethod() {
        return this.oDataRequest.getMethod().toString();
    }

    public String getPathInfo() {
        return this.oDataRequest.getPathInfo().toString();
    }

    public String getPathTranslated() {
        return this.oDataRequest.getPathInfo().toString();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    static String urlEncodeUTF8(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    static String urlEncodeUTF8(Map<?, ?> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(String.format("%s=%s", ODataRequestWrapper.urlEncodeUTF8(entry.getKey().toString()), ODataRequestWrapper.urlEncodeUTF8(entry.getValue().toString())));
        }
        return sb.toString();
    }

    public String getQueryString() {
        return ODataRequestWrapper.urlEncodeUTF8(this.oDataRequest.getQueryParameters());
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.oDataRequest.getPathInfo().getRequestUri().toString();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.oDataRequest.getPathInfo().getRequestUri().toString());
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.request.isRequestedSessionIdFromUrl();
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(env);
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public String getParameter(String name) {
        return (String)this.oDataRequest.getQueryParameters().get(name);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.oDataRequest.getQueryParameters().keySet());
    }

    public String[] getParameterValues(String name) {
        List values = (List)this.oDataRequest.getAllQueryParameters().get(name);
        if (values != null) {
            return values.toArray(new String[0]);
        }
        return new String[0];
    }

    public Map<String, String[]> getParameterMap() {
        LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>();
        for (Map.Entry entry : this.oDataRequest.getAllQueryParameters().entrySet()) {
            if (entry.getValue() != null) {
                map.put((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[0]));
                continue;
            }
            map.put((String)entry.getKey(), new String[0]);
        }
        return map;
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public void setAttribute(String name, Object o) {
        this.request.setAttribute(name, o);
    }

    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.request.getLocales();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.request.getRequestDispatcher(path);
    }

    public String getRealPath(String path) {
        return this.request.getRealPath(path);
    }

    public int getRemotePort() {
        return this.request.getRemotePort();
    }

    public String getLocalName() {
        return this.request.getLocalName();
    }

    public String getLocalAddr() {
        return this.request.getLocalAddr();
    }

    public int getLocalPort() {
        return this.request.getLocalPort();
    }
}

