/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.exception;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.olingo.odata2.api.exception.MessageReference;

public class MessageService {
    private static final String BUNDLE_NAME = "i18n";
    private final ResourceBundle resourceBundle;
    private final Locale requestedLocale;
    private static final Map<Locale, MessageService> LOCALE_2_MESSAGE_SERVICE = new HashMap<Locale, MessageService>();

    private MessageService(Locale locale) {
        this.requestedLocale = locale;
        this.resourceBundle = this.createResourceBundle(locale);
    }

    private ResourceBundle createResourceBundle(Locale locale) {
        ResourceBundle bundle;
        try {
            if (locale == null) {
                throw new IllegalArgumentException("Parameter locale MUST NOT be NULL.");
            }
            bundle = ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }
        catch (Exception e) {
            bundle = new ResourceBundle(){

                @Override
                protected Object handleGetObject(String key) {
                    return "MessageService could not be created because of exception '" + e.getClass().getSimpleName() + " with message '" + e.getMessage() + "'.";
                }

                @Override
                public Locale getLocale() {
                    return Locale.ENGLISH;
                }

                @Override
                public Enumeration<String> getKeys() {
                    return (Enumeration)((Object)Collections.emptySet());
                }
            };
        }
        return bundle;
    }

    public static MessageService getInstance(Locale locale) {
        MessageService messagesInstance = LOCALE_2_MESSAGE_SERVICE.get(locale);
        if (messagesInstance == null) {
            messagesInstance = new MessageService(locale);
            LOCALE_2_MESSAGE_SERVICE.put(locale, messagesInstance);
        }
        return messagesInstance;
    }

    public static boolean isLocaleSupported(Locale locale) {
        if (locale == null) {
            return false;
        }
        MessageService service = MessageService.getInstance(locale);
        return service.getLocale().equals(locale);
    }

    public static Locale getSupportedLocale(List<Locale> locales) {
        return MessageService.getSupportedLocale(locales, null);
    }

    public static Locale getSupportedLocale(List<Locale> locales, Locale defaultLocale) {
        for (Locale locale : locales) {
            if (!MessageService.isLocaleSupported(locale)) continue;
            return locale;
        }
        return defaultLocale;
    }

    public static MessageService getInstance(List<Locale> locales) {
        MessageService service = null;
        for (Locale locale : locales) {
            service = MessageService.getInstance(locale);
            if (service.getLocale().equals(locale)) break;
        }
        return service;
    }

    public static Message getMessage(Locale language, MessageReference context) {
        Object[] contentAsArray = context.getContent().toArray(new Object[0]);
        return MessageService.getMessage(language, context.getKey(), contentAsArray);
    }

    public static Message getMessage(Locale locale, String key, Object ... replacements) {
        MessageService messages = MessageService.getInstance(locale);
        return messages.getMessage(key, replacements);
    }

    private Message getMessage(String key, Object ... replacements) {
        String message = null;
        try {
            message = this.resourceBundle.getString(key);
            StringBuilder builder = new StringBuilder();
            Formatter f = new Formatter(builder, this.requestedLocale);
            f.format(message, replacements);
            f.close();
            return new Message(this.getLocale(), builder.toString());
        }
        catch (MissingResourceException e) {
            return new Message(Locale.ENGLISH, "Missing message for key '" + key + "'!");
        }
        catch (MissingFormatArgumentException e) {
            return new Message(Locale.ENGLISH, "Missing replacement for place holder in message '" + message + "' for following arguments '" + Arrays.toString(replacements) + "'!");
        }
    }

    public Locale getLocale() {
        return this.resourceBundle.getLocale();
    }

    public Enumeration<String> getKeys() {
        return this.resourceBundle.getKeys();
    }

    public static class Message {
        private final String localizedText;
        private final Locale locale;

        public Message(Locale locale, String localizedMessage) {
            this.localizedText = localizedMessage;
            this.locale = locale;
        }

        public String getText() {
            return this.localizedText;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getLang() {
            Locale locale = this.getLocale();
            if (locale.getCountry().isEmpty()) {
                return locale.getLanguage();
            }
            return String.valueOf(locale.getLanguage()) + "-" + locale.getCountry();
        }
    }
}

