/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.producer;

import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.core.edm.EdmDateTimeOffset;
import org.apache.olingo.odata2.core.ep.EntityProviderProducerException;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.aggregator.EntityPropertyInfo;
import org.apache.olingo.odata2.core.ep.producer.AtomEntryEntityProducer;

public class TombstoneProducer {
    private String defaultDateString;

    public void appendTombstones(XMLStreamWriter writer, EntityInfoAggregator eia, EntityProviderWriteProperties properties, List<Map<String, Object>> deletedEntries) throws EntityProviderException {
        try {
            for (Map<String, Object> deletedEntry : deletedEntries) {
                writer.writeStartElement("http://purl.org/atompub/tombstones/1.0", "deleted-entry");
                this.appendRefAttribute(writer, eia, properties, deletedEntry);
                this.appendWhenAttribute(writer, eia, deletedEntry);
                writer.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, e);
        }
        catch (EdmSimpleTypeException e) {
            throw new EntityProviderProducerException(e.getMessageReference(), e);
        }
    }

    private void appendWhenAttribute(XMLStreamWriter writer, EntityInfoAggregator eia, Map<String, Object> deletedEntry) throws XMLStreamException, EdmSimpleTypeException {
        Object updateDate = null;
        EntityPropertyInfo updatedInfo = eia.getTargetPathInfo("SyndicationUpdated");
        if (updatedInfo != null) {
            updateDate = deletedEntry.get(updatedInfo.getName());
        }
        if (updateDate == null) {
            this.appendDefaultWhenAttribute(writer);
        } else {
            this.appendCustomWhenAttribute(writer, updateDate, updatedInfo);
        }
    }

    private void appendCustomWhenAttribute(XMLStreamWriter writer, Object updateDate, EntityPropertyInfo updatedInfo) throws XMLStreamException, EdmSimpleTypeException {
        EdmFacets updateFacets = updatedInfo.getFacets();
        writer.writeAttribute("when", EdmDateTimeOffset.getInstance().valueToString(updateDate, EdmLiteralKind.DEFAULT, updateFacets));
    }

    private void appendRefAttribute(XMLStreamWriter writer, EntityInfoAggregator eia, EntityProviderWriteProperties properties, Map<String, Object> deletedEntry) throws XMLStreamException, EntityProviderException {
        String ref = String.valueOf(properties.getServiceRoot().toASCIIString()) + AtomEntryEntityProducer.createSelfLink(eia, deletedEntry, null);
        writer.writeAttribute("ref", ref);
    }

    private void appendDefaultWhenAttribute(XMLStreamWriter writer) throws XMLStreamException, EdmSimpleTypeException {
        if (this.defaultDateString == null) {
            Date defaultDate = new Date();
            this.defaultDateString = EdmDateTimeOffset.getInstance().valueToString(defaultDate, EdmLiteralKind.DEFAULT, null);
        }
        writer.writeAttribute("when", this.defaultDateString);
    }
}

