/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.debug;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.core.debug.DebugInfo;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;

public class DebugInfoRuntime
implements DebugInfo {
    private final RuntimeNode rootNode = new RuntimeNode();

    public DebugInfoRuntime(List<ODataContext.RuntimeMeasurement> runtimeMeasurements) {
        for (ODataContext.RuntimeMeasurement runtimeMeasurement : runtimeMeasurements) {
            this.rootNode.add(runtimeMeasurement);
        }
        this.rootNode.combineRuntimeMeasurements();
    }

    @Override
    public String getName() {
        return "Runtime";
    }

    @Override
    public void appendJson(JsonStreamWriter jsonStreamWriter) throws IOException {
        DebugInfoRuntime.appendJsonChildren(jsonStreamWriter, this.rootNode);
    }

    private static void appendJsonNode(JsonStreamWriter jsonStreamWriter, RuntimeNode node) throws IOException {
        jsonStreamWriter.beginObject().namedStringValueRaw("class", node.className).separator().namedStringValueRaw("method", node.methodName).separator().name("duration");
        if (node.timeStopped == 0L) {
            jsonStreamWriter.unquotedValue(null);
        } else {
            jsonStreamWriter.beginObject().name("value").unquotedValue(Long.toString((node.timeStopped - node.timeStarted) / 1000L)).separator().namedStringValueRaw("unit", "\u00b5s").endObject();
        }
        if (!node.children.isEmpty()) {
            jsonStreamWriter.separator().name("children");
            DebugInfoRuntime.appendJsonChildren(jsonStreamWriter, node);
        }
        jsonStreamWriter.endObject();
    }

    private static void appendJsonChildren(JsonStreamWriter jsonStreamWriter, RuntimeNode node) throws IOException {
        jsonStreamWriter.beginArray();
        boolean first = true;
        for (RuntimeNode childNode : node.children) {
            if (!first) {
                jsonStreamWriter.separator();
            }
            first = false;
            DebugInfoRuntime.appendJsonNode(jsonStreamWriter, childNode);
        }
        jsonStreamWriter.endArray();
    }

    @Override
    public void appendHtml(Writer writer) throws IOException {
        this.appendRuntimeNode(this.rootNode, "", true, writer);
    }

    private void appendRuntimeNode(RuntimeNode node, String draw, boolean isLast, Writer writer) throws IOException {
        if (node.className != null) {
            writer.append("<li>").append("<span class=\"code\">").append("<span class=\"draw\">").append(draw).append(isLast ? "&#x2514;" : "&#x251C;").append("&#x2500;&nbsp;</span>").append("<span class=\"class\">").append(node.className).append("</span>.").append("<span class=\"method\">").append(node.methodName).append("(&hellip;)").append("</span></span>");
            long time = node.timeStopped == 0L ? 0L : (node.timeStopped - node.timeStarted) / 1000L;
            writer.append("<span class=\"").append(time == 0L ? "null" : "numeric").append("\" title=\"").append(time == 0L ? "Stop time missing" : "Gross duration").append("\">").append(time == 0L ? "unfinished" : String.valueOf(Long.toString(time)) + "&nbsp;&micro;s").append("</span>\n");
        }
        if (!node.children.isEmpty()) {
            writer.append("<ol class=\"tree\">\n");
            for (RuntimeNode childNode : node.children) {
                this.appendRuntimeNode(childNode, node.className == null ? draw : String.valueOf(draw) + (isLast ? "&nbsp;" : "&#x2502;") + "&nbsp;&nbsp;", node.children.indexOf(childNode) == node.children.size() - 1, writer);
            }
            writer.append("</ol>\n");
        }
        if (node.className != null) {
            writer.append("</li>\n");
        }
    }

    private class RuntimeNode {
        protected String className;
        protected String methodName;
        protected long timeStarted;
        protected long timeStopped;
        protected List<RuntimeNode> children = new ArrayList<RuntimeNode>();
        public long memoryStarted;
        public long memoryStopped;

        protected RuntimeNode() {
            this.timeStarted = 0L;
            this.timeStopped = Long.MAX_VALUE;
            this.memoryStarted = 0L;
            this.memoryStopped = 0L;
        }

        private RuntimeNode(ODataContext.RuntimeMeasurement runtimeMeasurement) {
            this.className = runtimeMeasurement.getClassName();
            this.methodName = runtimeMeasurement.getMethodName();
            this.timeStarted = runtimeMeasurement.getTimeStarted();
            this.timeStopped = runtimeMeasurement.getTimeStopped();
            this.memoryStarted = runtimeMeasurement.getMemoryStarted();
            this.memoryStopped = runtimeMeasurement.getMemoryStopped();
        }

        protected boolean add(ODataContext.RuntimeMeasurement runtimeMeasurement) {
            if (this.timeStarted <= runtimeMeasurement.getTimeStarted() && this.timeStopped != 0L && this.timeStopped >= runtimeMeasurement.getTimeStopped()) {
                for (RuntimeNode candidate : this.children) {
                    if (!candidate.add(runtimeMeasurement)) continue;
                    return true;
                }
                this.children.add(new RuntimeNode(runtimeMeasurement));
                return true;
            }
            return false;
        }

        protected void combineRuntimeMeasurements() {
            RuntimeNode preceding = null;
            Iterator<RuntimeNode> iterator = this.children.iterator();
            while (iterator.hasNext()) {
                RuntimeNode child = iterator.next();
                if (preceding != null && preceding.timeStopped != 0L && child.timeStopped != 0L && preceding.timeStopped <= child.timeStarted && preceding.children.isEmpty() && child.children.isEmpty() && preceding.methodName.equals(child.methodName) && preceding.className.equals(child.className)) {
                    preceding.timeStarted = child.timeStarted - (preceding.timeStopped - preceding.timeStarted);
                    preceding.timeStopped = child.timeStopped;
                    preceding.memoryStarted = child.memoryStarted - (preceding.memoryStopped - preceding.memoryStarted);
                    preceding.memoryStopped = child.memoryStopped;
                    iterator.remove();
                    continue;
                }
                preceding = child;
                child.combineRuntimeMeasurements();
            }
        }
    }
}

