/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.olingo.odata2.core.ep.util;

/**
 * String constants for formatting and parsing of JSON.
 * 
 */
public class FormatJson {

  public static final String D = "d";
  public static final String RESULTS = "results";
  public static final String COUNT = "__count";
  public static final String CALLBACK = "__callback";
  public static final String METADATA = "__metadata";
  public static final String DEFERRED = "__deferred";
  public static final String ID = "id";
  public static final String CONTENT_TYPE = "content_type";
  public static final String MEDIA_SRC = "media_src";
  public static final String MEDIA_ETAG = "media_etag";
  public static final String EDIT_MEDIA = "edit_media";
  public static final String PROPERTIES = "properties";
  public static final String URI = "uri";
  public static final String NULL = "null";
  public static final String TRUE = "true";
  public static final String FALSE = "false";
  public static final String TYPE = "type";
  public static final String ETAG = "etag";
  public static final String ENTITY_SETS = "EntitySets";
  public static final String NEXT = "__next";
  public static final String ERROR = "error";
  public static final String CODE = "code";
  public static final String MESSAGE = "message";
  public static final String LANG = "lang";
  public static final String VALUE = "value";
  public static final String INNER_ERROR = "innererror";
  public static final String DELTA = "__delta";
  public static final String ODATA_CONTEXT = "@odata.context";
  public static final String DELTA_CONTEXT_PREFIX = "$metadata#";
  public static final String DELTA_CONTEXT_POSTFIX = "/$deletedEntity";
  public static final String DELTA_WHEN = "when";
}
