/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.producer;

import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XmlErrorDocumentProducer {
    public void writeErrorDocument(XMLStreamWriter writer, String errorCode, String message, Locale locale, String innerError) throws XMLStreamException {
        writer.writeStartDocument();
        writer.writeStartElement("error");
        writer.writeDefaultNamespace("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
        writer.writeStartElement("code");
        if (errorCode != null) {
            writer.writeCharacters(errorCode);
        }
        writer.writeEndElement();
        writer.writeStartElement("message");
        if (locale != null) {
            writer.writeAttribute("xml", "http://www.w3.org/XML/1998/namespace", "lang", this.getLocale(locale));
        } else {
            writer.writeAttribute("xml", "http://www.w3.org/XML/1998/namespace", "lang", "");
        }
        if (message != null) {
            writer.writeCharacters(message);
        }
        writer.writeEndElement();
        if (innerError != null) {
            writer.writeStartElement("innererror");
            writer.writeCharacters(innerError);
            writer.writeEndElement();
        }
        writer.writeEndDocument();
    }

    private String getLocale(Locale locale) {
        if (locale.getCountry().isEmpty()) {
            return locale.getLanguage();
        }
        return String.valueOf(locale.getLanguage()) + "-" + locale.getCountry();
    }
}

