/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;
import org.apache.olingo.odata2.core.edm.Bit;
import org.apache.olingo.odata2.core.edm.EdmByte;
import org.apache.olingo.odata2.core.edm.EdmSByte;
import org.apache.olingo.odata2.core.edm.Uint7;

public class EdmInt16
extends AbstractSimpleType {
    private static final EdmInt16 instance = new EdmInt16();

    public static EdmInt16 getInstance() {
        return instance;
    }

    @Override
    public boolean isCompatible(EdmSimpleType simpleType) {
        return simpleType instanceof Bit || simpleType instanceof Uint7 || simpleType instanceof EdmByte || simpleType instanceof EdmSByte || simpleType instanceof EdmInt16;
    }

    public Class<?> getDefaultType() {
        return Short.class;
    }

    @Override
    protected <T> T internalValueOfString(String value, EdmLiteralKind literalKind, EdmFacets facets, Class<T> returnType) throws EdmSimpleTypeException {
        Short valueShort;
        try {
            valueShort = Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(new Object[]{value}), (Throwable)e);
        }
        if (returnType.isAssignableFrom(Short.class)) {
            return returnType.cast(valueShort);
        }
        if (returnType.isAssignableFrom(Byte.class)) {
            if (valueShort >= -128 && valueShort <= 127) {
                return returnType.cast(valueShort.byteValue());
            }
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_UNCONVERTIBLE_TO_VALUE_TYPE.addContent(new Object[]{value, returnType}));
        }
        if (returnType.isAssignableFrom(Integer.class)) {
            return returnType.cast(valueShort.intValue());
        }
        if (returnType.isAssignableFrom(Long.class)) {
            return returnType.cast(valueShort.longValue());
        }
        throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(new Object[]{returnType}));
    }

    @Override
    protected <T> String internalValueToString(T value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        if (value instanceof Byte || value instanceof Short) {
            return value.toString();
        }
        if (value instanceof Integer || value instanceof Long || value instanceof Number) {
            if (((Number)value).longValue() >= -32768L && ((Number)value).longValue() <= 32767L) {
                return value.toString();
            }
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_ILLEGAL_CONTENT.addContent(new Object[]{value}));
        }
        throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(new Object[]{value.getClass()}));
    }
}

