/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;

public class EdmBinary
extends AbstractSimpleType {
    private static final EdmBinary instance = new EdmBinary();

    public static EdmBinary getInstance() {
        return instance;
    }

    public Class<?> getDefaultType() {
        return byte[].class;
    }

    @Override
    public boolean validate(String value, EdmLiteralKind literalKind, EdmFacets facets) {
        if (value == null) {
            return facets == null || facets.isNullable() == null || facets.isNullable() != false;
        }
        if (literalKind == null) {
            return false;
        }
        return EdmBinary.validateLiteral(value, literalKind) && EdmBinary.validateMaxLength(value, literalKind, facets);
    }

    private static boolean validateLiteral(String value, EdmLiteralKind literalKind) {
        return literalKind == EdmLiteralKind.URI ? value.matches("(?:X|binary)'(?:\\p{XDigit}{2})*'") : Base64.isBase64((String)value);
    }

    private static boolean validateMaxLength(String value, EdmLiteralKind literalKind, EdmFacets facets) {
        return facets == null || facets.getMaxLength() == null ? true : (literalKind == EdmLiteralKind.URI ? facets.getMaxLength() >= (value.length() - (value.startsWith("X") ? 3 : 8)) / 2 : (long)facets.getMaxLength().intValue() * 4L >= (long)(value.length() - EdmBinary.crlfLength(value)) * 3L - (long)(value.contains("==") ? 2 : (value.contains("=") ? 1 : 0)) * 4L);
    }

    private static int crlfLength(String value) {
        int result = 0;
        int index = 0;
        while ((index = value.indexOf(10, index)) >= 0) {
            result += index > 0 && value.charAt(index - 1) == '\r' ? 2 : 1;
            ++index;
        }
        return result;
    }

    @Override
    protected <T> T internalValueOfString(String value, EdmLiteralKind literalKind, EdmFacets facets, Class<T> returnType) throws EdmSimpleTypeException {
        byte[] result;
        if (!EdmBinary.validateLiteral(value, literalKind)) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(new Object[]{value}));
        }
        if (!EdmBinary.validateMaxLength(value, literalKind, facets)) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_FACETS_NOT_MATCHED.addContent(new Object[]{value, facets}));
        }
        if (literalKind == EdmLiteralKind.URI) {
            try {
                result = Hex.decodeHex((char[])value.substring(value.startsWith("X") ? 2 : 7, value.length() - 1).toCharArray());
            }
            catch (DecoderException e) {
                throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(new Object[]{value}), (Throwable)e);
            }
        } else {
            result = Base64.decodeBase64((String)value);
        }
        if (returnType.isAssignableFrom(byte[].class)) {
            return returnType.cast(result);
        }
        if (returnType.isAssignableFrom(Byte[].class)) {
            Byte[] byteArray = new Byte[result.length];
            int i = 0;
            while (i < result.length) {
                byteArray[i] = result[i];
                ++i;
            }
            return returnType.cast(byteArray);
        }
        throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(new Object[]{returnType}));
    }

    @Override
    protected <T> String internalValueToString(T value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        byte[] byteArrayValue;
        if (value instanceof byte[]) {
            byteArrayValue = (byte[])value;
        } else if (value instanceof Byte[]) {
            int length = ((Byte[])value).length;
            byteArrayValue = new byte[length];
            int i = 0;
            while (i < length) {
                byteArrayValue[i] = ((Byte[])value)[i];
                ++i;
            }
        } else {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(new Object[]{value.getClass()}));
        }
        if (facets != null && facets.getMaxLength() != null && byteArrayValue.length > facets.getMaxLength()) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_FACETS_NOT_MATCHED.addContent(new Object[]{value, facets}));
        }
        return Base64.encodeBase64String((byte[])byteArrayValue);
    }

    @Override
    public String toUriLiteral(String literal) throws EdmSimpleTypeException {
        return "binary'" + String.valueOf(Hex.encodeHex((byte[])Base64.decodeBase64((String)literal), (boolean)false)) + "'";
    }
}

