/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.commons;

import java.io.UnsupportedEncodingException;

public class Decoder {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String decode(String value) throws IllegalArgumentException, NumberFormatException {
        if (value == null) {
            return value;
        }
        byte[] result = new byte[value.length()];
        int position = 0;
        int encodedPart = -2;
        char[] cArray = value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c > '\u007f') throw new IllegalArgumentException();
            if (c == '%') {
                if (encodedPart != -2) throw new IllegalArgumentException();
                encodedPart = -1;
            } else if (encodedPart == -1) {
                encodedPart = (byte)c;
            } else if (encodedPart >= 0) {
                int i = Integer.parseInt(String.valueOf(new char[]{(char)encodedPart, c}), 16);
                if (i < 0) {
                    throw new NumberFormatException();
                }
                result[position++] = (byte)i;
                encodedPart = -2;
            } else {
                result[position++] = c == '+' ? 32 : (byte)c;
            }
            ++n2;
        }
        if (encodedPart >= 0) {
            throw new IllegalArgumentException();
        }
        try {
            return new String(result, 0, position, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

