/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class CircleStreamBuffer {
    private static final int NEW_BUFFER_RESIZE_FACTOR = 2;
    private static final int READ_EOF = -1;
    private static final int DEFAULT_CAPACITY = 8192;
    private static final int MAX_CAPACITY = 262144;
    private int currentAllocateCapacity = 8192;
    private boolean writeMode = true;
    private boolean writeClosed = false;
    private boolean readClosed = false;
    private Queue<ByteBuffer> bufferQueue = new LinkedBlockingQueue<ByteBuffer>();
    private ByteBuffer currentWriteBuffer;
    private InternalInputStream inStream;
    private InternalOutputStream outStream;
    private static Method clearMethod;

    static {
        Method m;
        Method[] methodArray = ByteBuffer.class.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            m = methodArray[n2];
            if (m.getName().equalsIgnoreCase("clear")) {
                clearMethod = m;
            }
            ++n2;
        }
        if (clearMethod == null) {
            methodArray = ByteBuffer.class.getDeclaredMethods();
            n = methodArray.length;
            n2 = 0;
            while (n2 < n) {
                m = methodArray[n2];
                if (m.getName().equalsIgnoreCase("clear")) {
                    clearMethod = m;
                }
                ++n2;
            }
        }
    }

    public CircleStreamBuffer() {
        this(8192);
    }

    public CircleStreamBuffer(int initialCapacity) {
        this.currentAllocateCapacity = initialCapacity;
        this.createNewWriteBuffer();
        this.inStream = new InternalInputStream(this);
        this.outStream = new InternalOutputStream(this);
    }

    public InputStream getInputStream() {
        return this.inStream;
    }

    public OutputStream getOutputStream() {
        return this.outStream;
    }

    public void closeWrite() {
        this.writeClosed = true;
    }

    public void closeRead() {
        this.readClosed = true;
        ByteBuffer buffer = this.bufferQueue.poll();
        while (buffer != null) {
            try {
                if (clearMethod != null) {
                    clearMethod.invoke((Object)buffer, new Object[0]);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            buffer = this.bufferQueue.poll();
        }
    }

    public void close() {
        this.closeWrite();
        this.closeRead();
    }

    private int remaining() throws IOException {
        if (this.writeMode) {
            return this.currentWriteBuffer.remaining();
        }
        ByteBuffer toRead = this.getReadBuffer();
        if (toRead == null) {
            return 0;
        }
        return toRead.remaining();
    }

    private ByteBuffer getReadBuffer() throws IOException {
        if (this.readClosed) {
            throw new IOException("Tried to read from closed stream.");
        }
        boolean next = false;
        ByteBuffer tmp = null;
        if (this.writeMode) {
            this.writeMode = false;
            next = true;
        } else {
            tmp = this.bufferQueue.peek();
            if (tmp != null && !tmp.hasRemaining()) {
                tmp = this.bufferQueue.poll();
                next = true;
            }
        }
        if (next) {
            tmp = this.bufferQueue.peek();
            if (tmp != null) {
                tmp.flip();
            }
            tmp = this.getReadBuffer();
        }
        return tmp;
    }

    private int read(byte[] b, int off, int len) throws IOException {
        ByteBuffer readBuffer = this.getReadBuffer();
        if (readBuffer == null) {
            return -1;
        }
        int toReadLength = readBuffer.remaining();
        if (len < toReadLength) {
            toReadLength = len;
        }
        readBuffer.get(b, off, toReadLength);
        return toReadLength;
    }

    private int read() throws IOException {
        ByteBuffer readBuffer = this.getReadBuffer();
        if (readBuffer == null) {
            return -1;
        }
        return readBuffer.get();
    }

    private void write(byte[] data, int off, int len) throws IOException {
        ByteBuffer writeBuffer = this.getWriteBuffer(len);
        writeBuffer.put(data, off, len);
    }

    private ByteBuffer getWriteBuffer(int size) throws IOException {
        if (this.writeClosed) {
            throw new IOException("Tried to write into closed stream.");
        }
        if (this.writeMode) {
            if (this.remaining() < size) {
                this.createNewWriteBuffer(size);
            }
        } else {
            this.writeMode = true;
            this.createNewWriteBuffer();
        }
        return this.currentWriteBuffer;
    }

    private void write(int b) throws IOException {
        ByteBuffer writeBuffer = this.getWriteBuffer(1);
        writeBuffer.put((byte)b);
    }

    private void createNewWriteBuffer() {
        this.createNewWriteBuffer(this.currentAllocateCapacity);
    }

    private void createNewWriteBuffer(int requestedCapacity) {
        ByteBuffer b = this.allocateBuffer(requestedCapacity);
        this.bufferQueue.add(b);
        this.currentWriteBuffer = b;
    }

    private ByteBuffer allocateBuffer(int requestedCapacity) {
        if (requestedCapacity > 262144) {
            this.currentAllocateCapacity = 262144;
            return ByteBuffer.allocate(requestedCapacity);
        }
        if (requestedCapacity <= this.currentAllocateCapacity) {
            this.currentAllocateCapacity *= 2;
            if (this.currentAllocateCapacity > 262144) {
                this.currentAllocateCapacity = 262144;
            }
        } else {
            this.currentAllocateCapacity = requestedCapacity;
        }
        return ByteBuffer.allocate(this.currentAllocateCapacity);
    }

    private static class InternalInputStream
    extends InputStream {
        private final CircleStreamBuffer inBuffer;

        public InternalInputStream(CircleStreamBuffer csBuffer) {
            this.inBuffer = csBuffer;
        }

        @Override
        public int available() throws IOException {
            return this.inBuffer.remaining();
        }

        @Override
        public int read() throws IOException {
            return this.inBuffer.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.inBuffer.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.inBuffer.closeRead();
        }
    }

    private static class InternalOutputStream
    extends OutputStream {
        private final CircleStreamBuffer outBuffer;

        public InternalOutputStream(CircleStreamBuffer csBuffer) {
            this.outBuffer = csBuffer;
        }

        @Override
        public void write(int b) throws IOException {
            this.outBuffer.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.outBuffer.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.outBuffer.closeWrite();
        }
    }
}

