/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.producer;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.core.edm.EdmAuto;
import org.apache.olingo.odata2.core.ep.EntityProviderProducerException;
import org.apache.olingo.odata2.core.ep.aggregator.EntityComplexPropertyInfo;
import org.apache.olingo.odata2.core.ep.aggregator.EntityPropertyInfo;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;

public class JsonPropertyEntityProducer {
    public void append(Writer writer, EntityPropertyInfo propertyInfo, Object value) throws EntityProviderException {
        JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
        try {
            jsonStreamWriter.beginObject().name("d").beginObject();
            jsonStreamWriter.name(propertyInfo.getName());
            JsonPropertyEntityProducer.appendPropertyValue(jsonStreamWriter, propertyInfo.isComplex() ? (EntityComplexPropertyInfo)propertyInfo : propertyInfo, value, true, false);
            jsonStreamWriter.endObject().endObject();
        }
        catch (IOException e) {
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), e);
        }
        catch (EdmException e) {
            throw new EntityProviderProducerException(e.getMessageReference(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void appendPropertyValue(JsonStreamWriter jsonStreamWriter, EntityPropertyInfo propertyInfo, Object value, boolean validatingFacets, boolean isDataBasedPropertySerialization) throws IOException, EdmException, EntityProviderException {
        if (propertyInfo.isComplex()) {
            if (value != null && !(value instanceof Map)) throw new EntityProviderProducerException(EntityProviderException.ILLEGAL_ARGUMENT.addContent(new Object[]{"A complex property must have a Map as data"}));
            jsonStreamWriter.beginObject();
            JsonPropertyEntityProducer.appendPropertyMetadata(jsonStreamWriter, propertyInfo.getType());
            if (value == null && isDataBasedPropertySerialization) {
                jsonStreamWriter.endObject();
                return;
            }
            for (EntityPropertyInfo childPropertyInfo : ((EntityComplexPropertyInfo)propertyInfo).getPropertyInfos()) {
                String name = childPropertyInfo.getName();
                if (isDataBasedPropertySerialization && !((Map)value).containsKey(name)) continue;
                jsonStreamWriter.separator();
                jsonStreamWriter.name(name);
                JsonPropertyEntityProducer.appendPropertyValue(jsonStreamWriter, childPropertyInfo, value == null ? null : ((Map)value).get(name), validatingFacets, isDataBasedPropertySerialization);
            }
            jsonStreamWriter.endObject();
            return;
        }
        EdmSimpleType type = (EdmSimpleType)propertyInfo.getType();
        if (type instanceof EdmAuto) {
            type = ((EdmAuto)type).getType(value);
        }
        Object contentValue = value instanceof Map ? ((Map)value).get(propertyInfo.getName()) : value;
        EdmFacets facets = validatingFacets ? propertyInfo.getFacets() : null;
        String valueAsString = null;
        try {
            valueAsString = type.valueToString(contentValue, EdmLiteralKind.JSON, facets);
        }
        catch (EdmSimpleTypeException e) {
            throw new EntityProviderProducerException(EdmSimpleTypeException.getMessageReference((MessageReference)e.getMessageReference()).updateContent(e.getMessageReference().getContent(), new Object[]{propertyInfo.getName()}), e);
        }
        switch (EdmSimpleTypeKind.valueOf((String)type.getName())) {
            case String: {
                jsonStreamWriter.stringValue(valueAsString);
                return;
            }
            case Boolean: 
            case Byte: 
            case Decimal: 
            case Double: 
            case Int16: 
            case Int32: 
            case Int64: 
            case SByte: 
            case Single: {
                jsonStreamWriter.unquotedValue(valueAsString);
                return;
            }
            case DateTime: 
            case DateTimeOffset: {
                jsonStreamWriter.stringValueRaw(valueAsString == null ? null : valueAsString.replace("/", "\\/"));
                return;
            }
            default: {
                jsonStreamWriter.stringValueRaw(valueAsString);
            }
        }
    }

    protected static void appendPropertyMetadata(JsonStreamWriter jsonStreamWriter, EdmType type) throws IOException, EdmException {
        jsonStreamWriter.name("__metadata").beginObject().namedStringValueRaw("type", String.valueOf(type.getNamespace()) + "." + type.getName()).endObject();
    }
}

