/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.consumer;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;
import org.apache.olingo.odata2.core.ep.aggregator.EntityComplexPropertyInfo;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.aggregator.EntityPropertyInfo;

public class JsonPropertyConsumer {
    public Map<String, Object> readPropertyStandalone(JsonReader reader, EdmProperty edmProperty, EntityProviderReadProperties readProperties) throws EntityProviderException {
        return this.readPropertyStandalone(reader, EntityInfoAggregator.create(edmProperty), readProperties);
    }

    public Map<String, Object> readPropertyStandalone(JsonReader reader, EntityPropertyInfo propertyInfo, EntityProviderReadProperties readProperties) throws EntityProviderException {
        Map typeMappings = readProperties == null ? null : readProperties.getTypeMappings();
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            reader.beginObject();
            String nextName = reader.nextName();
            if ("d".equals(nextName)) {
                reader.beginObject();
                nextName = reader.nextName();
                this.handleName(reader, typeMappings, propertyInfo, readProperties, result, nextName);
                reader.endObject();
            } else {
                this.handleName(reader, typeMappings, propertyInfo, readProperties, result, nextName);
            }
            reader.endObject();
            if (reader.peek() != JsonToken.END_DOCUMENT) {
                throw new EntityProviderException(EntityProviderException.END_DOCUMENT_EXPECTED.addContent(new Object[]{reader.peek().toString()}));
            }
            return result;
        }
        catch (IOException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
    }

    public List<?> readCollection(JsonReader reader, EntityPropertyInfo propertyInfo, EntityProviderReadProperties readProperties) throws EntityProviderException {
        Object typeMapping = readProperties == null ? null : readProperties.getTypeMappings().get(propertyInfo.getName());
        ArrayList<Object> result = new ArrayList<Object>();
        String name = null;
        boolean wrapped = false;
        boolean version2 = false;
        try {
            if (reader.peek() == JsonToken.BEGIN_OBJECT) {
                reader.beginObject();
                name = reader.nextName();
                if ("d".equals(name)) {
                    wrapped = true;
                    if (reader.peek() == JsonToken.BEGIN_OBJECT) {
                        reader.beginObject();
                        name = reader.nextName();
                    } else {
                        name = null;
                    }
                }
            }
            if (name != null) {
                version2 = true;
                if ("__metadata".equals(name)) {
                    this.readAndCheckTypeInfo(reader, "Collection(" + propertyInfo.getType().getNamespace() + "." + propertyInfo.getType().getName() + ")");
                    name = reader.nextName();
                }
                if (!"results".equals(name)) {
                    throw new EntityProviderException(EntityProviderException.INVALID_PARENT_TAG.addContent(new Object[]{"results", name}));
                }
            }
            reader.beginArray();
            while (reader.hasNext()) {
                result.add(this.readPropertyValue(reader, propertyInfo, typeMapping, readProperties));
            }
            reader.endArray();
            if (version2) {
                reader.endObject();
            }
            if (wrapped) {
                reader.endObject();
            }
            if (reader.peek() != JsonToken.END_DOCUMENT) {
                throw new EntityProviderException(EntityProviderException.END_DOCUMENT_EXPECTED.addContent(new Object[]{reader.peek().toString()}));
            }
            return result;
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{((Object)((Object)e)).getClass().getSimpleName()}), (Throwable)e);
        }
        catch (IOException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
    }

    private void handleName(JsonReader reader, Map<String, Object> typeMappings, EntityPropertyInfo entityPropertyInfo, EntityProviderReadProperties readProperties, Map<String, Object> result, String nextName) throws EntityProviderException {
        if (!entityPropertyInfo.getName().equals(nextName)) {
            throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent(new Object[]{nextName}));
        }
        Object mapping = typeMappings == null ? null : typeMappings.get(nextName);
        Object propertyValue = this.readPropertyValue(reader, entityPropertyInfo, mapping, readProperties);
        result.put(nextName, propertyValue);
    }

    protected Object readPropertyValue(JsonReader reader, EntityPropertyInfo entityPropertyInfo, Object typeMapping, EntityProviderReadProperties readProperties) throws EntityProviderException {
        try {
            return entityPropertyInfo.isComplex() ? this.readComplexProperty(reader, (EntityComplexPropertyInfo)entityPropertyInfo, typeMapping, readProperties) : this.readSimpleProperty(reader, entityPropertyInfo, typeMapping, readProperties);
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{((Object)((Object)e)).getClass().getSimpleName()}), (Throwable)e);
        }
        catch (IOException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
    }

    private Object readSimpleProperty(JsonReader reader, EntityPropertyInfo entityPropertyInfo, Object typeMapping, EntityProviderReadProperties readProperties) throws EdmException, EntityProviderException, IOException {
        EdmFacets facets;
        EdmSimpleType type = (EdmSimpleType)entityPropertyInfo.getType();
        Object value = null;
        JsonToken tokenType = reader.peek();
        if (tokenType == JsonToken.NULL) {
            reader.nextNull();
        } else {
            switch (EdmSimpleTypeKind.valueOf((String)type.getName())) {
                case Boolean: {
                    if (tokenType == JsonToken.NUMBER) {
                        double v = reader.nextDouble();
                        value = v > 0.0 ? "true" : "false";
                        break;
                    }
                    if (tokenType == JsonToken.STRING) {
                        value = reader.nextString();
                        value = value.toString();
                        break;
                    }
                    if (tokenType == JsonToken.BOOLEAN) {
                        value = reader.nextBoolean();
                        value = value.toString();
                        break;
                    }
                    throw new EntityProviderException(EntityProviderException.INVALID_PROPERTY_VALUE.addContent(new Object[]{entityPropertyInfo.getName()}));
                }
                case Byte: 
                case Int16: 
                case Int32: 
                case Int64: 
                case SByte: {
                    if (tokenType == JsonToken.NUMBER || tokenType == JsonToken.STRING) {
                        value = Math.round(reader.nextDouble());
                        value = value.toString();
                        break;
                    }
                    throw new EntityProviderException(EntityProviderException.INVALID_PROPERTY_VALUE.addContent(new Object[]{entityPropertyInfo.getName()}));
                }
                case Decimal: 
                case Double: 
                case Single: {
                    if (tokenType == JsonToken.STRING) {
                        value = reader.nextString();
                        break;
                    }
                    if (tokenType == JsonToken.NUMBER) {
                        value = reader.nextDouble();
                        value = value.toString();
                        break;
                    }
                    throw new EntityProviderException(EntityProviderException.INVALID_PROPERTY_VALUE.addContent(new Object[]{entityPropertyInfo.getName()}));
                }
                default: {
                    if (tokenType == JsonToken.NUMBER) {
                        value = Math.round(reader.nextDouble());
                        value = value.toString();
                        break;
                    }
                    if (tokenType == JsonToken.STRING) {
                        value = reader.nextString();
                        break;
                    }
                    throw new EntityProviderException(EntityProviderException.INVALID_PROPERTY_VALUE.addContent(new Object[]{entityPropertyInfo.getName()}));
                }
            }
        }
        Class typeMappingClass = typeMapping == null ? type.getDefaultType() : (Class)typeMapping;
        Object object = facets = readProperties == null || readProperties.isValidatingFacets() ? entityPropertyInfo.getFacets() : null;
        if (type instanceof AbstractSimpleType) {
            return ((AbstractSimpleType)type).valueOfString((String)value, EdmLiteralKind.JSON, facets, typeMappingClass, entityPropertyInfo);
        }
        return type.valueOfString((String)value, EdmLiteralKind.JSON, facets, typeMappingClass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object readComplexProperty(JsonReader reader, EntityComplexPropertyInfo complexPropertyInfo, Object typeMapping, EntityProviderReadProperties readProperties) throws EdmException, EntityProviderException, IOException {
        Map mapping;
        if (reader.peek().equals((Object)JsonToken.NULL)) {
            reader.nextNull();
            if (readProperties != null && !readProperties.isValidatingFacets() || !complexPropertyInfo.isMandatory()) return null;
            throw new EntityProviderException(EntityProviderException.INVALID_PROPERTY_VALUE.addContent(new Object[]{complexPropertyInfo.getName()}));
        }
        reader.beginObject();
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (typeMapping != null) {
            if (!(typeMapping instanceof Map)) throw new EntityProviderException(EntityProviderException.INVALID_MAPPING.addContent(new Object[]{complexPropertyInfo.getName()}));
            mapping = (Map)typeMapping;
        } else {
            mapping = new HashMap();
        }
        while (reader.hasNext()) {
            String childName = reader.nextName();
            if ("__metadata".equals(childName)) {
                this.readAndCheckTypeInfo(reader, String.valueOf(complexPropertyInfo.getType().getNamespace()) + "." + complexPropertyInfo.getType().getName());
                continue;
            }
            EntityPropertyInfo childPropertyInfo = complexPropertyInfo.getPropertyInfo(childName);
            if (childPropertyInfo == null) {
                throw new EntityProviderException(EntityProviderException.INVALID_PROPERTY.addContent(new Object[]{childName}));
            }
            Object childData = this.readPropertyValue(reader, childPropertyInfo, mapping.get(childName), readProperties);
            if (data.containsKey(childName)) {
                throw new EntityProviderException(EntityProviderException.DOUBLE_PROPERTY.addContent(new Object[]{childName}));
            }
            data.put(childName, childData);
        }
        reader.endObject();
        return data;
    }

    protected void readAndCheckTypeInfo(JsonReader reader, String expectedTypeName) throws IOException, EntityProviderException {
        reader.beginObject();
        if (!"type".equals(reader.nextName())) {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent(new Object[]{"type"}).addContent(new Object[]{"__metadata"}));
        }
        String actualTypeName = reader.nextString();
        if (!expectedTypeName.equals(actualTypeName)) {
            throw new EntityProviderException(EntityProviderException.INVALID_ENTITYTYPE.addContent(new Object[]{expectedTypeName}).addContent(new Object[]{actualTypeName}));
        }
        reader.endObject();
    }
}

