/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm.provider;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.olingo.odata2.api.edm.EdmEntitySetInfo;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.provider.EntityContainerInfo;
import org.apache.olingo.odata2.api.edm.provider.EntitySet;
import org.apache.olingo.odata2.core.commons.Encoder;

public class EdmEntitySetInfoImplProv
implements EdmEntitySetInfo {
    private final String entitySetName;
    private final URI entitySetUri;
    private final String entityContainerName;
    private final boolean isDefaultEntityContainer;

    public EdmEntitySetInfoImplProv(EntitySet entitySet, EntityContainerInfo entityContainerInfo) throws EdmException {
        this.entityContainerName = entityContainerInfo.getName();
        this.isDefaultEntityContainer = entityContainerInfo.isDefaultEntityContainer();
        this.entitySetName = entitySet.getName();
        try {
            this.entitySetUri = this.isDefaultEntityContainer ? new URI(Encoder.encode(this.entitySetName)) : new URI(Encoder.encode(String.valueOf(this.entityContainerName) + "." + this.entitySetName));
        }
        catch (URISyntaxException e) {
            throw new EdmException(EdmException.COMMON, (Throwable)e);
        }
    }

    public String getEntityContainerName() {
        return this.entityContainerName;
    }

    public String getEntitySetName() {
        return this.entitySetName;
    }

    public boolean isDefaultEntityContainer() {
        return this.isDefaultEntityContainer;
    }

    public URI getEntitySetUri() {
        return this.entitySetUri;
    }
}

