/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;
import org.apache.olingo.odata2.core.edm.EdmDateTime;
import org.apache.olingo.odata2.core.edm.EdmDateTimeOffset;

public class EdmTime
extends AbstractSimpleType {
    private static final Pattern PATTERN = Pattern.compile("PT(?:(\\p{Digit}{1,2})H)?(?:(\\p{Digit}{1,4})M)?(?:(\\p{Digit}{1,5})(?:\\.(\\p{Digit}+?)0*)?S)?");
    private static final EdmTime instance = new EdmTime();

    public static EdmTime getInstance() {
        return instance;
    }

    public Class<?> getDefaultType() {
        return Calendar.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected <T> T internalValueOfString(String value, EdmLiteralKind literalKind, EdmFacets facets, Class<T> returnType) throws EdmSimpleTypeException {
        if (!(literalKind != EdmLiteralKind.URI || value.length() > 6 && value.toLowerCase().startsWith("time'") && value.endsWith("'"))) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(new Object[]{value}));
        }
        Matcher matcher = PATTERN.matcher(literalKind == EdmLiteralKind.URI ? value.substring(5, value.length() - 1) : value);
        if (!matcher.matches() || matcher.group(1) == null && matcher.group(2) == null && matcher.group(3) == null) {
            return EdmDateTimeOffset.getInstance().internalValueOfString(value, literalKind, facets, returnType);
        }
        Calendar dateTimeValue = Calendar.getInstance();
        dateTimeValue.clear();
        dateTimeValue.set(11, matcher.group(1) == null ? 0 : Integer.parseInt(matcher.group(1)));
        dateTimeValue.set(12, matcher.group(2) == null ? 0 : Integer.parseInt(matcher.group(2)));
        dateTimeValue.set(13, matcher.group(3) == null ? 0 : Integer.parseInt(matcher.group(3)));
        int nanoSeconds = 0;
        if (matcher.group(4) != null) {
            String decimals = matcher.group(4);
            if (facets != null && facets.getPrecision() != null && facets.getPrecision() < decimals.length()) throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_FACETS_NOT_MATCHED.addContent(new Object[]{value, facets}));
            nanoSeconds = Integer.parseInt(String.valueOf(decimals) + "000000000".substring(decimals.length()));
            if (!returnType.isAssignableFrom(Timestamp.class)) {
                if (nanoSeconds % 1000000 != 0) throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(new Object[]{value}));
                dateTimeValue.set(14, nanoSeconds / 1000000);
            }
        }
        if (dateTimeValue.get(6) != 1) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(new Object[]{value}));
        }
        if (returnType.isAssignableFrom(Calendar.class)) {
            return returnType.cast(dateTimeValue);
        }
        if (returnType.isAssignableFrom(Long.class)) {
            return returnType.cast(dateTimeValue.getTimeInMillis());
        }
        if (returnType.isAssignableFrom(Date.class)) {
            return returnType.cast(dateTimeValue.getTime());
        }
        if (returnType.isAssignableFrom(Time.class)) {
            return returnType.cast(new Time(dateTimeValue.getTimeInMillis()));
        }
        if (!returnType.isAssignableFrom(Timestamp.class)) throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(new Object[]{returnType}));
        Timestamp timestamp = new Timestamp(dateTimeValue.getTimeInMillis());
        timestamp.setNanos(nanoSeconds);
        return returnType.cast(timestamp);
    }

    @Override
    protected <T> String internalValueToString(T value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        Calendar dateTimeValue;
        if (value instanceof Date) {
            dateTimeValue = Calendar.getInstance();
            dateTimeValue.clear();
            dateTimeValue.setTime((Date)value);
        } else if (value instanceof Calendar) {
            dateTimeValue = (Calendar)((Calendar)value).clone();
        } else if (value instanceof Long) {
            dateTimeValue = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            dateTimeValue.clear();
            dateTimeValue.setTimeInMillis((Long)value);
        } else {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(new Object[]{value.getClass()}));
        }
        StringBuilder result = new StringBuilder(21);
        result.append('P');
        result.append('T');
        result.append(dateTimeValue.get(11));
        result.append('H');
        result.append(dateTimeValue.get(12));
        result.append('M');
        result.append(dateTimeValue.get(13));
        int fractionalSecs = value instanceof Timestamp ? ((Timestamp)value).getNanos() : dateTimeValue.get(14);
        try {
            EdmDateTime.appendFractionalSeconds(result, fractionalSecs, value instanceof Timestamp, facets);
        }
        catch (IllegalArgumentException e) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_FACETS_NOT_MATCHED.addContent(new Object[]{value, facets}), (Throwable)e);
        }
        result.append('S');
        return result.toString();
    }

    @Override
    public String toUriLiteral(String literal) {
        return "time'" + literal + "'";
    }
}

