/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.client.core.ep.serializer;

import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.odata2.api.edm.EdmCustomizableFeedMappings;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.client.api.ep.Entity;
import org.apache.olingo.odata2.client.api.ep.EntitySerializerProperties;
import org.apache.olingo.odata2.core.ep.EntityProviderProducerException;
import org.apache.olingo.odata2.core.ep.aggregator.EntityComplexPropertyInfo;
import org.apache.olingo.odata2.core.ep.aggregator.EntityPropertyInfo;

public class XmlPropertyEntitySerializer {
    private final boolean validateFacets;

    public XmlPropertyEntitySerializer(EntitySerializerProperties writeProperties) {
        this(writeProperties.isValidatingFacets());
    }

    public XmlPropertyEntitySerializer(boolean validateFacets) {
        this.validateFacets = validateFacets;
    }

    public void append(XMLStreamWriter writer, String name, EntityPropertyInfo propertyInfo, Object value) throws EntityProviderException {
        try {
            writer.writeStartElement("http://schemas.microsoft.com/ado/2007/08/dataservices", name);
            if (propertyInfo.isComplex()) {
                this.appendProperty(writer, (EntityComplexPropertyInfo)propertyInfo, value);
            } else {
                this.appendProperty(writer, propertyInfo, value);
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, (Throwable)e);
        }
        catch (EdmException e) {
            throw new EntityProviderProducerException(e.getMessageReference(), (Throwable)e);
        }
    }

    public void appendCustomProperty(XMLStreamWriter writer, String name, EntityPropertyInfo propertyInfo, Object value) throws EntityProviderException {
        try {
            if (!propertyInfo.isComplex()) {
                this.writeStartElementWithCustomNamespace(writer, propertyInfo, name);
                this.appendProperty(writer, propertyInfo, value);
                writer.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, (Throwable)e);
        }
        catch (EdmException e) {
            throw new EntityProviderProducerException(e.getMessageReference(), (Throwable)e);
        }
    }

    private void appendProperty(XMLStreamWriter writer, EntityComplexPropertyInfo propertyInfo, Object value) throws XMLStreamException, EdmException, EntityProviderException {
        if (value == null) {
            writer.writeAttribute("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "null", "true");
        } else {
            writer.writeAttribute("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "type", this.getFqnTypeName(propertyInfo));
            List propertyInfos = propertyInfo.getPropertyInfos();
            for (EntityPropertyInfo childPropertyInfo : propertyInfos) {
                if (value instanceof Map && !((Map)value).containsKey(childPropertyInfo.getName()) || value instanceof Entity && ((Entity)value).getProperty(childPropertyInfo.getName()) == null) continue;
                Object childValue = this.extractChildValue(value, childPropertyInfo.getName());
                this.append(writer, childPropertyInfo.getName(), childPropertyInfo, childValue);
            }
        }
    }

    private String getFqnTypeName(EntityComplexPropertyInfo propertyInfo) throws EdmException {
        return String.valueOf(propertyInfo.getType().getNamespace()) + "." + propertyInfo.getType().getName();
    }

    private Object extractChildValue(Object value, String name) {
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.get(name);
        }
        if (value instanceof Entity) {
            Map map = ((Entity)value).getProperties();
            return map.get(name);
        }
        return String.valueOf(value);
    }

    private void appendProperty(XMLStreamWriter writer, EntityPropertyInfo prop, Object value) throws XMLStreamException, EdmException, EntityProviderProducerException {
        Object contentValue = value;
        String mimeType = null;
        if (prop.getMimeType() != null) {
            mimeType = prop.getMimeType();
        } else if (prop.getMapping() != null && prop.getMapping().getMediaResourceMimeTypeKey() != null) {
            mimeType = (String)this.extractChildValue(value, prop.getMapping().getMediaResourceMimeTypeKey());
            contentValue = this.extractChildValue(value, prop.getName());
        }
        if (mimeType != null) {
            writer.writeAttribute("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "MimeType", mimeType);
        }
        EdmSimpleType type = (EdmSimpleType)prop.getType();
        EdmFacets facets = this.validateFacets ? prop.getFacets() : null;
        String valueAsString = null;
        try {
            valueAsString = type.valueToString(contentValue, EdmLiteralKind.DEFAULT, facets);
        }
        catch (EdmSimpleTypeException e) {
            throw new EntityProviderProducerException(EdmSimpleTypeException.getMessageReference((MessageReference)e.getMessageReference()).updateContent(e.getMessageReference().getContent(), new Object[]{prop.getName()}), (Throwable)e);
        }
        if (valueAsString == null) {
            writer.writeAttribute("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "null", "true");
        } else {
            writer.writeCharacters(valueAsString);
        }
    }

    private void writeStartElementWithCustomNamespace(XMLStreamWriter writer, EntityPropertyInfo prop, String name) throws XMLStreamException, EntityProviderException {
        EdmCustomizableFeedMappings mapping = prop.getCustomMapping();
        String nsPrefix = mapping.getFcNsPrefix();
        String nsUri = mapping.getFcNsUri();
        if (nsUri == null || nsPrefix == null) {
            throw new EntityProviderProducerException(EntityProviderException.INVALID_NAMESPACE.addContent(new Object[]{name}));
        }
        writer.writeStartElement(nsPrefix, name, nsUri);
        writer.writeNamespace(nsPrefix, nsUri);
    }
}

