/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.client.core.ep.deserializer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.entry.EntryMetadata;
import org.apache.olingo.odata2.api.ep.entry.MediaMetadata;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.FeedMetadata;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.client.api.ep.DeserializerProperties;
import org.apache.olingo.odata2.client.api.ep.callback.OnDeserializeInlineContent;
import org.apache.olingo.odata2.client.core.ep.deserializer.XmlPropertyDeserializer;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.aggregator.EntityPropertyInfo;
import org.apache.olingo.odata2.core.ep.aggregator.EntityTypeMapping;
import org.apache.olingo.odata2.core.ep.entry.EntryMetadataImpl;
import org.apache.olingo.odata2.core.ep.entry.MediaMetadataImpl;
import org.apache.olingo.odata2.core.ep.entry.ODataEntryImpl;
import org.apache.olingo.odata2.core.ep.feed.FeedMetadataImpl;
import org.apache.olingo.odata2.core.ep.feed.ODataDeltaFeedImpl;

public class XmlEntryDeserializer {
    private ODataEntryImpl readEntryResult;
    private Map<String, Object> properties;
    private MediaMetadataImpl mediaMetadata;
    private EntryMetadataImpl entryMetadata;
    private EntityTypeMapping typeMappings;
    private String currentHandledStartTagName;

    public ODataEntry readEntry(XMLStreamReader reader, EntityInfoAggregator eia, DeserializerProperties readProperties, boolean isInline) throws EntityProviderException {
        try {
            this.initialize(readProperties);
            if (isInline) {
                this.setETag(reader);
            }
            while (reader.hasNext() && !this.isEntryEndTag(reader)) {
                reader.nextTag();
                if (!reader.isStartElement()) continue;
                this.handleStartedTag(reader, eia, readProperties);
            }
            return this.readEntryResult;
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{((Object)((Object)e)).getClass().getSimpleName()}), (Throwable)e);
        }
    }

    private boolean isEntryEndTag(XMLStreamReader reader) {
        return reader.isEndElement() && "http://www.w3.org/2005/Atom".equals(reader.getNamespaceURI()) && "entry".equals(reader.getLocalName());
    }

    private void initialize(DeserializerProperties readProperties) throws EntityProviderException {
        this.properties = new HashMap<String, Object>();
        this.mediaMetadata = new MediaMetadataImpl();
        this.entryMetadata = new EntryMetadataImpl();
        this.readEntryResult = new ODataEntryImpl(this.properties, (MediaMetadata)this.mediaMetadata, (EntryMetadata)this.entryMetadata, null);
        this.typeMappings = EntityTypeMapping.create((Map)readProperties.getTypeMappings());
    }

    private void handleStartedTag(XMLStreamReader reader, EntityInfoAggregator eia, DeserializerProperties readProperties) throws EntityProviderException, XMLStreamException, EdmException {
        this.currentHandledStartTagName = reader.getLocalName();
        if ("id".equals(this.currentHandledStartTagName)) {
            this.readId(reader);
        } else if ("entry".equals(this.currentHandledStartTagName)) {
            this.readEntry(reader);
        } else if ("link".equals(this.currentHandledStartTagName)) {
            this.readLink(reader, eia, readProperties);
        } else if ("content".equals(this.currentHandledStartTagName)) {
            this.readContent(reader, eia, readProperties);
        } else if ("properties".equals(this.currentHandledStartTagName)) {
            this.readProperties(reader, eia, readProperties);
        } else {
            this.readCustomElement(reader, this.currentHandledStartTagName, eia, readProperties);
        }
    }

    private void readCustomElement(XMLStreamReader reader, String tagName, EntityInfoAggregator eia, DeserializerProperties readProperties) throws EdmException, EntityProviderException, XMLStreamException {
        EntityPropertyInfo targetPathInfo = eia.getTargetPathInfo(tagName);
        NamespaceContext nsctx = reader.getNamespaceContext();
        boolean skipTag = true;
        if (!"http://www.w3.org/2005/Atom".equals(reader.getName().getNamespaceURI())) {
            if (targetPathInfo != null) {
                String customPrefix = targetPathInfo.getCustomMapping().getFcNsPrefix();
                String customNamespaceURI = targetPathInfo.getCustomMapping().getFcNsUri();
                if (customPrefix != null && customNamespaceURI != null) {
                    String xmlPrefix = nsctx.getPrefix(customNamespaceURI);
                    String xmlNamespaceUri = reader.getNamespaceURI(customPrefix);
                    if (customNamespaceURI.equals(xmlNamespaceUri) && customPrefix.equals(xmlPrefix)) {
                        skipTag = false;
                        reader.require(1, customNamespaceURI, tagName);
                        String text = reader.getElementText();
                        reader.require(2, customNamespaceURI, tagName);
                        EntityPropertyInfo propertyInfo = this.getValidatedPropertyInfo(eia, tagName);
                        Class typeMapping = this.typeMappings.getMappingClass(propertyInfo.getName());
                        EdmSimpleType type = (EdmSimpleType)propertyInfo.getType();
                        Object value = type.valueOfString(text, EdmLiteralKind.DEFAULT, (EdmFacets)(readProperties == null || readProperties.isValidatingFacets() ? propertyInfo.getFacets() : null), typeMapping == null ? type.getDefaultType() : typeMapping);
                        this.properties.put(tagName, value);
                    }
                }
            } else {
                throw new EntityProviderException(EntityProviderException.INVALID_PROPERTY.addContent(new Object[]{tagName}));
            }
        }
        if (skipTag) {
            this.skipStartedTag(reader);
        }
    }

    private void skipStartedTag(XMLStreamReader reader) throws XMLStreamException {
        String name = reader.getLocalName();
        int read = 1;
        while (read > 0 && reader.hasNext()) {
            reader.next();
            if (!reader.hasName() || !name.equals(reader.getLocalName())) continue;
            if (reader.isEndElement()) {
                --read;
                continue;
            }
            if (!reader.isStartElement()) continue;
            ++read;
        }
    }

    private void readEntry(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, "http://www.w3.org/2005/Atom", "entry");
        this.setETag(reader);
    }

    private void setETag(XMLStreamReader reader) {
        String etag = reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "etag");
        this.entryMetadata.setEtag(etag);
    }

    private void readLink(XMLStreamReader reader, EntityInfoAggregator eia, DeserializerProperties readProperties) throws EntityProviderException, XMLStreamException, EdmException {
        reader.require(1, "http://www.w3.org/2005/Atom", "link");
        String rel = reader.getAttributeValue(null, "rel");
        String uri = reader.getAttributeValue(null, "href");
        String type = reader.getAttributeValue(null, "type");
        String etag = reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "etag");
        reader.require(1, "http://www.w3.org/2005/Atom", "link");
        reader.nextTag();
        if (rel == null || uri == null) {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent(new Object[]{"href' and/or 'rel"}).addContent(new Object[]{"link"}));
        }
        if (rel.startsWith("http://schemas.microsoft.com/ado/2007/08/dataservices/related/")) {
            String navigationPropertyName = rel.substring("http://schemas.microsoft.com/ado/2007/08/dataservices/related/".length());
            this.entryMetadata.putAssociationUri(navigationPropertyName, uri);
        } else if (rel.equals("edit-media")) {
            this.mediaMetadata.setEditLink(uri);
            this.mediaMetadata.setEtag(etag);
        }
        if (!reader.isEndElement() && rel != null && rel.startsWith("http://schemas.microsoft.com/ado/2007/08/dataservices/related/")) {
            this.readInlineContent(reader, eia, readProperties, type, rel);
        }
    }

    private void readInlineContent(XMLStreamReader reader, EntityInfoAggregator eia, DeserializerProperties readProperties, String atomLinkType, String atomLinkRel) throws XMLStreamException, EntityProviderException, EdmException {
        String navigationPropertyName = atomLinkRel.substring("http://schemas.microsoft.com/ado/2007/08/dataservices/related/".length());
        EdmNavigationProperty navigationProperty = (EdmNavigationProperty)eia.getEntityType().getProperty(navigationPropertyName);
        EdmEntitySet entitySet = eia.getEntitySet().getRelatedEntitySet(navigationProperty);
        EntityInfoAggregator inlineEia = EntityInfoAggregator.create((EdmEntitySet)entitySet);
        DeserializerProperties inlineProperties = this.createInlineProperties(readProperties, navigationProperty);
        boolean isFeed = this.isInlineFeedValidated(reader, atomLinkType, navigationProperty);
        ArrayList<ODataEntry> inlineEntries = new ArrayList<ODataEntry>();
        while (!(reader.isEndElement() && "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata".equals(reader.getNamespaceURI()) && "inline".equals(reader.getLocalName()))) {
            if (reader.isStartElement() && "http://www.w3.org/2005/Atom".equals(reader.getNamespaceURI()) && "entry".equals(reader.getLocalName())) {
                XmlEntryDeserializer xec = new XmlEntryDeserializer();
                ODataEntry inlineEntry = xec.readEntry(reader, inlineEia, inlineProperties, true);
                inlineEntries.add(inlineEntry);
            }
            reader.next();
        }
        this.updateReadProperties(navigationPropertyName, isFeed, inlineEntries);
        reader.require(2, "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "inline");
    }

    private void updateReadProperties(String navigationPropertyName, boolean isFeed, List<ODataEntry> inlineEntries) {
        Object entry = this.extractODataEntity(isFeed, inlineEntries);
        this.readEntryResult.setContainsInlineEntry(true);
        this.properties.put(navigationPropertyName, entry);
    }

    private Object extractODataEntity(boolean isFeed, List<ODataEntry> inlineEntries) {
        if (isFeed) {
            return new ODataDeltaFeedImpl(inlineEntries, (FeedMetadata)new FeedMetadataImpl());
        }
        if (!inlineEntries.isEmpty()) {
            return inlineEntries.get(0);
        }
        return null;
    }

    private DeserializerProperties createInlineProperties(DeserializerProperties readProperties, EdmNavigationProperty navigationProperty) throws EntityProviderException {
        OnDeserializeInlineContent callback = readProperties.getCallback();
        DeserializerProperties currentReadProperties = DeserializerProperties.initFrom((DeserializerProperties)readProperties).build();
        if (callback == null) {
            return currentReadProperties;
        }
        try {
            return callback.receiveReadProperties(currentReadProperties, navigationProperty);
        }
        catch (ODataApplicationException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{((Object)((Object)e)).getClass().getSimpleName()}), (Throwable)e);
        }
    }

    private boolean isInlineFeedValidated(XMLStreamReader reader, String type, EdmNavigationProperty navigationProperty) throws EntityProviderException, EdmException {
        boolean isFeed = false;
        try {
            reader.require(1, "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "inline");
            ContentType cType = ContentType.parse((String)type);
            if (cType == null) {
                throw new EntityProviderException(EntityProviderException.INVALID_INLINE_CONTENT.addContent(new Object[]{"xml data"}));
            }
            EdmMultiplicity navigationMultiplicity = navigationProperty.getMultiplicity();
            switch (navigationMultiplicity) {
                case MANY: {
                    this.validateFeedTags(reader, cType);
                    isFeed = true;
                    break;
                }
                case ZERO_TO_ONE: 
                case ONE: {
                    this.validateEntryTags(reader, cType);
                }
            }
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.INVALID_INLINE_CONTENT.addContent(new Object[]{"xml data"}), (Throwable)e);
        }
        return isFeed;
    }

    private void validateEntryTags(XMLStreamReader reader, ContentType cType) throws XMLStreamException, EntityProviderException {
        if ("entry".equals(cType.getParameters().get("type"))) {
            int next = reader.nextTag();
            if (1 == next) {
                reader.require(1, "http://www.w3.org/2005/Atom", "entry");
            } else {
                reader.require(2, "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "inline");
            }
        } else {
            throw new EntityProviderException(EntityProviderException.INVALID_INLINE_CONTENT.addContent(new Object[]{"entry"}));
        }
    }

    private void validateFeedTags(XMLStreamReader reader, ContentType cType) throws XMLStreamException, EntityProviderException {
        if ("feed".equals(cType.getParameters().get("type"))) {
            int next = reader.nextTag();
            if (1 == next) {
                reader.require(1, "http://www.w3.org/2005/Atom", "feed");
            } else {
                reader.require(2, "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "inline");
            }
        } else {
            throw new EntityProviderException(EntityProviderException.INVALID_INLINE_CONTENT.addContent(new Object[]{"feed"}));
        }
    }

    private void readContent(XMLStreamReader reader, EntityInfoAggregator eia, DeserializerProperties readProperties) throws EntityProviderException, XMLStreamException, EdmException {
        reader.require(1, "http://www.w3.org/2005/Atom", "content");
        String contentType = reader.getAttributeValue(null, "type");
        String sourceLink = reader.getAttributeValue(null, "src");
        reader.nextTag();
        if (reader.isStartElement() && reader.getLocalName().equals("properties")) {
            this.readProperties(reader, eia, readProperties);
        } else if (reader.isEndElement()) {
            reader.require(2, "http://www.w3.org/2005/Atom", "content");
        } else {
            throw new EntityProviderException(EntityProviderException.INVALID_STATE.addContent(new Object[]{"Expected closing 'content' or starting 'properties' but found '" + reader.getLocalName() + "'."}));
        }
        this.mediaMetadata.setContentType(contentType);
        this.mediaMetadata.setSourceLink(sourceLink);
    }

    private void readId(XMLStreamReader reader) throws EntityProviderException, XMLStreamException {
        reader.require(1, "http://www.w3.org/2005/Atom", "id");
        this.entryMetadata.setId(reader.getElementText());
        reader.require(2, "http://www.w3.org/2005/Atom", "id");
    }

    private void readProperties(XMLStreamReader reader, EntityInfoAggregator entitySet, DeserializerProperties readProperties) throws XMLStreamException, EdmException, EntityProviderException {
        reader.require(1, "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "properties");
        if (entitySet.getEntityType().hasStream()) {
            this.checkCurrentHandledStartTag("properties");
        } else {
            this.checkCurrentHandledStartTag("content");
        }
        XmlPropertyDeserializer xpc = new XmlPropertyDeserializer();
        String closeTag = null;
        boolean run = true;
        reader.next();
        while (run) {
            if (reader.isStartElement() && closeTag == null) {
                closeTag = reader.getLocalName();
                if (this.isEdmNamespaceProperty(reader)) {
                    if (this.properties.containsKey(closeTag)) {
                        throw new EntityProviderException(EntityProviderException.DOUBLE_PROPERTY.addContent(new Object[]{closeTag}));
                    }
                    EntityPropertyInfo property = this.getValidatedPropertyInfo(entitySet, closeTag);
                    Object value = xpc.readStartedElement(reader, closeTag, property, this.typeMappings, readProperties);
                    this.properties.put(closeTag, value);
                    closeTag = null;
                }
            } else if (reader.isEndElement()) {
                if (reader.getLocalName().equals(closeTag)) {
                    closeTag = null;
                } else if ("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata".equals(reader.getNamespaceURI()) && "properties".equals(reader.getLocalName())) {
                    run = false;
                }
            }
            reader.next();
        }
    }

    private void checkCurrentHandledStartTag(String expectedTagName) throws EntityProviderException {
        if (this.currentHandledStartTagName == null) {
            throw new EntityProviderException(EntityProviderException.INVALID_STATE.addContent(new Object[]{"No current handled start tag name set."}));
        }
        if (!this.currentHandledStartTagName.equals(expectedTagName)) {
            throw new EntityProviderException(EntityProviderException.INVALID_PARENT_TAG.addContent(new Object[]{expectedTagName}).addContent(new Object[]{this.currentHandledStartTagName}));
        }
    }

    private boolean isEdmNamespaceProperty(XMLStreamReader reader) throws EntityProviderException {
        String nsUri = reader.getNamespaceURI();
        if (nsUri == null) {
            throw new EntityProviderException(EntityProviderException.INVALID_NAMESPACE.addContent(new Object[]{reader.getLocalName()}));
        }
        return "http://schemas.microsoft.com/ado/2007/08/dataservices".equals(nsUri);
    }

    private EntityPropertyInfo getValidatedPropertyInfo(EntityInfoAggregator entitySet, String name) throws EntityProviderException {
        EntityPropertyInfo info = entitySet.getPropertyInfo(name);
        if (info == null) {
            throw new EntityProviderException(EntityProviderException.INVALID_PROPERTY.addContent(new Object[]{name}));
        }
        return info;
    }
}

