/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.client.core.edm.Impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmAnnotatable;
import org.apache.olingo.odata2.api.edm.EdmAnnotations;
import org.apache.olingo.odata2.api.edm.EdmAssociation;
import org.apache.olingo.odata2.api.edm.EdmAssociationSet;
import org.apache.olingo.odata2.api.edm.EdmEntityContainer;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.client.api.edm.ClientEdm;
import org.apache.olingo.odata2.client.api.edm.EdmDocumentation;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmImpl;

public class EdmEntityContainerImpl
implements EdmEntityContainer,
EdmAnnotatable {
    private EdmImpl edm;
    private List<EdmEntityContainer> entityContainerHierachy;
    private List<EdmEntitySet> edmEntitySets;
    private Map<String, EdmAssociationSet> edmAssociationSetMap;
    private List<EdmAssociationSet> edmAssociationSets;
    private List<EdmFunctionImport> edmFunctionImports;
    private EdmEntityContainer edmExtendedEntityContainer;
    private boolean isDefaultContainer;
    private EdmAnnotations annotations;
    private EdmDocumentation documentation;
    private String name;
    private String extendz;

    public Map<String, EdmAssociationSet> getEdmAssociationSetMap() {
        return this.edmAssociationSetMap;
    }

    public void setEdmAssociationSetMap(Map<String, EdmAssociationSet> associationSetMap) {
        this.edmAssociationSetMap = associationSetMap;
    }

    public EdmDocumentation getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(EdmDocumentation documentation) {
        this.documentation = documentation;
    }

    public void setEdm(EdmImpl edm) {
        this.edm = edm;
    }

    public ClientEdm getEdm() {
        return this.edm;
    }

    public EdmEntityContainer getEdmExtendedEntityContainer() {
        return this.edmExtendedEntityContainer;
    }

    public void setEdmExtendedEntityContainer(EdmEntityContainer edmExtendedEntityContainer) {
        this.edmExtendedEntityContainer = edmExtendedEntityContainer;
    }

    public void setEntityContainerHierachy(List<EdmEntityContainer> entityContainerHierachy) {
        this.entityContainerHierachy = entityContainerHierachy;
    }

    public String getExtendz() {
        return this.extendz;
    }

    public void setExtendz(String extendz) {
        this.extendz = extendz;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAnnotations(EdmAnnotations annotations) {
        this.annotations = annotations;
    }

    public EdmEntityContainerImpl(EdmImpl edm) throws EdmException {
        this.edm = edm;
        this.edmEntitySets = new ArrayList<EdmEntitySet>();
        this.edmAssociationSets = new ArrayList<EdmAssociationSet>();
        this.edmFunctionImports = new ArrayList<EdmFunctionImport>();
    }

    public boolean isDefaultContainer() {
        return this.isDefaultContainer;
    }

    public void setDefaultContainer(boolean isDefaultContainer) {
        this.isDefaultContainer = isDefaultContainer;
    }

    public String getName() throws EdmException {
        return this.name;
    }

    public EdmEntitySet getEntitySet(String name) throws EdmException {
        EdmEntitySet edmEntitySet = null;
        for (EdmEntitySet entity : this.edmEntitySets) {
            if (!entity.getName().equals(name)) continue;
            edmEntitySet = entity;
        }
        return edmEntitySet;
    }

    public EdmFunctionImport getFunctionImport(String name) throws EdmException {
        for (EdmFunctionImport edmFunctionImport : this.edmFunctionImports) {
            if (!edmFunctionImport.getName().equalsIgnoreCase(name)) continue;
            return edmFunctionImport;
        }
        return null;
    }

    public EdmAssociationSet getAssociationSet(EdmEntitySet sourceEntitySet, EdmNavigationProperty navigationProperty) throws EdmException {
        EdmAssociation edmAssociation = navigationProperty.getRelationship();
        String association = String.valueOf(edmAssociation.getNamespace()) + "." + edmAssociation.getName();
        String entitySetName = sourceEntitySet.getName();
        String entitySetFromRole = navigationProperty.getFromRole();
        String key = String.valueOf(entitySetName) + ">>" + association + ">>" + entitySetFromRole;
        for (Map.Entry<String, EdmAssociationSet> edmAssociationSet : this.edmAssociationSetMap.entrySet()) {
            if (!edmAssociationSet.getKey().equalsIgnoreCase(key)) continue;
            return edmAssociationSet.getValue();
        }
        return null;
    }

    public boolean isDefaultEntityContainer() {
        return this.isDefaultContainer;
    }

    public EdmAnnotations getAnnotations() throws EdmException {
        return this.annotations;
    }

    public List<EdmEntitySet> getEntitySets() throws EdmException {
        return this.edmEntitySets;
    }

    public List<EdmAssociationSet> getAssociationSets() throws EdmException {
        return this.edmAssociationSets;
    }

    public List<EdmEntitySet> getEdmEntitySets() {
        return this.edmEntitySets;
    }

    public EdmEntityContainerImpl setEdmEntitySets(List<EdmEntitySet> edmEntitySets) {
        this.edmEntitySets = edmEntitySets;
        return this;
    }

    public List<EdmAssociationSet> getEdmAssociationSets() {
        return this.edmAssociationSets;
    }

    public EdmEntityContainerImpl setEdmAssociationSets(List<EdmAssociationSet> edmAssociationSets) {
        this.edmAssociationSets = edmAssociationSets;
        return this;
    }

    public List<EdmFunctionImport> getEdmFunctionImports() {
        return this.edmFunctionImports;
    }

    public EdmEntityContainerImpl setEdmFunctionImports(List<EdmFunctionImport> edmFunctionImports) {
        this.edmFunctionImports = edmFunctionImports;
        return this;
    }

    public String toString() {
        return String.format(this.name, new Object[0]);
    }
}

