/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.client.core.uri;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.client.api.uri.QueryOption;
import org.apache.olingo.odata2.client.api.uri.SegmentType;
import org.apache.olingo.odata2.client.api.uri.URIBuilder;
import org.apache.olingo.odata2.client.core.uri.Segment;
import org.apache.olingo.odata2.client.core.uri.util.UriUtil;
import org.apache.olingo.odata2.core.commons.Encoder;

public class URIBuilderImpl
implements URIBuilder {
    protected final List<Segment> segments = new ArrayList<Segment>();
    protected final Map<String, String> queryOptions = new LinkedHashMap<String, String>();
    protected final Map<String, String> customQueryOptions = new LinkedHashMap<String, String>();
    protected final Map<String, Object> functionImportParameters = new LinkedHashMap<String, Object>();

    public URIBuilderImpl(String serviceRoot) {
        this.segments.add(new Segment(SegmentType.INITIAL, serviceRoot));
    }

    public URIBuilder appendCountSegment() {
        this.segments.add(new Segment(SegmentType.COUNT, SegmentType.COUNT.getValue()));
        return this;
    }

    public URIBuilder appendMetadataSegment() {
        this.segments.add(new Segment(SegmentType.METADATA, SegmentType.METADATA.getValue()));
        return this;
    }

    public URIBuilder format(String format) {
        UriUtil.appendQueryOption(QueryOption.FORMAT.toString(), format, this.queryOptions, true);
        return this;
    }

    public URIBuilder appendValueSegment() {
        this.segments.add(new Segment(SegmentType.VALUE, SegmentType.VALUE.getValue()));
        return this;
    }

    public URIBuilder addQueryOption(QueryOption option, String value) {
        UriUtil.appendQueryOption(option.toString(), value, this.queryOptions, false);
        return this;
    }

    public URIBuilder filter(String filter) {
        return this.replaceQueryOption(QueryOption.FILTER, filter);
    }

    public URIBuilder top(int top) {
        return this.replaceQueryOption(QueryOption.TOP, String.valueOf(top));
    }

    public URIBuilder skip(int skip) {
        return this.replaceQueryOption(QueryOption.SKIP, String.valueOf(skip));
    }

    public URIBuilder addCustomQueryOption(String paramName, Object paramValue) {
        UriUtil.appendQueryOption(paramName, paramValue.toString(), this.customQueryOptions, true);
        return this;
    }

    public URI build() {
        return UriUtil.getUri(this.segments, this.queryOptions, this.customQueryOptions, this.functionImportParameters);
    }

    public URIBuilder appendEntitySetSegment(String entitySet) {
        this.segments.add(new Segment(SegmentType.ENTITYSET, entitySet));
        return this;
    }

    public URIBuilder appendNavigationSegment(String navigationProperty) {
        this.segments.add(new Segment(SegmentType.NAVIGATION, navigationProperty));
        return this;
    }

    public URIBuilder appendKeySegment(Object value) {
        String key = this.getKey(value, false);
        this.segments.add(new Segment(SegmentType.KEY, key));
        return this;
    }

    private String getKey(Object value, boolean isSegment) {
        String key = "";
        if (!isSegment) {
            if (value instanceof String) {
                value = Encoder.encode((String)value.toString());
                key = key + "('" + value + "')";
            } else {
                key = key + "(" + value + ")";
            }
        } else if (value instanceof String) {
            value = Encoder.encode((String)value.toString());
            key = key + "'" + value + "'";
        } else {
            key = key + value;
        }
        return key;
    }

    public URIBuilder appendKeySegment(Map<String, Object> segmentValues) {
        String key = this.buildMultiKeySegment(segmentValues, ',');
        this.segments.add(new Segment(SegmentType.KEY, key));
        return this;
    }

    private String buildMultiKeySegment(Map<String, Object> segmentValues, char separator) {
        if (segmentValues == null || segmentValues.isEmpty()) {
            return "";
        }
        StringBuilder keyBuilder = new StringBuilder().append('(');
        for (Map.Entry<String, Object> entry : segmentValues.entrySet()) {
            keyBuilder.append(entry.getKey()).append('=').append(this.getKey(entry.getValue(), true));
            keyBuilder.append(separator);
        }
        keyBuilder.deleteCharAt(keyBuilder.length() - 1).append(')');
        return keyBuilder.toString();
    }

    public URIBuilder appendPropertySegment(String segmentValue) {
        this.segments.add(new Segment(SegmentType.PROPERTY, segmentValue));
        return this;
    }

    public URIBuilder expand(String ... expandItems) {
        return this.addQueryOption(QueryOption.EXPAND, UriUtil.join(expandItems, ","));
    }

    public URIBuilder select(String ... selectItems) {
        return this.addQueryOption(QueryOption.SELECT, UriUtil.join(selectItems, ","));
    }

    public URIBuilder orderBy(String order) {
        return this.addQueryOption(QueryOption.ORDERBY, order);
    }

    public URIBuilder replaceQueryOption(QueryOption option, String value) {
        UriUtil.appendQueryOption(option.toString(), value, this.queryOptions, true);
        return this;
    }

    public URIBuilder appendFunctionImportSegment(String functionImport) {
        this.segments.add(new Segment(SegmentType.FUNCTIONIMPORT, functionImport));
        return this;
    }

    public URIBuilder appendFunctionImportParameters(Map<String, Object> functionImportParams) {
        if (functionImportParams != null && !functionImportParams.isEmpty()) {
            for (Map.Entry<String, Object> param : functionImportParams.entrySet()) {
                Object value = param.getValue();
                if (value instanceof String) {
                    value = "'" + value + "'";
                }
                this.functionImportParameters.put(param.getKey(), value);
            }
        }
        return this;
    }
}

