/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.client.core.edm.Impl;

import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmAnnotatable;
import org.apache.olingo.odata2.api.edm.EdmAnnotations;
import org.apache.olingo.odata2.api.edm.EdmComplexType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmStructuralType;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmNamedImpl;

public abstract class EdmStructuralTypeImpl
extends EdmNamedImpl
implements EdmStructuralType,
EdmAnnotatable {
    protected EdmStructuralType edmBaseType;
    protected EdmComplexType structuralType;
    private EdmTypeKind edmTypeKind;
    protected String namespace;
    private List<EdmProperty> properties;
    private List<String> edmPropertyNames;
    private EdmAnnotations annotations;

    public EdmStructuralType getEdmBaseType() {
        return this.edmBaseType;
    }

    public void setEdmBaseType(EdmStructuralType edmBaseType) {
        this.edmBaseType = edmBaseType;
    }

    public EdmComplexType getStructuralType() {
        return this.structuralType;
    }

    public void setStructuralType(EdmComplexType structuralType) {
        this.structuralType = structuralType;
    }

    public EdmTypeKind getEdmTypeKind() {
        return this.edmTypeKind;
    }

    public void setEdmTypeKind(EdmTypeKind edmTypeKind) {
        this.edmTypeKind = edmTypeKind;
    }

    public void setEdmPropertyNames(List<String> edmPropertyNames) {
        this.edmPropertyNames = edmPropertyNames;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setAnnotations(EdmAnnotations annotations) {
        this.annotations = annotations;
    }

    public List<EdmProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<EdmProperty> properties) {
        this.properties = properties;
    }

    public String getNamespace() throws EdmException {
        return this.namespace;
    }

    public EdmTyped getProperty(String name) throws EdmException {
        EdmTyped property = this.getPropertyInternal(name);
        if (property == null && this.edmBaseType != null) {
            property = this.edmBaseType.getProperty(name);
        }
        return property;
    }

    public List<String> getPropertyNames() throws EdmException {
        return this.edmPropertyNames;
    }

    public EdmStructuralType getBaseType() throws EdmException {
        return this.edmBaseType;
    }

    public EdmTypeKind getKind() {
        return this.edmTypeKind;
    }

    public EdmMapping getMapping() throws EdmException {
        return this.structuralType.getMapping();
    }

    protected EdmTyped getPropertyInternal(String name) throws EdmException {
        EdmTyped edmProperty = null;
        for (EdmProperty property : this.properties) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        if (this.edmBaseType != null) {
            edmProperty = this.edmBaseType.getProperty(name);
        }
        return edmProperty;
    }

    @Override
    public String toString() {
        try {
            return this.namespace + "." + this.getName();
        }
        catch (EdmException e) {
            return null;
        }
    }

    public EdmAnnotations getAnnotations() throws EdmException {
        return this.annotations;
    }
}

