/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.client.core.ep.deserializer;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.processor.ODataErrorContext;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.commons.XmlHelper;

public class XmlErrorDocumentDeserializer {
    private static final Map<String, Locale> AVAILABLE_LOCALES;

    static {
        Locale[] locales;
        AVAILABLE_LOCALES = new HashMap<String, Locale>();
        Locale[] localeArray = locales = Locale.getAvailableLocales();
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale l = localeArray[n2];
            AVAILABLE_LOCALES.put(String.valueOf(l.getLanguage()) + "-" + l.getCountry(), l);
            ++n2;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ODataErrorContext readError(InputStream errorDocument) throws EntityProviderException {
        ODataErrorContext oDataErrorContext;
        XMLStreamReader reader = null;
        EntityProviderException cachedException = null;
        try {
            reader = XmlHelper.createStreamReader((Object)errorDocument);
            oDataErrorContext = this.parserError(reader);
            if (reader == null) return oDataErrorContext;
        }
        catch (XMLStreamException e) {
            try {
                cachedException = new EntityProviderException(EntityProviderException.INVALID_STATE.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                throw cachedException;
                catch (EntityProviderException e2) {
                    cachedException = e2;
                    throw cachedException;
                }
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (XMLStreamException e3) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e3.getClass().getSimpleName()}), (Throwable)e3);
                }
            }
        }
        try {
            reader.close();
            return oDataErrorContext;
        }
        catch (XMLStreamException e) {
            if (cachedException != null) {
                throw cachedException;
            }
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
    }

    private ODataErrorContext parserError(XMLStreamReader reader) throws XMLStreamException, EntityProviderException {
        reader.require(7, null, null);
        reader.nextTag();
        reader.require(1, "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "error");
        boolean codeFound = false;
        boolean messageFound = false;
        ODataErrorContext errorContext = new ODataErrorContext();
        while (this.notFinished(reader)) {
            reader.nextTag();
            if (!reader.isStartElement()) continue;
            String name = reader.getLocalName();
            if ("code".equals(name)) {
                codeFound = true;
                this.handleCode(reader, errorContext);
                continue;
            }
            if ("message".equals(name)) {
                messageFound = true;
                this.handleMessage(reader, errorContext);
                continue;
            }
            if ("innererror".equals(name)) {
                this.handleInnerError(reader, errorContext);
                continue;
            }
            throw new EntityProviderException(EntityProviderException.INVALID_CONTENT.addContent(new Object[]{name, "error"}));
        }
        this.validate(codeFound, messageFound);
        errorContext.setContentType(ContentType.APPLICATION_XML.toContentTypeString());
        return errorContext;
    }

    private void validate(boolean codeFound, boolean messageFound) throws EntityProviderException {
        if (!codeFound) {
            throw new EntityProviderException(EntityProviderException.MISSING_PROPERTY.addContent(new Object[]{"Mandatory 'code' property not found.'"}));
        }
        if (!messageFound) {
            throw new EntityProviderException(EntityProviderException.MISSING_PROPERTY.addContent(new Object[]{"Mandatory 'message' property not found.'"}));
        }
    }

    private boolean notFinished(XMLStreamReader reader) throws XMLStreamException {
        return this.notFinished(reader, "error");
    }

    private boolean notFinished(XMLStreamReader reader, String tagName) throws XMLStreamException {
        boolean finished;
        boolean bl = finished = reader.isEndElement() && tagName.equals(reader.getLocalName());
        return !finished && reader.hasNext();
    }

    private void handleInnerError(XMLStreamReader reader, ODataErrorContext errorContext) throws XMLStreamException {
        StringBuilder sb = new StringBuilder();
        while (this.notFinished(reader, "innererror")) {
            if (reader.hasName() && !"innererror".equals(reader.getLocalName())) {
                sb.append("<");
                if (reader.isEndElement()) {
                    sb.append("/");
                }
                sb.append(reader.getLocalName()).append(">");
            } else if (reader.isCharacters()) {
                sb.append(reader.getText());
            }
            reader.next();
        }
        errorContext.setInnerError(sb.toString());
    }

    private void handleMessage(XMLStreamReader reader, ODataErrorContext errorContext) throws XMLStreamException {
        String lang = reader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
        errorContext.setLocale(this.getLocale(lang));
        String message = reader.getElementText();
        errorContext.setMessage(message);
    }

    private void handleCode(XMLStreamReader reader, ODataErrorContext errorContext) throws XMLStreamException {
        String code = reader.getElementText();
        errorContext.setErrorCode(code);
    }

    private Locale getLocale(String langValue) {
        return AVAILABLE_LOCALES.get(langValue);
    }
}

