/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.api.edm.provider;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.provider.AnnotationAttribute;
import org.apache.olingo.odata2.api.edm.provider.AnnotationElement;
import org.apache.olingo.odata2.api.edm.provider.CustomizableFeedMappings;
import org.apache.olingo.odata2.api.edm.provider.Documentation;
import org.apache.olingo.odata2.api.edm.provider.Mapping;

public abstract class Property {
    private String name;
    private String originalName;
    private boolean originalId = false;
    private int index = 0;
    private EdmFacets facets;
    private CustomizableFeedMappings customizableFeedMappings;
    private String mimeType;
    private Mapping mapping;
    private Documentation documentation;
    private List<AnnotationAttribute> annotationAttributes;
    private List<AnnotationElement> annotationElements;
    private List<Property> composite;
    private boolean isForeignKey;
    private Class<?> originalType;
    private String columnDefinition;

    public String getName() {
        return this.name;
    }

    public EdmFacets getFacets() {
        return this.facets;
    }

    public CustomizableFeedMappings getCustomizableFeedMappings() {
        return this.customizableFeedMappings;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public Documentation getDocumentation() {
        return this.documentation;
    }

    public List<AnnotationAttribute> getAnnotationAttributes() {
        return this.annotationAttributes;
    }

    public List<AnnotationElement> getAnnotationElements() {
        return this.annotationElements;
    }

    public Property setName(String name) {
        this.name = name;
        return this;
    }

    public Property setFacets(EdmFacets facets) {
        this.facets = facets;
        return this;
    }

    public Property setCustomizableFeedMappings(CustomizableFeedMappings customizableFeedMappings) {
        this.customizableFeedMappings = customizableFeedMappings;
        return this;
    }

    public Property setMimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public Property setMapping(Mapping mapping) {
        this.mapping = mapping;
        return this;
    }

    public Property setDocumentation(Documentation documentation) {
        this.documentation = documentation;
        return this;
    }

    public Property setAnnotationAttributes(List<AnnotationAttribute> annotationAttributes) {
        this.annotationAttributes = annotationAttributes;
        return this;
    }

    public Property setAnnotationElements(List<AnnotationElement> annotationElements) {
        this.annotationElements = annotationElements;
        return this;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    private static int countStr(String someString, char someChar) {
        int count = 0;
        int i = 0;
        while (i < someString.length()) {
            if (someString.charAt(i) == someChar) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void setComposite(List<Property> composite) {
        this.composite = composite;
    }

    public void addComposite(Property property) {
        if (this.composite == null) {
            this.composite = new LinkedList<Property>();
        }
        this.composite.add(property);
        Collections.sort(this.composite, new Comparator<Property>(){

            @Override
            public int compare(Property p1, Property p2) {
                int totalP2;
                int totalP1 = Property.countStr(p1.getMapping().getInternalName(), '.');
                if (totalP1 > (totalP2 = Property.countStr(p2.getMapping().getInternalName(), '.'))) {
                    return 1;
                }
                if (totalP1 < totalP2) {
                    return -1;
                }
                return p1.getMapping().getInternalName().compareTo(p2.getMapping().getInternalName());
            }
        });
    }

    public List<Property> getComposite() {
        return this.composite;
    }

    public boolean isForeignKey() {
        return this.isForeignKey;
    }

    public void setForeignKey(boolean foreignKey) {
        this.isForeignKey = foreignKey;
    }

    public boolean isOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(boolean originalId) {
        this.originalId = originalId;
    }

    public Class<?> getOriginalType() {
        return this.originalType;
    }

    public void setOriginalType(Class<?> originalType) {
        this.originalType = originalType;
    }

    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    public void setColumnDefinition(String columnDefinition) {
        this.columnDefinition = columnDefinition;
    }
}

