/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.api.exception;

import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.exception.ODataHttpException;
import org.apache.olingo.odata2.api.exception.ODataMessageException;

public class ODataException
extends Exception {
    private static final long serialVersionUID = 1L;

    public ODataException() {
    }

    public ODataException(String msg) {
        super(msg);
    }

    public ODataException(String msg, Throwable e) {
        super(msg, e);
    }

    public ODataException(Throwable e) {
        super(e);
    }

    public boolean isCausedByHttpException() {
        return this.getHttpExceptionCause() != null;
    }

    public ODataHttpException getHttpExceptionCause() {
        return this.getSpecificCause(ODataHttpException.class);
    }

    public boolean isCausedByApplicationException() {
        return this.getApplicationExceptionCause() != null;
    }

    public boolean isCausedByMessageException() {
        return this.getMessageExceptionCause() != null;
    }

    public ODataMessageException getMessageExceptionCause() {
        return this.getSpecificCause(ODataMessageException.class);
    }

    public ODataApplicationException getApplicationExceptionCause() {
        return this.getSpecificCause(ODataApplicationException.class);
    }

    private <T extends ODataException> T getSpecificCause(Class<T> causeClass) {
        Throwable cause = this;
        while (cause != null) {
            if (causeClass.isInstance(cause)) {
                return (T)((ODataException)causeClass.cast(cause));
            }
            cause = cause.getCause();
        }
        return null;
    }
}

