/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.olingo.odata2.api.edm.provider;

import org.apache.olingo.odata2.api.edm.EdmMapping;

/**
 * Object of this class represent the mapping of a value to a MIME type.
 * 
 */
public class Mapping implements EdmMapping {

  private String value;
  private Object object;
  private String mediaResourceSourceKey;
  private String mediaResourceMimeTypeKey;
  private String expression;
  private boolean canEdit = true;
  private boolean isCalculated = false;
  private boolean isPath = false;
  private String path;
  private String complexPath;
  private int complexIndex = -1;

  @Override
  public String getInternalName() {
    return value;
  }

  @Override
  public String getInternalExpression() {
    return expression;
  }

  @Override
  public Object getObject() {
    return object;
  }

  @Override
  public String getMediaResourceSourceKey() {
    return mediaResourceSourceKey;
  }

  @Override
  public String getMediaResourceMimeTypeKey() {
    return mediaResourceMimeTypeKey;
  }

  /**
   * Sets the value for this {@link Mapping}.
   * @param value
   * @return {@link Mapping} for method chaining
   */
  public Mapping setInternalName(final String value) {
    this.value = value;
    return this;
  }

  public Mapping setInternalExpression(final String value) {
    this.expression = value;
    return this;
  }

  public boolean isPath() {
    return isPath;
  }

  public void setIsPath(boolean path) {
    isPath = path;
  }

  public String getPath() {
    return path;
  }

  public void setPath(String path) {
    this.path = path;
  }

  public String getComplexPath() {
    return complexPath;
  }

  public void setComplexPath(String complexPath) {
    this.complexPath = complexPath;
  }

  public int getComplexIndex() {
    return complexIndex;
  }

  public void setComplexIndex(int complexIndex) {
    this.complexIndex = complexIndex;
  }

  /**
   * Sets an object. This method can be used by a provider to set whatever it wants to associate with this.
   * @param object
   * @return {@link Mapping} for method chaining
   */
  public Mapping setObject(final Object object) {
    this.object = object;
    return this;
  }

  /**
   * Sets the key for the resource source key which is used for the lookup in the data map
   * @param mediaResourceSourceKey under which the source can be found in the data map
   * @return {@link Mapping} for method chaining
   */
  public Mapping setMediaResourceSourceKey(final String mediaResourceSourceKey) {
    this.mediaResourceSourceKey = mediaResourceSourceKey;
    return this;
  }

  /**
   * Sets the key for the resource mime type key which is used for the lookup in the data map
   * @param mediaResourceMimeTypeKey under which the mime type can be found in the data map
   * @return {@link Mapping} for method chaining
   */
  public Mapping setMediaResourceMimeTypeKey(final String mediaResourceMimeTypeKey) {
    this.mediaResourceMimeTypeKey = mediaResourceMimeTypeKey;
    return this;
  }

  public boolean canEdit() {
    return canEdit;
  }

  public void setCanEdit(boolean canEdit) {
    this.canEdit = canEdit;
  }

  @Override
  public boolean isCalculated() {
    return isCalculated;
  }

  public void setCalculated(boolean calculated) {
    isCalculated = calculated;
  }
}
