/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.annotation.processor.ref.model;

import java.util.Arrays;
import org.apache.olingo.odata2.annotation.processor.ref.model.ResourceHelper;
import org.apache.olingo.odata2.api.annotation.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.annotation.edm.EdmEntityType;
import org.apache.olingo.odata2.api.annotation.edm.EdmKey;
import org.apache.olingo.odata2.api.annotation.edm.EdmMediaResourceContent;
import org.apache.olingo.odata2.api.annotation.edm.EdmMediaResourceMimeType;
import org.apache.olingo.odata2.api.annotation.edm.EdmMediaResourceSource;
import org.apache.olingo.odata2.api.annotation.edm.EdmProperty;
import org.apache.olingo.odata2.api.annotation.edm.EdmType;

@EdmEntityType(name="Photo", namespace="RefScenario")
@EdmEntitySet(name="Photos")
public class Photo {
    @EdmKey
    @EdmProperty
    private String name;
    @EdmKey
    @EdmProperty
    private String type;
    @EdmProperty
    @EdmMediaResourceMimeType
    private String mimeType;
    @EdmProperty
    @EdmMediaResourceSource
    private String imageUrl = "http://localhost/someResource.png";
    @EdmProperty(type=EdmType.BINARY)
    @EdmMediaResourceContent
    private byte[] image = ResourceHelper.generateImage();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getImageUri() {
        return this.imageUrl;
    }

    public void setImageUri(String uri) {
        this.imageUrl = uri;
    }

    public byte[] getImage() {
        return (byte[])this.image.clone();
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public String getImageType() {
        return this.mimeType;
    }

    public void setImageType(String imageType) {
        this.mimeType = imageType;
    }

    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 83 * hash + (this.type != null ? this.type.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Photo other = (Photo)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return "{\"Name\":\"" + this.name + "\",\"Type\":\"" + this.type + "\",\"ImageUrl\":\"" + this.imageUrl + "\",\"Image\":\"" + Arrays.toString(this.image) + "\",\"MimeType\":\"" + this.mimeType + "\"";
    }
}

