/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.annotation.processor.ref;

import java.util.Calendar;
import org.apache.olingo.odata2.annotation.processor.api.AnnotationServiceFactory;
import org.apache.olingo.odata2.annotation.processor.core.datasource.DataStore;
import org.apache.olingo.odata2.annotation.processor.ref.model.Building;
import org.apache.olingo.odata2.annotation.processor.ref.model.Employee;
import org.apache.olingo.odata2.annotation.processor.ref.model.Location;
import org.apache.olingo.odata2.annotation.processor.ref.model.Manager;
import org.apache.olingo.odata2.annotation.processor.ref.model.Photo;
import org.apache.olingo.odata2.annotation.processor.ref.model.ResourceHelper;
import org.apache.olingo.odata2.annotation.processor.ref.model.Room;
import org.apache.olingo.odata2.annotation.processor.ref.model.Team;
import org.apache.olingo.odata2.api.ODataCallback;
import org.apache.olingo.odata2.api.ODataDebugCallback;
import org.apache.olingo.odata2.api.ODataService;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.processor.ODataErrorCallback;
import org.apache.olingo.odata2.api.processor.ODataErrorContext;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationRefServiceFactory
extends ODataServiceFactory {
    public ODataService createService(ODataContext context) throws ODataException {
        return AnnotationInstances.ANNOTATION_ODATA_SERVICE;
    }

    public <T extends ODataCallback> T getCallback(Class<T> callbackInterface) {
        return (T)(callbackInterface.isAssignableFrom(ScenarioErrorCallback.class) ? new ScenarioErrorCallback() : (callbackInterface.isAssignableFrom(ODataDebugCallback.class) ? new ScenarioDebugCallback() : super.getCallback(callbackInterface)));
    }

    private static <T> DataStore<T> getDataStore(Class<T> clz) throws DataStore.DataStoreException {
        return DataStore.createInMemory(clz, (boolean)true);
    }

    private static void initializeSampleData() throws ODataApplicationException {
        DataStore<Team> teamDs = AnnotationRefServiceFactory.getDataStore(Team.class);
        teamDs.create((Object)AnnotationRefServiceFactory.createTeam("Team Alpha", true));
        teamDs.create((Object)AnnotationRefServiceFactory.createTeam("Team Beta", false));
        teamDs.create((Object)AnnotationRefServiceFactory.createTeam("Team Gamma", false));
        teamDs.create((Object)AnnotationRefServiceFactory.createTeam("Team Omega", true));
        Team subTeam = AnnotationRefServiceFactory.createTeam("SubTeamOne", false);
        teamDs.create((Object)subTeam);
        teamDs.create((Object)AnnotationRefServiceFactory.createTeam("Team Zeta", true, subTeam));
        DataStore<Building> buildingsDs = AnnotationRefServiceFactory.getDataStore(Building.class);
        Building redBuilding = AnnotationRefServiceFactory.createBuilding("Red Building");
        buildingsDs.create((Object)redBuilding);
        Building greenBuilding = AnnotationRefServiceFactory.createBuilding("Green Building");
        buildingsDs.create((Object)greenBuilding);
        Building blueBuilding = AnnotationRefServiceFactory.createBuilding("Blue Building");
        buildingsDs.create((Object)blueBuilding);
        Building yellowBuilding = AnnotationRefServiceFactory.createBuilding("Yellow Building");
        buildingsDs.create((Object)yellowBuilding);
        DataStore<Photo> photoDs = AnnotationRefServiceFactory.getDataStore(Photo.class);
        photoDs.create((Object)AnnotationRefServiceFactory.createPhoto("Small picture", ResourceHelper.Format.GIF));
        photoDs.create((Object)AnnotationRefServiceFactory.createPhoto("Medium picture", ResourceHelper.Format.PNG));
        photoDs.create((Object)AnnotationRefServiceFactory.createPhoto("Big picture", ResourceHelper.Format.JPEG));
        photoDs.create((Object)AnnotationRefServiceFactory.createPhoto("Huge picture", ResourceHelper.Format.BMP));
        DataStore<Room> roomDs = AnnotationRefServiceFactory.getDataStore(Room.class);
        roomDs.create((Object)AnnotationRefServiceFactory.createRoom("Tiny red room", 5, 1, redBuilding));
        roomDs.create((Object)AnnotationRefServiceFactory.createRoom("Small red room", 20, 1, redBuilding));
        roomDs.create((Object)AnnotationRefServiceFactory.createRoom("Small green room", 20, 1, greenBuilding));
        roomDs.create((Object)AnnotationRefServiceFactory.createRoom("Big blue room", 40, 1, blueBuilding));
        roomDs.create((Object)AnnotationRefServiceFactory.createRoom("Huge blue room", 120, 1, blueBuilding));
        roomDs.create((Object)AnnotationRefServiceFactory.createRoom("Huge yellow room", 120, 1, yellowBuilding));
        DataStore<Employee> employeeDataStore = AnnotationRefServiceFactory.getDataStore(Employee.class);
        employeeDataStore.create((Object)AnnotationRefServiceFactory.createEmployee("first Employee", new Location("Norge", "8392", "\u00c4"), 42, null, ((Photo)photoDs.read().iterator().next()).getImage(), ((Photo)photoDs.read().iterator().next()).getImageType(), "http://localhost/image/first.png", null, (Team)teamDs.read().iterator().next(), (Room)roomDs.read().iterator().next()));
    }

    private static Employee createEmployee(String name, Location location, int age, Calendar date, byte[] image, String imageType, String imageUrl, Manager manager, Team team, Room room) {
        Employee employee = new Employee();
        employee.setEmployeeName(name);
        employee.setLocation(location);
        employee.setAge(age);
        employee.setEntryDate(date);
        employee.setImage(image);
        employee.setImageType(imageType);
        employee.setImageUri(imageUrl);
        employee.setManager(manager);
        employee.setTeam(team);
        employee.setRoom(room);
        return employee;
    }

    private static Team createTeam(String teamName, boolean isScrumTeam) {
        return AnnotationRefServiceFactory.createTeam(teamName, isScrumTeam, null);
    }

    private static Team createTeam(String teamName, boolean isScrumTeam, Team subTeam) {
        Team team = new Team();
        team.setName(teamName);
        team.setScrumTeam(isScrumTeam);
        team.setSubTeam(subTeam);
        return team;
    }

    private static Building createBuilding(String buildingName) {
        Building b = new Building();
        b.setName(buildingName);
        return b;
    }

    private static Photo createPhoto(String name, ResourceHelper.Format format) {
        Photo p = new Photo();
        p.setName(name);
        p.setImageUri("http://localhost/image/" + name);
        p.setType(format.name());
        p.setImageType("image/" + format.name().toLowerCase());
        p.setImage(ResourceHelper.generateImage(format));
        return p;
    }

    private static Room createRoom(String name, int seats, int version, Building building) {
        Room r = new Room();
        r.setName(name);
        r.setSeats(seats);
        r.setVersion(version);
        r.setBuilding(building);
        building.addRoom(r);
        return r;
    }

    private static class AnnotationInstances {
        static final String MODEL_PACKAGE = "org.apache.olingo.odata2.annotation.processor.ref.model";
        static final ODataService ANNOTATION_ODATA_SERVICE;

        static {
            try {
                ANNOTATION_ODATA_SERVICE = AnnotationServiceFactory.createAnnotationService((String)MODEL_PACKAGE);
                AnnotationRefServiceFactory.initializeSampleData();
            }
            catch (ODataApplicationException ex) {
                throw new RuntimeException("Exception during sample data generation.", ex);
            }
            catch (ODataException ex) {
                throw new RuntimeException("Exception during data source initialization generation.", ex);
            }
        }

        private AnnotationInstances() {
        }
    }

    private final class ScenarioDebugCallback
    implements ODataDebugCallback {
        private ScenarioDebugCallback() {
        }

        public boolean isDebugEnabled() {
            return true;
        }
    }

    private class ScenarioErrorCallback
    implements ODataErrorCallback {
        private final Logger LOG = LoggerFactory.getLogger(ScenarioErrorCallback.class);

        private ScenarioErrorCallback() {
        }

        public ODataResponse handleError(ODataErrorContext context) throws ODataApplicationException {
            if (context.getHttpStatus() == HttpStatusCodes.INTERNAL_SERVER_ERROR) {
                this.LOG.error("Internal Server Error", (Throwable)context.getException());
            }
            return EntityProvider.writeErrorDocument((ODataErrorContext)context);
        }
    }
}

